/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.config;

import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitMQConfig {
    public static final String MEDICAL_EXCHANGE = "medical_exchange";
    public static final String MEDICAL_QUEUE = "medical_queue";
    public static final String MEDICAL_ROUTING_KEY = "medical_routing_key";
    public static final String CHAT_EXCHANGE = "chat_exchange";
    public static final String CHAT_QUEUE = "chat_queue";
    public static final String CHAT_ROUTING_KEY = "chat.send";

    @Bean
    public DirectExchange medicalExchange() {
        return new DirectExchange(MEDICAL_EXCHANGE, true, false);
    }

    @Bean
    public Queue medicalQueue() {
        return QueueBuilder.durable((String)MEDICAL_QUEUE).build();
    }

    @Bean
    public Binding medicalBinding() {
        return BindingBuilder.bind((Queue)this.medicalQueue()).to(this.medicalExchange()).with(MEDICAL_ROUTING_KEY);
    }

    @Bean
    public DirectExchange chatExchange() {
        return new DirectExchange(CHAT_EXCHANGE, true, false);
    }

    @Bean
    public Queue chatQueue() {
        return QueueBuilder.durable((String)CHAT_QUEUE).build();
    }

    @Bean
    public Binding chatBinding() {
        return BindingBuilder.bind((Queue)this.chatQueue()).to(this.chatExchange()).with(CHAT_ROUTING_KEY);
    }
}

