/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.service.BaichuanApiService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class BaichuanApiServiceImpl
implements BaichuanApiService {
    private final RestTemplate restTemplate = new RestTemplate();
    @Value(value="${baichuan.api.url}")
    private String baichuanApiUrl;
    @Value(value="${baichuan.api.vectorizeurl}")
    private String vectorizeApiUrl;
    @Value(value="${baichuan.api.key}")
    private String apiKey;
    @Value(value="${baichuan.api.timeout}")
    private int timeout;

    public String queryBaichuanAPI(String question) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + this.apiKey);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", "Baichuan4-Turbo");
        requestBody.put("temperature", 0.7);
        requestBody.put("top_p", 0.9);
        requestBody.put("max_tokens", 256);
        ArrayList messages = new ArrayList();
        HashMap<String, String> userMessage = new HashMap<String, String>();
        userMessage.put("system", "\u4f60\u662f\u4e00\u540d\u533b\u751f\u52a9\u7406\uff0c\u4e3b\u8981\u4e3a\u60a3\u8005\u63d0\u4f9b\u5065\u5eb7\u54a8\u8be2\u3001\u521d\u6b65\u75c7\u72b6\u5206\u6790\u5e76\u5f15\u5bfc\u60a3\u8005\u5230\u9662\u5c31\u8bca");
        userMessage.put("role", "user");
        userMessage.put("content", question);
        messages.add(userMessage);
        requestBody.put("messages", messages);
        HttpEntity entity = new HttpEntity(requestBody, (MultiValueMap)headers);
        try {
            List choices;
            ResponseEntity response = this.restTemplate.exchange(this.baichuanApiUrl, HttpMethod.POST, entity, Map.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK && response.getBody() != null && (choices = (List)((Map)response.getBody()).get("choices")) != null && !choices.isEmpty()) {
                Map firstChoice = (Map)choices.get(0);
                Map message = (Map)firstChoice.get("message");
                return (String)message.get("content");
            }
        }
        catch (Exception e) {
            return "\u767e\u5ddd API \u8bf7\u6c42\u5931\u8d25\uff1a" + e.getMessage();
        }
        return "\u672a\u80fd\u83b7\u53d6\u6709\u6548\u56de\u590d";
    }

    public float[] vectorizeText(String text) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + this.apiKey);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("model", "Baichuan-Text-Embedding");
        requestBody.put("input", text);
        HttpEntity entity = new HttpEntity(requestBody, (MultiValueMap)headers);
        try {
            List dataList;
            ResponseEntity response = this.restTemplate.exchange(this.vectorizeApiUrl, HttpMethod.POST, entity, Map.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK && response.getBody() != null && (dataList = (List)((Map)response.getBody()).get("data")) != null && !dataList.isEmpty()) {
                Map firstEntry = (Map)dataList.get(0);
                List embeddingList = (List)firstEntry.get("embedding");
                float[] embeddingArray = new float[embeddingList.size()];
                for (int i = 0; i < embeddingList.size(); ++i) {
                    embeddingArray[i] = ((Number)embeddingList.get(i)).floatValue();
                }
                return embeddingArray;
            }
        }
        catch (Exception e) {
            System.err.println("\u5411\u91cf\u5316 API \u8bf7\u6c42\u5931\u8d25\uff1a" + e.getMessage());
        }
        return new float[768];
    }
}

