/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.model.CozeChatRequest;
import com.chdu.ai.service.ChatService;
import com.chdu.ai.service.CozeSearchService;
import java.util.concurrent.TimeUnit;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;
import org.springframework.web.socket.WebSocketSession;

@Service
public class CozeSearchServiceImpl
implements CozeSearchService {
    private static final Logger log = LoggerFactory.getLogger(CozeSearchServiceImpl.class);
    @Value(value="${coze.api.url}")
    private String cozeApiUrl;
    @Value(value="${coze.api.token}")
    private String cozeApiToken;
    @Autowired
    private ChatService chatService;
    private final RestTemplate restTemplate = new RestTemplate();
    private final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.SECONDS).build();

    public String createConversation() {
        String url = this.cozeApiUrl + "/v1/conversation/create";
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + this.cozeApiToken);
        headers.set("Content-Type", "application/json");
        HttpEntity requestEntity = new HttpEntity((Object)"{}", (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        if (response.getStatusCode() == HttpStatus.OK) {
            JSONObject jsonResponse = new JSONObject((String)response.getBody());
            return jsonResponse.getJSONObject("data").getString("id");
        }
        log.error("\u521b\u5efa\u4f1a\u8bdd\u5931\u8d25\uff0c\u72b6\u6001\u7801\uff1a{}", (Object)response.getStatusCode());
        return null;
    }

    public SseEmitter chatWithCoze(CozeChatRequest cozeChatRequest) {
        SseEmitter emitter = new SseEmitter(Long.valueOf(0L));
        return emitter;
    }

    public void chatWithCoze(CozeChatRequest cozeChatRequest, WebSocketSession session) {
        String url = this.cozeApiUrl + "/v3/chat";
        JSONObject payload = new JSONObject();
        payload.put("bot_id", (Object)cozeChatRequest.getBotId());
        payload.put("user_id", (Object)cozeChatRequest.getUserId());
        payload.put("stream", cozeChatRequest.isStream());
        payload.put("auto_save_history", cozeChatRequest.isAutoSaveHistory());
        JSONArray additionalMessagesArray = new JSONArray();
        JSONObject additionalMsg = new JSONObject();
        additionalMsg.put("role", (Object)cozeChatRequest.getRole());
        additionalMsg.put("content", (Object)cozeChatRequest.getContent());
        additionalMsg.put("content_type", (Object)cozeChatRequest.getContentType());
        additionalMessagesArray.put((Object)additionalMsg);
        payload.put("additional_messages", (Object)additionalMessagesArray);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)payload.toString());
        Request cozeRequest = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + this.cozeApiToken).addHeader("Content-Type", "application/json").post(body).build();
        this.client.newCall(cozeRequest).enqueue((Callback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ ChatService access$100(CozeSearchServiceImpl x0) {
        return x0.chatService;
    }
}

