/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.handler;

import com.chdu.ai.model.ChatMessage;
import com.chdu.ai.model.DifyChatRequest;
import com.chdu.ai.service.ChatService;
import com.chdu.ai.service.MultiWorkflowDifyService;
import com.chdu.ai.util.NumericIdGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.PingMessage;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class ChatWebSocketHandler
extends TextWebSocketHandler {
    private static final Logger logger = LoggerFactory.getLogger(ChatWebSocketHandler.class);
    private final ChatService chatService;
    private final MultiWorkflowDifyService difyService;
    private static ConcurrentHashMap<String, WebSocketSession> sessions = new ConcurrentHashMap();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ChatWebSocketHandler(ChatService chatService, MultiWorkflowDifyService difyService) {
        this.chatService = chatService;
        this.difyService = difyService;
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        String userId = this.getHeaderValue(session, "userid");
        String hospitalId = this.getHeaderValue(session, "organid");
        if (userId == null || userId.trim().isEmpty()) {
            logger.warn("WebSocket\u8fde\u63a5\u7f3a\u5c11userId header: userId={}", (Object)userId);
            userId = "";
        }
        if (hospitalId == null || hospitalId.trim().isEmpty()) {
            logger.warn("WebSocket\u8fde\u63a5\u7f3a\u5c11hospitalId header: hospitalId={}", (Object)hospitalId);
            hospitalId = "";
        }
        session.getAttributes().put("userId", userId);
        session.getAttributes().put("hospitalId", hospitalId);
        sessions.put(userId, session);
        logger.info("WebSocket\u8fde\u63a5\u5df2\u5efa\u7acb: userId={}, hospitalId={}, sessionId={}", new Object[]{userId, hospitalId, session.getId()});
        try {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("type", "connection_established");
            response.put("message", "WebSocket\u8fde\u63a5\u5df2\u5efa\u7acb");
            response.put("userId", userId);
            response.put("hospitalId", hospitalId);
            response.put("timestamp", System.currentTimeMillis());
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)this.objectMapper.writeValueAsString(response)));
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u8fde\u63a5\u6210\u529f\u6d88\u606f\u5931\u8d25: userId={}, hospitalId={}", new Object[]{userId, hospitalId, e});
        }
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        String payload = (String)message.getPayload();
        logger.info("\u6536\u5230WebSocket\u6d88\u606f: userId={}, payload={}", session.getAttributes().get("userId"), (Object)payload);
        try {
            String messageType;
            String currentUserId = session.getAttributes().get("userId").toString();
            String hospitalId = (String)session.getAttributes().get("hospitalId");
            JsonNode messageNode = this.objectMapper.readTree(payload);
            String string = messageType = messageNode.has("type") ? messageNode.get("type").asText() : "chat";
            if ("chat".equals(messageType)) {
                this.handleChatMessage(session, messageNode, currentUserId, hospitalId);
            } else if ("get_history".equals(messageType)) {
                this.handleGetHistory(session, messageNode, currentUserId, hospitalId);
            } else if ("tts_request".equals(messageType)) {
                this.handleTTSRequest(session, messageNode, currentUserId);
            } else {
                logger.warn("\u672a\u77e5\u7684\u6d88\u606f\u7c7b\u578b: {}", (Object)messageType);
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406WebSocket\u6d88\u606f\u65f6\u53d1\u751f\u5f02\u5e38: userId={}", session.getAttributes().get("userId"), (Object)e);
            this.sendErrorMessage(session, "\u5904\u7406\u6d88\u606f\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    private void handleChatMessage(WebSocketSession session, JsonNode messageNode, String userId, String hospitalId) throws Exception {
        String workflowType;
        String content = messageNode.has("content") ? messageNode.get("content").asText() : "";
        String conversationId = messageNode.has("conversationId") ? messageNode.get("conversationId").asText() : null;
        String string = workflowType = messageNode.has("workflowType") ? messageNode.get("workflowType").asText() : null;
        if (content.trim().isEmpty()) {
            this.sendErrorMessage(session, "\u6d88\u606f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (workflowType == null || workflowType.trim().isEmpty()) {
            this.sendErrorMessage(session, "\u5de5\u4f5c\u6d41\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        logger.info("\u5904\u7406\u804a\u5929\u6d88\u606f: userId={}, hospitalId={}, workflowType={}, conversationId={}, content={}", new Object[]{userId, hospitalId, workflowType, conversationId, content});
        ChatMessage userMessage = this.createChatMessage(userId, "ai_assistant", content, "text", conversationId, hospitalId);
        this.chatService.saveMessage(userMessage);
        DifyChatRequest difyRequest = new DifyChatRequest();
        difyRequest.setQuery(content);
        difyRequest.setUser(userId);
        difyRequest.setConversationId(conversationId);
        difyRequest.setHospitalId(hospitalId);
        difyRequest.setWorkflowType(workflowType);
        this.difyService.chatWithDify(difyRequest, session);
    }

    private void handleGetHistory(WebSocketSession session, JsonNode messageNode, String userId, String hospitalId) throws Exception {
        String conversationId;
        String string = conversationId = messageNode.has("conversationId") ? messageNode.get("conversationId").asText() : null;
        if (conversationId == null || conversationId.trim().isEmpty()) {
            this.sendErrorMessage(session, "\u5bf9\u8bddID\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        logger.info("\u83b7\u53d6\u804a\u5929\u5386\u53f2: userId={}, hospitalId={}, conversationId={}", new Object[]{userId, hospitalId, conversationId});
        try {
            List chatHistory = this.chatService.getChatRecords(conversationId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("type", "chat_history");
            response.put("conversationId", conversationId);
            response.put("messages", chatHistory);
            response.put("timestamp", System.currentTimeMillis());
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)this.objectMapper.writeValueAsString(response)));
            logger.info("\u53d1\u9001\u804a\u5929\u5386\u53f2\u6210\u529f: userId={}, conversationId={}, \u6d88\u606f\u6570\u91cf={}", new Object[]{userId, conversationId, chatHistory.size()});
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u804a\u5929\u5386\u53f2\u5931\u8d25: userId={}, conversationId={}", new Object[]{userId, conversationId, e});
            this.sendErrorMessage(session, "\u83b7\u53d6\u804a\u5929\u5386\u53f2\u5931\u8d25");
        }
    }

    private void handleTTSRequest(WebSocketSession session, JsonNode messageNode, String userId) throws Exception {
        String text;
        String string = text = messageNode.has("text") ? messageNode.get("text").asText() : "";
        if (text.trim().isEmpty()) {
            this.sendErrorMessage(session, "TTS\u6587\u672c\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        logger.info("\u5904\u7406TTS\u8bf7\u6c42: userId={}, text={}", (Object)userId, (Object)text);
        try {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("type", "tts_processing");
            response.put("message", "\u6b63\u5728\u5904\u7406\u8bed\u97f3\u5408\u6210");
            response.put("timestamp", System.currentTimeMillis());
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)this.objectMapper.writeValueAsString(response)));
            logger.info("TTS\u8bf7\u6c42\u5904\u7406\u4e2d: userId={}", (Object)userId);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406TTS\u8bf7\u6c42\u5931\u8d25: userId={}", (Object)userId, (Object)e);
            this.sendErrorMessage(session, "\u8bed\u97f3\u5408\u6210\u5931\u8d25");
        }
    }

    private void sendErrorMessage(WebSocketSession session, String errorMessage) {
        try {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("type", "error");
            response.put("message", errorMessage);
            response.put("timestamp", System.currentTimeMillis());
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)this.objectMapper.writeValueAsString(response)));
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u9519\u8bef\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    private ChatMessage createChatMessage(String fromUser, String toUser, String content, String msgType, String conversationId, String hospitalId) {
        ChatMessage message = new ChatMessage();
        message.setId(NumericIdGenerator.generate9NumericId());
        message.setViewId(NumericIdGenerator.generateViewId());
        message.setFromUser(fromUser);
        message.setToUser(toUser);
        message.setMessage(content);
        message.setMsgType(msgType);
        message.setConversionId(conversationId);
        message.setHospitalId(hospitalId);
        message.setCreateTime(new Date());
        message.setDelivered(1);
        message.setStatus(Integer.valueOf(0));
        return message;
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
        String userId = (String)session.getAttributes().get("userId");
        String hospitalId = (String)session.getAttributes().get("hospitalId");
        logger.error("WebSocket\u4f20\u8f93\u9519\u8bef: userId={}, hospitalId={}, error={}", new Object[]{userId, hospitalId, exception.getMessage(), exception});
        if (exception.getMessage() != null && (exception.getMessage().contains("too big") || exception.getMessage().contains("buffer") || exception.getMessage().contains("1009"))) {
            logger.warn("\u68c0\u6d4b\u5230\u6d88\u606f\u8fc7\u5927\u9519\u8bef\uff0c\u5efa\u8bae\u68c0\u67e5\u6d88\u606f\u5206\u7247\u673a\u5236: userId={}", (Object)userId);
        }
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        String userId = (String)session.getAttributes().get("userId");
        String hospitalId = (String)session.getAttributes().get("hospitalId");
        if (userId != null) {
            sessions.remove(userId);
            logger.info("WebSocket\u8fde\u63a5\u5173\u95ed: userId={}, hospitalId={}, sessionId={}, status={}", new Object[]{userId, hospitalId, session.getId(), status});
        }
    }

    private String getHeaderValue(WebSocketSession session, String headerName) {
        try {
            return session.getHandshakeHeaders().getFirst(headerName);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6header\u503c\u5931\u8d25: headerName={}", (Object)headerName, (Object)e);
            return null;
        }
    }

    @Scheduled(fixedRate=30000L)
    public void sendPingMessages() {
        for (WebSocketSession session : sessions.values()) {
            if (!session.isOpen()) continue;
            try {
                session.sendMessage((WebSocketMessage)new PingMessage());
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u5fc3\u8df3 Ping \u6d88\u606f\u5931\u8d25: sessionId={}", (Object)session.getId(), (Object)e);
            }
        }
    }
}

