/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.model.DifyChatRequest;
import com.chdu.ai.model.HospitalWorkflow;
import com.chdu.ai.service.HospitalWorkflowService;
import com.chdu.ai.service.MultiWorkflowDifyService;
import com.chdu.ai.util.DifyResponseProcessor;
import com.chdu.ai.util.UltraSafeMessageSender;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;
import org.springframework.web.socket.WebSocketSession;

@Service
public class MultiWorkflowDifyServiceImpl
implements MultiWorkflowDifyService {
    private static final Logger logger = LoggerFactory.getLogger(MultiWorkflowDifyServiceImpl.class);
    @Autowired
    private HospitalWorkflowService hospitalWorkflowService;
    private final RestTemplate restTemplate = new RestTemplate();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public void chatWithDify(DifyChatRequest request, WebSocketSession session) {
        CompletableFuture.runAsync(() -> {
            try {
                if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                    this.sendErrorMessage(session, "\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
                    return;
                }
                if (request.getWorkflowType() == null || request.getWorkflowType().trim().isEmpty()) {
                    this.sendErrorMessage(session, "\u5de5\u4f5c\u6d41\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                    return;
                }
                HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(request.getHospitalId(), request.getWorkflowType());
                if (workflow == null) {
                    this.sendErrorMessage(session, "\u672a\u627e\u5230\u533b\u9662\u5bf9\u5e94\u7684\u5de5\u4f5c\u6d41\u914d\u7f6e");
                    return;
                }
                this.streamChatRequest(request, workflow, null, session);
            }
            catch (Exception e) {
                logger.error("\u591a\u5de5\u4f5c\u6d41WebSocket\u804a\u5929\u8bf7\u6c42\u5931\u8d25: hospitalId={}", (Object)request.getHospitalId(), (Object)e);
                this.sendErrorMessage(session, "\u804a\u5929\u8bf7\u6c42\u5931\u8d25: " + e.getMessage());
            }
        });
    }

    public SseEmitter chatWithDify(DifyChatRequest request) {
        SseEmitter emitter = new SseEmitter(Long.valueOf(60000L));
        CompletableFuture.runAsync(() -> {
            try {
                if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                    emitter.completeWithError((Throwable)new RuntimeException("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a"));
                    return;
                }
                if (request.getWorkflowType() == null || request.getWorkflowType().trim().isEmpty()) {
                    emitter.completeWithError((Throwable)new RuntimeException("\u5de5\u4f5c\u6d41\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
                    return;
                }
                HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(request.getHospitalId(), request.getWorkflowType());
                if (workflow == null) {
                    emitter.completeWithError((Throwable)new RuntimeException("\u672a\u627e\u5230\u533b\u9662\u5bf9\u5e94\u7684\u5de5\u4f5c\u6d41\u914d\u7f6e"));
                    return;
                }
                this.streamChatRequest(request, workflow, emitter, null);
            }
            catch (Exception e) {
                logger.error("\u591a\u5de5\u4f5c\u6d41SSE\u804a\u5929\u8bf7\u6c42\u5931\u8d25: hospitalId={}", (Object)request.getHospitalId(), (Object)e);
                emitter.completeWithError((Throwable)e);
            }
        });
        return emitter;
    }

    public String chatWithDifyBlocking(DifyChatRequest request) {
        try {
            if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                throw new RuntimeException("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getWorkflowType() == null || request.getWorkflowType().trim().isEmpty()) {
                throw new RuntimeException("\u5de5\u4f5c\u6d41\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(request.getHospitalId(), request.getWorkflowType());
            if (workflow == null) {
                throw new RuntimeException("\u672a\u627e\u5230\u533b\u9662\u5bf9\u5e94\u7684\u5de5\u4f5c\u6d41\u914d\u7f6e");
            }
            return this.blockingChatRequest(request, workflow);
        }
        catch (Exception e) {
            logger.error("\u591a\u5de5\u4f5c\u6d41\u963b\u585e\u804a\u5929\u8bf7\u6c42\u5931\u8d25: hospitalId={}", (Object)request.getHospitalId(), (Object)e);
            throw new RuntimeException("\u804a\u5929\u8bf7\u6c42\u5931\u8d25: " + e.getMessage());
        }
    }

    public boolean hasWorkflowConfig(String hospitalId) {
        return this.hospitalWorkflowService.hasWorkflowConfig(hospitalId);
    }

    public String getWorkflowInfo(String hospitalId) {
        List workflows = this.hospitalWorkflowService.getWorkflowsByHospitalId(hospitalId);
        if (workflows.isEmpty()) {
            return "\u65e0\u53ef\u7528\u5de5\u4f5c\u6d41";
        }
        StringBuilder info = new StringBuilder();
        for (HospitalWorkflow workflow : workflows) {
            if (info.length() > 0) {
                info.append(", ");
            }
            info.append(workflow.getWorkflowName()).append("(").append(workflow.getWorkflowType()).append(")");
        }
        return info.toString();
    }

    private void streamChatRequest(DifyChatRequest request, HospitalWorkflow workflow, SseEmitter emitter, WebSocketSession session) throws Exception {
        String url = workflow.getDifyApiUrl() + "/chat-messages";
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Authorization", "Bearer " + workflow.getDifyApiKey());
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoOutput(true);
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("inputs", new HashMap());
        requestBody.put("query", request.getQuery());
        requestBody.put("response_mode", "streaming");
        if (request.getConversationId() != null && !request.getConversationId().trim().isEmpty()) {
            requestBody.put("conversation_id", request.getConversationId());
        }
        requestBody.put("user", request.getUser());
        if (request.getFiles() != null && !request.getFiles().isEmpty()) {
            requestBody.put("files", request.getFiles());
        }
        String jsonBody = this.objectMapper.writeValueAsString(requestBody);
        connection.getOutputStream().write(jsonBody.getBytes(StandardCharsets.UTF_8));
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            String errorResponse = "";
            try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));){
                String line;
                StringBuilder errorBuilder = new StringBuilder();
                while ((line = errorReader.readLine()) != null) {
                    errorBuilder.append(line);
                }
                errorResponse = errorBuilder.toString();
            }
            catch (Exception e) {
                errorResponse = "\u65e0\u6cd5\u8bfb\u53d6\u9519\u8bef\u8be6\u60c5";
            }
            String errorMsg = String.format("Dify API\u8bf7\u6c42\u5931\u8d25: HTTP %d, URL: %s, \u54cd\u5e94: %s", responseCode, url, errorResponse);
            logger.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            int messageCount = 0;
            logger.info("\u5f00\u59cb\u8bfb\u53d6Dify\u6d41\u5f0f\u54cd\u5e94");
            while ((line = reader.readLine()) != null) {
                String processedData;
                int processedSize;
                if (!line.startsWith("data: ")) continue;
                String data = line.substring(6);
                if ("[DONE]".equals(data.trim())) {
                    logger.info("Dify\u6d41\u5f0f\u54cd\u5e94\u7ed3\u675f\uff0c\u5171\u5904\u7406{}\u6761\u6d88\u606f", (Object)messageCount);
                    break;
                }
                int dataSize = data.getBytes(StandardCharsets.UTF_8).length;
                logger.info("\u6536\u5230Dify\u54cd\u5e94\u6570\u636e #{}: \u957f\u5ea6={} bytes", (Object)(++messageCount), (Object)dataSize);
                if (dataSize > 8192) {
                    String preview = data.length() > 200 ? data.substring(0, 200) + "..." : data;
                    logger.warn("\u68c0\u6d4b\u5230\u5927\u6d88\u606f #{}: \u524d200\u5b57\u7b26\u5185\u5bb9={}", (Object)messageCount, (Object)preview);
                }
                if ((processedSize = (processedData = DifyResponseProcessor.processDifyResponse((String)data, (int)messageCount)).getBytes(StandardCharsets.UTF_8).length) != dataSize) {
                    logger.info("Dify\u54cd\u5e94 #{} \u9884\u5904\u7406\u5b8c\u6210: {}bytes -> {}bytes", new Object[]{messageCount, dataSize, processedSize});
                }
                if (emitter != null) {
                    emitter.send(SseEmitter.event().data((Object)processedData));
                }
                if (session != null && session.isOpen()) {
                    boolean sendSuccess = UltraSafeMessageSender.ultraSafeSend((WebSocketSession)session, (String)processedData, (String)("dify_" + messageCount));
                    if (sendSuccess) continue;
                    logger.error("\u6d88\u606f #{} \u53d1\u9001\u5931\u8d25\uff0c\u505c\u6b62\u540e\u7eed\u6d88\u606f\u53d1\u9001", (Object)messageCount);
                    break;
                }
                if (session == null) continue;
                logger.warn("WebSocket\u4f1a\u8bdd\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u53d1\u9001\u6d88\u606f #{}", (Object)messageCount);
                break;
            }
            if (emitter != null) {
                emitter.complete();
            }
        }
        catch (Exception e) {
            logger.error("\u6d41\u5f0f\u54cd\u5e94\u5904\u7406\u5931\u8d25", (Throwable)e);
            if (emitter != null) {
                emitter.completeWithError((Throwable)e);
            }
            throw e;
        }
    }

    private String blockingChatRequest(DifyChatRequest request, HospitalWorkflow workflow) throws Exception {
        HttpEntity entity;
        ResponseEntity response;
        String url = workflow.getDifyApiUrl() + "/chat-messages";
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + workflow.getDifyApiKey());
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("inputs", new HashMap());
        requestBody.put("query", request.getQuery());
        requestBody.put("response_mode", "blocking");
        if (request.getConversationId() != null && !request.getConversationId().trim().isEmpty()) {
            requestBody.put("conversation_id", request.getConversationId());
        }
        requestBody.put("user", request.getUser());
        if (request.getFiles() != null && !request.getFiles().isEmpty()) {
            requestBody.put("files", request.getFiles());
        }
        if ((response = this.restTemplate.postForEntity(url, (Object)(entity = new HttpEntity(requestBody, (MultiValueMap)headers)), String.class, new Object[0])).getStatusCode() == HttpStatus.OK) {
            JsonNode jsonNode = this.objectMapper.readTree((String)response.getBody());
            return jsonNode.get("answer").asText();
        }
        throw new RuntimeException("Dify API\u8bf7\u6c42\u5931\u8d25: " + response.getStatusCode());
    }

    private void sendErrorMessage(WebSocketSession session, String message) {
        UltraSafeMessageSender.sendError((WebSocketSession)session, (String)message);
    }
}

