/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.model.DifyChatRequest;
import com.chdu.ai.model.DifySTTRequest;
import com.chdu.ai.model.DifyTTSRequest;
import com.chdu.ai.service.DifyService;
import com.chdu.ai.service.DifyTTSService;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@RequestMapping(value={"/api/dify"})
@CrossOrigin(origins={"*"})
public class DifyController {
    private static final Logger logger = LoggerFactory.getLogger(DifyController.class);
    @Autowired
    private DifyService difyService;
    @Autowired
    private DifyTTSService difyTTSService;

    @PostMapping(value={"/chat/stream"}, produces={"text/event-stream"})
    public SseEmitter chatStream(@RequestBody DifyChatRequest request, HttpServletRequest httpRequest) {
        try {
            logger.info("\u6536\u5230Dify\u6d41\u5f0f\u804a\u5929\u8bf7\u6c42: \u7528\u6237={}, \u533b\u9662ID={}, \u5de5\u4f5c\u6d41\u7c7b\u578b={}, \u67e5\u8be2={}", new Object[]{request.getUser(), request.getHospitalId(), request.getWorkflowType(), request.getQuery()});
            if (request.getQuery() == null || request.getQuery().trim().isEmpty()) {
                SseEmitter emitter = new SseEmitter();
                emitter.completeWithError((Throwable)new IllegalArgumentException("\u67e5\u8be2\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a"));
                return emitter;
            }
            if (request.getUser() == null || request.getUser().trim().isEmpty()) {
                SseEmitter emitter = new SseEmitter();
                emitter.completeWithError((Throwable)new IllegalArgumentException("\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a"));
                return emitter;
            }
            if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                SseEmitter emitter = new SseEmitter();
                emitter.completeWithError((Throwable)new IllegalArgumentException("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a"));
                return emitter;
            }
            if (request.getWorkflowType() == null || request.getWorkflowType().trim().isEmpty()) {
                SseEmitter emitter = new SseEmitter();
                emitter.completeWithError((Throwable)new IllegalArgumentException("\u5de5\u4f5c\u6d41\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
                return emitter;
            }
            return this.difyService.chatWithDify(request);
        }
        catch (Exception e) {
            logger.error("Dify\u6d41\u5f0f\u804a\u5929\u8bf7\u6c42\u5904\u7406\u5931\u8d25", (Throwable)e);
            SseEmitter emitter = new SseEmitter();
            emitter.completeWithError((Throwable)e);
            return emitter;
        }
    }

    @PostMapping(value={"/chat/blocking"})
    public BaseResponse<Map<String, Object>> chatBlocking(@RequestBody DifyChatRequest request) {
        try {
            logger.info("\u6536\u5230Dify\u963b\u585e\u5f0f\u804a\u5929\u8bf7\u6c42: \u7528\u6237={}, \u533b\u9662ID={}, \u5de5\u4f5c\u6d41\u7c7b\u578b={}, \u67e5\u8be2={}", new Object[]{request.getUser(), request.getHospitalId(), request.getWorkflowType(), request.getQuery()});
            if (request.getQuery() == null || request.getQuery().trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u67e5\u8be2\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getUser() == null || request.getUser().trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getWorkflowType() == null || request.getWorkflowType().trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u5de5\u4f5c\u6d41\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String answer = this.difyService.chatWithDifyBlocking(request);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("answer", answer);
            result.put("conversation_id", request.getConversationId());
            result.put("user", request.getUser());
            return BaseResponse.success(result);
        }
        catch (Exception e) {
            logger.error("Dify\u963b\u585e\u5f0f\u804a\u5929\u8bf7\u6c42\u5904\u7406\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u5904\u7406\u804a\u5929\u8bf7\u6c42\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/conversations/{conversationId}/messages"})
    public BaseResponse<String> getConversationHistory(@PathVariable String conversationId, @RequestParam String user) {
        try {
            logger.info("\u83b7\u53d6\u5bf9\u8bdd\u5386\u53f2: \u5bf9\u8bddID={}, \u7528\u6237={}", (Object)conversationId, (Object)user);
            String history = this.difyService.getConversationHistory(conversationId, user);
            if (history != null) {
                return BaseResponse.success((Object)history);
            }
            return BaseResponse.error((String)"404", (String)"\u83b7\u53d6\u5bf9\u8bdd\u5386\u53f2\u5931\u8d25");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5bf9\u8bdd\u5386\u53f2\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u83b7\u53d6\u5bf9\u8bdd\u5386\u53f2\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/conversations/{conversationId}"})
    public BaseResponse<String> deleteConversation(@PathVariable String conversationId, @RequestParam String user) {
        try {
            logger.info("\u5220\u9664\u5bf9\u8bdd: \u5bf9\u8bddID={}, \u7528\u6237={}", (Object)conversationId, (Object)user);
            boolean success = this.difyService.deleteConversation(conversationId, user);
            if (success) {
                return BaseResponse.success((Object)"\u5bf9\u8bdd\u5220\u9664\u6210\u529f");
            }
            return BaseResponse.error((String)"404", (String)"\u5bf9\u8bdd\u5220\u9664\u5931\u8d25");
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u5bf9\u8bdd\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u5220\u9664\u5bf9\u8bdd\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/parameters"})
    public BaseResponse<String> getApplicationParameters(@RequestParam String user) {
        try {
            logger.info("\u83b7\u53d6\u5e94\u7528\u53c2\u6570: \u7528\u6237={}", (Object)user);
            String parameters = this.difyService.getApplicationParameters(user);
            if (parameters != null) {
                return BaseResponse.success((Object)parameters);
            }
            return BaseResponse.error((String)"404", (String)"\u83b7\u53d6\u5e94\u7528\u53c2\u6570\u5931\u8d25");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5e94\u7528\u53c2\u6570\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u83b7\u53d6\u5e94\u7528\u53c2\u6570\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/tts"})
    public ResponseEntity<?> textToSpeech(@RequestBody DifyTTSRequest request) {
        try {
            logger.info("\u6536\u5230Dify TTS\u8bf7\u6c42: \u7528\u6237={}, \u533b\u9662ID={}, \u5de5\u4f5c\u6d41\u7c7b\u578b={}, messageId={}, \u6587\u672c\u957f\u5ea6={}", new Object[]{request.getUser(), request.getHospitalId(), request.getWorkflowType(), request.getMessageId(), request.getText() != null ? request.getText().length() : 0});
            if ((request.getMessageId() == null || request.getMessageId().trim().isEmpty()) && (request.getText() == null || request.getText().trim().isEmpty())) {
                return ResponseEntity.badRequest().body((Object)BaseResponse.error((String)"400", (String)"message_id\u548ctext\u81f3\u5c11\u9700\u8981\u63d0\u4f9b\u4e00\u4e2a"));
            }
            if (request.getUser() == null || request.getUser().trim().isEmpty()) {
                return ResponseEntity.badRequest().body((Object)BaseResponse.error((String)"400", (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                return ResponseEntity.badRequest().body((Object)BaseResponse.error((String)"400", (String)"\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (request.getWorkflowType() == null || request.getWorkflowType().trim().isEmpty()) {
                return ResponseEntity.badRequest().body((Object)BaseResponse.error((String)"400", (String)"\u5de5\u4f5c\u6d41\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (!this.difyTTSService.isTTSAvailable(request.getHospitalId(), request.getWorkflowType())) {
                return ResponseEntity.status((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE).body((Object)BaseResponse.error((String)"503", (String)"TTS\u670d\u52a1\u4e0d\u53ef\u7528"));
            }
            InputStream audioStream = this.difyTTSService.textToSpeech(request);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)"audio/wav"));
            headers.setContentDispositionFormData("attachment", "dify_tts_audio.wav");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)new InputStreamResource(audioStream));
        }
        catch (Exception e) {
            logger.error("Dify TTS\u8bf7\u6c42\u5904\u7406\u5931\u8d25", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)BaseResponse.error((String)"500", (String)("TTS\u5904\u7406\u5931\u8d25: " + e.getMessage())));
        }
    }

    @PostMapping(value={"/stt"})
    public BaseResponse<Map<String, Object>> speechToText(@RequestParam(value="audioFile") MultipartFile audioFile, @RequestParam(value="user") String user, @RequestParam(value="hospitalId") String hospitalId, @RequestParam(value="workflowType") String workflowType, @RequestParam(value="language", required=false) String language) {
        try {
            logger.info("\u6536\u5230Dify STT\u8bf7\u6c42: \u7528\u6237={}, \u533b\u9662ID={}, \u5de5\u4f5c\u6d41\u7c7b\u578b={}, \u6587\u4ef6\u540d={}", new Object[]{user, hospitalId, workflowType, audioFile.getOriginalFilename()});
            if (audioFile == null || audioFile.isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u97f3\u9891\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (user == null || user.trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (hospitalId == null || hospitalId.trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (workflowType == null || workflowType.trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u5de5\u4f5c\u6d41\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String contentType = audioFile.getContentType();
            if (contentType == null || !contentType.startsWith("audio/")) {
                return BaseResponse.error((String)"400", (String)"\u8bf7\u4e0a\u4f20\u97f3\u9891\u6587\u4ef6");
            }
            if (!this.difyTTSService.isSTTAvailable(hospitalId, workflowType)) {
                return BaseResponse.error((String)"503", (String)"STT\u670d\u52a1\u4e0d\u53ef\u7528");
            }
            DifySTTRequest request = new DifySTTRequest();
            request.setAudioFile(audioFile);
            request.setUser(user);
            request.setHospitalId(hospitalId);
            request.setWorkflowType(workflowType);
            request.setLanguage(language);
            String recognizedText = this.difyTTSService.speechToText(request);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("text", recognizedText);
            result.put("user", user);
            result.put("hospitalId", hospitalId);
            result.put("workflowType", workflowType);
            result.put("language", language);
            result.put("fileName", audioFile.getOriginalFilename());
            result.put("fileSize", audioFile.getSize());
            return BaseResponse.success(result);
        }
        catch (Exception e) {
            logger.error("Dify STT\u8bf7\u6c42\u5904\u7406\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("STT\u5904\u7406\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/tts/status"})
    public BaseResponse<Map<String, Object>> getTTSStatus(@RequestParam String hospitalId, @RequestParam String workflowType) {
        try {
            boolean available = this.difyTTSService.isTTSAvailable(hospitalId, workflowType);
            HashMap<String, Object> status = new HashMap<String, Object>();
            status.put("available", available);
            status.put("service", "Dify TTS");
            status.put("hospitalId", hospitalId);
            status.put("workflowType", workflowType);
            status.put("timestamp", System.currentTimeMillis());
            return BaseResponse.success(status);
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5TTS\u670d\u52a1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u68c0\u67e5\u670d\u52a1\u72b6\u6001\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/stt/status"})
    public BaseResponse<Map<String, Object>> getSTTStatus(@RequestParam String hospitalId, @RequestParam String workflowType) {
        try {
            boolean available = this.difyTTSService.isSTTAvailable(hospitalId, workflowType);
            HashMap<String, Object> status = new HashMap<String, Object>();
            status.put("available", available);
            status.put("service", "Dify STT");
            status.put("hospitalId", hospitalId);
            status.put("workflowType", workflowType);
            status.put("timestamp", System.currentTimeMillis());
            return BaseResponse.success(status);
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5STT\u670d\u52a1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u68c0\u67e5\u670d\u52a1\u72b6\u6001\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/health"})
    public BaseResponse<Map<String, Object>> health() {
        HashMap<String, Object> status = new HashMap<String, Object>();
        status.put("status", "UP");
        status.put("service", "Dify AI Service");
        status.put("timestamp", System.currentTimeMillis());
        return BaseResponse.success(status);
    }
}

