/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.model.DifySTTRequest;
import com.chdu.ai.model.DifyTTSRequest;
import com.chdu.ai.model.HospitalWorkflow;
import com.chdu.ai.model.TTSAudioCache;
import com.chdu.ai.service.DifyTTSService;
import com.chdu.ai.service.HospitalWorkflowService;
import com.chdu.ai.service.TTSCacheService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DifyTTSServiceImpl
implements DifyTTSService {
    private static final Logger logger = LoggerFactory.getLogger(DifyTTSServiceImpl.class);
    @Autowired
    private HospitalWorkflowService hospitalWorkflowService;
    @Autowired
    private TTSCacheService ttsCacheService;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public InputStream textToSpeech(DifyTTSRequest request) {
        try {
            logger.info("\u5f00\u59cbDify\u6587\u5b57\u8f6c\u8bed\u97f3: \u7528\u6237={}, \u533b\u9662ID={}, \u5de5\u4f5c\u6d41\u7c7b\u578b={}, messageId={}, \u6587\u672c\u957f\u5ea6={}", new Object[]{request.getUser(), request.getHospitalId(), request.getWorkflowType(), request.getMessageId(), request.getText() != null ? request.getText().length() : 0});
            TTSAudioCache cachedAudio = this.ttsCacheService.findCachedAudio(request.getMessageId(), request.getText(), request.getHospitalId(), request.getWorkflowType());
            if (cachedAudio != null) {
                logger.info("\u627e\u5230TTS\u7f13\u5b58\uff0c\u76f4\u63a5\u8fd4\u56de: cacheId={}, ossUrl={}", (Object)cachedAudio.getId(), (Object)cachedAudio.getOssUrl());
                this.ttsCacheService.updateHitCount(cachedAudio.getId());
                return new ByteArrayInputStream(new byte[0]);
            }
            logger.info("\u672a\u627e\u5230TTS\u7f13\u5b58\uff0c\u8c03\u7528Dify API\u751f\u6210\u97f3\u9891");
            HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(request.getHospitalId(), request.getWorkflowType());
            if (workflow == null) {
                throw new RuntimeException("\u672a\u627e\u5230\u533b\u9662\u5bf9\u5e94\u7684\u5de5\u4f5c\u6d41\u914d\u7f6e");
            }
            String ttsUrl = workflow.getDifyApiUrl() + "/text-to-audio";
            HttpURLConnection connection = (HttpURLConnection)new URL(ttsUrl).openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Authorization", "Bearer " + workflow.getDifyApiKey());
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            HashMap<String, String> requestBody = new HashMap<String, String>();
            requestBody.put("user", request.getUser());
            if (request.getMessageId() != null && !request.getMessageId().trim().isEmpty()) {
                requestBody.put("message_id", request.getMessageId());
                logger.debug("\u4f7f\u7528message_id\u8fdb\u884cTTS: {}", (Object)request.getMessageId());
            } else if (request.getText() != null && !request.getText().trim().isEmpty()) {
                requestBody.put("text", request.getText());
                logger.debug("\u4f7f\u7528text\u8fdb\u884cTTS: {}\u5b57\u7b26", (Object)request.getText().length());
            } else {
                throw new RuntimeException("message_id\u548ctext\u81f3\u5c11\u9700\u8981\u63d0\u4f9b\u4e00\u4e2a");
            }
            String jsonBody = this.objectMapper.writeValueAsString(requestBody);
            connection.getOutputStream().write(jsonBody.getBytes(StandardCharsets.UTF_8));
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                logger.info("Dify TTS\u8bf7\u6c42\u6210\u529f: \u7528\u6237={}", (Object)request.getUser());
                InputStream audioStream = connection.getInputStream();
                try {
                    TTSAudioCache newCache = this.ttsCacheService.cacheAudioFile(request.getMessageId(), request.getText(), request.getHospitalId(), request.getWorkflowType(), request.getUser(), audioStream, connection.getContentLengthLong());
                    logger.info("TTS\u97f3\u9891\u7f13\u5b58\u6210\u529f: cacheId={}, ossUrl={}", (Object)newCache.getId(), (Object)newCache.getOssUrl());
                    return new ByteArrayInputStream(new byte[0]);
                }
                catch (Exception cacheException) {
                    logger.error("\u7f13\u5b58TTS\u97f3\u9891\u5931\u8d25\uff0c\u76f4\u63a5\u8fd4\u56de\u539f\u59cb\u6d41: \u7528\u6237={}", (Object)request.getUser(), (Object)cacheException);
                    audioStream.close();
                    HttpURLConnection newConnection = (HttpURLConnection)new URL(ttsUrl).openConnection();
                    newConnection.setRequestMethod("POST");
                    newConnection.setRequestProperty("Authorization", "Bearer " + workflow.getDifyApiKey());
                    newConnection.setRequestProperty("Content-Type", "application/json");
                    newConnection.setDoOutput(true);
                    newConnection.getOutputStream().write(jsonBody.getBytes(StandardCharsets.UTF_8));
                    return newConnection.getInputStream();
                }
            }
            String errorResponse = this.readErrorResponse(connection);
            String errorMsg = String.format("Dify TTS\u8bf7\u6c42\u5931\u8d25: HTTP %d, \u54cd\u5e94: %s", responseCode, errorResponse);
            logger.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        catch (Exception e) {
            logger.error("Dify\u6587\u5b57\u8f6c\u8bed\u97f3\u5931\u8d25: \u7528\u6237={}", (Object)request.getUser(), (Object)e);
            throw new RuntimeException("\u6587\u5b57\u8f6c\u8bed\u97f3\u5931\u8d25: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String speechToText(DifySTTRequest request) {
        try {
            Object object;
            Object writer;
            logger.info("\u5f00\u59cbDify\u8bed\u97f3\u8f6c\u6587\u5b57: \u7528\u6237={}, \u533b\u9662ID={}, \u5de5\u4f5c\u6d41\u7c7b\u578b={}, \u6587\u4ef6\u540d={}", new Object[]{request.getUser(), request.getHospitalId(), request.getWorkflowType(), request.getAudioFile() != null ? request.getAudioFile().getOriginalFilename() : "null"});
            HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(request.getHospitalId(), request.getWorkflowType());
            if (workflow == null) {
                throw new RuntimeException("\u672a\u627e\u5230\u533b\u9662\u5bf9\u5e94\u7684\u5de5\u4f5c\u6d41\u914d\u7f6e");
            }
            String sttUrl = workflow.getDifyApiUrl() + "/audio-to-text";
            HttpURLConnection connection = (HttpURLConnection)new URL(sttUrl).openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Authorization", "Bearer " + workflow.getDifyApiKey());
            connection.setDoOutput(true);
            String boundary = "----WebKitFormBoundary" + System.currentTimeMillis();
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            try (OutputStream outputStream = connection.getOutputStream();){
                writer = new PrintWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), true);
                Throwable throwable = null;
                try {
                    ((PrintWriter)writer).append("--").append(boundary).append("\r\n");
                    ((PrintWriter)writer).append("Content-Disposition: form-data; name=\"user\"").append("\r\n");
                    ((PrintWriter)writer).append("\r\n");
                    ((PrintWriter)writer).append(request.getUser()).append("\r\n");
                    if (request.getLanguage() != null && !request.getLanguage().trim().isEmpty()) {
                        ((PrintWriter)writer).append("--").append(boundary).append("\r\n");
                        ((PrintWriter)writer).append("Content-Disposition: form-data; name=\"language\"").append("\r\n");
                        ((PrintWriter)writer).append("\r\n");
                        ((PrintWriter)writer).append(request.getLanguage()).append("\r\n");
                    }
                    ((PrintWriter)writer).append("--").append(boundary).append("\r\n");
                    ((PrintWriter)writer).append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(request.getAudioFile().getOriginalFilename()).append("\"").append("\r\n");
                    ((PrintWriter)writer).append("Content-Type: ").append(request.getAudioFile().getContentType()).append("\r\n");
                    ((PrintWriter)writer).append("\r\n");
                    ((PrintWriter)writer).flush();
                    InputStream fileInputStream = request.getAudioFile().getInputStream();
                    object = null;
                    try {
                        int bytesRead;
                        byte[] buffer = new byte[4096];
                        while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, bytesRead);
                        }
                    }
                    catch (Throwable throwable2) {
                        object = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fileInputStream != null) {
                            if (object != null) {
                                try {
                                    fileInputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)object).addSuppressed(throwable3);
                                }
                            } else {
                                fileInputStream.close();
                            }
                        }
                    }
                    ((PrintWriter)writer).append("\r\n");
                    ((PrintWriter)writer).append("--").append(boundary).append("--").append("\r\n");
                    ((PrintWriter)writer).flush();
                }
                catch (Throwable fileInputStream) {
                    throwable = fileInputStream;
                    throw fileInputStream;
                }
                finally {
                    if (writer != null) {
                        if (throwable != null) {
                            try {
                                ((PrintWriter)writer).close();
                            }
                            catch (Throwable fileInputStream) {
                                throwable.addSuppressed(fileInputStream);
                            }
                        } else {
                            ((PrintWriter)writer).close();
                        }
                    }
                }
            }
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                String errorResponse = this.readErrorResponse(connection);
                String errorMsg = String.format("Dify STT\u8bf7\u6c42\u5931\u8d25: HTTP %d, \u54cd\u5e94: %s", responseCode, errorResponse);
                logger.error(errorMsg);
                throw new RuntimeException(errorMsg);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            writer = null;
            try {
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                logger.info("Dify STT\u8bf7\u6c42\u6210\u529f: \u7528\u6237={}", (Object)request.getUser());
                object = response.toString();
                return object;
            }
            catch (Throwable throwable) {
                writer = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (writer != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)writer).addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Dify\u8bed\u97f3\u8f6c\u6587\u5b57\u5931\u8d25: \u7528\u6237={}", (Object)request.getUser(), (Object)e);
            throw new RuntimeException("\u8bed\u97f3\u8f6c\u6587\u5b57\u5931\u8d25: " + e.getMessage());
        }
    }

    public boolean isTTSAvailable(String hospitalId, String workflowType) {
        try {
            HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(hospitalId, workflowType);
            return workflow != null && workflow.getDifyApiUrl() != null && workflow.getDifyApiKey() != null;
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5TTS\u670d\u52a1\u53ef\u7528\u6027\u5931\u8d25: hospitalId={}, workflowType={}", new Object[]{hospitalId, workflowType, e});
            return false;
        }
    }

    public boolean isSTTAvailable(String hospitalId, String workflowType) {
        try {
            HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(hospitalId, workflowType);
            return workflow != null && workflow.getDifyApiUrl() != null && workflow.getDifyApiKey() != null;
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5STT\u670d\u52a1\u53ef\u7528\u6027\u5931\u8d25: hospitalId={}, workflowType={}", new Object[]{hospitalId, workflowType, e});
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readErrorResponse(HttpURLConnection connection) {
        try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder errorBuilder = new StringBuilder();
            while ((line = errorReader.readLine()) != null) {
                errorBuilder.append(line);
            }
            String string = errorBuilder.toString();
            return string;
        }
        catch (Exception e) {
            return "\u65e0\u6cd5\u8bfb\u53d6\u9519\u8bef\u8be6\u60c5";
        }
    }
}

