/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.rabbitmq;

import com.chdu.ai.model.ChatMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.stereotype.Service;

@Service
public class RabbitMQProducer {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQProducer.class);
    private final RabbitTemplate rabbitTemplate;

    public RabbitMQProducer(RabbitTemplate rabbitTemplate) {
        this.rabbitTemplate = rabbitTemplate;
    }

    public void sendMedicalQuery(String query) {
        log.info("\u53d1\u9001\u533b\u5b66\u95ee\u7b54\u8bf7\u6c42\u5230 RabbitMQ: {}", (Object)query);
        this.rabbitTemplate.convertAndSend("medical_exchange", "medical_routing_key", (Object)query);
    }

    public void sendMessage(ChatMessage chatMessage) {
        log.info("\u53d1\u9001\u804a\u5929\u6d88\u606f\u5230 RabbitMQ: {}", (Object)chatMessage);
        this.rabbitTemplate.convertAndSend("chat_exchange", "chat.send", (Object)chatMessage);
    }
}

