/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class AudioDurationUtil {
    private static final Logger logger = LoggerFactory.getLogger(AudioDurationUtil.class);

    public static Double calculateDuration(InputStream audioStream) {
        try {
            if (audioStream.markSupported()) {
                audioStream.reset();
            }
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(audioStream);
            AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(audioInputStream);
            long frameLength = audioFileFormat.getFrameLength();
            float frameRate = audioFileFormat.getFormat().getFrameRate();
            if (frameLength != -1L && frameRate != -1.0f) {
                double duration = (float)frameLength / frameRate;
                logger.debug("\u97f3\u9891\u65f6\u957f\u8ba1\u7b97\u6210\u529f: {} \u79d2", (Object)duration);
                return duration;
            }
            logger.warn("\u65e0\u6cd5\u83b7\u53d6\u97f3\u9891\u5e27\u4fe1\u606f\u6765\u8ba1\u7b97\u65f6\u957f");
            return null;
        }
        catch (Exception e) {
            logger.error("\u8ba1\u7b97\u97f3\u9891\u65f6\u957f\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Double calculateDuration(byte[] audioBytes) {
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(audioBytes);){
            Double d = AudioDurationUtil.calculateDuration((InputStream)byteStream);
            return d;
        }
        catch (Exception e) {
            logger.error("\u8ba1\u7b97\u5b57\u8282\u6570\u7ec4\u97f3\u9891\u65f6\u957f\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static String formatDuration(Double durationSeconds) {
        if (durationSeconds == null) {
            return "\u672a\u77e5";
        }
        int minutes = (int)(durationSeconds / 60.0);
        int seconds = (int)(durationSeconds % 60.0);
        return String.format("%d:%02d", minutes, seconds);
    }

    public static boolean isSupportedAudioFormat(String contentType) {
        if (contentType == null) {
            return false;
        }
        String lowerContentType = contentType.toLowerCase();
        return lowerContentType.startsWith("audio/") && (lowerContentType.contains("wav") || lowerContentType.contains("mp3") || lowerContentType.contains("m4a") || lowerContentType.contains("aac"));
    }
}

