/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.model.DifyDataset;
import com.chdu.ai.model.DifyDocument;
import com.chdu.ai.model.DifyDocumentRequest;
import com.chdu.ai.model.DifyKnowledgeRequest;
import com.chdu.ai.service.DifyKnowledgeService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/dify/knowledge"})
@CrossOrigin(origins={"*"})
public class DifyKnowledgeController {
    private static final Logger logger = LoggerFactory.getLogger(DifyKnowledgeController.class);
    @Autowired
    private DifyKnowledgeService difyKnowledgeService;

    @PostMapping(value={"/datasets"})
    public ResponseEntity<BaseResponse<DifyDataset>> createDataset(@RequestBody DifyKnowledgeRequest request, @RequestParam String hospitalId, @RequestParam String createdBy, HttpServletRequest httpRequest) {
        logger.info("\u521b\u5efa\u77e5\u8bc6\u5e93\u6570\u636e\u96c6\u8bf7\u6c42: name={}, hospitalId={}, createdBy={}", new Object[]{request.getName(), hospitalId, createdBy});
        try {
            DifyDataset dataset = this.difyKnowledgeService.createDataset(request, hospitalId, createdBy);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u521b\u5efa\u6570\u636e\u96c6\u6210\u529f");
            response.setData((Object)dataset);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u77e5\u8bc6\u5e93\u6570\u636e\u96c6\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u521b\u5efa\u6570\u636e\u96c6\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @GetMapping(value={"/datasets"})
    public ResponseEntity<BaseResponse<List<DifyDataset>>> getDatasets(@RequestParam String hospitalId, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="20") int limit, HttpServletRequest httpRequest) {
        logger.info("\u83b7\u53d6\u77e5\u8bc6\u5e93\u6570\u636e\u96c6\u5217\u8868: hospitalId={}, page={}, limit={}", new Object[]{hospitalId, page, limit});
        try {
            List datasets = this.difyKnowledgeService.getDatasets(hospitalId, page, limit);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u83b7\u53d6\u6570\u636e\u96c6\u5217\u8868\u6210\u529f");
            response.setData((Object)datasets);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u77e5\u8bc6\u5e93\u6570\u636e\u96c6\u5217\u8868\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u83b7\u53d6\u6570\u636e\u96c6\u5217\u8868\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @GetMapping(value={"/datasets/{datasetId}"})
    public ResponseEntity<BaseResponse<DifyDataset>> getDatasetById(@PathVariable String datasetId, @RequestParam String hospitalId, HttpServletRequest httpRequest) {
        logger.info("\u83b7\u53d6\u6570\u636e\u96c6\u8be6\u60c5: datasetId={}, hospitalId={}", (Object)datasetId, (Object)hospitalId);
        try {
            DifyDataset dataset = this.difyKnowledgeService.getDatasetById(datasetId, hospitalId);
            BaseResponse response = new BaseResponse();
            if (dataset != null) {
                response.setCode("200");
                response.setMsg("\u83b7\u53d6\u6570\u636e\u96c6\u8be6\u60c5\u6210\u529f");
                response.setData((Object)dataset);
            } else {
                response.setCode("404");
                response.setMsg("\u6570\u636e\u96c6\u4e0d\u5b58\u5728");
            }
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u96c6\u8be6\u60c5\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u83b7\u53d6\u6570\u636e\u96c6\u8be6\u60c5\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PutMapping(value={"/datasets/{datasetId}"})
    public ResponseEntity<BaseResponse<DifyDataset>> updateDataset(@PathVariable String datasetId, @RequestBody DifyKnowledgeRequest request, @RequestParam String hospitalId, @RequestParam String updatedBy, HttpServletRequest httpRequest) {
        logger.info("\u66f4\u65b0\u6570\u636e\u96c6\u4fe1\u606f: datasetId={}, hospitalId={}, updatedBy={}", new Object[]{datasetId, hospitalId, updatedBy});
        try {
            DifyDataset dataset = this.difyKnowledgeService.updateDataset(datasetId, request, hospitalId, updatedBy);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u66f4\u65b0\u6570\u636e\u96c6\u6210\u529f");
            response.setData((Object)dataset);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u6570\u636e\u96c6\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u66f4\u65b0\u6570\u636e\u96c6\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @DeleteMapping(value={"/datasets/{datasetId}"})
    public ResponseEntity<BaseResponse<Boolean>> deleteDataset(@PathVariable String datasetId, @RequestParam String hospitalId, HttpServletRequest httpRequest) {
        logger.info("\u5220\u9664\u6570\u636e\u96c6: datasetId={}, hospitalId={}", (Object)datasetId, (Object)hospitalId);
        try {
            boolean success = this.difyKnowledgeService.deleteDataset(datasetId, hospitalId);
            BaseResponse response = new BaseResponse();
            response.setCode(success ? "200" : "500");
            response.setMsg(success ? "\u5220\u9664\u6570\u636e\u96c6\u6210\u529f" : "\u5220\u9664\u6570\u636e\u96c6\u5931\u8d25");
            response.setData((Object)success);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u96c6\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u5220\u9664\u6570\u636e\u96c6\u5931\u8d25: " + e.getMessage());
            response.setData((Object)false);
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/datasets/{datasetId}/documents"})
    public ResponseEntity<BaseResponse<DifyDocument>> uploadDocument(@PathVariable String datasetId, @RequestParam(value="file") MultipartFile file, @RequestParam String hospitalId, @RequestParam String uploadedBy, @RequestParam(defaultValue="high_quality") String indexingTechnique, @RequestParam(defaultValue="automatic") String processRule, @RequestParam(defaultValue="enabled") String duplicateCheck, @RequestParam(required=false) String separator, @RequestParam(required=false) Integer maxTokens, @RequestParam(required=false) Integer chunkOverlap, HttpServletRequest httpRequest) {
        logger.info("\u4e0a\u4f20\u6587\u6863\u5230\u6570\u636e\u96c6: datasetId={}, fileName={}, hospitalId={}, uploadedBy={}", new Object[]{datasetId, file.getOriginalFilename(), hospitalId, uploadedBy});
        try {
            DifyDocumentRequest request = new DifyDocumentRequest();
            request.setDatasetId(datasetId);
            request.setFile(file);
            request.setIndexingTechnique(indexingTechnique);
            request.setProcessRule(processRule);
            request.setDuplicateCheck(duplicateCheck);
            request.setSeparator(separator);
            request.setMaxTokens(maxTokens);
            request.setChunkOverlap(chunkOverlap);
            DifyDocument document = this.difyKnowledgeService.uploadDocument(request, hospitalId, uploadedBy);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u4e0a\u4f20\u6587\u6863\u6210\u529f");
            response.setData((Object)document);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u6863\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u4e0a\u4f20\u6587\u6863\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @GetMapping(value={"/datasets/{datasetId}/documents"})
    public ResponseEntity<BaseResponse<List<DifyDocument>>> getDocuments(@PathVariable String datasetId, @RequestParam String hospitalId, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="20") int limit, HttpServletRequest httpRequest) {
        logger.info("\u83b7\u53d6\u6570\u636e\u96c6\u6587\u6863\u5217\u8868: datasetId={}, hospitalId={}, page={}, limit={}", new Object[]{datasetId, hospitalId, page, limit});
        try {
            List documents = this.difyKnowledgeService.getDocuments(datasetId, hospitalId, page, limit);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u83b7\u53d6\u6587\u6863\u5217\u8868\u6210\u529f");
            response.setData((Object)documents);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u96c6\u6587\u6863\u5217\u8868\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u83b7\u53d6\u6587\u6863\u5217\u8868\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @GetMapping(value={"/documents/{documentId}"})
    public ResponseEntity<BaseResponse<DifyDocument>> getDocumentById(@PathVariable String documentId, @RequestParam String hospitalId, HttpServletRequest httpRequest) {
        logger.info("\u83b7\u53d6\u6587\u6863\u8be6\u60c5: documentId={}, hospitalId={}", (Object)documentId, (Object)hospitalId);
        try {
            DifyDocument document = this.difyKnowledgeService.getDocumentById(documentId, hospitalId);
            BaseResponse response = new BaseResponse();
            if (document != null) {
                response.setCode("200");
                response.setMsg("\u83b7\u53d6\u6587\u6863\u8be6\u60c5\u6210\u529f");
                response.setData((Object)document);
            } else {
                response.setCode("404");
                response.setMsg("\u6587\u6863\u4e0d\u5b58\u5728");
            }
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u6863\u8be6\u60c5\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u83b7\u53d6\u6587\u6863\u8be6\u60c5\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PutMapping(value={"/documents/{documentId}"})
    public ResponseEntity<BaseResponse<DifyDocument>> updateDocument(@PathVariable String documentId, @RequestParam(value="file", required=false) MultipartFile file, @RequestParam String hospitalId, @RequestParam String updatedBy, @RequestParam(defaultValue="high_quality") String indexingTechnique, @RequestParam(defaultValue="automatic") String processRule, HttpServletRequest httpRequest) {
        logger.info("\u66f4\u65b0\u6587\u6863: documentId={}, hospitalId={}, updatedBy={}", new Object[]{documentId, hospitalId, updatedBy});
        try {
            DifyDocumentRequest request = new DifyDocumentRequest();
            request.setFile(file);
            request.setIndexingTechnique(indexingTechnique);
            request.setProcessRule(processRule);
            DifyDocument document = this.difyKnowledgeService.updateDocument(documentId, request, hospitalId, updatedBy);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u66f4\u65b0\u6587\u6863\u6210\u529f");
            response.setData((Object)document);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u6587\u6863\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u66f4\u65b0\u6587\u6863\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @DeleteMapping(value={"/documents/{documentId}"})
    public ResponseEntity<BaseResponse<Boolean>> deleteDocument(@PathVariable String documentId, @RequestParam String hospitalId, HttpServletRequest httpRequest) {
        logger.info("\u5220\u9664\u6587\u6863: documentId={}, hospitalId={}", (Object)documentId, (Object)hospitalId);
        try {
            boolean success = this.difyKnowledgeService.deleteDocument(documentId, hospitalId);
            BaseResponse response = new BaseResponse();
            response.setCode(success ? "200" : "500");
            response.setMsg(success ? "\u5220\u9664\u6587\u6863\u6210\u529f" : "\u5220\u9664\u6587\u6863\u5931\u8d25");
            response.setData((Object)success);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6587\u6863\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u5220\u9664\u6587\u6863\u5931\u8d25: " + e.getMessage());
            response.setData((Object)false);
            return ResponseEntity.ok((Object)response);
        }
    }

    @PatchMapping(value={"/documents/{documentId}/toggle"})
    public ResponseEntity<BaseResponse<Boolean>> toggleDocumentStatus(@PathVariable String documentId, @RequestParam boolean enabled, @RequestParam String hospitalId, @RequestParam String operatedBy, HttpServletRequest httpRequest) {
        logger.info("\u5207\u6362\u6587\u6863\u72b6\u6001: documentId={}, enabled={}, hospitalId={}, operatedBy={}", new Object[]{documentId, enabled, hospitalId, operatedBy});
        try {
            boolean success = this.difyKnowledgeService.toggleDocumentStatus(documentId, enabled, hospitalId, operatedBy);
            BaseResponse response = new BaseResponse();
            response.setCode(success ? "200" : "500");
            response.setMsg(success ? "\u5207\u6362\u6587\u6863\u72b6\u6001\u6210\u529f" : "\u5207\u6362\u6587\u6863\u72b6\u6001\u5931\u8d25");
            response.setData((Object)success);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u5207\u6362\u6587\u6863\u72b6\u6001\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u5207\u6362\u6587\u6863\u72b6\u6001\u5931\u8d25: " + e.getMessage());
            response.setData((Object)false);
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/datasets/{datasetId}/retrieve"})
    public ResponseEntity<BaseResponse<Map<String, Object>>> retrieveKnowledge(@PathVariable String datasetId, @RequestParam String query, @RequestParam(defaultValue="3") int topK, @RequestParam(defaultValue="0.5") double scoreThreshold, @RequestParam String hospitalId, HttpServletRequest httpRequest) {
        logger.info("\u68c0\u7d22\u77e5\u8bc6\u5e93\u5185\u5bb9: datasetId={}, query={}, topK={}, scoreThreshold={}, hospitalId={}", new Object[]{datasetId, query, topK, scoreThreshold, hospitalId});
        try {
            Map result = this.difyKnowledgeService.retrieveKnowledge(datasetId, query, topK, scoreThreshold, hospitalId);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u68c0\u7d22\u77e5\u8bc6\u5e93\u5185\u5bb9\u6210\u529f");
            response.setData((Object)result);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u68c0\u7d22\u77e5\u8bc6\u5e93\u5185\u5bb9\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u68c0\u7d22\u77e5\u8bc6\u5e93\u5185\u5bb9\u5931\u8d25: " + e.getMessage());
            response.setData(new HashMap());
            return ResponseEntity.ok((Object)response);
        }
    }

    @GetMapping(value={"/documents/{documentId}/status"})
    public ResponseEntity<BaseResponse<Map<String, Object>>> getDocumentStatus(@PathVariable String documentId, @RequestParam String hospitalId, HttpServletRequest httpRequest) {
        logger.info("\u83b7\u53d6\u6587\u6863\u5904\u7406\u72b6\u6001: documentId={}, hospitalId={}", (Object)documentId, (Object)hospitalId);
        try {
            Map status = this.difyKnowledgeService.getDocumentStatus(documentId, hospitalId);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u83b7\u53d6\u6587\u6863\u5904\u7406\u72b6\u6001\u6210\u529f");
            response.setData((Object)status);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u6863\u5904\u7406\u72b6\u6001\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u83b7\u53d6\u6587\u6863\u5904\u7406\u72b6\u6001\u5931\u8d25: " + e.getMessage());
            response.setData(new HashMap());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/{documentId}/reindex"})
    public ResponseEntity<BaseResponse<Boolean>> reindexDocument(@PathVariable String documentId, @RequestParam String hospitalId, @RequestParam String operatedBy, HttpServletRequest httpRequest) {
        logger.info("\u91cd\u65b0\u7d22\u5f15\u6587\u6863: documentId={}, hospitalId={}, operatedBy={}", new Object[]{documentId, hospitalId, operatedBy});
        try {
            boolean success = this.difyKnowledgeService.reindexDocument(documentId, hospitalId, operatedBy);
            BaseResponse response = new BaseResponse();
            response.setCode(success ? "200" : "500");
            response.setMsg(success ? "\u91cd\u65b0\u7d22\u5f15\u6587\u6863\u6210\u529f" : "\u91cd\u65b0\u7d22\u5f15\u6587\u6863\u5931\u8d25");
            response.setData((Object)success);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u91cd\u65b0\u7d22\u5f15\u6587\u6863\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u91cd\u65b0\u7d22\u5f15\u6587\u6863\u5931\u8d25: " + e.getMessage());
            response.setData((Object)false);
            return ResponseEntity.ok((Object)response);
        }
    }
}

