/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.model.BatchOperationRequest;
import com.chdu.ai.model.DatasetDeleteRequest;
import com.chdu.ai.model.DatasetUpdateRequest;
import com.chdu.ai.model.DifyDataset;
import com.chdu.ai.model.DifyDocument;
import com.chdu.ai.model.DifyDocumentRequest;
import com.chdu.ai.model.DifyKnowledgeRequest;
import com.chdu.ai.model.DocumentDeleteRequest;
import com.chdu.ai.model.DocumentReindexRequest;
import com.chdu.ai.model.DocumentSearchRequest;
import com.chdu.ai.model.DocumentToggleRequest;
import com.chdu.ai.model.DocumentUpdateRequest;
import com.chdu.ai.model.DocumentUploadRequest;
import com.chdu.ai.model.KnowledgeRetrieveRequest;
import com.chdu.ai.service.DifyKnowledgeService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dify/knowledge"})
@CrossOrigin(origins={"*"})
public class DifyKnowledgeController {
    private static final Logger logger = LoggerFactory.getLogger(DifyKnowledgeController.class);
    @Autowired
    private DifyKnowledgeService difyKnowledgeService;

    @PostMapping(value={"/datasets"})
    public ResponseEntity<BaseResponse<DifyDataset>> createDataset(@RequestBody DifyKnowledgeRequest request, @RequestParam String hospitalId, @RequestParam String createdBy, @RequestParam String workflowType, HttpServletRequest httpRequest) {
        logger.info("\u521b\u5efa\u77e5\u8bc6\u5e93\u6570\u636e\u96c6\u8bf7\u6c42: name={}, hospitalId={}, createdBy={}, workflowType={}", new Object[]{request.getName(), hospitalId, createdBy, workflowType});
        try {
            DifyDataset dataset = this.difyKnowledgeService.createDataset(request, hospitalId, createdBy, workflowType);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u521b\u5efa\u6570\u636e\u96c6\u6210\u529f");
            response.setData((Object)dataset);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u77e5\u8bc6\u5e93\u6570\u636e\u96c6\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u521b\u5efa\u6570\u636e\u96c6\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @GetMapping(value={"/datasets"})
    public ResponseEntity<BaseResponse<List<DifyDataset>>> getDatasets(@RequestParam String hospitalId, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="20") int limit, @RequestParam String workflowType, HttpServletRequest httpRequest) {
        logger.info("\u83b7\u53d6\u77e5\u8bc6\u5e93\u6570\u636e\u96c6\u5217\u8868: hospitalId={}, page={}, limit={}, workflowType={}", new Object[]{hospitalId, page, limit, workflowType});
        try {
            List datasets = this.difyKnowledgeService.getDatasets(hospitalId, page, limit, workflowType);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u83b7\u53d6\u6570\u636e\u96c6\u5217\u8868\u6210\u529f");
            response.setData((Object)datasets);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u77e5\u8bc6\u5e93\u6570\u636e\u96c6\u5217\u8868\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u83b7\u53d6\u6570\u636e\u96c6\u5217\u8868\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @GetMapping(value={"/datasets/{datasetId}"})
    public ResponseEntity<BaseResponse<DifyDataset>> getDatasetById(@PathVariable String datasetId, @RequestParam String hospitalId, @RequestParam String workflowType, HttpServletRequest httpRequest) {
        logger.info("\u83b7\u53d6\u6570\u636e\u96c6\u8be6\u60c5: datasetId={}, hospitalId={}, workflowType={}", new Object[]{datasetId, hospitalId, workflowType});
        try {
            DifyDataset dataset = this.difyKnowledgeService.getDatasetById(datasetId, hospitalId, workflowType);
            BaseResponse response = new BaseResponse();
            if (dataset != null) {
                response.setCode("200");
                response.setMsg("\u83b7\u53d6\u6570\u636e\u96c6\u8be6\u60c5\u6210\u529f");
                response.setData((Object)dataset);
            } else {
                response.setCode("404");
                response.setMsg("\u6570\u636e\u96c6\u4e0d\u5b58\u5728");
            }
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u96c6\u8be6\u60c5\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u83b7\u53d6\u6570\u636e\u96c6\u8be6\u60c5\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/datasets/update"})
    public ResponseEntity<BaseResponse<DifyDataset>> updateDataset(@RequestBody DatasetUpdateRequest request, HttpServletRequest httpRequest) {
        logger.info("\u66f4\u65b0\u6570\u636e\u96c6\u4fe1\u606f: datasetId={}, hospitalId={}, updatedBy={}, workflowType={}", new Object[]{request.getDatasetId(), request.getHospitalId(), request.getUpdatedBy(), request.getWorkflowType()});
        try {
            DifyKnowledgeRequest difyRequest = new DifyKnowledgeRequest();
            difyRequest.setName(request.getName());
            difyRequest.setDescription(request.getDescription());
            DifyDataset dataset = this.difyKnowledgeService.updateDataset(request.getDatasetId(), difyRequest, request.getHospitalId(), request.getUpdatedBy(), request.getWorkflowType());
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u66f4\u65b0\u6570\u636e\u96c6\u6210\u529f");
            response.setData((Object)dataset);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u6570\u636e\u96c6\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u66f4\u65b0\u6570\u636e\u96c6\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/datasets/delete"})
    public ResponseEntity<BaseResponse<Boolean>> deleteDataset(@RequestBody DatasetDeleteRequest request, HttpServletRequest httpRequest) {
        logger.info("\u5220\u9664\u6570\u636e\u96c6: datasetId={}, hospitalId={}, workflowType={}", new Object[]{request.getDatasetId(), request.getHospitalId(), request.getWorkflowType()});
        try {
            boolean success = this.difyKnowledgeService.deleteDataset(request.getDatasetId(), request.getHospitalId(), request.getWorkflowType());
            BaseResponse response = new BaseResponse();
            response.setCode(success ? "200" : "500");
            response.setMsg(success ? "\u5220\u9664\u6570\u636e\u96c6\u6210\u529f" : "\u5220\u9664\u6570\u636e\u96c6\u5931\u8d25");
            response.setData((Object)success);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u96c6\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u5220\u9664\u6570\u636e\u96c6\u5931\u8d25: " + e.getMessage());
            response.setData((Object)false);
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/datasets/documents"})
    public ResponseEntity<BaseResponse<DifyDocument>> uploadDocument(@RequestBody DocumentUploadRequest request, HttpServletRequest httpRequest) {
        logger.info("\u4e0a\u4f20\u6587\u6863\u5230\u6570\u636e\u96c6: datasetId={}, fileName={}, hospitalId={}, uploadedBy={}, workflowType={}", new Object[]{request.getDatasetId(), request.getFile().getOriginalFilename(), request.getHospitalId(), request.getUploadedBy(), request.getWorkflowType()});
        try {
            DifyDocumentRequest difyRequest = new DifyDocumentRequest();
            difyRequest.setDatasetId(request.getDatasetId());
            difyRequest.setFile(request.getFile());
            difyRequest.setIndexingTechnique(request.getIndexingTechnique());
            difyRequest.setProcessRule(request.getProcessRule());
            difyRequest.setDuplicateCheck(request.getDuplicateCheck());
            difyRequest.setSeparator(request.getSeparator());
            difyRequest.setMaxTokens(request.getMaxTokens());
            difyRequest.setChunkOverlap(request.getChunkOverlap());
            DifyDocument document = this.difyKnowledgeService.uploadDocument(difyRequest, request.getHospitalId(), request.getUploadedBy(), request.getWorkflowType());
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u4e0a\u4f20\u6587\u6863\u6210\u529f");
            response.setData((Object)document);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u6863\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u4e0a\u4f20\u6587\u6863\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @GetMapping(value={"/datasets/{datasetId}/documents"})
    public ResponseEntity<BaseResponse<List<DifyDocument>>> getDocuments(@PathVariable String datasetId, @RequestParam String hospitalId, @RequestParam String workflowType, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="20") int limit, HttpServletRequest httpRequest) {
        logger.info("\u83b7\u53d6\u6570\u636e\u96c6\u6587\u6863\u5217\u8868: datasetId={}, hospitalId={}, workflowType={}, page={}, limit={}", new Object[]{datasetId, hospitalId, workflowType, page, limit});
        try {
            List documents = this.difyKnowledgeService.getDocuments(datasetId, hospitalId, page, limit, workflowType);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u83b7\u53d6\u6587\u6863\u5217\u8868\u6210\u529f");
            response.setData((Object)documents);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u96c6\u6587\u6863\u5217\u8868\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u83b7\u53d6\u6587\u6863\u5217\u8868\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @GetMapping(value={"/documents/{documentId}"})
    public ResponseEntity<BaseResponse<DifyDocument>> getDocumentById(@PathVariable String documentId, @RequestParam String hospitalId, @RequestParam String workflowType, HttpServletRequest httpRequest) {
        logger.info("\u83b7\u53d6\u6587\u6863\u8be6\u60c5: documentId={}, hospitalId={}, workflowType={}", new Object[]{documentId, hospitalId, workflowType});
        try {
            DifyDocument document = this.difyKnowledgeService.getDocumentById(documentId, hospitalId, workflowType);
            BaseResponse response = new BaseResponse();
            if (document != null) {
                response.setCode("200");
                response.setMsg("\u83b7\u53d6\u6587\u6863\u8be6\u60c5\u6210\u529f");
                response.setData((Object)document);
            } else {
                response.setCode("404");
                response.setMsg("\u6587\u6863\u4e0d\u5b58\u5728");
            }
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u6863\u8be6\u60c5\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u83b7\u53d6\u6587\u6863\u8be6\u60c5\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/update"})
    public ResponseEntity<BaseResponse<DifyDocument>> updateDocument(@RequestBody DocumentUpdateRequest request, HttpServletRequest httpRequest) {
        logger.info("\u66f4\u65b0\u6587\u6863: documentId={}, hospitalId={}, updatedBy={}, workflowType={}", new Object[]{request.getDocumentId(), request.getHospitalId(), request.getUpdatedBy(), request.getWorkflowType()});
        try {
            DifyDocumentRequest difyRequest = new DifyDocumentRequest();
            difyRequest.setFile(request.getFile());
            difyRequest.setIndexingTechnique(request.getIndexingTechnique());
            difyRequest.setProcessRule(request.getProcessRule());
            DifyDocument document = this.difyKnowledgeService.updateDocument(request.getDocumentId(), difyRequest, request.getHospitalId(), request.getUpdatedBy(), request.getWorkflowType());
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u66f4\u65b0\u6587\u6863\u6210\u529f");
            response.setData((Object)document);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u6587\u6863\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u66f4\u65b0\u6587\u6863\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/delete"})
    public ResponseEntity<BaseResponse<Boolean>> deleteDocument(@RequestBody DocumentDeleteRequest request, HttpServletRequest httpRequest) {
        logger.info("\u5220\u9664\u6587\u6863: documentId={}, hospitalId={}, workflowType={}", new Object[]{request.getDocumentId(), request.getHospitalId(), request.getWorkflowType()});
        try {
            boolean success = this.difyKnowledgeService.deleteDocument(request.getDocumentId(), request.getHospitalId(), request.getWorkflowType());
            BaseResponse response = new BaseResponse();
            response.setCode(success ? "200" : "500");
            response.setMsg(success ? "\u5220\u9664\u6587\u6863\u6210\u529f" : "\u5220\u9664\u6587\u6863\u5931\u8d25");
            response.setData((Object)success);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6587\u6863\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u5220\u9664\u6587\u6863\u5931\u8d25: " + e.getMessage());
            response.setData((Object)false);
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/toggle"})
    public ResponseEntity<BaseResponse<Boolean>> toggleDocumentStatus(@RequestBody DocumentToggleRequest request, HttpServletRequest httpRequest) {
        logger.info("\u5207\u6362\u6587\u6863\u72b6\u6001: documentId={}, enabled={}, hospitalId={}, operatedBy={}, workflowType={}", new Object[]{request.getDocumentId(), request.isEnabled(), request.getHospitalId(), request.getOperatedBy(), request.getWorkflowType()});
        try {
            boolean success = this.difyKnowledgeService.toggleDocumentStatus(request.getDocumentId(), request.isEnabled(), request.getHospitalId(), request.getOperatedBy(), request.getWorkflowType());
            BaseResponse response = new BaseResponse();
            response.setCode(success ? "200" : "500");
            response.setMsg(success ? "\u5207\u6362\u6587\u6863\u72b6\u6001\u6210\u529f" : "\u5207\u6362\u6587\u6863\u72b6\u6001\u5931\u8d25");
            response.setData((Object)success);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u5207\u6362\u6587\u6863\u72b6\u6001\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u5207\u6362\u6587\u6863\u72b6\u6001\u5931\u8d25: " + e.getMessage());
            response.setData((Object)false);
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/datasets/retrieve"})
    public ResponseEntity<BaseResponse<Map<String, Object>>> retrieveKnowledge(@RequestBody KnowledgeRetrieveRequest request, HttpServletRequest httpRequest) {
        logger.info("\u68c0\u7d22\u77e5\u8bc6\u5e93\u5185\u5bb9: datasetId={}, query={}, topK={}, scoreThreshold={}, hospitalId={}, workflowType={}", new Object[]{request.getDatasetId(), request.getQuery(), request.getTopK(), request.getScoreThreshold(), request.getHospitalId(), request.getWorkflowType()});
        try {
            Map result = this.difyKnowledgeService.retrieveKnowledge(request.getDatasetId(), request.getQuery(), request.getTopK(), request.getScoreThreshold(), request.getHospitalId(), request.getWorkflowType());
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u68c0\u7d22\u77e5\u8bc6\u5e93\u5185\u5bb9\u6210\u529f");
            response.setData((Object)result);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u68c0\u7d22\u77e5\u8bc6\u5e93\u5185\u5bb9\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u68c0\u7d22\u77e5\u8bc6\u5e93\u5185\u5bb9\u5931\u8d25: " + e.getMessage());
            response.setData(new HashMap());
            return ResponseEntity.ok((Object)response);
        }
    }

    @GetMapping(value={"/documents/{documentId}/status"})
    public ResponseEntity<BaseResponse<Map<String, Object>>> getDocumentStatus(@PathVariable String documentId, @RequestParam String hospitalId, @RequestParam String workflowType, HttpServletRequest httpRequest) {
        logger.info("\u83b7\u53d6\u6587\u6863\u5904\u7406\u72b6\u6001: documentId={}, hospitalId={}, workflowType={}", new Object[]{documentId, hospitalId, workflowType});
        try {
            Map status = this.difyKnowledgeService.getDocumentStatus(documentId, hospitalId, workflowType);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u83b7\u53d6\u6587\u6863\u5904\u7406\u72b6\u6001\u6210\u529f");
            response.setData((Object)status);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u6863\u5904\u7406\u72b6\u6001\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u83b7\u53d6\u6587\u6863\u5904\u7406\u72b6\u6001\u5931\u8d25: " + e.getMessage());
            response.setData(new HashMap());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/reindex"})
    public ResponseEntity<BaseResponse<Boolean>> reindexDocument(@RequestBody DocumentReindexRequest request, HttpServletRequest httpRequest) {
        logger.info("\u91cd\u65b0\u7d22\u5f15\u6587\u6863: documentId={}, hospitalId={}, operatedBy={}, workflowType={}", new Object[]{request.getDocumentId(), request.getHospitalId(), request.getOperatedBy(), request.getWorkflowType()});
        try {
            boolean success = this.difyKnowledgeService.reindexDocument(request.getDocumentId(), request.getHospitalId(), request.getOperatedBy(), request.getWorkflowType());
            BaseResponse response = new BaseResponse();
            response.setCode(success ? "200" : "500");
            response.setMsg(success ? "\u91cd\u65b0\u7d22\u5f15\u6587\u6863\u6210\u529f" : "\u91cd\u65b0\u7d22\u5f15\u6587\u6863\u5931\u8d25");
            response.setData((Object)success);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u91cd\u65b0\u7d22\u5f15\u6587\u6863\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u91cd\u65b0\u7d22\u5f15\u6587\u6863\u5931\u8d25: " + e.getMessage());
            response.setData((Object)false);
            return ResponseEntity.ok((Object)response);
        }
    }

    @GetMapping(value={"/datasets/search"})
    public ResponseEntity<BaseResponse<List<DifyDataset>>> searchDatasets(@RequestParam String keyword, @RequestParam String hospitalId, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="20") int limit, @RequestParam String workflowType, HttpServletRequest httpRequest) {
        logger.info("\u641c\u7d22\u6570\u636e\u96c6: keyword={}, hospitalId={}, page={}, limit={}, workflowType={}", new Object[]{keyword, hospitalId, page, limit, workflowType});
        try {
            List datasets = this.difyKnowledgeService.searchDatasets(keyword, hospitalId, page, limit, workflowType);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u641c\u7d22\u6570\u636e\u96c6\u6210\u529f");
            response.setData((Object)datasets);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u641c\u7d22\u6570\u636e\u96c6\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u641c\u7d22\u6570\u636e\u96c6\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/search"})
    public ResponseEntity<BaseResponse<List<DifyDocument>>> searchDocuments(@RequestBody DocumentSearchRequest request, @RequestParam String workflowType, HttpServletRequest httpRequest) {
        logger.info("\u9ad8\u7ea7\u6587\u6863\u641c\u7d22: keyword={}, hospitalId={}, datasetId={}, workflowType={}", new Object[]{request.getKeyword(), request.getHospitalId(), request.getDatasetId(), workflowType});
        try {
            if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                BaseResponse response = new BaseResponse();
                response.setCode("400");
                response.setMsg("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.ok((Object)response);
            }
            List documents = this.difyKnowledgeService.searchDocuments(request, workflowType);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u641c\u7d22\u6587\u6863\u6210\u529f");
            response.setData((Object)documents);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u9ad8\u7ea7\u6587\u6863\u641c\u7d22\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u641c\u7d22\u6587\u6863\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/batch/delete"})
    public ResponseEntity<BaseResponse<Map<String, Object>>> batchDeleteDocuments(@RequestBody BatchOperationRequest request, @RequestParam String workflowType, HttpServletRequest httpRequest) {
        logger.info("\u6279\u91cf\u5220\u9664\u6587\u6863: documentIds={}, hospitalId={}, operatedBy={}, workflowType={}", new Object[]{request.getDocumentIds(), request.getHospitalId(), request.getOperatedBy(), workflowType});
        try {
            if (request.getDocumentIds() == null || request.getDocumentIds().isEmpty()) {
                BaseResponse response = new BaseResponse();
                response.setCode("400");
                response.setMsg("\u6587\u6863ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.ok((Object)response);
            }
            if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                BaseResponse response = new BaseResponse();
                response.setCode("400");
                response.setMsg("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.ok((Object)response);
            }
            if (request.getOperatedBy() == null || request.getOperatedBy().trim().isEmpty()) {
                BaseResponse response = new BaseResponse();
                response.setCode("400");
                response.setMsg("\u64cd\u4f5c\u8005\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.ok((Object)response);
            }
            Map result = this.difyKnowledgeService.batchDeleteDocuments(request, workflowType);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u6279\u91cf\u5220\u9664\u6587\u6863\u5b8c\u6210");
            response.setData((Object)result);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u5220\u9664\u6587\u6863\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u6279\u91cf\u5220\u9664\u6587\u6863\u5931\u8d25: " + e.getMessage());
            response.setData(new HashMap());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/batch/toggle"})
    public ResponseEntity<BaseResponse<Map<String, Object>>> batchToggleDocuments(@RequestBody BatchOperationRequest request, @RequestParam String workflowType, HttpServletRequest httpRequest) {
        logger.info("\u6279\u91cf\u5207\u6362\u6587\u6863\u72b6\u6001: documentIds={}, enabled={}, hospitalId={}, operatedBy={}, workflowType={}", new Object[]{request.getDocumentIds(), request.getEnabled(), request.getHospitalId(), request.getOperatedBy(), workflowType});
        try {
            if (request.getDocumentIds() == null || request.getDocumentIds().isEmpty()) {
                BaseResponse response = new BaseResponse();
                response.setCode("400");
                response.setMsg("\u6587\u6863ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.ok((Object)response);
            }
            if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                BaseResponse response = new BaseResponse();
                response.setCode("400");
                response.setMsg("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.ok((Object)response);
            }
            if (request.getOperatedBy() == null || request.getOperatedBy().trim().isEmpty()) {
                BaseResponse response = new BaseResponse();
                response.setCode("400");
                response.setMsg("\u64cd\u4f5c\u8005\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.ok((Object)response);
            }
            if (request.getEnabled() == null) {
                BaseResponse response = new BaseResponse();
                response.setCode("400");
                response.setMsg("\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.ok((Object)response);
            }
            Map result = this.difyKnowledgeService.batchToggleDocuments(request, workflowType);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u6279\u91cf\u5207\u6362\u6587\u6863\u72b6\u6001\u5b8c\u6210");
            response.setData((Object)result);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u5207\u6362\u6587\u6863\u72b6\u6001\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u6279\u91cf\u5207\u6362\u6587\u6863\u72b6\u6001\u5931\u8d25: " + e.getMessage());
            response.setData(new HashMap());
            return ResponseEntity.ok((Object)response);
        }
    }

    @GetMapping(value={"/statistics"})
    public ResponseEntity<BaseResponse<Map<String, Object>>> getKnowledgeStatistics(@RequestParam String hospitalId, @RequestParam String workflowType, HttpServletRequest httpRequest) {
        logger.info("\u83b7\u53d6\u77e5\u8bc6\u5e93\u7edf\u8ba1\u4fe1\u606f: hospitalId={}, workflowType={}", (Object)hospitalId, (Object)workflowType);
        try {
            Map statistics = this.difyKnowledgeService.getKnowledgeStatistics(hospitalId, workflowType);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u83b7\u53d6\u77e5\u8bc6\u5e93\u7edf\u8ba1\u4fe1\u606f\u6210\u529f");
            response.setData((Object)statistics);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u77e5\u8bc6\u5e93\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u83b7\u53d6\u77e5\u8bc6\u5e93\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25: " + e.getMessage());
            response.setData(new HashMap());
            return ResponseEntity.ok((Object)response);
        }
    }

    @GetMapping(value={"/datasets/{datasetId}/progress"})
    public ResponseEntity<BaseResponse<Map<String, Object>>> getDatasetProcessingProgress(@PathVariable String datasetId, @RequestParam String hospitalId, @RequestParam String workflowType, HttpServletRequest httpRequest) {
        logger.info("\u83b7\u53d6\u6570\u636e\u96c6\u5904\u7406\u8fdb\u5ea6: datasetId={}, hospitalId={}, workflowType={}", new Object[]{datasetId, hospitalId, workflowType});
        try {
            Map progress = this.difyKnowledgeService.getDatasetProcessingProgress(datasetId, hospitalId, workflowType);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u83b7\u53d6\u6570\u636e\u96c6\u5904\u7406\u8fdb\u5ea6\u6210\u529f");
            response.setData((Object)progress);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u96c6\u5904\u7406\u8fdb\u5ea6\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u83b7\u53d6\u6570\u636e\u96c6\u5904\u7406\u8fdb\u5ea6\u5931\u8d25: " + e.getMessage());
            response.setData(new HashMap());
            return ResponseEntity.ok((Object)response);
        }
    }
}

