/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.config;

import javax.websocket.server.ServerContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WebSocketBufferConfig {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketBufferConfig.class);

    @Bean
    public WebServerFactoryCustomizer<TomcatServletWebServerFactory> tomcatCustomizer() {
        return factory -> {
            factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
                logger.info("\u914d\u7f6eTomcat WebSocket\u7f13\u51b2\u533a\u5927\u5c0f");
                connector.setProperty("maxTextMessageBufferSize", "2097152");
                connector.setProperty("maxBinaryMessageBufferSize", "2097152");
                connector.setProperty("sessionTimeout", "300000");
            }});
            factory.addContextCustomizers(new TomcatContextCustomizer[]{context -> context.addServletContainerInitializer((classes, servletContext) -> {
                try {
                    ServerContainer serverContainer = (ServerContainer)servletContext.getAttribute("javax.websocket.server.ServerContainer");
                    if (serverContainer != null) {
                        serverContainer.setDefaultMaxTextMessageBufferSize(0x200000);
                        serverContainer.setDefaultMaxBinaryMessageBufferSize(0x200000);
                        serverContainer.setDefaultMaxSessionIdleTimeout(300000L);
                        logger.info("WebSocket\u7f13\u51b2\u533a\u914d\u7f6e\u6210\u529f: \u6587\u672c\u6d88\u606f=2MB, \u4e8c\u8fdb\u5236\u6d88\u606f=2MB, \u8d85\u65f6=5\u5206\u949f");
                    } else {
                        logger.warn("\u65e0\u6cd5\u83b7\u53d6ServerContainer\uff0cWebSocket\u7f13\u51b2\u533a\u914d\u7f6e\u53ef\u80fd\u672a\u751f\u6548");
                    }
                }
                catch (Exception e) {
                    logger.error("\u914d\u7f6eWebSocket\u7f13\u51b2\u533a\u5931\u8d25", (Throwable)e);
                }
            }, null)});
        };
    }
}

