/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.alibaba.nls.client.AccessToken;
import com.alibaba.nls.client.protocol.NlsClient;
import com.alibaba.nls.client.protocol.tts.SpeechSynthesizer;
import com.alibaba.nls.client.protocol.tts.SpeechSynthesizerListener;
import com.chdu.ai.service.TTSService;
import com.chdu.ai.service.impl.TTSServiceImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TTSServiceImpl
implements TTSService {
    private static final Logger logger = LoggerFactory.getLogger(TTSServiceImpl.class);
    @Value(value="${aliyun.tts.app-key}")
    private String appKey;
    @Value(value="${aliyun.accessKeyId}")
    private String accessKeyId;
    @Value(value="${aliyun.accessKeySecret}")
    private String accessKeySecret;
    private NlsClient client;
    private AccessToken accessToken;

    @PostConstruct
    public void init() {
        try {
            this.accessToken = new AccessToken(this.accessKeyId, this.accessKeySecret);
            this.accessToken.apply();
            this.client = new NlsClient(this.accessToken.getToken());
            logger.info("\u963f\u91cc\u4e91TTS\u670d\u52a1\u521d\u59cb\u5316\u6210\u529f\uff0cToken\u8fc7\u671f\u65f6\u95f4: {}", (Object)this.accessToken.getExpireTime());
        }
        catch (Exception e) {
            logger.error("\u963f\u91cc\u4e91TTS\u670d\u52a1\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("TTS\u670d\u52a1\u521d\u59cb\u5316\u5931\u8d25", e);
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.client != null) {
            try {
                this.client.shutdown();
                logger.info("\u963f\u91cc\u4e91TTS\u5ba2\u6237\u7aef\u5df2\u5173\u95ed");
            }
            catch (Exception e) {
                logger.error("\u5173\u95edTTS\u5ba2\u6237\u7aef\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            }
        }
    }

    public InputStream synthesizeText(String text) throws Exception {
        if (text == null || text.trim().isEmpty()) {
            throw new IllegalArgumentException("\u5408\u6210\u6587\u672c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.refreshTokenIfNeeded();
        ByteArrayOutputStream audioData = new ByteArrayOutputStream();
        CountDownLatch latch = new CountDownLatch(1);
        Exception[] exception = new Exception[1];
        1 listener = new /* Unavailable Anonymous Inner Class!! */;
        try {
            SpeechSynthesizer synthesizer = new SpeechSynthesizer(this.client, (SpeechSynthesizerListener)listener);
            synthesizer.setAppKey(this.appKey);
            synthesizer.setText(text);
            logger.info("\u5f00\u59cb\u8bed\u97f3\u5408\u6210\uff0c\u6587\u672c: {}, \u58f0\u97f3: {}, \u91c7\u6837\u7387: {}, \u683c\u5f0f: {}", (Object)text);
            synthesizer.start();
            if (!latch.await(30L, TimeUnit.SECONDS)) {
                logger.warn("\u8bed\u97f3\u5408\u6210\u8d85\u65f6\uff0c\u5c1d\u8bd5\u5173\u95ed\u5408\u6210\u5668");
                try {
                    synthesizer.close();
                }
                catch (Exception e) {
                    logger.warn("\u5173\u95ed\u5408\u6210\u5668\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
                }
                throw new RuntimeException("\u8bed\u97f3\u5408\u6210\u8d85\u65f6");
            }
            if (exception[0] != null) {
                throw exception[0];
            }
            byte[] audioBytes = audioData.toByteArray();
            if (audioBytes.length == 0) {
                throw new RuntimeException("\u8bed\u97f3\u5408\u6210\u5931\u8d25\uff0c\u672a\u751f\u6210\u97f3\u9891\u6570\u636e");
            }
            logger.info("\u8bed\u97f3\u5408\u6210\u6210\u529f\uff0c\u751f\u6210\u97f3\u9891\u6570\u636e: {} \u5b57\u8282", (Object)audioBytes.length);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(audioBytes);
            return byteArrayInputStream;
        }
        catch (Exception e) {
            logger.error("\u8bed\u97f3\u5408\u6210\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef", (Throwable)e);
            throw e;
        }
        finally {
            try {
                audioData.close();
            }
            catch (Exception e) {
                logger.warn("\u5173\u95ed\u97f3\u9891\u6570\u636e\u6d41\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            }
        }
    }

    public boolean testConnection() {
        try {
            this.refreshTokenIfNeeded();
            return this.client != null && this.accessToken != null && !this.accessToken.getToken().isEmpty();
        }
        catch (Exception e) {
            logger.error("\u6d4b\u8bd5TTS\u8fde\u63a5\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    private void refreshTokenIfNeeded() throws Exception {
        if (this.accessToken == null || System.currentTimeMillis() >= this.accessToken.getExpireTime() - 60000L) {
            logger.info("Token\u5373\u5c06\u8fc7\u671f\uff0c\u5f00\u59cb\u5237\u65b0Token");
            this.accessToken = new AccessToken(this.accessKeyId, this.accessKeySecret);
            this.accessToken.apply();
            if (this.client != null) {
                this.client.shutdown();
            }
            this.client = new NlsClient(this.accessToken.getToken());
            logger.info("Token\u5237\u65b0\u6210\u529f\uff0c\u65b0\u7684\u8fc7\u671f\u65f6\u95f4: {}", (Object)this.accessToken.getExpireTime());
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

