/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.model.BatchOperationRequest;
import com.chdu.ai.model.BatchSegmentRequest;
import com.chdu.ai.model.DifyChildChunk;
import com.chdu.ai.model.DifyDocument;
import com.chdu.ai.model.DifyDocumentRequest;
import com.chdu.ai.model.DifySegment;
import com.chdu.ai.model.DocumentDeleteRequest;
import com.chdu.ai.model.DocumentListResponse;
import com.chdu.ai.model.DocumentReindexRequest;
import com.chdu.ai.model.DocumentSearchRequest;
import com.chdu.ai.model.DocumentToggleRequest;
import com.chdu.ai.model.KnowledgeRetrieveRequest;
import com.chdu.ai.model.SegmentListResponse;
import com.chdu.ai.model.SegmentRequest;
import com.chdu.ai.model.SegmentSearchRequest;
import com.chdu.ai.service.DifyKnowledgeService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/dify/knowledge"})
@CrossOrigin(origins={"*"})
public class DifyKnowledgeController {
    private static final Logger logger = LoggerFactory.getLogger(DifyKnowledgeController.class);
    @Autowired
    private DifyKnowledgeService difyKnowledgeService;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @PostMapping(value={"/documents"}, consumes={"multipart/form-data"})
    public ResponseEntity<BaseResponse<DifyDocument>> uploadDocument(@RequestParam(value="file") MultipartFile file, @RequestParam(value="hospitalId") String hospitalId, @RequestParam(value="uploadedBy") String uploadedBy, @RequestParam(value="workflowType") String workflowType, @RequestParam(value="indexingTechnique", defaultValue="high_quality") String indexingTechnique, @RequestParam(value="processRule", defaultValue="automatic") String processRule, @RequestParam(value="duplicateCheck", defaultValue="enabled") String duplicateCheck, @RequestParam(value="separator", required=false) String separator, @RequestParam(value="maxTokens", required=false) Integer maxTokens, @RequestParam(value="chunkOverlap", required=false) Integer chunkOverlap, HttpServletRequest httpRequest) {
        logger.info("\u4e0a\u4f20\u6587\u6863: fileName={}, hospitalId={}, uploadedBy={}, workflowType={}", new Object[]{file.getOriginalFilename(), hospitalId, uploadedBy, workflowType});
        try {
            DifyDocumentRequest difyRequest = new DifyDocumentRequest();
            difyRequest.setFile(file);
            difyRequest.setIndexingTechnique(indexingTechnique);
            difyRequest.setProcessRule(processRule);
            difyRequest.setDuplicateCheck(duplicateCheck);
            difyRequest.setSeparator(separator);
            difyRequest.setMaxTokens(maxTokens);
            difyRequest.setChunkOverlap(chunkOverlap);
            DifyDocument document = this.difyKnowledgeService.uploadDocument(difyRequest, hospitalId, uploadedBy, workflowType);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u4e0a\u4f20\u6587\u6863\u6210\u529f");
            response.setData((Object)document);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u6863\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u4e0a\u4f20\u6587\u6863\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/list"})
    public ResponseEntity<BaseResponse<DocumentListResponse>> getDocuments(@RequestBody DocumentSearchRequest request, HttpServletRequest httpRequest) {
        logger.info("\u83b7\u53d6\u6587\u6863\u5217\u8868: hospitalId={}, workflowType={}, page={}, limit={}, keyword={}", new Object[]{request.getHospitalId(), request.getWorkflowType(), request.getPage(), request.getLimit(), request.getKeyword()});
        try {
            DocumentListResponse documents = this.difyKnowledgeService.getDocumentsWithPagination(request.getHospitalId(), request.getPage(), request.getLimit(), request.getKeyword(), request.getWorkflowType());
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u83b7\u53d6\u6587\u6863\u5217\u8868\u6210\u529f");
            response.setData((Object)documents);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u6863\u5217\u8868\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u83b7\u53d6\u6587\u6863\u5217\u8868\u5931\u8d25: " + e.getMessage());
            response.setData((Object)new DocumentListResponse(new ArrayList(), false, request.getLimit(), 0, request.getPage()));
            return ResponseEntity.ok((Object)response);
        }
    }

    @GetMapping(value={"/documents/{documentId}"})
    public ResponseEntity<BaseResponse<DifyDocument>> getDocumentById(@PathVariable String documentId, @RequestParam String hospitalId, @RequestParam String workflowType, HttpServletRequest httpRequest) {
        logger.info("\u83b7\u53d6\u6587\u6863\u8be6\u60c5: documentId={}, hospitalId={}, workflowType={}", new Object[]{documentId, hospitalId, workflowType});
        try {
            DifyDocument document = this.difyKnowledgeService.getDocumentById(documentId, hospitalId, workflowType);
            BaseResponse response = new BaseResponse();
            if (document != null) {
                response.setCode("200");
                response.setMsg("\u83b7\u53d6\u6587\u6863\u8be6\u60c5\u6210\u529f");
                response.setData((Object)document);
            } else {
                response.setCode("404");
                response.setMsg("\u6587\u6863\u4e0d\u5b58\u5728");
            }
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u6863\u8be6\u60c5\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u83b7\u53d6\u6587\u6863\u8be6\u60c5\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/update"}, consumes={"multipart/form-data"})
    public ResponseEntity<BaseResponse<DifyDocument>> updateDocument(@RequestParam(value="documentId") String documentId, @RequestParam(value="file") MultipartFile file, @RequestParam(value="hospitalId") String hospitalId, @RequestParam(value="updatedBy") String updatedBy, @RequestParam(value="workflowType") String workflowType, @RequestParam(value="indexingTechnique", defaultValue="high_quality") String indexingTechnique, @RequestParam(value="processRule", defaultValue="automatic") String processRule, HttpServletRequest httpRequest) {
        logger.info("\u66f4\u65b0\u6587\u6863: documentId={}, hospitalId={}, updatedBy={}, workflowType={}", new Object[]{documentId, hospitalId, updatedBy, workflowType});
        try {
            DifyDocumentRequest difyRequest = new DifyDocumentRequest();
            difyRequest.setFile(file);
            difyRequest.setIndexingTechnique(indexingTechnique);
            difyRequest.setProcessRule(processRule);
            DifyDocument document = this.difyKnowledgeService.updateDocument(documentId, difyRequest, hospitalId, updatedBy, workflowType);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u66f4\u65b0\u6587\u6863\u6210\u529f");
            response.setData((Object)document);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u6587\u6863\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u66f4\u65b0\u6587\u6863\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/delete"})
    public ResponseEntity<BaseResponse<Boolean>> deleteDocument(@RequestBody DocumentDeleteRequest request, HttpServletRequest httpRequest) {
        logger.info("\u5220\u9664\u6587\u6863: documentId={}, hospitalId={}, workflowType={}", new Object[]{request.getDocumentId(), request.getHospitalId(), request.getWorkflowType()});
        try {
            boolean success = this.difyKnowledgeService.deleteDocument(request.getDocumentId(), request.getHospitalId(), request.getWorkflowType());
            BaseResponse response = new BaseResponse();
            response.setCode(success ? "200" : "500");
            response.setMsg(success ? "\u5220\u9664\u6587\u6863\u6210\u529f" : "\u5220\u9664\u6587\u6863\u5931\u8d25");
            response.setData((Object)success);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6587\u6863\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u5220\u9664\u6587\u6863\u5931\u8d25: " + e.getMessage());
            response.setData((Object)false);
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/toggle"})
    public ResponseEntity<BaseResponse<Boolean>> toggleDocumentStatus(@RequestBody DocumentToggleRequest request, HttpServletRequest httpRequest) {
        logger.info("\u5207\u6362\u6587\u6863\u72b6\u6001: documentId={}, enabled={}, hospitalId={}, operatedBy={}, workflowType={}", new Object[]{request.getDocumentId(), request.isEnabled(), request.getHospitalId(), request.getOperatedBy(), request.getWorkflowType()});
        try {
            boolean success = this.difyKnowledgeService.toggleDocumentStatus(request.getDocumentId(), request.isEnabled(), request.getHospitalId(), request.getOperatedBy(), request.getWorkflowType());
            BaseResponse response = new BaseResponse();
            response.setCode(success ? "200" : "500");
            response.setMsg(success ? "\u5207\u6362\u6587\u6863\u72b6\u6001\u6210\u529f" : "\u5207\u6362\u6587\u6863\u72b6\u6001\u5931\u8d25");
            response.setData((Object)success);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u5207\u6362\u6587\u6863\u72b6\u6001\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u5207\u6362\u6587\u6863\u72b6\u6001\u5931\u8d25: " + e.getMessage());
            response.setData((Object)false);
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/retrieve"})
    public ResponseEntity<BaseResponse<Map<String, Object>>> retrieveKnowledge(@RequestBody KnowledgeRetrieveRequest request, HttpServletRequest httpRequest) {
        logger.info("\u68c0\u7d22\u77e5\u8bc6\u5e93\u5185\u5bb9: query={}, topK={}, scoreThreshold={}, hospitalId={}, workflowType={}", new Object[]{request.getQuery(), request.getTopK(), request.getScoreThreshold(), request.getHospitalId(), request.getWorkflowType()});
        try {
            Map result = this.difyKnowledgeService.retrieveKnowledge(request.getQuery(), request.getTopK(), request.getScoreThreshold(), request.getHospitalId(), request.getWorkflowType());
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u68c0\u7d22\u77e5\u8bc6\u5e93\u5185\u5bb9\u6210\u529f");
            response.setData((Object)result);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u68c0\u7d22\u77e5\u8bc6\u5e93\u5185\u5bb9\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u68c0\u7d22\u77e5\u8bc6\u5e93\u5185\u5bb9\u5931\u8d25: " + e.getMessage());
            response.setData(new HashMap());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/status"})
    public ResponseEntity<BaseResponse<Map<String, Object>>> getDocumentStatus(@RequestBody DocumentSearchRequest request, HttpServletRequest httpRequest) {
        logger.info("\u83b7\u53d6\u6587\u6863\u5904\u7406\u72b6\u6001: documentId={}, hospitalId={}, workflowType={}", new Object[]{request.getDocumentId(), request.getHospitalId(), request.getWorkflowType()});
        try {
            Map status = this.difyKnowledgeService.getDocumentStatus(request.getDocumentId(), request.getHospitalId(), request.getWorkflowType());
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u83b7\u53d6\u6587\u6863\u5904\u7406\u72b6\u6001\u6210\u529f");
            response.setData((Object)status);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u6863\u5904\u7406\u72b6\u6001\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u83b7\u53d6\u6587\u6863\u5904\u7406\u72b6\u6001\u5931\u8d25: " + e.getMessage());
            response.setData(new HashMap());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/reindex"})
    public ResponseEntity<BaseResponse<Boolean>> reindexDocument(@RequestBody DocumentReindexRequest request, HttpServletRequest httpRequest) {
        logger.info("\u91cd\u65b0\u7d22\u5f15\u6587\u6863: documentId={}, hospitalId={}, operatedBy={}, workflowType={}", new Object[]{request.getDocumentId(), request.getHospitalId(), request.getOperatedBy(), request.getWorkflowType()});
        try {
            boolean success = this.difyKnowledgeService.reindexDocument(request.getDocumentId(), request.getHospitalId(), request.getOperatedBy(), request.getWorkflowType());
            BaseResponse response = new BaseResponse();
            response.setCode(success ? "200" : "500");
            response.setMsg(success ? "\u91cd\u65b0\u7d22\u5f15\u6587\u6863\u6210\u529f" : "\u91cd\u65b0\u7d22\u5f15\u6587\u6863\u5931\u8d25");
            response.setData((Object)success);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u91cd\u65b0\u7d22\u5f15\u6587\u6863\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u91cd\u65b0\u7d22\u5f15\u6587\u6863\u5931\u8d25: " + e.getMessage());
            response.setData((Object)false);
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/search"})
    public ResponseEntity<BaseResponse<List<DifyDocument>>> searchDocuments(@RequestBody DocumentSearchRequest request, HttpServletRequest httpRequest) {
        logger.info("\u9ad8\u7ea7\u6587\u6863\u641c\u7d22: keyword={}, hospitalId={}, workflowType={}", new Object[]{request.getKeyword(), request.getHospitalId(), request.getWorkflowType()});
        try {
            if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                BaseResponse response = new BaseResponse();
                response.setCode("400");
                response.setMsg("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.ok((Object)response);
            }
            List documents = this.difyKnowledgeService.searchDocuments(request, request.getWorkflowType());
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u641c\u7d22\u6587\u6863\u6210\u529f");
            response.setData((Object)documents);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u9ad8\u7ea7\u6587\u6863\u641c\u7d22\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u641c\u7d22\u6587\u6863\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/batch/delete"})
    public ResponseEntity<BaseResponse<Map<String, Object>>> batchDeleteDocuments(@RequestBody BatchOperationRequest request, HttpServletRequest httpRequest) {
        logger.info("\u6279\u91cf\u5220\u9664\u6587\u6863: documentIds={}, hospitalId={}, operatedBy={}, workflowType={}", new Object[]{request.getDocumentIds(), request.getHospitalId(), request.getOperatedBy(), request.getWorkflowType()});
        try {
            if (request.getDocumentIds() == null || request.getDocumentIds().isEmpty()) {
                BaseResponse response = new BaseResponse();
                response.setCode("400");
                response.setMsg("\u6587\u6863ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.ok((Object)response);
            }
            if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                BaseResponse response = new BaseResponse();
                response.setCode("400");
                response.setMsg("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.ok((Object)response);
            }
            if (request.getOperatedBy() == null || request.getOperatedBy().trim().isEmpty()) {
                BaseResponse response = new BaseResponse();
                response.setCode("400");
                response.setMsg("\u64cd\u4f5c\u8005\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.ok((Object)response);
            }
            Map result = this.difyKnowledgeService.batchDeleteDocuments(request, request.getWorkflowType());
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u6279\u91cf\u5220\u9664\u6587\u6863\u5b8c\u6210");
            response.setData((Object)result);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u5220\u9664\u6587\u6863\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u6279\u91cf\u5220\u9664\u6587\u6863\u5931\u8d25: " + e.getMessage());
            response.setData(new HashMap());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/batch/toggle"})
    public ResponseEntity<BaseResponse<Map<String, Object>>> batchToggleDocuments(@RequestBody BatchOperationRequest request, HttpServletRequest httpRequest) {
        logger.info("\u6279\u91cf\u5207\u6362\u6587\u6863\u72b6\u6001: documentIds={}, enabled={}, hospitalId={}, operatedBy={}, workflowType={}", new Object[]{request.getDocumentIds(), request.getEnabled(), request.getHospitalId(), request.getOperatedBy(), request.getWorkflowType()});
        try {
            if (request.getDocumentIds() == null || request.getDocumentIds().isEmpty()) {
                BaseResponse response = new BaseResponse();
                response.setCode("400");
                response.setMsg("\u6587\u6863ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.ok((Object)response);
            }
            if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                BaseResponse response = new BaseResponse();
                response.setCode("400");
                response.setMsg("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.ok((Object)response);
            }
            if (request.getOperatedBy() == null || request.getOperatedBy().trim().isEmpty()) {
                BaseResponse response = new BaseResponse();
                response.setCode("400");
                response.setMsg("\u64cd\u4f5c\u8005\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.ok((Object)response);
            }
            if (request.getEnabled() == null) {
                BaseResponse response = new BaseResponse();
                response.setCode("400");
                response.setMsg("\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
                return ResponseEntity.ok((Object)response);
            }
            Map result = this.difyKnowledgeService.batchToggleDocuments(request, request.getWorkflowType());
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u6279\u91cf\u5207\u6362\u6587\u6863\u72b6\u6001\u5b8c\u6210");
            response.setData((Object)result);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u5207\u6362\u6587\u6863\u72b6\u6001\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u6279\u91cf\u5207\u6362\u6587\u6863\u72b6\u6001\u5931\u8d25: " + e.getMessage());
            response.setData(new HashMap());
            return ResponseEntity.ok((Object)response);
        }
    }

    @GetMapping(value={"/statistics"})
    public ResponseEntity<BaseResponse<Map<String, Object>>> getKnowledgeStatistics(@RequestParam String hospitalId, @RequestParam String workflowType, HttpServletRequest httpRequest) {
        logger.info("\u83b7\u53d6\u77e5\u8bc6\u5e93\u7edf\u8ba1\u4fe1\u606f: hospitalId={}, workflowType={}", (Object)hospitalId, (Object)workflowType);
        try {
            Map statistics = this.difyKnowledgeService.getKnowledgeStatistics(hospitalId, workflowType);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u83b7\u53d6\u77e5\u8bc6\u5e93\u7edf\u8ba1\u4fe1\u606f\u6210\u529f");
            response.setData((Object)statistics);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u77e5\u8bc6\u5e93\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u83b7\u53d6\u77e5\u8bc6\u5e93\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25: " + e.getMessage());
            response.setData(new HashMap());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/{documentId}/segments"})
    public ResponseEntity<BaseResponse<List<DifySegment>>> addDocumentSegments(@PathVariable String documentId, @RequestBody BatchSegmentRequest request, HttpServletRequest httpRequest) {
        String hospitalId = request.getHospitalId();
        String workflowType = request.getWorkflowType();
        logger.info("\u65b0\u589e\u6587\u6863\u5206\u6bb5: documentId={}, hospitalId={}, workflowType={}, segmentCount={}", new Object[]{documentId, hospitalId, workflowType, request.getSegments().size()});
        try {
            List segments = this.difyKnowledgeService.addDocumentSegments(documentId, request, hospitalId, workflowType);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u65b0\u589e\u6587\u6863\u5206\u6bb5\u6210\u529f");
            response.setData((Object)segments);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6587\u6863\u5206\u6bb5\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u65b0\u589e\u6587\u6863\u5206\u6bb5\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/segments/list"})
    public ResponseEntity<BaseResponse<SegmentListResponse>> getDocumentSegments(@RequestBody SegmentSearchRequest request, HttpServletRequest httpRequest) {
        logger.info("\u67e5\u8be2\u6587\u6863\u5206\u6bb5\u5217\u8868: {}", (Object)request);
        try {
            SegmentListResponse segments = this.difyKnowledgeService.getDocumentSegmentsWithPagination(request);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u67e5\u8be2\u6587\u6863\u5206\u6bb5\u5217\u8868\u6210\u529f");
            response.setData((Object)segments);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6587\u6863\u5206\u6bb5\u5217\u8868\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u67e5\u8be2\u6587\u6863\u5206\u6bb5\u5217\u8868\u5931\u8d25: " + e.getMessage());
            response.setData((Object)new SegmentListResponse(new ArrayList(), "text_model", false, request.getLimit().intValue(), 0, request.getPage().intValue()));
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/{documentId}/segments/{segmentId}/detail"})
    public ResponseEntity<BaseResponse<DifySegment>> getSegmentDetail(@PathVariable String documentId, @PathVariable String segmentId, @RequestBody Map<String, String> request, HttpServletRequest httpRequest) {
        String hospitalId = request.get("hospitalId");
        String workflowType = request.get("workflowType");
        logger.info("\u83b7\u53d6\u5206\u6bb5\u8be6\u60c5: documentId={}, segmentId={}, hospitalId={}, workflowType={}", new Object[]{documentId, segmentId, hospitalId, workflowType});
        try {
            DifySegment segment = this.difyKnowledgeService.getSegmentDetail(documentId, segmentId, hospitalId, workflowType);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u83b7\u53d6\u5206\u6bb5\u8be6\u60c5\u6210\u529f");
            response.setData((Object)segment);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5206\u6bb5\u8be6\u60c5\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u83b7\u53d6\u5206\u6bb5\u8be6\u60c5\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/{documentId}/segments/{segmentId}"})
    public ResponseEntity<BaseResponse<DifySegment>> updateDocumentSegment(@PathVariable String documentId, @PathVariable String segmentId, @RequestBody Map<String, Object> requestMap, HttpServletRequest httpRequest) {
        String hospitalId = (String)requestMap.get("hospitalId");
        String workflowType = (String)requestMap.get("workflowType");
        SegmentRequest segmentRequest = (SegmentRequest)this.objectMapper.convertValue(requestMap.get("segment"), SegmentRequest.class);
        logger.info("\u66f4\u65b0\u6587\u6863\u5206\u6bb5: documentId={}, segmentId={}, hospitalId={}, workflowType={}", new Object[]{documentId, segmentId, hospitalId, workflowType});
        try {
            DifySegment segment = this.difyKnowledgeService.updateDocumentSegment(documentId, segmentId, segmentRequest, hospitalId, workflowType);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u66f4\u65b0\u6587\u6863\u5206\u6bb5\u6210\u529f");
            response.setData((Object)segment);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u6587\u6863\u5206\u6bb5\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u66f4\u65b0\u6587\u6863\u5206\u6bb5\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/{documentId}/segments/{segmentId}/delete"})
    public ResponseEntity<BaseResponse<Boolean>> deleteDocumentSegment(@PathVariable String documentId, @PathVariable String segmentId, @RequestBody Map<String, String> request, HttpServletRequest httpRequest) {
        String hospitalId = request.get("hospitalId");
        String workflowType = request.get("workflowType");
        logger.info("\u5220\u9664\u6587\u6863\u5206\u6bb5: documentId={}, segmentId={}, hospitalId={}, workflowType={}", new Object[]{documentId, segmentId, hospitalId, workflowType});
        try {
            boolean success = this.difyKnowledgeService.deleteDocumentSegment(documentId, segmentId, hospitalId, workflowType);
            BaseResponse response = new BaseResponse();
            response.setCode(success ? "200" : "500");
            response.setMsg(success ? "\u5220\u9664\u6587\u6863\u5206\u6bb5\u6210\u529f" : "\u5220\u9664\u6587\u6863\u5206\u6bb5\u5931\u8d25");
            response.setData((Object)success);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6587\u6863\u5206\u6bb5\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u5220\u9664\u6587\u6863\u5206\u6bb5\u5931\u8d25: " + e.getMessage());
            response.setData((Object)false);
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/{documentId}/segments/{segmentId}/child_chunks"})
    public ResponseEntity<BaseResponse<DifyChildChunk>> addChildChunk(@PathVariable String documentId, @PathVariable String segmentId, @RequestBody Map<String, String> request, HttpServletRequest httpRequest) {
        String content = request.get("content");
        String hospitalId = request.get("hospitalId");
        String workflowType = request.get("workflowType");
        logger.info("\u65b0\u589e\u5b50\u5206\u6bb5: documentId={}, segmentId={}, hospitalId={}, workflowType={}", new Object[]{documentId, segmentId, hospitalId, workflowType});
        try {
            DifyChildChunk childChunk = this.difyKnowledgeService.addChildChunk(documentId, segmentId, content, hospitalId, workflowType);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u65b0\u589e\u5b50\u5206\u6bb5\u6210\u529f");
            response.setData((Object)childChunk);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u5b50\u5206\u6bb5\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u65b0\u589e\u5b50\u5206\u6bb5\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/{documentId}/segments/{segmentId}/child_chunks/list"})
    public ResponseEntity<BaseResponse<List<DifyChildChunk>>> getChildChunks(@PathVariable String documentId, @PathVariable String segmentId, @RequestBody Map<String, Object> request, HttpServletRequest httpRequest) {
        String keyword = (String)request.get("keyword");
        Integer page = request.get("page") != null ? (Integer)request.get("page") : 1;
        Integer limit = request.get("limit") != null ? (Integer)request.get("limit") : 20;
        String hospitalId = (String)request.get("hospitalId");
        String workflowType = (String)request.get("workflowType");
        logger.info("\u67e5\u8be2\u5b50\u5206\u6bb5\u5217\u8868: documentId={}, segmentId={}, hospitalId={}, workflowType={}", new Object[]{documentId, segmentId, hospitalId, workflowType});
        try {
            List childChunks = this.difyKnowledgeService.getChildChunks(documentId, segmentId, keyword, page, limit, hospitalId, workflowType);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u67e5\u8be2\u5b50\u5206\u6bb5\u5217\u8868\u6210\u529f");
            response.setData((Object)childChunks);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5b50\u5206\u6bb5\u5217\u8868\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u67e5\u8be2\u5b50\u5206\u6bb5\u5217\u8868\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/{documentId}/segments/{segmentId}/child_chunks/{childChunkId}"})
    public ResponseEntity<BaseResponse<DifyChildChunk>> updateChildChunk(@PathVariable String documentId, @PathVariable String segmentId, @PathVariable String childChunkId, @RequestBody Map<String, String> request, HttpServletRequest httpRequest) {
        String content = request.get("content");
        String hospitalId = request.get("hospitalId");
        String workflowType = request.get("workflowType");
        logger.info("\u66f4\u65b0\u5b50\u5206\u6bb5: documentId={}, segmentId={}, childChunkId={}, hospitalId={}, workflowType={}", new Object[]{documentId, segmentId, childChunkId, hospitalId, workflowType});
        try {
            DifyChildChunk childChunk = this.difyKnowledgeService.updateChildChunk(documentId, segmentId, childChunkId, content, hospitalId, workflowType);
            BaseResponse response = new BaseResponse();
            response.setCode("200");
            response.setMsg("\u66f4\u65b0\u5b50\u5206\u6bb5\u6210\u529f");
            response.setData((Object)childChunk);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u5b50\u5206\u6bb5\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u66f4\u65b0\u5b50\u5206\u6bb5\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok((Object)response);
        }
    }

    @PostMapping(value={"/documents/{documentId}/segments/{segmentId}/child_chunks/{childChunkId}/delete"})
    public ResponseEntity<BaseResponse<Boolean>> deleteChildChunk(@PathVariable String documentId, @PathVariable String segmentId, @PathVariable String childChunkId, @RequestBody Map<String, String> request, HttpServletRequest httpRequest) {
        String hospitalId = request.get("hospitalId");
        String workflowType = request.get("workflowType");
        logger.info("\u5220\u9664\u5b50\u5206\u6bb5: documentId={}, segmentId={}, childChunkId={}, hospitalId={}, workflowType={}", new Object[]{documentId, segmentId, childChunkId, hospitalId, workflowType});
        try {
            boolean success = this.difyKnowledgeService.deleteChildChunk(documentId, segmentId, childChunkId, hospitalId, workflowType);
            BaseResponse response = new BaseResponse();
            response.setCode(success ? "200" : "500");
            response.setMsg(success ? "\u5220\u9664\u5b50\u5206\u6bb5\u6210\u529f" : "\u5220\u9664\u5b50\u5206\u6bb5\u5931\u8d25");
            response.setData((Object)success);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u5b50\u5206\u6bb5\u5931\u8d25", (Throwable)e);
            BaseResponse response = new BaseResponse();
            response.setCode("500");
            response.setMsg("\u5220\u9664\u5b50\u5206\u6bb5\u5931\u8d25: " + e.getMessage());
            response.setData((Object)false);
            return ResponseEntity.ok((Object)response);
        }
    }
}

