/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

/*
 * Exception performing whole class analysis ignored.
 */
public class UltraSafeMessageSender {
    private static final Logger logger = LoggerFactory.getLogger(UltraSafeMessageSender.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final int ULTRA_SAFE_SIZE = 2048;

    public static boolean ultraSafeSend(WebSocketSession session, String message, String messageType) {
        if (session == null || !session.isOpen()) {
            logger.warn("WebSocket\u4f1a\u8bdd\u65e0\u6548\u6216\u5df2\u5173\u95ed");
            return false;
        }
        try {
            byte[] messageBytes = message.getBytes(StandardCharsets.UTF_8);
            int messageSize = messageBytes.length;
            logger.debug("\u51c6\u5907\u8d85\u5b89\u5168\u53d1\u9001{}\u6d88\u606f: \u5927\u5c0f={}bytes", (Object)messageType, (Object)messageSize);
            if (messageSize <= 2048) {
                return UltraSafeMessageSender.directSend((WebSocketSession)session, (String)message);
            }
            return UltraSafeMessageSender.microChunkSend((WebSocketSession)session, (String)message, (String)messageType);
        }
        catch (Exception e) {
            logger.error("\u8d85\u5b89\u5168\u53d1\u9001{}\u6d88\u606f\u5931\u8d25", (Object)messageType, (Object)e);
            return false;
        }
    }

    private static boolean directSend(WebSocketSession session, String message) {
        try {
            if (!session.isOpen()) {
                return false;
            }
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)message));
            logger.debug("\u76f4\u63a5\u53d1\u9001\u6d88\u606f\u6210\u529f: {}bytes", (Object)message.getBytes(StandardCharsets.UTF_8).length);
            return true;
        }
        catch (Exception e) {
            logger.error("\u76f4\u63a5\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    private static boolean microChunkSend(WebSocketSession session, String message, String messageType) {
        try {
            byte[] messageBytes = message.getBytes(StandardCharsets.UTF_8);
            int microChunkSize = 1024;
            int totalMicroChunks = (int)Math.ceil((double)messageBytes.length / (double)microChunkSize);
            String microChunkId = System.currentTimeMillis() + "_micro_" + messageType;
            logger.info("\u5f00\u59cb\u5fae\u5206\u7247\u53d1\u9001{}\u6d88\u606f: \u603b\u5927\u5c0f={}bytes, \u5fae\u5206\u7247\u6570={}", new Object[]{messageType, messageBytes.length, totalMicroChunks});
            for (int i = 0; i < totalMicroChunks; ++i) {
                if (!session.isOpen()) {
                    logger.warn("\u8fde\u63a5\u5df2\u5173\u95ed\uff0c\u505c\u6b62\u5fae\u5206\u7247\u53d1\u9001 {}/{}", (Object)(i + 1), (Object)totalMicroChunks);
                    return false;
                }
                int start = i * microChunkSize;
                int end = Math.min(start + microChunkSize, messageBytes.length);
                byte[] microChunkBytes = new byte[end - start];
                System.arraycopy(messageBytes, start, microChunkBytes, 0, end - start);
                String microChunkData = new String(microChunkBytes, StandardCharsets.UTF_8);
                HashMap<String, Object> microChunk = new HashMap<String, Object>();
                microChunk.put("t", "mc");
                microChunk.put("mt", messageType);
                microChunk.put("id", microChunkId);
                microChunk.put("i", i);
                microChunk.put("n", totalMicroChunks);
                microChunk.put("d", microChunkData);
                microChunk.put("l", i == totalMicroChunks - 1);
                String microChunkJson = objectMapper.writeValueAsString(microChunk);
                int chunkJsonSize = microChunkJson.getBytes(StandardCharsets.UTF_8).length;
                if (chunkJsonSize > 2048) {
                    logger.error("\u5fae\u5206\u7247 {}/{} \u4ecd\u7136\u8fc7\u5927: {}bytes\uff0c\u65e0\u6cd5\u53d1\u9001", new Object[]{i + 1, totalMicroChunks, chunkJsonSize});
                    return false;
                }
                session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)microChunkJson));
                logger.debug("\u53d1\u9001\u5fae\u5206\u7247 {}/{}: \u5927\u5c0f={}bytes", new Object[]{i + 1, totalMicroChunks, chunkJsonSize});
                Thread.sleep(100L);
            }
            logger.info("\u5fae\u5206\u7247\u53d1\u9001\u5b8c\u6210: microChunkId={}, \u603b\u5fae\u5206\u7247\u6570={}", (Object)microChunkId, (Object)totalMicroChunks);
            return true;
        }
        catch (Exception e) {
            logger.error("\u5fae\u5206\u7247\u53d1\u9001{}\u6d88\u606f\u5931\u8d25", (Object)messageType, (Object)e);
            return false;
        }
    }

    public static void sendError(WebSocketSession session, String errorMessage) {
        try {
            if (session != null && session.isOpen()) {
                HashMap<String, Object> error = new HashMap<String, Object>();
                error.put("t", "err");
                error.put("m", errorMessage);
                error.put("ts", System.currentTimeMillis());
                String errorJson = objectMapper.writeValueAsString(error);
                if (errorJson.getBytes(StandardCharsets.UTF_8).length <= 2048) {
                    session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)errorJson));
                } else {
                    session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)"{\"t\":\"err\",\"m\":\"Error\"}"));
                }
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u9519\u8bef\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }
}

