/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.chdu.ai.controller.TTSController;
import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.service.TTSService;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tts"})
@CrossOrigin(origins={"*"})
public class TTSController {
    private static final Logger logger = LoggerFactory.getLogger(TTSController.class);
    @Autowired
    private TTSService ttsService;

    @PostMapping(value={"/synthesize"})
    public ResponseEntity<?> synthesizeText(@RequestBody TTSRequest request) {
        try {
            if (request.getText() == null || request.getText().trim().isEmpty()) {
                return ResponseEntity.badRequest().body((Object)BaseResponse.error((String)"400", (String)"\u6587\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            InputStream audioStream = this.ttsService.synthesizeText(request.getText());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)"audio/wav"));
            headers.setContentDispositionFormData("attachment", "tts_audio.wav");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)new InputStreamResource(audioStream));
        }
        catch (Exception e) {
            logger.error("\u8bed\u97f3\u5408\u6210\u5931\u8d25", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)BaseResponse.error((String)"500", (String)("\u8bed\u97f3\u5408\u6210\u5931\u8d25: " + e.getMessage())));
        }
    }

    @PostMapping(value={"/synthesize/custom"})
    public ResponseEntity<?> synthesizeTextWithCustomParams(@RequestBody TTSCustomRequest request) {
        try {
            if (request.getText() == null || request.getText().trim().isEmpty()) {
                return ResponseEntity.badRequest().body((Object)BaseResponse.error((String)"400", (String)"\u6587\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            InputStream audioStream = this.ttsService.synthesizeText(request.getText());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)"audio/wav"));
            headers.setContentDispositionFormData("attachment", "tts_audio.wav");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)new InputStreamResource(audioStream));
        }
        catch (Exception e) {
            logger.error("\u8bed\u97f3\u5408\u6210\u5931\u8d25", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)BaseResponse.error((String)"500", (String)("\u8bed\u97f3\u5408\u6210\u5931\u8d25: " + e.getMessage())));
        }
    }

    @GetMapping(value={"/health"})
    public ResponseEntity<BaseResponse<String>> healthCheck() {
        try {
            boolean isHealthy = this.ttsService.testConnection();
            if (isHealthy) {
                return ResponseEntity.ok((Object)BaseResponse.success((Object)"TTS\u670d\u52a1\u8fd0\u884c\u6b63\u5e38"));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE).body((Object)BaseResponse.error((String)"503", (String)"TTS\u670d\u52a1\u8fde\u63a5\u5f02\u5e38"));
        }
        catch (Exception e) {
            logger.error("TTS\u5065\u5eb7\u68c0\u67e5\u5931\u8d25", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)BaseResponse.error((String)"500", (String)("\u5065\u5eb7\u68c0\u67e5\u5931\u8d25: " + e.getMessage())));
        }
    }
}

