/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.model.Product;
import com.chdu.ai.model.ProductRequest;
import com.chdu.ai.service.ProductService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/product"})
@CrossOrigin(origins={"*"})
public class ProductController {
    private static final Logger logger = LoggerFactory.getLogger(ProductController.class);
    @Autowired
    private ProductService productService;

    @PostMapping
    public BaseResponse<Product> create(@RequestBody ProductRequest request) {
        try {
            logger.info("\u521b\u5efa\u4ea7\u54c1: productName={}, productType={}", (Object)request.getProductName(), (Object)request.getProductType());
            if (request.getProductName() == null || request.getProductName().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getCategoryCode() == null || request.getCategoryCode().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getProductType() == null || request.getProductType().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u4ea7\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getPrice() == null) {
                return BaseResponse.error((String)"400", (String)"\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Product product = new Product();
            product.setProductName(request.getProductName());
            product.setCategoryCode(request.getCategoryCode());
            product.setProductType(request.getProductType());
            product.setPrice(request.getPrice());
            product.setOriginalPrice(request.getOriginalPrice());
            product.setUnit(request.getUnit());
            product.setStockQuantity(request.getStockQuantity());
            product.setDescription(request.getDescription());
            product.setDetailHtml(request.getDetailHtml());
            product.setMainImageUrl(request.getMainImageUrl());
            product.setImageUrls(request.getImageUrls());
            product.setSpecifications(request.getSpecifications());
            product.setStatus(request.getStatus());
            product.setIsRecommended(request.getIsRecommended());
            product.setSortOrder(request.getSortOrder());
            product.setHospitalId(request.getHospitalId());
            Product result = this.productService.create(product);
            logger.info("\u521b\u5efa\u4ea7\u54c1\u6210\u529f: id={}", (Object)result.getId());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u4ea7\u54c1\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u521b\u5efa\u4ea7\u54c1\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/detail"})
    public BaseResponse<Product> getByProductCode(@RequestParam String productCode) {
        try {
            logger.info("\u6839\u636e\u4ea7\u54c1\u7f16\u7801\u67e5\u8be2\u4ea7\u54c1: productCode={}", (Object)productCode);
            Product result = this.productService.getByProductCode(productCode);
            if (result == null) {
                return BaseResponse.error((String)"404", (String)"\u4ea7\u54c1\u4e0d\u5b58\u5728");
            }
            logger.info("\u67e5\u8be2\u4ea7\u54c1\u6210\u529f: productCode={}", (Object)productCode);
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4ea7\u54c1\u5931\u8d25: productCode={}", (Object)productCode, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u67e5\u8be2\u4ea7\u54c1\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping
    public BaseResponse<List<Product>> getByCondition(@RequestParam(required=false) String categoryCode, @RequestParam(required=false) String productType, @RequestParam(required=false) Integer status, @RequestParam(required=false) String hospitalId, @RequestParam(required=false) String keyword, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="20") int size) {
        try {
            logger.info("\u5206\u9875\u67e5\u8be2\u4ea7\u54c1\u5217\u8868: categoryCode={}, productType={}, status={}, page={}, size={}", new Object[]{categoryCode, productType, status, page, size});
            List result = this.productService.getByCondition(categoryCode, productType, status, hospitalId, keyword, page, size);
            logger.info("\u5206\u9875\u67e5\u8be2\u4ea7\u54c1\u5217\u8868\u6210\u529f: \u6570\u91cf={}", (Object)result.size());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u5206\u9875\u67e5\u8be2\u4ea7\u54c1\u5217\u8868\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u5206\u9875\u67e5\u8be2\u4ea7\u54c1\u5217\u8868\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/category/{categoryCode}"})
    public BaseResponse<List<Product>> getByCategoryCode(@PathVariable String categoryCode) {
        try {
            logger.info("\u6839\u636e\u5206\u7c7b\u67e5\u8be2\u4ea7\u54c1: categoryCode={}", (Object)categoryCode);
            List result = this.productService.getByCategoryCode(categoryCode);
            logger.info("\u67e5\u8be2\u4ea7\u54c1\u6210\u529f: categoryCode={}, \u6570\u91cf={}", (Object)categoryCode, (Object)result.size());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4ea7\u54c1\u5931\u8d25: categoryCode={}", (Object)categoryCode, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u67e5\u8be2\u4ea7\u54c1\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/type/{type}"})
    public BaseResponse<List<Product>> getByProductType(@PathVariable String type) {
        try {
            logger.info("\u6839\u636e\u7c7b\u578b\u67e5\u8be2\u4ea7\u54c1: type={}", (Object)type);
            List result = this.productService.getByProductType(type);
            logger.info("\u67e5\u8be2\u4ea7\u54c1\u6210\u529f: type={}, \u6570\u91cf={}", (Object)type, (Object)result.size());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4ea7\u54c1\u5931\u8d25: type={}", (Object)type, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u67e5\u8be2\u4ea7\u54c1\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public BaseResponse<Product> update(@RequestBody ProductRequest request) {
        try {
            logger.info("\u66f4\u65b0\u4ea7\u54c1: id={}", (Object)request.getId());
            if (request.getId() == null) {
                return BaseResponse.error((String)"400", (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Product product = new Product();
            product.setId(request.getId());
            product.setProductCode(request.getProductCode());
            product.setProductName(request.getProductName());
            product.setCategoryCode(request.getCategoryCode());
            product.setProductType(request.getProductType());
            product.setPrice(request.getPrice());
            product.setOriginalPrice(request.getOriginalPrice());
            product.setUnit(request.getUnit());
            product.setStockQuantity(request.getStockQuantity());
            product.setDescription(request.getDescription());
            product.setDetailHtml(request.getDetailHtml());
            product.setMainImageUrl(request.getMainImageUrl());
            product.setImageUrls(request.getImageUrls());
            product.setSpecifications(request.getSpecifications());
            product.setStatus(request.getStatus());
            product.setIsRecommended(request.getIsRecommended());
            product.setSortOrder(request.getSortOrder());
            product.setHospitalId(request.getHospitalId());
            boolean success = this.productService.update(product);
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u66f4\u65b0\u5931\u8d25\uff0c\u4ea7\u54c1\u53ef\u80fd\u4e0d\u5b58\u5728");
            }
            Product result = this.productService.getById(request.getId());
            logger.info("\u66f4\u65b0\u4ea7\u54c1\u6210\u529f: id={}", (Object)request.getId());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u4ea7\u54c1\u5931\u8d25: id={}", (Object)request.getId(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u66f4\u65b0\u4ea7\u54c1\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/update-status"})
    public BaseResponse<String> updateStatus(@RequestBody ProductRequest request) {
        try {
            logger.info("\u66f4\u65b0\u4ea7\u54c1\u72b6\u6001: id={}, status={}", (Object)request.getId(), (Object)request.getStatus());
            if (request.getId() == null) {
                return BaseResponse.error((String)"400", (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getStatus() == null) {
                return BaseResponse.error((String)"400", (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            }
            boolean success = this.productService.updateStatus(request.getId(), request.getStatus());
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u66f4\u65b0\u5931\u8d25\uff0c\u4ea7\u54c1\u53ef\u80fd\u4e0d\u5b58\u5728");
            }
            logger.info("\u66f4\u65b0\u4ea7\u54c1\u72b6\u6001\u6210\u529f: id={}, status={}", (Object)request.getId(), (Object)request.getStatus());
            return BaseResponse.success((Object)"\u72b6\u6001\u66f4\u65b0\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u4ea7\u54c1\u72b6\u6001\u5931\u8d25: id={}, status={}", new Object[]{request.getId(), request.getStatus(), e});
            return BaseResponse.error((String)"500", (String)("\u66f4\u65b0\u4ea7\u54c1\u72b6\u6001\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/update-stock"})
    public BaseResponse<String> updateStock(@RequestBody ProductRequest request) {
        try {
            logger.info("\u66f4\u65b0\u4ea7\u54c1\u5e93\u5b58: id={}, stockQuantity={}", (Object)request.getId(), (Object)request.getStockQuantity());
            if (request.getId() == null) {
                return BaseResponse.error((String)"400", (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getStockQuantity() == null) {
                return BaseResponse.error((String)"400", (String)"\u5e93\u5b58\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            boolean success = this.productService.updateStock(request.getId(), request.getStockQuantity());
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u66f4\u65b0\u5931\u8d25\uff0c\u4ea7\u54c1\u53ef\u80fd\u4e0d\u5b58\u5728");
            }
            logger.info("\u66f4\u65b0\u4ea7\u54c1\u5e93\u5b58\u6210\u529f: id={}, stockQuantity={}", (Object)request.getId(), (Object)request.getStockQuantity());
            return BaseResponse.success((Object)"\u5e93\u5b58\u66f4\u65b0\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u4ea7\u54c1\u5e93\u5b58\u5931\u8d25: id={}, stockQuantity={}", new Object[]{request.getId(), request.getStockQuantity(), e});
            return BaseResponse.error((String)"500", (String)("\u66f4\u65b0\u4ea7\u54c1\u5e93\u5b58\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/delete"})
    public BaseResponse<String> delete(@RequestBody ProductRequest request) {
        try {
            logger.info("\u5220\u9664\u4ea7\u54c1: id={}", (Object)request.getId());
            if (request.getId() == null) {
                return BaseResponse.error((String)"400", (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            boolean success = this.productService.deleteById(request.getId());
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u5220\u9664\u5931\u8d25\uff0c\u4ea7\u54c1\u53ef\u80fd\u4e0d\u5b58\u5728");
            }
            logger.info("\u5220\u9664\u4ea7\u54c1\u6210\u529f: id={}", (Object)request.getId());
            return BaseResponse.success((Object)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u4ea7\u54c1\u5931\u8d25: id={}", (Object)request.getId(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u5220\u9664\u4ea7\u54c1\u5931\u8d25: " + e.getMessage()));
        }
    }
}

