/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.model.OrderRequest;
import com.chdu.ai.model.ProductOrder;
import com.chdu.ai.service.ProductOrderService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/product-order"})
@CrossOrigin(origins={"*"})
public class ProductOrderController {
    private static final Logger logger = LoggerFactory.getLogger(ProductOrderController.class);
    @Autowired
    private ProductOrderService productOrderService;

    @PostMapping(value={"/create"})
    public BaseResponse<ProductOrder> create(@RequestBody OrderRequest request) {
        try {
            logger.info("\u521b\u5efa\u8ba2\u5355: userId={}, cartIds={}", (Object)request.getUserId(), (Object)request.getCartIds());
            if (request.getUserId() == null || request.getUserId().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getCartIds() == null || request.getCartIds().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u8d2d\u7269\u8f66ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ProductOrder result = this.productOrderService.createOrderFromCart(request.getUserId(), request.getUserType(), request.getCartIds(), request.getShippingAddress(), request.getContactName(), request.getContactPhone(), request.getRemark(), request.getHospitalId());
            logger.info("\u521b\u5efa\u8ba2\u5355\u6210\u529f: orderNo={}", (Object)result.getOrderNo());
            return BaseResponse.success((Object)result);
        }
        catch (RuntimeException e) {
            logger.error("\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"400", (String)e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u521b\u5efa\u8ba2\u5355\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/detail"})
    public BaseResponse<ProductOrder> getByOrderNo(@RequestParam String orderNo) {
        try {
            logger.info("\u6839\u636e\u8ba2\u5355\u53f7\u67e5\u8be2\u8ba2\u5355: orderNo={}", (Object)orderNo);
            ProductOrder result = this.productOrderService.getByOrderNo(orderNo);
            if (result == null) {
                return BaseResponse.error((String)"404", (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            logger.info("\u67e5\u8be2\u8ba2\u5355\u6210\u529f: orderNo={}", (Object)orderNo);
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8ba2\u5355\u5931\u8d25: orderNo={}", (Object)orderNo, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u67e5\u8be2\u8ba2\u5355\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping
    public BaseResponse<List<ProductOrder>> getByCondition(@RequestParam(required=false) String userId, @RequestParam(required=false) String userType, @RequestParam(required=false) String hospitalId, @RequestParam(required=false) String orderStatus, @RequestParam(required=false) String paymentStatus, @RequestParam(required=false) String orderNo, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="20") int size) {
        try {
            logger.info("\u5206\u9875\u67e5\u8be2\u8ba2\u5355\u5217\u8868: userId={}, orderStatus={}, page={}, size={}", new Object[]{userId, orderStatus, page, size});
            List result = this.productOrderService.getByCondition(userId, userType, hospitalId, orderStatus, paymentStatus, orderNo, page, size);
            logger.info("\u5206\u9875\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u6210\u529f: \u6570\u91cf={}", (Object)result.size());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u5206\u9875\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u5206\u9875\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/user/{userId}"})
    public BaseResponse<List<ProductOrder>> getByUserId(@PathVariable String userId) {
        try {
            logger.info("\u67e5\u8be2\u7528\u6237\u8ba2\u5355\u5217\u8868: userId={}", (Object)userId);
            List result = this.productOrderService.getByUserId(userId);
            logger.info("\u67e5\u8be2\u7528\u6237\u8ba2\u5355\u5217\u8868\u6210\u529f: userId={}, \u6570\u91cf={}", (Object)userId, (Object)result.size());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7528\u6237\u8ba2\u5355\u5217\u8868\u5931\u8d25: userId={}", (Object)userId, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u67e5\u8be2\u7528\u6237\u8ba2\u5355\u5217\u8868\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/cancel"})
    public BaseResponse<String> cancel(@RequestBody OrderRequest request) {
        try {
            logger.info("\u53d6\u6d88\u8ba2\u5355: id={}", (Object)request.getId());
            if (request.getId() == null) {
                return BaseResponse.error((String)"400", (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            boolean success = this.productOrderService.cancelOrder(request.getId());
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u53d6\u6d88\u5931\u8d25\uff0c\u8ba2\u5355\u53ef\u80fd\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u4e0d\u6b63\u786e");
            }
            logger.info("\u53d6\u6d88\u8ba2\u5355\u6210\u529f: id={}", (Object)request.getId());
            return BaseResponse.success((Object)"\u53d6\u6d88\u6210\u529f");
        }
        catch (RuntimeException e) {
            logger.error("\u53d6\u6d88\u8ba2\u5355\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"400", (String)e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u53d6\u6d88\u8ba2\u5355\u5931\u8d25: id={}", (Object)request.getId(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u53d6\u6d88\u8ba2\u5355\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/pay"})
    public BaseResponse<String> pay(@RequestBody OrderRequest request) {
        try {
            logger.info("\u652f\u4ed8\u8ba2\u5355: id={}, paymentMethod={}", (Object)request.getId(), (Object)request.getPaymentMethod());
            if (request.getId() == null) {
                return BaseResponse.error((String)"400", (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getPaymentMethod() == null || request.getPaymentMethod().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            boolean success = this.productOrderService.payOrder(request.getId(), request.getPaymentMethod());
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u652f\u4ed8\u5931\u8d25\uff0c\u8ba2\u5355\u53ef\u80fd\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u4e0d\u6b63\u786e");
            }
            logger.info("\u652f\u4ed8\u8ba2\u5355\u6210\u529f: id={}", (Object)request.getId());
            return BaseResponse.success((Object)"\u652f\u4ed8\u6210\u529f");
        }
        catch (RuntimeException e) {
            logger.error("\u652f\u4ed8\u8ba2\u5355\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"400", (String)e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u652f\u4ed8\u8ba2\u5355\u5931\u8d25: id={}", (Object)request.getId(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u652f\u4ed8\u8ba2\u5355\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/ship"})
    public BaseResponse<String> ship(@RequestBody OrderRequest request) {
        try {
            logger.info("\u53d1\u8d27: id={}", (Object)request.getId());
            if (request.getId() == null) {
                return BaseResponse.error((String)"400", (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            boolean success = this.productOrderService.shipOrder(request.getId());
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u53d1\u8d27\u5931\u8d25\uff0c\u8ba2\u5355\u53ef\u80fd\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u4e0d\u6b63\u786e");
            }
            logger.info("\u53d1\u8d27\u6210\u529f: id={}", (Object)request.getId());
            return BaseResponse.success((Object)"\u53d1\u8d27\u6210\u529f");
        }
        catch (RuntimeException e) {
            logger.error("\u53d1\u8d27\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"400", (String)e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u53d1\u8d27\u5931\u8d25: id={}", (Object)request.getId(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u53d1\u8d27\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/complete"})
    public BaseResponse<String> complete(@RequestBody OrderRequest request) {
        try {
            logger.info("\u5b8c\u6210\u8ba2\u5355: id={}", (Object)request.getId());
            if (request.getId() == null) {
                return BaseResponse.error((String)"400", (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            boolean success = this.productOrderService.completeOrder(request.getId());
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u5b8c\u6210\u5931\u8d25\uff0c\u8ba2\u5355\u53ef\u80fd\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u4e0d\u6b63\u786e");
            }
            logger.info("\u5b8c\u6210\u8ba2\u5355\u6210\u529f: id={}", (Object)request.getId());
            return BaseResponse.success((Object)"\u5b8c\u6210\u6210\u529f");
        }
        catch (RuntimeException e) {
            logger.error("\u5b8c\u6210\u8ba2\u5355\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"400", (String)e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u5b8c\u6210\u8ba2\u5355\u5931\u8d25: id={}", (Object)request.getId(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u5b8c\u6210\u8ba2\u5355\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/status/{status}"})
    public BaseResponse<List<ProductOrder>> getByOrderStatus(@PathVariable String status) {
        try {
            logger.info("\u6839\u636e\u72b6\u6001\u67e5\u8be2\u8ba2\u5355: status={}", (Object)status);
            List result = this.productOrderService.getByOrderStatus(status);
            logger.info("\u67e5\u8be2\u8ba2\u5355\u6210\u529f: status={}, \u6570\u91cf={}", (Object)status, (Object)result.size());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8ba2\u5355\u5931\u8d25: status={}", (Object)status, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u67e5\u8be2\u8ba2\u5355\u5931\u8d25: " + e.getMessage()));
        }
    }
}

