/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.config;

import javax.servlet.MultipartConfigElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.servlet.MultipartProperties;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.event.EventListener;
import org.springframework.util.unit.DataSize;

@Configuration
public class MultipartConfig {
    private static final Logger logger = LoggerFactory.getLogger(MultipartConfig.class);
    private static final long MAX_FILE_SIZE_MB = 500L;
    private static final long MAX_REQUEST_SIZE_MB = 500L;
    @Autowired(required=false)
    private MultipartProperties multipartProperties;

    @Bean
    @Primary
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        factory.setMaxFileSize(DataSize.ofMegabytes((long)500L));
        factory.setMaxRequestSize(DataSize.ofMegabytes((long)500L));
        factory.setFileSizeThreshold(DataSize.ofKilobytes((long)2L));
        MultipartConfigElement configElement = factory.createMultipartConfig();
        logger.warn("========== \u6587\u4ef6\u4e0a\u4f20\u914d\u7f6e\u5df2\u52a0\u8f7d\uff08MultipartConfigElement Bean\uff09 ==========");
        logger.warn("maxFileSize: {}MB ({}\u5b57\u8282)", (Object)500L, (Object)configElement.getMaxFileSize());
        logger.warn("maxRequestSize: {}MB ({}\u5b57\u8282)", (Object)500L, (Object)configElement.getMaxRequestSize());
        logger.warn("fileSizeThreshold: {}\u5b57\u8282", (Object)configElement.getFileSizeThreshold());
        logger.warn("========================================================================");
        return configElement;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void printMultipartConfig() {
        logger.warn("==================== \u5e94\u7528\u542f\u52a8\u5b8c\u6210\uff0c\u9a8c\u8bc1\u6587\u4ef6\u4e0a\u4f20\u914d\u7f6e ====================");
        if (this.multipartProperties != null) {
            logger.warn("\u4ece\u914d\u7f6e\u4e2d\u5fc3/\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u7684 MultipartProperties:");
            logger.warn("  - maxFileSize: {}", (Object)this.multipartProperties.getMaxFileSize());
            logger.warn("  - maxRequestSize: {}", (Object)this.multipartProperties.getMaxRequestSize());
            logger.warn("  - fileSizeThreshold: {}", (Object)this.multipartProperties.getFileSizeThreshold());
            logger.warn("  - location: {}", (Object)this.multipartProperties.getLocation());
            DataSize expectedSize = DataSize.ofMegabytes((long)500L);
            if (this.multipartProperties.getMaxFileSize().toBytes() < expectedSize.toBytes()) {
                logger.error("\u274c \u8b66\u544a\uff1amaxFileSize ({}) \u5c0f\u4e8e\u9884\u671f\u7684 500MB\uff01", (Object)this.multipartProperties.getMaxFileSize());
                logger.error("\u274c \u914d\u7f6e\u4e2d\u5fc3\u7684\u914d\u7f6e\u53ef\u80fd\u672a\u751f\u6548\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4e2d\u5fc3\u7684 spring.servlet.multipart.max-file-size \u914d\u7f6e");
            } else {
                logger.warn("\u2705 maxFileSize \u914d\u7f6e\u6b63\u786e\uff1a{}", (Object)this.multipartProperties.getMaxFileSize());
            }
            if (this.multipartProperties.getMaxRequestSize().toBytes() < expectedSize.toBytes()) {
                logger.error("\u274c \u8b66\u544a\uff1amaxRequestSize ({}) \u5c0f\u4e8e\u9884\u671f\u7684 500MB\uff01", (Object)this.multipartProperties.getMaxRequestSize());
                logger.error("\u274c \u914d\u7f6e\u4e2d\u5fc3\u7684\u914d\u7f6e\u53ef\u80fd\u672a\u751f\u6548\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4e2d\u5fc3\u7684 spring.servlet.multipart.max-request-size \u914d\u7f6e");
            } else {
                logger.warn("\u2705 maxRequestSize \u914d\u7f6e\u6b63\u786e\uff1a{}", (Object)this.multipartProperties.getMaxRequestSize());
            }
        } else {
            logger.error("\u274c MultipartProperties \u672a\u6ce8\u5165\uff0c\u914d\u7f6e\u53ef\u80fd\u6709\u4e25\u91cd\u95ee\u9898\uff01");
        }
        logger.warn("========================================================================");
    }
}

