/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.mapper.ProductMapper;
import com.chdu.ai.model.Product;
import com.chdu.ai.service.ProductService;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductServiceImpl
implements ProductService {
    private static final Logger logger = LoggerFactory.getLogger(ProductServiceImpl.class);
    @Autowired
    private ProductMapper productMapper;

    @Transactional
    public Product create(Product product) {
        if (product.getProductCode() == null || product.getProductCode().trim().isEmpty()) {
            String productCode = "PROD" + UUID.randomUUID().toString().replace("-", "").toUpperCase();
            product.setProductCode(productCode);
            logger.info("\u81ea\u52a8\u751f\u6210\u4ea7\u54c1\u7f16\u7801: productCode={}", (Object)productCode);
        }
        if (product.getStatus() == null) {
            product.setStatus(Integer.valueOf(1));
        }
        if (product.getIsRecommended() == null) {
            product.setIsRecommended(Integer.valueOf(0));
        }
        if (product.getSortOrder() == null) {
            product.setSortOrder(Integer.valueOf(0));
        }
        if (product.getStockQuantity() == null) {
            product.setStockQuantity(Integer.valueOf(0));
        }
        if (product.getSalesCount() == null) {
            product.setSalesCount(Integer.valueOf(0));
        }
        if (product.getViewCount() == null) {
            product.setViewCount(Integer.valueOf(0));
        }
        if (product.getUnit() == null || product.getUnit().isEmpty()) {
            product.setUnit("\u4ef6");
        }
        if (product.getCreateTime() == null) {
            product.setCreateTime(new Date());
        }
        if (product.getUpdateTime() == null) {
            product.setUpdateTime(new Date());
        }
        this.productMapper.insert(product);
        return this.productMapper.selectById(product.getId());
    }

    public Product getById(Long id) {
        Product product = this.productMapper.selectById(id);
        if (product != null) {
            this.productMapper.increaseViewCount(id);
        }
        return product;
    }

    public Product getByProductCode(String productCode) {
        return this.productMapper.selectByProductCode(productCode);
    }

    public List<Product> getByCondition(String categoryCode, String productType, Integer status, String hospitalId, String keyword, int page, int size) {
        int offset = page * size;
        return this.productMapper.selectByCondition(categoryCode, productType, status, hospitalId, keyword, size, offset);
    }

    public List<Product> getByCategoryCode(String categoryCode) {
        return this.productMapper.selectByCategoryCode(categoryCode);
    }

    public List<Product> getByProductType(String productType) {
        return this.productMapper.selectByProductType(productType);
    }

    @Transactional
    public boolean update(Product product) {
        return this.productMapper.update(product) > 0;
    }

    @Transactional
    public boolean updateByProductCode(Product product) {
        return this.productMapper.updateByProductCode(product) > 0;
    }

    @Transactional
    public boolean updateStatus(Long id, Integer status) {
        return this.productMapper.updateStatus(id, status) > 0;
    }

    @Transactional
    public boolean updateStatusByProductCode(String productCode, Integer status) {
        return this.productMapper.updateStatusByProductCode(productCode, status) > 0;
    }

    @Transactional
    public boolean updateStock(Long id, Integer quantity) {
        return this.productMapper.updateStock(id, quantity) > 0;
    }

    @Transactional
    public boolean updateStockByProductCode(String productCode, Integer quantity) {
        return this.productMapper.updateStockByProductCode(productCode, quantity) > 0;
    }

    @Transactional
    public boolean decreaseStock(Long id, Integer quantity) {
        Product product = this.productMapper.selectById(id);
        if (product == null) {
            return false;
        }
        if (product.getStockQuantity() != -1 && product.getStockQuantity() < quantity) {
            return false;
        }
        return this.productMapper.decreaseStock(id, quantity) > 0;
    }

    @Transactional
    public boolean increaseStock(Long id, Integer quantity) {
        return this.productMapper.increaseStock(id, quantity) > 0;
    }

    public boolean checkStock(Long id, Integer quantity) {
        Product product = this.productMapper.selectById(id);
        if (product == null) {
            return false;
        }
        if (product.getStockQuantity() == -1) {
            return true;
        }
        return product.getStockQuantity() >= quantity;
    }

    @Transactional
    public boolean increaseSalesCount(Long id, Integer count) {
        return this.productMapper.increaseSalesCount(id, count) > 0;
    }

    @Transactional
    public boolean increaseViewCount(Long id) {
        return this.productMapper.increaseViewCount(id) > 0;
    }

    @Transactional
    public boolean deleteById(Long id) {
        return this.productMapper.deleteById(id) > 0;
    }

    @Transactional
    public boolean deleteByProductCode(String productCode) {
        return this.productMapper.deleteByProductCode(productCode) > 0;
    }

    public long countByCondition(String categoryCode, String productType, Integer status, String hospitalId, String keyword) {
        return this.productMapper.countByCondition(categoryCode, productType, status, hospitalId, keyword);
    }
}

