/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.model.ProductCategory;
import com.chdu.ai.model.ProductCategoryRequest;
import com.chdu.ai.service.ProductCategoryService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/product-category"})
@CrossOrigin(origins={"*"})
public class ProductCategoryController {
    private static final Logger logger = LoggerFactory.getLogger(ProductCategoryController.class);
    @Autowired
    private ProductCategoryService productCategoryService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping
    public BaseResponse<ProductCategory> create(@RequestBody ProductCategoryRequest request) {
        try {
            logger.info("\u521b\u5efa\u4ea7\u54c1\u5206\u7c7b: categoryName={}, categoryType={}", (Object)request.getCategoryName(), (Object)request.getCategoryType());
            if (request.getCategoryName() == null || request.getCategoryName().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getCategoryType() == null || request.getCategoryType().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u5206\u7c7b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ProductCategory category = new ProductCategory();
            category.setCategoryName(request.getCategoryName());
            if (request.getParentCategoryCode() != null && !request.getParentCategoryCode().isEmpty()) {
                ProductCategory parentCategory = this.productCategoryService.getByCategoryCode(request.getParentCategoryCode());
                if (parentCategory == null) return BaseResponse.error((String)"400", (String)("\u7236\u5206\u7c7b\u4e0d\u5b58\u5728: " + request.getParentCategoryCode()));
                category.setParentId(parentCategory.getId());
                logger.info("\u6839\u636eparentCategoryCode\u67e5\u627eparentId: parentCategoryCode={}, parentId={}", (Object)request.getParentCategoryCode(), (Object)parentCategory.getId());
            } else {
                category.setParentId(request.getParentId());
            }
            category.setCategoryType(request.getCategoryType());
            category.setSortOrder(request.getSortOrder());
            category.setDescription(request.getDescription());
            category.setIconUrl(request.getIconUrl());
            category.setStatus(request.getStatus());
            category.setHospitalId(request.getHospitalId());
            ProductCategory result = this.productCategoryService.create(category);
            logger.info("\u521b\u5efa\u4ea7\u54c1\u5206\u7c7b\u6210\u529f: id={}", (Object)result.getId());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u4ea7\u54c1\u5206\u7c7b\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u521b\u5efa\u4ea7\u54c1\u5206\u7c7b\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/detail"})
    public BaseResponse<ProductCategory> getByCategoryCode(@RequestParam String categoryCode) {
        try {
            logger.info("\u6839\u636e\u5206\u7c7b\u7f16\u7801\u67e5\u8be2\u4ea7\u54c1\u5206\u7c7b: categoryCode={}", (Object)categoryCode);
            ProductCategory result = this.productCategoryService.getByCategoryCode(categoryCode);
            if (result == null) {
                return BaseResponse.error((String)"404", (String)"\u5206\u7c7b\u4e0d\u5b58\u5728");
            }
            logger.info("\u67e5\u8be2\u4ea7\u54c1\u5206\u7c7b\u6210\u529f: categoryCode={}", (Object)categoryCode);
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4ea7\u54c1\u5206\u7c7b\u5931\u8d25: categoryCode={}", (Object)categoryCode, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u67e5\u8be2\u4ea7\u54c1\u5206\u7c7b\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping
    public BaseResponse<List<ProductCategory>> getAll(@RequestParam(required=false) Integer status) {
        try {
            logger.info("\u67e5\u8be2\u6240\u6709\u4ea7\u54c1\u5206\u7c7b: status={}", (Object)status);
            List result = this.productCategoryService.getAll(status);
            logger.info("\u67e5\u8be2\u4ea7\u54c1\u5206\u7c7b\u6210\u529f: \u6570\u91cf={}", (Object)result.size());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4ea7\u54c1\u5206\u7c7b\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u67e5\u8be2\u4ea7\u54c1\u5206\u7c7b\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/type/{type}"})
    public BaseResponse<List<ProductCategory>> getByCategoryType(@PathVariable String type) {
        try {
            logger.info("\u6839\u636e\u7c7b\u578b\u67e5\u8be2\u4ea7\u54c1\u5206\u7c7b: type={}", (Object)type);
            List result = this.productCategoryService.getByCategoryType(type);
            logger.info("\u67e5\u8be2\u4ea7\u54c1\u5206\u7c7b\u6210\u529f: type={}, \u6570\u91cf={}", (Object)type, (Object)result.size());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4ea7\u54c1\u5206\u7c7b\u5931\u8d25: type={}", (Object)type, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u67e5\u8be2\u4ea7\u54c1\u5206\u7c7b\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/parent/{parentId}"})
    public BaseResponse<List<ProductCategory>> getByParentId(@PathVariable Long parentId) {
        try {
            logger.info("\u6839\u636e\u7236\u5206\u7c7bID\u67e5\u8be2\u4ea7\u54c1\u5206\u7c7b: parentId={}", (Object)parentId);
            List result = this.productCategoryService.getByParentId(parentId);
            logger.info("\u67e5\u8be2\u4ea7\u54c1\u5206\u7c7b\u6210\u529f: parentId={}, \u6570\u91cf={}", (Object)parentId, (Object)result.size());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4ea7\u54c1\u5206\u7c7b\u5931\u8d25: parentId={}", (Object)parentId, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u67e5\u8be2\u4ea7\u54c1\u5206\u7c7b\u5931\u8d25: " + e.getMessage()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"/update"})
    public BaseResponse<ProductCategory> update(@RequestBody ProductCategoryRequest request) {
        try {
            logger.info("\u66f4\u65b0\u4ea7\u54c1\u5206\u7c7b: categoryCode={}", (Object)request.getCategoryCode());
            if (request.getCategoryCode() == null || request.getCategoryCode().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ProductCategory category = new ProductCategory();
            category.setCategoryCode(request.getCategoryCode());
            category.setCategoryName(request.getCategoryName());
            if (request.getParentCategoryCode() != null && !request.getParentCategoryCode().isEmpty()) {
                ProductCategory parentCategory = this.productCategoryService.getByCategoryCode(request.getParentCategoryCode());
                if (parentCategory == null) return BaseResponse.error((String)"400", (String)("\u7236\u5206\u7c7b\u4e0d\u5b58\u5728: " + request.getParentCategoryCode()));
                category.setParentId(parentCategory.getId());
                logger.info("\u6839\u636eparentCategoryCode\u67e5\u627eparentId: parentCategoryCode={}, parentId={}", (Object)request.getParentCategoryCode(), (Object)parentCategory.getId());
            } else {
                category.setParentId(request.getParentId());
            }
            category.setCategoryType(request.getCategoryType());
            category.setSortOrder(request.getSortOrder());
            category.setDescription(request.getDescription());
            category.setIconUrl(request.getIconUrl());
            category.setStatus(request.getStatus());
            category.setHospitalId(request.getHospitalId());
            category.setUpdateTime(new Date());
            boolean success = this.productCategoryService.updateByCategoryCode(category);
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u66f4\u65b0\u5931\u8d25\uff0c\u5206\u7c7b\u53ef\u80fd\u4e0d\u5b58\u5728");
            }
            ProductCategory result = this.productCategoryService.getByCategoryCode(request.getCategoryCode());
            logger.info("\u66f4\u65b0\u4ea7\u54c1\u5206\u7c7b\u6210\u529f: categoryCode={}", (Object)request.getCategoryCode());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u4ea7\u54c1\u5206\u7c7b\u5931\u8d25: categoryCode={}", (Object)request.getCategoryCode(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u66f4\u65b0\u4ea7\u54c1\u5206\u7c7b\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/update-status"})
    public BaseResponse<String> updateStatus(@RequestBody ProductCategoryRequest request) {
        try {
            logger.info("\u66f4\u65b0\u4ea7\u54c1\u5206\u7c7b\u72b6\u6001: categoryCode={}, status={}", (Object)request.getCategoryCode(), (Object)request.getStatus());
            if (request.getCategoryCode() == null || request.getCategoryCode().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getStatus() == null) {
                return BaseResponse.error((String)"400", (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            }
            boolean success = this.productCategoryService.updateStatusByCategoryCode(request.getCategoryCode(), request.getStatus());
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u66f4\u65b0\u5931\u8d25\uff0c\u5206\u7c7b\u53ef\u80fd\u4e0d\u5b58\u5728");
            }
            logger.info("\u66f4\u65b0\u4ea7\u54c1\u5206\u7c7b\u72b6\u6001\u6210\u529f: categoryCode={}, status={}", (Object)request.getCategoryCode(), (Object)request.getStatus());
            return BaseResponse.success((Object)"\u72b6\u6001\u66f4\u65b0\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u4ea7\u54c1\u5206\u7c7b\u72b6\u6001\u5931\u8d25: categoryCode={}, status={}", new Object[]{request.getCategoryCode(), request.getStatus(), e});
            return BaseResponse.error((String)"500", (String)("\u66f4\u65b0\u4ea7\u54c1\u5206\u7c7b\u72b6\u6001\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/delete"})
    public BaseResponse<String> delete(@RequestBody ProductCategoryRequest request) {
        try {
            logger.info("\u5220\u9664\u4ea7\u54c1\u5206\u7c7b: categoryCode={}", (Object)request.getCategoryCode());
            if (request.getCategoryCode() == null || request.getCategoryCode().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            boolean success = this.productCategoryService.deleteByCategoryCode(request.getCategoryCode());
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u5220\u9664\u5931\u8d25\uff0c\u5206\u7c7b\u53ef\u80fd\u4e0d\u5b58\u5728");
            }
            logger.info("\u5220\u9664\u4ea7\u54c1\u5206\u7c7b\u6210\u529f: categoryCode={}", (Object)request.getCategoryCode());
            return BaseResponse.success((Object)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u4ea7\u54c1\u5206\u7c7b\u5931\u8d25: categoryCode={}", (Object)request.getCategoryCode(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u5220\u9664\u4ea7\u54c1\u5206\u7c7b\u5931\u8d25: " + e.getMessage()));
        }
    }
}

