/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.chdu.ai.mapper.ServicePayBillMapper;
import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.model.PayCallbackVo;
import com.chdu.ai.model.PayParamVo;
import com.chdu.ai.model.ProductOrder;
import com.chdu.ai.model.RefundCallbackVo;
import com.chdu.ai.model.RefundVo;
import com.chdu.ai.model.ServiceMerchantConfig;
import com.chdu.ai.model.ServicePayBill;
import com.chdu.ai.service.PayService;
import com.chdu.ai.service.ProductOrderService;
import com.chdu.ai.service.ServiceMerchantConfigService;
import com.chdu.ai.util.SignUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PayServiceImpl
implements PayService {
    private static final Logger logger = LoggerFactory.getLogger(PayServiceImpl.class);
    private static final String SERVICE_CODE_SUFFIX = "ECOM";
    @Autowired
    private ServiceMerchantConfigService serviceMerchantConfigService;
    @Autowired
    private ProductOrderService productOrderService;
    @Autowired(required=false)
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired(required=false)
    private StringRedisTemplate redisTemplate;
    @Value(value="${pay.platform.url:}")
    private String payPlatformUrl;
    @Value(value="${pay.platform.refund.url:}")
    private String payRefundUrl;
    @Value(value="${pay.callback.domain:}")
    private String payCallbackDomain;

    public BaseResponse<JSONObject> pricePay(PayParamVo payParamVo) {
        try {
            boolean isSuccess;
            String payCallbackDomainStr;
            ProductOrder order;
            logger.info("\u521b\u5efa\u652f\u4ed8\u8ba2\u5355: orderNo={}, payChannel={}", (Object)payParamVo.getOrderNo(), (Object)payParamVo.getPayChannel());
            if (this.redisTemplate != null) {
                String cacheKey = "pay:order:" + payParamVo.getOrderNo();
                String cached = (String)this.redisTemplate.opsForValue().get((Object)cacheKey);
                if (cached != null) {
                    logger.info("\u652f\u4ed8\u7f13\u5b58\u4e0d\u4e3a\u7a7a\uff0c\u76f4\u63a5\u8fd4\u56de: orderNo={}", (Object)payParamVo.getOrderNo());
                    return BaseResponse.success((Object)JSONObject.parseObject((String)cached));
                }
            }
            if ((order = this.productOrderService.getByOrderNo(payParamVo.getOrderNo())) == null) {
                return BaseResponse.error((String)"404", (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            logger.info("\u8ba2\u5355\u4fe1\u606f: orderNo={}, status={}, hospitalId={}", new Object[]{order.getOrderNo(), order.getOrderStatus(), order.getHospitalId()});
            if (!"PENDING".equals(order.getOrderStatus())) {
                return BaseResponse.error((String)"400", (String)"\u8ba2\u5355\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u652f\u4ed8");
            }
            String appCode = payParamVo.getAppCode();
            if ((appCode == null || appCode.isEmpty()) && order.getHospitalId() != null) {
                try {
                    Integer organId = Integer.parseInt(order.getHospitalId());
                    ServiceMerchantConfig tempConfig = this.serviceMerchantConfigService.getByOrganId(organId);
                    if (tempConfig != null) {
                        appCode = tempConfig.getAppCode();
                    }
                }
                catch (NumberFormatException e) {
                    logger.warn("\u533b\u9662ID\u683c\u5f0f\u4e0d\u6b63\u786e: hospitalId={}", (Object)order.getHospitalId());
                }
            }
            if (appCode == null || appCode.isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u5e94\u7528\u4ee3\u7801(appCode)\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String bizSysSeq = SERVICE_CODE_SUFFIX;
            String organNameFirstChar = "";
            ServiceMerchantConfig config = this.serviceMerchantConfigService.getByConditions(appCode, order.getHospitalId(), bizSysSeq, payParamVo.getPayChannel());
            if (config == null && order.getHospitalId() != null) {
                try {
                    Integer organId = Integer.parseInt(order.getHospitalId());
                    config = this.serviceMerchantConfigService.getByOrganId(organId);
                }
                catch (NumberFormatException e) {
                    logger.warn("\u533b\u9662ID\u683c\u5f0f\u4e0d\u6b63\u786e: hospitalId={}", (Object)order.getHospitalId());
                }
            }
            if (config == null) {
                logger.error("\u672a\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u652f\u4ed8\u5e94\u7528code: appCode={}, hospitalId={}, bizSysSeq={}, applyName={}", new Object[]{appCode, order.getHospitalId(), bizSysSeq, payParamVo.getPayChannel()});
                return BaseResponse.error((String)"400", (String)"\u8be5\u533b\u9662\u7684\u5546\u6237\u53f7\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u5546\u6237\u53f7");
            }
            logger.info("\u652f\u4ed8\u914d\u7f6e\u67e5\u8be2\u6210\u529f: appCode={}, merchantSeq={}, organName={}", new Object[]{config.getAppCode(), config.getMerchantSeq(), config.getOrganName()});
            if (config.getOrganName() != null && !config.getOrganName().isEmpty()) {
                organNameFirstChar = config.getOrganName();
            }
            String serviceCode = appCode + "_" + organNameFirstChar + "_" + bizSysSeq;
            logger.info("\u6784\u5efa\u7684serviceCode: {}", (Object)serviceCode);
            JSONObject payRequest = new JSONObject();
            payRequest.put("payChannel", (Object)payParamVo.getPayChannel());
            payRequest.put("payType", (Object)payParamVo.getPayType());
            if ("JSAPI".equals(payParamVo.getPayType()) && payParamVo.getOpenId() != null) {
                payRequest.put("userSign", (Object)payParamVo.getOpenId());
            }
            payRequest.put("mchCode", (Object)config.getMerchantSeq());
            payRequest.put("serviceCode", (Object)serviceCode);
            payRequest.put("outTradeNo", (Object)order.getOrderNo());
            payRequest.put("totalAmount", (Object)order.getPayAmount());
            payRequest.put("actuallyAmount", (Object)order.getPayAmount());
            payRequest.put("productInfo", (Object)"\u533b\u9662\u7535\u5546\u8ba2\u5355");
            payRequest.put("nonceStr", (Object)SignUtil.getNonceStr());
            String string = payCallbackDomainStr = this.payCallbackDomain != null && !this.payCallbackDomain.isEmpty() ? this.payCallbackDomain : "";
            if (!payCallbackDomainStr.isEmpty() && !payCallbackDomainStr.endsWith("/")) {
                payCallbackDomainStr = payCallbackDomainStr + "/";
            }
            String payCallback = payCallbackDomainStr + config.getAppCode() + "/ai/api/pay/callback/payNotify";
            payRequest.put("payNotifyUrl", (Object)payCallback);
            payRequest.put("applyCode", (Object)config.getMerchantSeq());
            HashMap<String, String> signMap = new HashMap<String, String>();
            for (String key : payRequest.keySet()) {
                Object value = payRequest.get((Object)key);
                if (value == null) continue;
                signMap.put(key, value.toString());
            }
            logger.info("\u7b7e\u540d\u524d\u7684\u53c2\u6570map: {}", (Object)JSON.toJSONString(signMap));
            String sign = SignUtil.createSign(signMap, (String)config.getApplyKey(), (String[])new String[0]);
            payRequest.put("sign", (Object)sign);
            logger.info("\u652f\u4ed8\u8bf7\u6c42\u53c2\u6570: {}", (Object)payRequest.toJSONString());
            if (this.payPlatformUrl == null || this.payPlatformUrl.isEmpty()) {
                logger.error("\u652f\u4ed8\u5e73\u53f0URL\u672a\u914d\u7f6e");
                return BaseResponse.error((String)"500", (String)"\u652f\u4ed8\u5e73\u53f0URL\u672a\u914d\u7f6e");
            }
            String respStr = this.doHttpPost(this.payPlatformUrl, payRequest.toJSONString());
            logger.info("\u652f\u4ed8\u63a5\u53e3\u54cd\u5e94: {}", (Object)respStr);
            if (respStr == null || respStr.isEmpty()) {
                return BaseResponse.error((String)"500", (String)"\u652f\u4ed8\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
            }
            JSONObject responseJson = JSON.parseObject((String)respStr);
            String code = responseJson.getString("code");
            String errCode = responseJson.getString("errCode");
            boolean bl = isSuccess = "1".equals(code) || "200".equals(code) || "SUCCESS".equals(code) || "0".equals(errCode);
            if (isSuccess) {
                JSONObject payResponse;
                Object dataObj = responseJson.get((Object)"data");
                if (dataObj == null) {
                    payResponse = responseJson;
                } else if (dataObj instanceof String) {
                    try {
                        payResponse = JSON.parseObject((String)((String)dataObj));
                    }
                    catch (Exception e) {
                        logger.warn("\u89e3\u6790 data \u5b57\u6bb5\u5931\u8d25\uff0c\u4f7f\u7528\u6574\u4e2a\u54cd\u5e94: {}", (Object)e.getMessage());
                        payResponse = responseJson;
                    }
                } else {
                    payResponse = dataObj instanceof JSONObject ? (JSONObject)dataObj : responseJson;
                }
                if (this.redisTemplate != null) {
                    String cacheKey = "pay:order:" + payParamVo.getOrderNo();
                    this.redisTemplate.opsForValue().set((Object)cacheKey, (Object)payResponse.toJSONString(), 2L, TimeUnit.HOURS);
                }
                logger.info("\u521b\u5efa\u652f\u4ed8\u8ba2\u5355\u6210\u529f: orderNo={}", (Object)payParamVo.getOrderNo());
                return BaseResponse.success((Object)payResponse);
            }
            String msg = responseJson.getString("msg");
            logger.error("\u652f\u4ed8\u63a5\u53e3\u8fd4\u56de\u5931\u8d25: code={}, errCode={}, msg={}", new Object[]{code, errCode, msg});
            return BaseResponse.error((String)(code != null ? code : "500"), (String)(msg != null ? msg : "\u652f\u4ed8\u63a5\u53e3\u8c03\u7528\u5931\u8d25"));
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u652f\u4ed8\u8ba2\u5355\u5931\u8d25: orderNo={}", (Object)payParamVo.getOrderNo(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u521b\u5efa\u652f\u4ed8\u8ba2\u5355\u5931\u8d25: " + e.getMessage()));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean payCallback(PayCallbackVo payCallbackVo) {
        try {
            logger.info("\u652f\u4ed8\u56de\u8c03: outTradeNo={}, totalAmount={}", (Object)payCallbackVo.getOutTradeNo(), (Object)payCallbackVo.getTotalAmount());
            String orderNo = payCallbackVo.getOutTradeNo();
            ProductOrder order = this.productOrderService.getByOrderNo(orderNo);
            if (order == null) {
                logger.error("\u8ba2\u5355\u4e0d\u5b58\u5728: orderNo={}", (Object)orderNo);
                return false;
            }
            if ("PAID".equals(order.getOrderStatus())) {
                logger.info("\u8ba2\u5355\u5df2\u652f\u4ed8\uff0c\u56de\u8c03\u91cd\u590d: orderNo={}", (Object)orderNo);
                return true;
            }
            ServiceMerchantConfig config = null;
            if (order.getHospitalId() != null) {
                try {
                    Integer organId = Integer.parseInt(order.getHospitalId());
                    config = this.serviceMerchantConfigService.getByOrganId(organId);
                }
                catch (NumberFormatException e) {
                    logger.warn("\u533b\u9662ID\u683c\u5f0f\u4e0d\u6b63\u786e: hospitalId={}", (Object)order.getHospitalId());
                }
            }
            if (config == null && payCallbackVo.getApplyId() != null && !payCallbackVo.getApplyId().isEmpty()) {
                logger.warn("\u901a\u8fc7 applyId \u67e5\u8be2\u914d\u7f6e\u672a\u5b9e\u73b0\uff0c\u4f7f\u7528\u533b\u9662ID\u67e5\u8be2: applyId={}", (Object)payCallbackVo.getApplyId());
            }
            if (config == null) {
                logger.error("\u672a\u627e\u5230\u652f\u4ed8\u914d\u7f6e: orderNo={}", (Object)orderNo);
                return false;
            }
            Map signMap = SignUtil.getKeyAndValue((Object)payCallbackVo);
            Boolean signValid = SignUtil.checkSign((Map)signMap, (String)config.getApplyKey());
            if (!signValid.booleanValue()) {
                logger.error("\u9a8c\u7b7e\u5931\u8d25: orderNo={}", (Object)orderNo);
                return false;
            }
            logger.info("\u9a8c\u7b7e\u6210\u529f: orderNo={}", (Object)orderNo);
            boolean success = this.productOrderService.payOrder(order.getId(), payCallbackVo.getPayChannel());
            if (!success) {
                logger.error("\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5931\u8d25: orderNo={}", (Object)orderNo);
                return false;
            }
            if (this.servicePayBillMapper != null) {
                ServicePayBill payBill = new ServicePayBill();
                payBill.setStatus(Integer.valueOf(3));
                payBill.setAppCode(config.getAppCode());
                payBill.setOrganName(config.getOrganName());
                payBill.setWorkServiceCode(SERVICE_CODE_SUFFIX);
                payBill.setApplyCode(config.getMerchantSeq());
                payBill.setPayChannel(payCallbackVo.getPayChannel());
                payBill.setTradeTime(payCallbackVo.getPayTime());
                payBill.setTradeNo(payCallbackVo.getTradeNo());
                payBill.setOutTradeNo(orderNo);
                payBill.setTradeStatus("SUCCESS");
                payBill.setOrderAmount(payCallbackVo.getTotalAmount());
                payBill.setDealAmount(payCallbackVo.getTotalAmount());
                payBill.setServiceCode(config.getAppCode() + "_" + SERVICE_CODE_SUFFIX);
                payBill.setDealTradeNo(payCallbackVo.getDealTradeNo());
                payBill.setCreateTime(new Date());
                payBill.setUpdateTime(new Date());
                this.servicePayBillMapper.insert(payBill);
                logger.info("\u4fdd\u5b58\u652f\u4ed8\u8d26\u5355\u6210\u529f: orderNo={}, billId={}", (Object)orderNo, (Object)payBill.getId());
            } else {
                logger.warn("ServicePayBillMapper\u672a\u6ce8\u5165\uff0c\u8df3\u8fc7\u4fdd\u5b58\u652f\u4ed8\u8d26\u5355: orderNo={}", (Object)orderNo);
            }
            if (this.redisTemplate != null) {
                String cacheKey = "pay:order:" + orderNo;
                this.redisTemplate.delete((Object)cacheKey);
            }
            logger.info("\u652f\u4ed8\u56de\u8c03\u5904\u7406\u6210\u529f: orderNo={}", (Object)orderNo);
            return true;
        }
        catch (Exception e) {
            logger.error("\u652f\u4ed8\u56de\u8c03\u5904\u7406\u5931\u8d25: outTradeNo={}", (Object)payCallbackVo.getOutTradeNo(), (Object)e);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public Boolean refund(RefundVo refundVo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean refundCallback(RefundCallbackVo refundCallbackVo) {
        try {
            logger.info("\u9000\u6b3e\u56de\u8c03: outTradeNo={}, refundMoney={}", (Object)refundCallbackVo.getOutTradeNo(), (Object)refundCallbackVo.getRefundMoney());
            String orderNo = refundCallbackVo.getOutTradeNo();
            ProductOrder order = this.productOrderService.getByOrderNo(orderNo);
            if (order == null) {
                logger.error("\u8ba2\u5355\u4e0d\u5b58\u5728: orderNo={}", (Object)orderNo);
                return false;
            }
            ServiceMerchantConfig config = null;
            if (order.getHospitalId() != null) {
                try {
                    Integer organId = Integer.parseInt(order.getHospitalId());
                    config = this.serviceMerchantConfigService.getByOrganId(organId);
                }
                catch (NumberFormatException e) {
                    logger.warn("\u533b\u9662ID\u683c\u5f0f\u4e0d\u6b63\u786e: hospitalId={}", (Object)order.getHospitalId());
                }
            }
            if (config == null) {
                logger.error("\u672a\u627e\u5230\u652f\u4ed8\u914d\u7f6e: orderNo={}", (Object)orderNo);
                return false;
            }
            Map signMap = SignUtil.getKeyAndValue((Object)refundCallbackVo);
            String receivedSign = refundCallbackVo.getSign();
            logger.info("\u9000\u6b3e\u56de\u8c03\u9a8c\u7b7e: orderNo={}, receivedSign={}, signMap={}", new Object[]{orderNo, receivedSign, JSON.toJSONString((Object)signMap)});
            Boolean signValid = SignUtil.checkSign((Map)signMap, (String)config.getApplyKey());
            if (!signValid.booleanValue()) {
                String calculatedSign = SignUtil.createSign((Map)signMap, (String)config.getApplyKey(), (String[])new String[0]);
                logger.error("\u9a8c\u7b7e\u5931\u8d25: orderNo={}, receivedSign={}, calculatedSign={}", new Object[]{orderNo, receivedSign, calculatedSign});
                return false;
            }
            logger.info("\u9000\u6b3e\u56de\u8c03\u9a8c\u7b7e\u6210\u529f: orderNo={}", (Object)orderNo);
            if (!"SUCCESS".equals(refundCallbackVo.getReturnCode())) {
                logger.error("\u9000\u6b3e\u5931\u8d25: orderNo={}, returnCode={}", (Object)orderNo, (Object)refundCallbackVo.getReturnCode());
                return false;
            }
            boolean refundSuccess = this.productOrderService.refundOrder(order.getId());
            if (!refundSuccess) {
                logger.error("\u8ba2\u5355\u9000\u6b3e\u5931\u8d25: orderNo={}", (Object)orderNo);
                return false;
            }
            if (this.servicePayBillMapper != null) {
                ServicePayBill originalBill = this.servicePayBillMapper.selectPaySuccessByOutTradeNo(orderNo);
                ServicePayBill refundBill = new ServicePayBill();
                refundBill.setStatus(Integer.valueOf(6));
                refundBill.setAppCode(config.getAppCode());
                refundBill.setOrganName(config.getOrganName());
                refundBill.setWorkServiceCode(SERVICE_CODE_SUFFIX);
                refundBill.setApplyCode(config.getMerchantSeq());
                refundBill.setPayChannel(refundCallbackVo.getPayChannel());
                if (originalBill != null) {
                    refundBill.setTradeTime(originalBill.getTradeTime());
                    refundBill.setTradeNo(originalBill.getTradeNo());
                }
                refundBill.setOutTradeNo(orderNo);
                refundBill.setTradeStatus("SUCCESS");
                refundBill.setOrderAmount(refundCallbackVo.getTotalAmount());
                refundBill.setDealAmount(refundCallbackVo.getTotalAmount());
                refundBill.setRefundNo(refundCallbackVo.getRefundNo());
                refundBill.setOutRefundNo(refundCallbackVo.getOutRefundNo());
                refundBill.setRefundTime(refundCallbackVo.getRefundTime());
                refundBill.setRefundAmount(refundCallbackVo.getRefundMoney());
                refundBill.setServiceCode(config.getAppCode() + "_" + SERVICE_CODE_SUFFIX);
                refundBill.setDealTradeNo(refundCallbackVo.getDealTradeNo());
                refundBill.setCreateTime(new Date());
                refundBill.setUpdateTime(new Date());
                this.servicePayBillMapper.insert(refundBill);
                logger.info("\u4fdd\u5b58\u9000\u6b3e\u8d26\u5355\u6210\u529f: orderNo={}, billId={}", (Object)orderNo, (Object)refundBill.getId());
            } else {
                logger.warn("ServicePayBillMapper\u672a\u6ce8\u5165\uff0c\u8df3\u8fc7\u4fdd\u5b58\u9000\u6b3e\u8d26\u5355: orderNo={}", (Object)orderNo);
            }
            logger.info("\u9000\u6b3e\u56de\u8c03\u5904\u7406\u6210\u529f: orderNo={}", (Object)orderNo);
            return true;
        }
        catch (Exception e) {
            logger.error("\u9000\u6b3e\u56de\u8c03\u5904\u7406\u5931\u8d25: outTradeNo={}", (Object)refundCallbackVo.getOutTradeNo(), (Object)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doHttpPost(String url, String jsonBody) {
        String errorResponse;
        Object object;
        int responseCode;
        Throwable throwable;
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Accept", "application/json");
            connection.setDoOutput(true);
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(30000);
            throwable = null;
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = jsonBody.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
                os.flush();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            logger.debug("HTTP\u8bf7\u6c42\u5df2\u53d1\u9001: url={}, body={}", (Object)url, (Object)jsonBody);
            responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
                object = null;
                try {
                    String line;
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    String string = response.toString();
                    return string;
                }
                catch (Throwable throwable3) {
                    object = throwable3;
                    throw throwable3;
                }
                finally {
                    if (reader != null) {
                        if (object != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable4) {
                                ((Throwable)object).addSuppressed(throwable4);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            errorResponse = this.readErrorResponse(connection);
        }
        catch (Exception e) {
            logger.error("HTTP\u8bf7\u6c42\u5f02\u5e38: url={}, body={}", new Object[]{url, jsonBody, e});
            throwable = null;
            return throwable;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        logger.error("HTTP\u8bf7\u6c42\u5931\u8d25: code={}, url={}, response={}", new Object[]{responseCode, url, errorResponse});
        object = errorResponse;
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readErrorResponse(HttpURLConnection connection) {
        try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder errorBuilder = new StringBuilder();
            while ((line = errorReader.readLine()) != null) {
                errorBuilder.append(line);
            }
            String string = errorBuilder.toString();
            return string;
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u9519\u8bef\u54cd\u5e94\u5931\u8d25", (Throwable)e);
            return "\u65e0\u6cd5\u8bfb\u53d6\u9519\u8bef\u8be6\u60c5";
        }
    }
}

