/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.canal;

import com.alibaba.otter.canal.protocol.CanalEntry;
import com.chdu.ai.canal.CanalEventListener;
import com.chdu.ai.model.PatientOrderTodo;
import com.chdu.ai.service.PatientOrderTodoService;
import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CanalEventListener {
    private static final Logger log = LoggerFactory.getLogger(CanalEventListener.class);
    @Autowired
    private PatientOrderTodoService patientOrderTodoService;

    public void onEvent(CanalEntry.Entry entry) {
        try {
            String database = entry.getHeader().getSchemaName();
            String table = entry.getHeader().getTableName();
            CanalEntry.EventType eventType = entry.getHeader().getEventType();
            log.info("\u6536\u5230Canal\u4e8b\u4ef6 - \u6570\u636e\u5e93: [{}], \u8868: [{}], \u4e8b\u4ef6\u7c7b\u578b: {}", new Object[]{database, table, eventType});
            if ("followup_plan_provide_detail".equalsIgnoreCase(table) || table != null && table.toLowerCase().contains("followup_plan_provide_detail")) {
                log.info("\u26a0\ufe0f \u68c0\u6d4b\u5230followup_plan_provide_detail\u76f8\u5173\u8868\u4e8b\u4ef6 - \u6570\u636e\u5e93: [{}], \u8868: [{}], \u4e8b\u4ef6\u7c7b\u578b: {}", new Object[]{database, table, eventType});
            }
            if (entry.getEntryType() == CanalEntry.EntryType.ROWDATA) {
                CanalEntry.RowChange rowChange = CanalEntry.RowChange.parseFrom((ByteString)entry.getStoreValue());
                block7: for (CanalEntry.RowData rowData : rowChange.getRowDatasList()) {
                    switch (1.$SwitchMap$com$alibaba$otter$canal$protocol$CanalEntry$EventType[eventType.ordinal()]) {
                        case 1: {
                            this.handleInsert(database, table, rowData);
                            continue block7;
                        }
                        case 2: {
                            this.handleUpdate(database, table, rowData);
                            continue block7;
                        }
                        case 3: {
                            this.handleDelete(database, table, rowData);
                            continue block7;
                        }
                    }
                    log.debug("\u5ffd\u7565\u4e8b\u4ef6\u7c7b\u578b: {}", (Object)eventType);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406Canal\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    private void handleInsert(String database, String table, CanalEntry.RowData rowData) {
        log.info("\u5904\u7406INSERT\u4e8b\u4ef6 - \u6570\u636e\u5e93: {}, \u8868: {}", (Object)database, (Object)table);
        List columns = rowData.getAfterColumnsList();
        this.logColumnData("INSERT", database, table, columns);
        if ("byh-health-management".equals(database) && "offline_service_appointment".equals(table)) {
            this.handleOfflineServiceAppointmentChange(columns);
        }
        if ("byh-health-management".equals(database) && "followup_plan_provide".equals(table)) {
            log.info("\u2705 \u5339\u914d\u5230followup_plan_provide\u8868INSERT\u4e8b\u4ef6\uff0c\u5f00\u59cb\u5904\u7406");
            this.handleFollowupPlanProvideChange(columns);
        }
        if ("byh-health-management".equals(database) && "followup_plan_provide_detail".equals(table)) {
            log.info("\u2705 \u5339\u914d\u5230followup_plan_provide_detail\u8868INSERT\u4e8b\u4ef6\uff0c\u5f00\u59cb\u5904\u7406");
            this.handleFollowupPlanProvideDetailChange(columns);
        } else if ("byh-health-management".equals(database) && table != null && table.contains("followup_plan_provide_detail")) {
            log.warn("\u26a0\ufe0f \u6570\u636e\u5e93\u540d\u5339\u914d\u4f46\u8868\u540d\u4e0d\u5b8c\u5168\u5339\u914d - \u6570\u636e\u5e93: [{}], \u8868: [{}], \u671f\u671b: followup_plan_provide_detail", (Object)database, (Object)table);
        }
        if ("nursing-care".equals(database) && "orders".equals(table)) {
            log.info("\u2705 \u5339\u914d\u5230nursing-care.orders\u8868INSERT\u4e8b\u4ef6\uff0c\u5f00\u59cb\u5904\u7406");
            this.handleNursingCareOrdersChange(columns);
        }
        if ("byh-online-outpatient".equals(database) && "inquiry_admission".equals(table)) {
            log.info("\u2705 \u5339\u914d\u5230inquiry_admission\u8868INSERT\u4e8b\u4ef6\uff0c\u5f00\u59cb\u5904\u7406");
            this.handleInquiryAdmissionChange(columns);
        }
        if ("byh_medicalcloud_service".equals(database) && "mos_drug_main".equals(table)) {
            log.info("\u2705 \u5339\u914d\u5230mos_drug_main\u8868INSERT\u4e8b\u4ef6\uff0c\u5f00\u59cb\u5904\u7406");
            this.handleMosDrugMainChange(columns);
        }
        if ("yh-wisdom-medical".equals(database) && "medical_appointment_info".equals(table)) {
            log.info("\u2705 \u5339\u914d\u5230medical_appointment_info\u8868INSERT\u4e8b\u4ef6\uff0c\u5f00\u59cb\u5904\u7406");
            this.handleMedicalAppointmentInfoChange(columns);
        }
    }

    private void handleUpdate(String database, String table, CanalEntry.RowData rowData) {
        log.info("\u5904\u7406UPDATE\u4e8b\u4ef6 - \u6570\u636e\u5e93: {}, \u8868: {}", (Object)database, (Object)table);
        List beforeColumns = rowData.getBeforeColumnsList();
        List afterColumns = rowData.getAfterColumnsList();
        this.logColumnData("UPDATE-BEFORE", database, table, beforeColumns);
        this.logColumnData("UPDATE-AFTER", database, table, afterColumns);
        if ("byh-health-management".equals(database) && "offline_service_appointment".equals(table)) {
            this.handleOfflineServiceAppointmentChange(afterColumns);
        }
        if ("byh-health-management".equals(database) && "followup_plan_provide".equals(table)) {
            log.info("\u2705 \u5339\u914d\u5230followup_plan_provide\u8868UPDATE\u4e8b\u4ef6\uff0c\u5f00\u59cb\u5904\u7406");
            this.handleFollowupPlanProvideChange(afterColumns);
        }
        if ("byh-health-management".equals(database) && "followup_plan_provide_detail".equals(table)) {
            log.info("\u2705 \u5339\u914d\u5230followup_plan_provide_detail\u8868UPDATE\u4e8b\u4ef6\uff0c\u5f00\u59cb\u5904\u7406");
            this.handleFollowupPlanProvideDetailChange(afterColumns);
        } else if ("byh-health-management".equals(database) && table != null && table.contains("followup_plan_provide_detail")) {
            log.warn("\u26a0\ufe0f \u6570\u636e\u5e93\u540d\u5339\u914d\u4f46\u8868\u540d\u4e0d\u5b8c\u5168\u5339\u914d - \u6570\u636e\u5e93: [{}], \u8868: [{}], \u671f\u671b: followup_plan_provide_detail", (Object)database, (Object)table);
        }
        if ("nursing-care".equals(database) && "orders".equals(table)) {
            log.info("\u2705 \u5339\u914d\u5230nursing-care.orders\u8868UPDATE\u4e8b\u4ef6\uff0c\u5f00\u59cb\u5904\u7406");
            this.handleNursingCareOrdersChange(afterColumns);
        }
        if ("byh-online-outpatient".equals(database) && "inquiry_admission".equals(table)) {
            log.info("\u2705 \u5339\u914d\u5230inquiry_admission\u8868UPDATE\u4e8b\u4ef6\uff0c\u5f00\u59cb\u5904\u7406");
            this.handleInquiryAdmissionChange(afterColumns);
        }
        if ("byh_medicalcloud_service".equals(database) && "mos_drug_main".equals(table)) {
            log.info("\u2705 \u5339\u914d\u5230mos_drug_main\u8868UPDATE\u4e8b\u4ef6\uff0c\u5f00\u59cb\u5904\u7406");
            this.handleMosDrugMainChange(afterColumns);
        }
        if ("yh-wisdom-medical".equals(database) && "medical_appointment_info".equals(table)) {
            log.info("\u2705 \u5339\u914d\u5230medical_appointment_info\u8868UPDATE\u4e8b\u4ef6\uff0c\u5f00\u59cb\u5904\u7406");
            this.handleMedicalAppointmentInfoChange(afterColumns);
        }
    }

    private void handleDelete(String database, String table, CanalEntry.RowData rowData) {
        log.info("\u5904\u7406DELETE\u4e8b\u4ef6 - \u6570\u636e\u5e93: {}, \u8868: {}", (Object)database, (Object)table);
        List columns = rowData.getBeforeColumnsList();
        this.logColumnData("DELETE", database, table, columns);
    }

    private void handleOfflineServiceAppointmentChange(List<CanalEntry.Column> columns) {
        try {
            Integer appointmentStatus;
            HashMap<String, String> columnMap = new HashMap<String, String>();
            for (CanalEntry.Column column : columns) {
                columnMap.put(column.getName(), column.getValue());
            }
            String appointmentNo = (String)columnMap.get("appointment_no");
            String patientId = (String)columnMap.get("patient_id");
            String appointmentStatusStr = (String)columnMap.get("appointment_status");
            if (appointmentNo == null || appointmentNo.isEmpty()) {
                log.warn("offline_service_appointment\u8868\u53d8\u66f4\uff0c\u4f46appointment_no\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5904\u7406");
                return;
            }
            if (patientId == null || patientId.isEmpty()) {
                log.warn("offline_service_appointment\u8868\u53d8\u66f4\uff0c\u4f46patient_id\u4e3a\u7a7a\uff0cappointmentNo={}", (Object)appointmentNo);
                return;
            }
            if (appointmentStatusStr == null || appointmentStatusStr.isEmpty()) {
                log.warn("offline_service_appointment\u8868\u53d8\u66f4\uff0c\u4f46appointment_status\u4e3a\u7a7a\uff0cappointmentNo={}", (Object)appointmentNo);
                return;
            }
            try {
                appointmentStatus = Integer.parseInt(appointmentStatusStr);
            }
            catch (NumberFormatException e) {
                log.error("\u89e3\u6790appointment_status\u5931\u8d25\uff0cappointmentNo={}, appointmentStatusStr={}", new Object[]{appointmentNo, appointmentStatusStr, e});
                return;
            }
            Integer todoStatus = appointmentStatus == 2 || appointmentStatus == 4 ? Integer.valueOf(0) : Integer.valueOf(1);
            log.info("\u5904\u7406offline_service_appointment\u53d8\u66f4: appointmentNo={}, patientId={}, appointmentStatus={}, todoStatus={}", new Object[]{appointmentNo, patientId, appointmentStatus, todoStatus});
            PatientOrderTodo existingTodo = this.patientOrderTodoService.getByOrderTypeAndSourceId("offline_service_appointment", appointmentNo);
            if (existingTodo != null) {
                existingTodo.setStatus(todoStatus);
                boolean updated = this.patientOrderTodoService.update(existingTodo);
                if (updated) {
                    log.info("\u66f4\u65b0patient_order_todo\u6210\u529f: id={}, appointmentNo={}, status={}", new Object[]{existingTodo.getId(), appointmentNo, todoStatus});
                } else {
                    log.error("\u66f4\u65b0patient_order_todo\u5931\u8d25: appointmentNo={}", (Object)appointmentNo);
                }
            } else {
                PatientOrderTodo newTodo = new PatientOrderTodo();
                newTodo.setOrderType("offline_service_appointment");
                newTodo.setSourceId(appointmentNo);
                newTodo.setPatientId(patientId);
                newTodo.setStatus(todoStatus);
                PatientOrderTodo created = this.patientOrderTodoService.create(newTodo);
                if (created != null && created.getId() != null) {
                    log.info("\u521b\u5efapatient_order_todo\u6210\u529f: id={}, appointmentNo={}, status={}", new Object[]{created.getId(), appointmentNo, todoStatus});
                } else {
                    log.error("\u521b\u5efapatient_order_todo\u5931\u8d25: appointmentNo={}", (Object)appointmentNo);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406offline_service_appointment\u53d8\u66f4\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    private void handleFollowupPlanProvideChange(List<CanalEntry.Column> columns) {
        try {
            Integer followupStatus;
            HashMap<String, String> columnMap = new HashMap<String, String>();
            for (CanalEntry.Column column : columns) {
                columnMap.put(column.getName(), column.getValue());
            }
            String sourceId = (String)columnMap.get("id");
            String patientId = (String)columnMap.get("patient_id");
            String followupStatusStr = (String)columnMap.get("followup_status");
            if (sourceId == null || sourceId.isEmpty()) {
                log.warn("followup_plan_provide\u8868\u53d8\u66f4\uff0c\u4f46id\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5904\u7406");
                return;
            }
            if (patientId == null || patientId.isEmpty()) {
                log.warn("followup_plan_provide\u8868\u53d8\u66f4\uff0c\u4f46patient_id\u4e3a\u7a7a\uff0csourceId={}", (Object)sourceId);
                return;
            }
            if (followupStatusStr == null || followupStatusStr.isEmpty()) {
                log.warn("followup_plan_provide\u8868\u53d8\u66f4\uff0c\u4f46followup_status\u4e3a\u7a7a\uff0csourceId={}", (Object)sourceId);
                return;
            }
            try {
                followupStatus = Integer.parseInt(followupStatusStr);
            }
            catch (NumberFormatException e) {
                log.error("\u89e3\u6790followup_status\u5931\u8d25\uff0csourceId={}, followupStatusStr={}", new Object[]{sourceId, followupStatusStr, e});
                return;
            }
            Integer todoStatus = followupStatus == 2 ? Integer.valueOf(0) : Integer.valueOf(1);
            log.info("\u5904\u7406followup_plan_provide\u53d8\u66f4: sourceId={}, patientId={}, followupStatus={}, todoStatus={}", new Object[]{sourceId, patientId, followupStatus, todoStatus});
            PatientOrderTodo existingTodo = this.patientOrderTodoService.getByOrderTypeAndSourceId("followup_plan_provide", sourceId);
            if (existingTodo != null) {
                existingTodo.setStatus(todoStatus);
                boolean updated = this.patientOrderTodoService.update(existingTodo);
                if (updated) {
                    log.info("\u66f4\u65b0patient_order_todo\u6210\u529f: id={}, sourceId={}, status={}", new Object[]{existingTodo.getId(), sourceId, todoStatus});
                } else {
                    log.error("\u66f4\u65b0patient_order_todo\u5931\u8d25: sourceId={}", (Object)sourceId);
                }
            } else {
                PatientOrderTodo newTodo = new PatientOrderTodo();
                newTodo.setOrderType("followup_plan_provide");
                newTodo.setSourceId(sourceId);
                newTodo.setPatientId(patientId);
                newTodo.setStatus(todoStatus);
                PatientOrderTodo created = this.patientOrderTodoService.create(newTodo);
                if (created != null && created.getId() != null) {
                    log.info("\u521b\u5efapatient_order_todo\u6210\u529f: id={}, sourceId={}, status={}", new Object[]{created.getId(), sourceId, todoStatus});
                } else {
                    log.error("\u521b\u5efapatient_order_todo\u5931\u8d25: sourceId={}", (Object)sourceId);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406followup_plan_provide\u53d8\u66f4\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    private void handleNursingCareOrdersChange(List<CanalEntry.Column> columns) {
        try {
            Integer status;
            HashMap<String, String> columnMap = new HashMap<String, String>();
            for (CanalEntry.Column column : columns) {
                columnMap.put(column.getName(), column.getValue());
            }
            String sourceId = (String)columnMap.get("view_id");
            String patientId = (String)columnMap.get("patient_id");
            String statusStr = (String)columnMap.get("status");
            if (sourceId == null || sourceId.isEmpty()) {
                log.warn("nursing-care.orders\u8868\u53d8\u66f4\uff0c\u4f46id\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5904\u7406");
                return;
            }
            if (patientId == null || patientId.isEmpty()) {
                log.warn("nursing-care.orders\u8868\u53d8\u66f4\uff0c\u4f46patient_id\u4e3a\u7a7a\uff0csourceId={}", (Object)sourceId);
                return;
            }
            if (statusStr == null || statusStr.isEmpty()) {
                log.warn("nursing-care.orders\u8868\u53d8\u66f4\uff0c\u4f46status\u4e3a\u7a7a\uff0csourceId={}", (Object)sourceId);
                return;
            }
            try {
                status = Integer.parseInt(statusStr);
            }
            catch (NumberFormatException e) {
                log.error("\u89e3\u6790status\u5931\u8d25\uff0csourceId={}, statusStr={}", new Object[]{sourceId, statusStr, e});
                return;
            }
            Integer todoStatus = status == 5 ? Integer.valueOf(0) : Integer.valueOf(1);
            log.info("\u5904\u7406nursing-care.orders\u53d8\u66f4: sourceId={}, patientId={}, status={}, todoStatus={}", new Object[]{sourceId, patientId, status, todoStatus});
            PatientOrderTodo existingTodo = this.patientOrderTodoService.getByOrderTypeAndSourceId("nursing", sourceId);
            if (existingTodo != null) {
                existingTodo.setStatus(todoStatus);
                boolean updated = this.patientOrderTodoService.update(existingTodo);
                if (updated) {
                    log.info("\u66f4\u65b0patient_order_todo\u6210\u529f: id={}, sourceId={}, status={}", new Object[]{existingTodo.getId(), sourceId, todoStatus});
                } else {
                    log.error("\u66f4\u65b0patient_order_todo\u5931\u8d25: sourceId={}", (Object)sourceId);
                }
            } else {
                PatientOrderTodo newTodo = new PatientOrderTodo();
                newTodo.setOrderType("nursing");
                newTodo.setSourceId(sourceId);
                newTodo.setPatientId(patientId);
                newTodo.setStatus(todoStatus);
                PatientOrderTodo created = this.patientOrderTodoService.create(newTodo);
                if (created != null && created.getId() != null) {
                    log.info("\u521b\u5efapatient_order_todo\u6210\u529f: id={}, sourceId={}, status={}", new Object[]{created.getId(), sourceId, todoStatus});
                } else {
                    log.error("\u521b\u5efapatient_order_todo\u5931\u8d25: sourceId={}", (Object)sourceId);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406nursing-care.orders\u53d8\u66f4\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    private void handleInquiryAdmissionChange(List<CanalEntry.Column> columns) {
        try {
            String orderType;
            Integer admType;
            Integer status;
            HashMap<String, String> columnMap = new HashMap<String, String>();
            for (CanalEntry.Column column : columns) {
                columnMap.put(column.getName(), column.getValue());
            }
            String sourceId = (String)columnMap.get("id");
            String patientId = (String)columnMap.get("patient_id");
            String statusStr = (String)columnMap.get("status");
            String admTypeStr = (String)columnMap.get("adm_type");
            if (sourceId == null || sourceId.isEmpty()) {
                log.warn("inquiry_admission\u8868\u53d8\u66f4\uff0c\u4f46id\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5904\u7406");
                return;
            }
            if (patientId == null || patientId.isEmpty()) {
                log.warn("inquiry_admission\u8868\u53d8\u66f4\uff0c\u4f46patient_id\u4e3a\u7a7a\uff0csourceId={}", (Object)sourceId);
                return;
            }
            if (statusStr == null || statusStr.isEmpty()) {
                log.warn("inquiry_admission\u8868\u53d8\u66f4\uff0c\u4f46status\u4e3a\u7a7a\uff0csourceId={}", (Object)sourceId);
                return;
            }
            if (admTypeStr == null || admTypeStr.isEmpty()) {
                log.warn("inquiry_admission\u8868\u53d8\u66f4\uff0c\u4f46adm_type\u4e3a\u7a7a\uff0csourceId={}", (Object)sourceId);
                return;
            }
            try {
                status = Integer.parseInt(statusStr);
                admType = Integer.parseInt(admTypeStr);
            }
            catch (NumberFormatException e) {
                log.error("\u89e3\u6790\u5b57\u6bb5\u503c\u5931\u8d25\uff0csourceId={}, statusStr={}, admTypeStr={}", new Object[]{sourceId, statusStr, admTypeStr, e});
                return;
            }
            if (admType == 1) {
                orderType = "inquiry_revisit";
            } else if (admType == 2) {
                orderType = "inquiry_consultation";
            } else {
                log.warn("inquiry_admission\u8868\u53d8\u66f4\uff0c\u4f46adm_type\u503c\u4e0d\u5728\u9884\u671f\u8303\u56f4\u5185: admType={}, sourceId={}", (Object)admType, (Object)sourceId);
                orderType = "inquiry";
            }
            Integer todoStatus = status == 0 ? Integer.valueOf(0) : (status == 2 ? Integer.valueOf(10) : Integer.valueOf(1));
            log.info("\u5904\u7406inquiry_admission\u53d8\u66f4: sourceId={}, patientId={}, admType={}, orderType={}, status={}, todoStatus={}", new Object[]{sourceId, patientId, admType, orderType, status, todoStatus});
            PatientOrderTodo existingTodo = this.patientOrderTodoService.getByOrderTypeAndSourceId(orderType, sourceId);
            if (existingTodo != null) {
                existingTodo.setStatus(todoStatus);
                boolean updated = this.patientOrderTodoService.update(existingTodo);
                if (updated) {
                    log.info("\u66f4\u65b0patient_order_todo\u6210\u529f: id={}, sourceId={}, orderType={}, status={}", new Object[]{existingTodo.getId(), sourceId, orderType, todoStatus});
                } else {
                    log.error("\u66f4\u65b0patient_order_todo\u5931\u8d25: sourceId={}, orderType={}", (Object)sourceId, (Object)orderType);
                }
            } else {
                PatientOrderTodo newTodo = new PatientOrderTodo();
                newTodo.setOrderType(orderType);
                newTodo.setSourceId(sourceId);
                newTodo.setPatientId(patientId);
                newTodo.setStatus(todoStatus);
                PatientOrderTodo created = this.patientOrderTodoService.create(newTodo);
                if (created != null && created.getId() != null) {
                    log.info("\u521b\u5efapatient_order_todo\u6210\u529f: id={}, sourceId={}, orderType={}, status={}", new Object[]{created.getId(), sourceId, orderType, todoStatus});
                } else {
                    log.error("\u521b\u5efapatient_order_todo\u5931\u8d25: sourceId={}, orderType={}", (Object)sourceId, (Object)orderType);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406inquiry_admission\u53d8\u66f4\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    private void handleMedicalAppointmentInfoChange(List<CanalEntry.Column> columns) {
        try {
            Integer orderStatus;
            HashMap<String, String> columnMap = new HashMap<String, String>();
            for (CanalEntry.Column column : columns) {
                columnMap.put(column.getName(), column.getValue());
            }
            String orderNumber = (String)columnMap.get("orderNumber");
            String patientId = (String)columnMap.get("patient_id");
            String orderStatusStr = (String)columnMap.get("orderStatus");
            if (orderNumber == null || orderNumber.isEmpty()) {
                log.warn("medical_appointment_info\u8868\u53d8\u66f4\uff0c\u4f46orderNumber\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5904\u7406");
                return;
            }
            if (patientId == null || patientId.isEmpty()) {
                log.warn("medical_appointment_info\u8868\u53d8\u66f4\uff0c\u4f46patient_id\u4e3a\u7a7a\uff0corderNumber={}", (Object)orderNumber);
                return;
            }
            if (orderStatusStr == null || orderStatusStr.isEmpty()) {
                log.warn("medical_appointment_info\u8868\u53d8\u66f4\uff0c\u4f46orderStatus\u4e3a\u7a7a\uff0corderNumber={}", (Object)orderNumber);
                return;
            }
            try {
                orderStatus = Integer.parseInt(orderStatusStr);
            }
            catch (NumberFormatException e) {
                log.error("\u89e3\u6790orderStatus\u5931\u8d25\uff0corderNumber={}, orderStatusStr={}", new Object[]{orderNumber, orderStatusStr, e});
                return;
            }
            Integer todoStatus = orderStatus == 2 || orderStatus == 4 ? Integer.valueOf(0) : Integer.valueOf(1);
            log.info("\u5904\u7406medical_appointment_info\u53d8\u66f4: orderNumber={}, patientId={}, orderStatus={}, todoStatus={}", new Object[]{orderNumber, patientId, orderStatus, todoStatus});
            PatientOrderTodo existingTodo = this.patientOrderTodoService.getByOrderTypeAndSourceId("medical_appointment", orderNumber);
            if (existingTodo != null) {
                existingTodo.setStatus(todoStatus);
                boolean updated = this.patientOrderTodoService.update(existingTodo);
                if (updated) {
                    log.info("\u66f4\u65b0patient_order_todo\u6210\u529f: id={}, orderNumber={}, status={}", new Object[]{existingTodo.getId(), orderNumber, todoStatus});
                } else {
                    log.error("\u66f4\u65b0patient_order_todo\u5931\u8d25: orderNumber={}", (Object)orderNumber);
                }
            } else {
                PatientOrderTodo newTodo = new PatientOrderTodo();
                newTodo.setOrderType("medical_appointment");
                newTodo.setSourceId(orderNumber);
                newTodo.setPatientId(patientId);
                newTodo.setStatus(todoStatus);
                PatientOrderTodo created = this.patientOrderTodoService.create(newTodo);
                if (created != null && created.getId() != null) {
                    log.info("\u521b\u5efapatient_order_todo\u6210\u529f: id={}, orderNumber={}, status={}", new Object[]{created.getId(), orderNumber, todoStatus});
                } else {
                    log.error("\u521b\u5efapatient_order_todo\u5931\u8d25: orderNumber={}", (Object)orderNumber);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406medical_appointment_info\u53d8\u66f4\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    private void handleMosDrugMainChange(List<CanalEntry.Column> columns) {
        try {
            Integer itemStatus;
            HashMap<String, String> columnMap = new HashMap<String, String>();
            for (CanalEntry.Column column : columns) {
                columnMap.put(column.getName(), column.getValue());
            }
            String xId = (String)columnMap.get("x_id");
            String patientId = (String)columnMap.get("patient_id");
            String itemStatusStr = (String)columnMap.get("item_status");
            if (xId == null || xId.isEmpty()) {
                log.warn("mos_drug_main\u8868\u53d8\u66f4\uff0c\u4f46x_id\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5904\u7406");
                return;
            }
            if (patientId == null || patientId.isEmpty()) {
                log.warn("mos_drug_main\u8868\u53d8\u66f4\uff0c\u4f46patient_id\u4e3a\u7a7a\uff0cxId={}", (Object)xId);
                return;
            }
            if (itemStatusStr == null || itemStatusStr.isEmpty()) {
                log.warn("mos_drug_main\u8868\u53d8\u66f4\uff0c\u4f46item_status\u4e3a\u7a7a\uff0cxId={}", (Object)xId);
                return;
            }
            try {
                itemStatus = Integer.parseInt(itemStatusStr);
            }
            catch (NumberFormatException e) {
                log.error("\u89e3\u6790item_status\u5931\u8d25\uff0cxId={}, itemStatusStr={}", new Object[]{xId, itemStatusStr, e});
                return;
            }
            Integer todoStatus = itemStatus == 30 || itemStatus == 100 ? Integer.valueOf(0) : Integer.valueOf(1);
            log.info("\u5904\u7406mos_drug_main\u53d8\u66f4: xId={}, patientId={}, itemStatus={}, todoStatus={}", new Object[]{xId, patientId, itemStatus, todoStatus});
            PatientOrderTodo existingTodo = this.patientOrderTodoService.getByOrderTypeAndSourceId("drug", xId);
            if (existingTodo != null) {
                existingTodo.setStatus(todoStatus);
                boolean updated = this.patientOrderTodoService.update(existingTodo);
                if (updated) {
                    log.info("\u66f4\u65b0patient_order_todo\u6210\u529f: id={}, xId={}, status={}", new Object[]{existingTodo.getId(), xId, todoStatus});
                } else {
                    log.error("\u66f4\u65b0patient_order_todo\u5931\u8d25: xId={}", (Object)xId);
                }
            } else {
                PatientOrderTodo newTodo = new PatientOrderTodo();
                newTodo.setOrderType("drug");
                newTodo.setSourceId(xId);
                newTodo.setPatientId(patientId);
                newTodo.setStatus(todoStatus);
                PatientOrderTodo created = this.patientOrderTodoService.create(newTodo);
                if (created != null && created.getId() != null) {
                    log.info("\u521b\u5efapatient_order_todo\u6210\u529f: id={}, xId={}, status={}", new Object[]{created.getId(), xId, todoStatus});
                } else {
                    log.error("\u521b\u5efapatient_order_todo\u5931\u8d25: xId={}", (Object)xId);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406mos_drug_main\u53d8\u66f4\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    private void handleFollowupPlanProvideDetailChange(List<CanalEntry.Column> columns) {
        try {
            Integer type;
            Integer reviewStatus;
            Integer sendStatus;
            HashMap<String, String> columnMap = new HashMap<String, String>();
            for (CanalEntry.Column column : columns) {
                columnMap.put(column.getName(), column.getValue());
            }
            String followupProvideId = (String)columnMap.get("followup_provide_id");
            String patientId = (String)columnMap.get("patient_id");
            String sendStatusStr = (String)columnMap.get("send_status");
            String reviewStatusStr = (String)columnMap.get("review_status");
            String typeStr = (String)columnMap.get("type");
            if (followupProvideId == null || followupProvideId.isEmpty()) {
                log.warn("followup_plan_provide_detail\u8868\u53d8\u66f4\uff0c\u4f46followup_provide_id\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5904\u7406");
                return;
            }
            String sourceId = followupProvideId;
            if (patientId == null || patientId.isEmpty()) {
                log.warn("followup_plan_provide_detail\u8868\u53d8\u66f4\uff0c\u4f46patient_id\u4e3a\u7a7a\uff0cfollowupProvideId={}", (Object)followupProvideId);
                return;
            }
            if (sendStatusStr == null || sendStatusStr.isEmpty()) {
                log.warn("followup_plan_provide_detail\u8868\u53d8\u66f4\uff0c\u4f46send_status\u4e3a\u7a7a\uff0cfollowupProvideId={}", (Object)followupProvideId);
                return;
            }
            if (reviewStatusStr == null || reviewStatusStr.isEmpty()) {
                log.warn("followup_plan_provide_detail\u8868\u53d8\u66f4\uff0c\u4f46review_status\u4e3a\u7a7a\uff0cfollowupProvideId={}", (Object)followupProvideId);
                return;
            }
            if (typeStr == null || typeStr.isEmpty()) {
                log.warn("followup_plan_provide_detail\u8868\u53d8\u66f4\uff0c\u4f46type\u4e3a\u7a7a\uff0cfollowupProvideId={}", (Object)followupProvideId);
                return;
            }
            try {
                sendStatus = Integer.parseInt(sendStatusStr);
                reviewStatus = Integer.parseInt(reviewStatusStr);
                type = Integer.parseInt(typeStr);
            }
            catch (NumberFormatException e) {
                log.error("\u89e3\u6790\u5b57\u6bb5\u503c\u5931\u8d25\uff0cfollowupProvideId={}, sendStatusStr={}, reviewStatusStr={}, typeStr={}", new Object[]{followupProvideId, sendStatusStr, reviewStatusStr, typeStr, e});
                return;
            }
            Integer todoStatus = type != 3 && sendStatus == 2 && reviewStatus == 0 ? Integer.valueOf(0) : Integer.valueOf(1);
            log.info("\u5904\u7406followup_plan_provide_detail\u53d8\u66f4: followupProvideId={}, sourceId={}, patientId={}, type={}, sendStatus={}, reviewStatus={}, todoStatus={}", new Object[]{followupProvideId, sourceId, patientId, type, sendStatus, reviewStatus, todoStatus});
            PatientOrderTodo existingTodo = this.patientOrderTodoService.getByOrderTypeAndSourceId("followup_plan_provide_detail", sourceId);
            if (existingTodo != null) {
                existingTodo.setStatus(todoStatus);
                boolean updated = this.patientOrderTodoService.update(existingTodo);
                if (updated) {
                    log.info("\u66f4\u65b0patient_order_todo\u6210\u529f: id={}, sourceId={}, status={}", new Object[]{existingTodo.getId(), sourceId, todoStatus});
                } else {
                    log.error("\u66f4\u65b0patient_order_todo\u5931\u8d25: sourceId={}", (Object)sourceId);
                }
            } else {
                PatientOrderTodo newTodo = new PatientOrderTodo();
                newTodo.setOrderType("followup_plan_provide_detail");
                newTodo.setSourceId(sourceId);
                newTodo.setPatientId(patientId);
                newTodo.setStatus(todoStatus);
                PatientOrderTodo created = this.patientOrderTodoService.create(newTodo);
                if (created != null && created.getId() != null) {
                    log.info("\u521b\u5efapatient_order_todo\u6210\u529f: id={}, sourceId={}, status={}", new Object[]{created.getId(), sourceId, todoStatus});
                } else {
                    log.error("\u521b\u5efapatient_order_todo\u5931\u8d25: sourceId={}", (Object)sourceId);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406followup_plan_provide_detail\u53d8\u66f4\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    private void logColumnData(String operation, String database, String table, List<CanalEntry.Column> columns) {
        StringBuilder sb = new StringBuilder();
        sb.append(operation).append(" - ").append(database).append(".").append(table).append(": ");
        for (CanalEntry.Column column : columns) {
            sb.append(column.getName()).append("=").append(column.getValue()).append(", ");
        }
        log.debug(sb.toString());
    }
}

