/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.AssayReportQueryItemResDTO;
import com.ebaiyihui.his.pojo.dto.AssayReportQueryResDTO;
import com.ebaiyihui.his.pojo.dto.CheckInspectionGroupDetailsRes;
import com.ebaiyihui.his.pojo.dto.CheckReportResDTO;
import com.ebaiyihui.his.pojo.dto.EleInvoiceDetailResDTO;
import com.ebaiyihui.his.pojo.dto.EleInvoiceResDTO;
import com.ebaiyihui.his.pojo.dto.GetAppointmentHistoryDetailResDTO;
import com.ebaiyihui.his.pojo.dto.GetAppointmentHistoryResDTO;
import com.ebaiyihui.his.pojo.dto.GetOutPatientHistoryDetailResDTO;
import com.ebaiyihui.his.pojo.dto.GetOutPatientHistoryResDTO;
import com.ebaiyihui.his.pojo.dto.InspectionReportQueryResDTO;
import com.ebaiyihui.his.pojo.dto.InspectionResultsDTO;
import com.ebaiyihui.his.pojo.dto.InspectionResultsResDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.report.CheckInspectionGroupDetailsListRes;
import com.ebaiyihui.his.pojo.vo.report.GetAppointOrOutPatientHistoryListReq;
import com.ebaiyihui.his.pojo.vo.report.GetAppointmentHistoryDateRespVo;
import com.ebaiyihui.his.pojo.vo.report.GetAppointmentHistoryListRespVo;
import com.ebaiyihui.his.pojo.vo.report.GetEleInvoiceListDataRes;
import com.ebaiyihui.his.pojo.vo.report.GetEleInvoiceListReq;
import com.ebaiyihui.his.pojo.vo.report.GetEleInvoiceListRes;
import com.ebaiyihui.his.pojo.vo.report.GetHistoryOutPatientDataRespVo;
import com.ebaiyihui.his.pojo.vo.report.GetHistoryOutPatientListRespVo;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsReq;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsRes;
import com.ebaiyihui.his.pojo.vo.report.InspectionResultsData;
import com.ebaiyihui.his.pojo.vo.report.LisReportListReq;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListReq;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListRes;
import com.ebaiyihui.his.pojo.vo.report.datas.GetReportListsData;
import com.ebaiyihui.his.service.ElectronicReportService;
import com.ebaiyihui.his.service.HisRemoteService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ElectronicReportServiceImpl
implements ElectronicReportService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int MAP_SIZE = 1;
    public static final String CHECK_TYPE = "1";
    public static final String INSPECTION_TYPE = "2";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<GetReportListsRes> getReportLists(FrontRequest<GetReportListsReq> param) {
        GetReportListsReq paramBody = (GetReportListsReq)param.getBody();
        List<Object> getReportList = new ArrayList();
        GetReportListsRes getReportListsRes = new GetReportListsRes();
        if (CHECK_TYPE.equals(paramBody.getReportType())) {
            paramBody.setReportType(INSPECTION_TYPE);
        } else {
            paramBody.setReportType(CHECK_TYPE);
        }
        HashMap<String, GetReportListsReq> reportQueryReqMap = new HashMap<String, GetReportListsReq>(1);
        reportQueryReqMap.put(EntityKeyEnum.REPORT_LIST_QUERY.getValue(), paramBody);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.REPORT_LIST_QUERY.getValue(), reportQueryReqMap, AssayReportQueryResDTO.class);
        AssayReportQueryResDTO responseBody = (AssayReportQueryResDTO)response.getBody();
        if (Objects.isNull(responseBody)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!CHECK_TYPE.equals(responseBody.getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        List reportQueryItemResDTOList = responseBody.getItem();
        if (CollectionUtils.isEmpty((Collection)reportQueryItemResDTOList)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        for (AssayReportQueryItemResDTO assayReportQueryItemResDTO : reportQueryItemResDTOList) {
            GetReportListsData getReportListsData = new GetReportListsData();
            BeanUtils.copyProperties((Object)assayReportQueryItemResDTO, (Object)getReportListsData);
            getReportListsData.setReportType(paramBody.getReportType());
            getReportList.add(getReportListsData);
        }
        getReportList = getReportList.stream().sorted(Comparator.comparing(GetReportListsData::getReportDate).reversed()).collect(Collectors.toList());
        getReportListsRes.setDatas(getReportList);
        getReportListsRes.setPatientNo(((AssayReportQueryItemResDTO)reportQueryItemResDTOList.get(0)).getCardNo());
        getReportListsRes.setPatientName(((AssayReportQueryItemResDTO)reportQueryItemResDTOList.get(0)).getPatientName());
        getReportListsRes.setPatientID(((AssayReportQueryItemResDTO)reportQueryItemResDTOList.get(0)).getPatientId());
        return FrontResponse.success((String)response.getTransactionId(), (Object)getReportListsRes);
    }

    public FrontResponse<CheckInspectionGroupDetailsListRes> lisReportList(FrontRequest<LisReportListReq> param) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(EntityKeyEnum.ASSAY_REPORT_DETAIL_QUERY.getValue(), param.getBody());
        FrontResponse inspectionResultsResDTOFrontResponse = this.hisRemoteService.requestHisUrl("http://10.10.11.38:8099/Service.asmx/ProcessKiosk", param.getTransactionId(), MethodCodeEnum.ASSAY_REPORT_DETAIL_QUERY.getValue(), map, InspectionResultsResDTO.class);
        if (!((InspectionResultsResDTO)inspectionResultsResDTOFrontResponse.getBody()).getResult().equals(CHECK_TYPE)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((InspectionResultsResDTO)inspectionResultsResDTOFrontResponse.getBody()).getErr());
        }
        Map<String, List<InspectionResultsDTO>> collect = ((InspectionResultsResDTO)inspectionResultsResDTOFrontResponse.getBody()).getInspectionResultsDTOList().stream().collect(Collectors.groupingBy(InspectionResultsDTO::getBarCode));
        ArrayList<CheckInspectionGroupDetailsRes> checkInspectionGroupDetailsResList = new ArrayList<CheckInspectionGroupDetailsRes>();
        for (String s : collect.keySet()) {
            CheckInspectionGroupDetailsRes checkInspectionGroupDetailsRes = new CheckInspectionGroupDetailsRes();
            checkInspectionGroupDetailsRes.setInspectionResultsDTOList(collect.get(s));
            for (InspectionResultsDTO inspectionResultsDTO : collect.get(s)) {
                checkInspectionGroupDetailsRes.setItemCode(inspectionResultsDTO.getItemCode());
                checkInspectionGroupDetailsRes.setItemName(inspectionResultsDTO.getItemName());
                checkInspectionGroupDetailsRes.setCheckDate(inspectionResultsDTO.getCheckDate());
            }
            checkInspectionGroupDetailsResList.add(checkInspectionGroupDetailsRes);
        }
        CheckInspectionGroupDetailsListRes checkInspectionGroupDetailsListRes = new CheckInspectionGroupDetailsListRes();
        ArrayList<com.ebaiyihui.his.pojo.vo.report.CheckInspectionGroupDetailsRes> checkInspectionGroupDetailsListResList = new ArrayList<com.ebaiyihui.his.pojo.vo.report.CheckInspectionGroupDetailsRes>();
        for (CheckInspectionGroupDetailsRes checkInspectionGroupDetailsRes : checkInspectionGroupDetailsResList) {
            com.ebaiyihui.his.pojo.vo.report.CheckInspectionGroupDetailsRes checkInspectionGroupDetailsRes1 = new com.ebaiyihui.his.pojo.vo.report.CheckInspectionGroupDetailsRes();
            checkInspectionGroupDetailsRes1.setItemCode(checkInspectionGroupDetailsRes.getItemCode());
            checkInspectionGroupDetailsRes1.setItemName(checkInspectionGroupDetailsRes.getItemName());
            checkInspectionGroupDetailsRes1.setCheckDate(checkInspectionGroupDetailsRes.getCheckDate());
            ArrayList<InspectionResultsData> inspectionResultsDataList = new ArrayList<InspectionResultsData>();
            for (InspectionResultsDTO inspectionResultsDTO : checkInspectionGroupDetailsRes.getInspectionResultsDTOList()) {
                InspectionResultsData inspectionResultsData = new InspectionResultsData();
                inspectionResultsData.setBarCode(inspectionResultsDTO.getBarCode());
                inspectionResultsData.setSeqNo(inspectionResultsDTO.getSeqNo());
                inspectionResultsData.setItemCode(inspectionResultsDTO.getItemCode());
                inspectionResultsData.setItemName(inspectionResultsDTO.getItemName());
                inspectionResultsData.setLisitemCode(inspectionResultsDTO.getLisitemCode());
                inspectionResultsData.setLisitemName(inspectionResultsDTO.getLisitemName());
                if (Objects.nonNull(inspectionResultsDTO.getResult())) {
                    inspectionResultsData.setResult(inspectionResultsDTO.getResult().replace("&gt;", ">").replace("&lt;", "<"));
                } else {
                    inspectionResultsData.setResult(inspectionResultsDTO.getResult());
                }
                inspectionResultsData.setFlag(inspectionResultsDTO.getFlag());
                if (Objects.nonNull(inspectionResultsDTO.getRange())) {
                    inspectionResultsData.setRange(inspectionResultsDTO.getRange().replace("&gt;", ">").replace("&lt;", "<"));
                } else {
                    inspectionResultsData.setRange(inspectionResultsDTO.getRange());
                }
                inspectionResultsData.setUnit(inspectionResultsDTO.getUnit());
                inspectionResultsData.setCheckDate(inspectionResultsDTO.getCheckDate());
                inspectionResultsData.setMachineid(inspectionResultsDTO.getMachineid());
                inspectionResultsData.setSampLeid(inspectionResultsDTO.getSampLeid());
                inspectionResultsData.setMachineType(inspectionResultsDTO.getMachineType());
                inspectionResultsDataList.add(inspectionResultsData);
            }
            checkInspectionGroupDetailsRes1.setInspectionResultsDataList(inspectionResultsDataList);
            checkInspectionGroupDetailsListResList.add(checkInspectionGroupDetailsRes1);
        }
        checkInspectionGroupDetailsListRes.setCheckInspectionGroupDetailsResList(checkInspectionGroupDetailsListResList);
        return FrontResponse.success((String)param.getTransactionId(), (Object)checkInspectionGroupDetailsListRes);
    }

    public FrontResponse<PacsReportListRes> pacsReportList(FrontRequest<PacsReportListReq> param) {
        HashMap<String, PacsReportListReq> inspectionDetailReportQueryMap = new HashMap<String, PacsReportListReq>(1);
        PacsReportListReq paramBody = (PacsReportListReq)param.getBody();
        inspectionDetailReportQueryMap.put(EntityKeyEnum.CHECK_REPORT_DETAIL.getValue(), paramBody);
        FrontResponse inspectionReportQueryRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.CHECK_REPORT_DETAIL.getValue(), inspectionDetailReportQueryMap, InspectionReportQueryResDTO.class);
        InspectionReportQueryResDTO inspectionReportQueryResDTO = (InspectionReportQueryResDTO)inspectionReportQueryRes.getBody();
        if (Objects.isNull(inspectionReportQueryResDTO)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)inspectionReportQueryRes.getMessage());
        }
        if (!CHECK_TYPE.equals(inspectionReportQueryResDTO.getResultCode())) {
            return FrontResponse.error((String)inspectionReportQueryRes.getTransactionId(), (String)"0", (String)inspectionReportQueryRes.getMessage());
        }
        List item = inspectionReportQueryResDTO.getCheckReportResDTO();
        if (CollectionUtils.isEmpty((Collection)item)) {
            return FrontResponse.success((String)inspectionReportQueryRes.getTransactionId(), null);
        }
        PacsReportListRes pacsReportListRes = new PacsReportListRes();
        CheckReportResDTO checkReportResDTO = (CheckReportResDTO)item.get(0);
        pacsReportListRes.setReportName(checkReportResDTO.getPacsExoression());
        pacsReportListRes.setCheckResult(checkReportResDTO.getPacsExoression());
        pacsReportListRes.setCheckDesc(checkReportResDTO.getDiagImpress());
        return FrontResponse.success((String)inspectionReportQueryRes.getTransactionId(), (Object)pacsReportListRes);
    }

    public FrontResponse<GetEleInvoiceListRes> eleInvoiceList(FrontRequest<GetEleInvoiceListReq> param) {
        GetEleInvoiceListRes getEleInvoiceListRes = new GetEleInvoiceListRes();
        ArrayList<GetEleInvoiceListDataRes> getEleInvoiceListDataResList = new ArrayList<GetEleInvoiceListDataRes>();
        HashMap<String, GetEleInvoiceListReq> getEleInvMap = new HashMap<String, GetEleInvoiceListReq>(1);
        GetEleInvoiceListReq body = (GetEleInvoiceListReq)param.getBody();
        getEleInvMap.put(EntityKeyEnum.ELE_INVOICE_LIST.getValue(), body);
        FrontResponse eleInvoiceResDTOFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.ELE_INVOICE_LIST.getValue(), getEleInvMap, EleInvoiceResDTO.class);
        EleInvoiceResDTO eleInvoiceResDTO = (EleInvoiceResDTO)eleInvoiceResDTOFrontResponse.getBody();
        if (Objects.isNull(eleInvoiceResDTO)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)eleInvoiceResDTOFrontResponse.getMessage());
        }
        if (!CHECK_TYPE.equals(eleInvoiceResDTO.getResultCode())) {
            return FrontResponse.error((String)eleInvoiceResDTOFrontResponse.getTransactionId(), (String)"0", (String)eleInvoiceResDTOFrontResponse.getMessage());
        }
        List item = eleInvoiceResDTO.getEleInvoiceDetailResDTOList();
        if (CollectionUtils.isEmpty((Collection)item)) {
            return FrontResponse.success((String)eleInvoiceResDTOFrontResponse.getTransactionId(), null);
        }
        for (EleInvoiceDetailResDTO eleInvoiceDetailResDTO : item) {
            GetEleInvoiceListDataRes getEleInvoiceListDataRes = new GetEleInvoiceListDataRes();
            BigDecimal bigDecimal = new BigDecimal(eleInvoiceDetailResDTO.getTotCost());
            int i = bigDecimal.compareTo(new BigDecimal("0"));
            if (i < 0) continue;
            BeanUtils.copyProperties((Object)eleInvoiceDetailResDTO, (Object)getEleInvoiceListDataRes);
            getEleInvoiceListDataResList.add(getEleInvoiceListDataRes);
        }
        getEleInvoiceListRes.setGetEleInvoiceListDataResList(getEleInvoiceListDataResList);
        return FrontResponse.success((String)eleInvoiceResDTOFrontResponse.getTransactionId(), (Object)getEleInvoiceListRes);
    }

    public FrontResponse<GetHistoryOutPatientListRespVo> getHistoryOutPatient(FrontRequest<GetAppointOrOutPatientHistoryListReq> param) {
        GetHistoryOutPatientListRespVo getHistoryOutPatientListRespVo = new GetHistoryOutPatientListRespVo();
        ArrayList<GetHistoryOutPatientDataRespVo> getHistoryOutPatientDataRespVoList = new ArrayList<GetHistoryOutPatientDataRespVo>();
        HashMap<String, GetAppointOrOutPatientHistoryListReq> getHistoryOutPatientDataRespVoMap = new HashMap<String, GetAppointOrOutPatientHistoryListReq>(1);
        GetAppointOrOutPatientHistoryListReq body = (GetAppointOrOutPatientHistoryListReq)param.getBody();
        getHistoryOutPatientDataRespVoMap.put(EntityKeyEnum.HISTORY_OUTPATIENT.getValue(), body);
        FrontResponse getOutPatientHistoryResDTOFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.HISTORY_OUTPATIENT.getValue(), getHistoryOutPatientDataRespVoMap, GetOutPatientHistoryResDTO.class);
        GetOutPatientHistoryResDTO getOutPatientHistoryResDTO = (GetOutPatientHistoryResDTO)getOutPatientHistoryResDTOFrontResponse.getBody();
        if (Objects.isNull(getOutPatientHistoryResDTO)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)getOutPatientHistoryResDTOFrontResponse.getMessage());
        }
        if (!CHECK_TYPE.equals(getOutPatientHistoryResDTO.getResult())) {
            return FrontResponse.error((String)getOutPatientHistoryResDTOFrontResponse.getTransactionId(), (String)"0", (String)getOutPatientHistoryResDTOFrontResponse.getMessage());
        }
        List getOutPatientHistoryDetailResDTOList = getOutPatientHistoryResDTO.getGetOutPatientHistoryDetailResDTOList();
        if (CollectionUtils.isEmpty((Collection)getOutPatientHistoryDetailResDTOList)) {
            return FrontResponse.success((String)getOutPatientHistoryResDTOFrontResponse.getTransactionId(), null);
        }
        for (GetOutPatientHistoryDetailResDTO getOutPatientHistoryDetailResDTO : getOutPatientHistoryDetailResDTOList) {
            GetHistoryOutPatientDataRespVo getHistoryOutPatientDataRespVo = new GetHistoryOutPatientDataRespVo();
            BeanUtils.copyProperties((Object)getOutPatientHistoryDetailResDTO, (Object)getHistoryOutPatientDataRespVo);
            getHistoryOutPatientDataRespVoList.add(getHistoryOutPatientDataRespVo);
        }
        getHistoryOutPatientListRespVo.setGetHistoryOutPatientDataRespVoList(getHistoryOutPatientDataRespVoList);
        return FrontResponse.success((String)getOutPatientHistoryResDTOFrontResponse.getTransactionId(), (Object)getHistoryOutPatientListRespVo);
    }

    public FrontResponse<GetAppointmentHistoryListRespVo> getHistoryAppointment(FrontRequest<GetAppointOrOutPatientHistoryListReq> param) {
        GetAppointmentHistoryListRespVo getAppointmentHistoryListRespVo = new GetAppointmentHistoryListRespVo();
        ArrayList<GetAppointmentHistoryDateRespVo> getAppointmentHistoryDateRespVoList = new ArrayList<GetAppointmentHistoryDateRespVo>();
        HashMap<String, GetAppointOrOutPatientHistoryListReq> getAppointmentHistoryDateMap = new HashMap<String, GetAppointOrOutPatientHistoryListReq>(1);
        GetAppointOrOutPatientHistoryListReq body = (GetAppointOrOutPatientHistoryListReq)param.getBody();
        getAppointmentHistoryDateMap.put(EntityKeyEnum.HISTORY_APPOINTMENT.getValue(), body);
        FrontResponse getAppointmentHistoryResDTOFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.HISTORY_APPOINTMENT.getValue(), getAppointmentHistoryDateMap, GetAppointmentHistoryResDTO.class);
        GetAppointmentHistoryResDTO getAppointmentHistoryResDTO = (GetAppointmentHistoryResDTO)getAppointmentHistoryResDTOFrontResponse.getBody();
        if (Objects.isNull(getAppointmentHistoryResDTO)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)getAppointmentHistoryResDTOFrontResponse.getMessage());
        }
        if (!CHECK_TYPE.equals(getAppointmentHistoryResDTO.getResult())) {
            return FrontResponse.error((String)getAppointmentHistoryResDTOFrontResponse.getTransactionId(), (String)"0", (String)getAppointmentHistoryResDTOFrontResponse.getMessage());
        }
        List getAppointmentHistoryDetailResDTOList = getAppointmentHistoryResDTO.getGetAppointmentHistoryDetailResDTOList();
        if (CollectionUtils.isEmpty((Collection)getAppointmentHistoryDetailResDTOList)) {
            return FrontResponse.success((String)getAppointmentHistoryResDTOFrontResponse.getTransactionId(), null);
        }
        for (GetAppointmentHistoryDetailResDTO getAppointmentHistoryDetailResDTO : getAppointmentHistoryDetailResDTOList) {
            GetAppointmentHistoryDateRespVo getAppointmentHistoryDateRespVo = new GetAppointmentHistoryDateRespVo();
            BeanUtils.copyProperties((Object)getAppointmentHistoryDetailResDTO, (Object)getAppointmentHistoryDateRespVo);
            getAppointmentHistoryDateRespVoList.add(getAppointmentHistoryDateRespVo);
        }
        getAppointmentHistoryListRespVo.setGetAppointmentHistoryDateRespVoList(getAppointmentHistoryDateRespVoList);
        return FrontResponse.success((String)getAppointmentHistoryResDTOFrontResponse.getTransactionId(), (Object)getAppointmentHistoryListRespVo);
    }
}

