/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.QueryDiagnosisResDTO;
import com.ebaiyihui.his.pojo.dto.QueryDiagnosisResItemDTO;
import com.ebaiyihui.his.pojo.dto.QueryDrugPriceDTO;
import com.ebaiyihui.his.pojo.dto.QueryDrugPriceResDTO;
import com.ebaiyihui.his.pojo.dto.QueryPrescriptionDTO;
import com.ebaiyihui.his.pojo.dto.QueryPrescriptionResDto;
import com.ebaiyihui.his.pojo.dto.ResponseDrugResDTO;
import com.ebaiyihui.his.pojo.dto.SelfPayResDTO;
import com.ebaiyihui.his.pojo.dto.SelfPayResDeptDTO;
import com.ebaiyihui.his.pojo.vo.DrugListReqVo;
import com.ebaiyihui.his.pojo.vo.QueryPrescriptionHisResVo;
import com.ebaiyihui.his.pojo.vo.ResponseDrugResVo;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.medicalcloud.QueryDiagnosisItemResVo;
import com.ebaiyihui.his.pojo.vo.medicalcloud.QueryDiagnosisReqVo;
import com.ebaiyihui.his.pojo.vo.medicalcloud.QueryDiagnosisResVo;
import com.ebaiyihui.his.pojo.vo.medicalcloud.QueryPrescriptionItemResVo;
import com.ebaiyihui.his.pojo.vo.medicalcloud.QueryPrescriptionReqVo;
import com.ebaiyihui.his.pojo.vo.medicalcloud.QueryPrescriptionResVo;
import com.ebaiyihui.his.pojo.vo.medicalcloud.SelfPayItemResVo;
import com.ebaiyihui.his.pojo.vo.medicalcloud.SelfPayReqVo;
import com.ebaiyihui.his.pojo.vo.medicalcloud.SelfPayResVo;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.MedicalCloudService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MedicalCloudServiceImpl
implements MedicalCloudService {
    private static final Logger log = LoggerFactory.getLogger(MedicalCloudServiceImpl.class);
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<QueryPrescriptionResVo> queryPrescription(FrontRequest<QueryPrescriptionReqVo> param) {
        QueryPrescriptionDTO queryPrescriptionDTO = QueryPrescriptionDTO.builder().clinicNO(((QueryPrescriptionReqVo)param.getBody()).getClinicNo()).build();
        HashMap<String, QueryPrescriptionDTO> map = new HashMap<String, QueryPrescriptionDTO>(1);
        map.put(EntityKeyEnum.QUERY_PRESCRIPTION.getValue(), queryPrescriptionDTO);
        FrontResponse queryPrescriptionResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_PRESCRIPTION.getValue(), map, QueryPrescriptionResDto.class);
        if (Objects.isNull(queryPrescriptionResponse)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"1", null);
        }
        QueryPrescriptionResDto queryPrescriptionRes = (QueryPrescriptionResDto)queryPrescriptionResponse.getBody();
        if (Objects.isNull(queryPrescriptionRes)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"1", (String)queryPrescriptionResponse.getMessage());
        }
        if (!"1".equals(queryPrescriptionRes.getResultCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"1", (String)queryPrescriptionRes.getErr());
        }
        List item = queryPrescriptionRes.getQueryPrescriptionList();
        if (CollectionUtils.isEmpty((Collection)item)) {
            return FrontResponse.success((String)param.getTransactionId(), null);
        }
        QueryPrescriptionResVo queryPrescriptionResVo = new QueryPrescriptionResVo();
        ArrayList<QueryPrescriptionItemResVo> list = new ArrayList<QueryPrescriptionItemResVo>();
        for (QueryPrescriptionHisResVo queryPrescriptionHisResVo : item) {
            QueryPrescriptionItemResVo queryPrescriptionItemResVo = new QueryPrescriptionItemResVo();
            BeanUtils.copyProperties((Object)queryPrescriptionHisResVo, (Object)queryPrescriptionItemResVo);
            list.add(queryPrescriptionItemResVo);
        }
        queryPrescriptionResVo.setItem(list);
        return FrontResponse.success((String)param.getTransactionId(), (Object)queryPrescriptionResVo);
    }

    public FrontResponse<SelfPayResVo> selfPay(FrontRequest<SelfPayReqVo> param) {
        SelfPayReqVo body = (SelfPayReqVo)param.getBody();
        HashMap<String, SelfPayReqVo> map = new HashMap<String, SelfPayReqVo>(1);
        map.put(EntityKeyEnum.SELF_PAY.getValue(), body);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.AUTO_CHARGE.getValue(), map, SelfPayResDTO.class);
        if (Objects.isNull(response)) {
            return FrontResponse.success((String)param.getTransactionId(), null);
        }
        SelfPayResDTO responseBody = (SelfPayResDTO)response.getBody();
        if (Objects.isNull(responseBody)) {
            return FrontResponse.success((String)param.getTransactionId(), null);
        }
        if (!"1".equals(responseBody.getResultCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)responseBody.getResultMsg());
        }
        if (CollectionUtils.isEmpty((Collection)responseBody.getItem())) {
            return FrontResponse.success((String)param.getTransactionId(), null);
        }
        List item = responseBody.getItem();
        SelfPayResVo selfPayResVo = new SelfPayResVo();
        selfPayResVo.setPayCost(responseBody.getPayCost());
        selfPayResVo.setMark(responseBody.getMark());
        selfPayResVo.setOwnCost(responseBody.getOwnCost());
        selfPayResVo.setPubCost(responseBody.getPubCost());
        selfPayResVo.setTotCost(responseBody.getTotCost());
        ArrayList<SelfPayItemResVo> list = new ArrayList<SelfPayItemResVo>();
        for (SelfPayResDeptDTO selfPayResDeptDTO : item) {
            SelfPayItemResVo selfPayItemResVo = new SelfPayItemResVo();
            BeanUtils.copyProperties((Object)selfPayResDeptDTO, (Object)selfPayItemResVo);
            list.add(selfPayItemResVo);
        }
        selfPayResVo.setItem(list);
        return FrontResponse.success((String)param.getTransactionId(), (Object)selfPayResVo);
    }

    public FrontResponse<QueryDiagnosisResVo> queryDiagnosis(FrontRequest<QueryDiagnosisReqVo> param) {
        QueryDiagnosisReqVo paramBody = (QueryDiagnosisReqVo)param.getBody();
        HashMap<String, QueryDiagnosisReqVo> map = new HashMap<String, QueryDiagnosisReqVo>(1);
        map.put(EntityKeyEnum.QUERY_DIAGNOSIS.getValue(), paramBody);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_DIAGNOSIS.getValue(), map, QueryDiagnosisResDTO.class);
        if (Objects.isNull(response)) {
            return FrontResponse.success((String)param.getTransactionId(), null);
        }
        QueryDiagnosisResDTO responseBody = (QueryDiagnosisResDTO)response.getBody();
        if (Objects.isNull(responseBody)) {
            return FrontResponse.success((String)param.getTransactionId(), null);
        }
        if (!"1".equals(responseBody.getResultCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)responseBody.getResultMsg());
        }
        if (CollectionUtils.isEmpty((Collection)responseBody.getItem())) {
            return FrontResponse.success((String)param.getTransactionId(), null);
        }
        QueryDiagnosisResVo queryDiagnosisResVo = new QueryDiagnosisResVo();
        List item = responseBody.getItem();
        ArrayList<QueryDiagnosisItemResVo> list = new ArrayList<QueryDiagnosisItemResVo>();
        queryDiagnosisResVo.setDiagnoseName(responseBody.getDiagnoseName());
        for (QueryDiagnosisResItemDTO queryDiagnosisResItemDTO : item) {
            QueryDiagnosisItemResVo queryDiagnosisItemResVo = new QueryDiagnosisItemResVo();
            BeanUtils.copyProperties((Object)queryDiagnosisResItemDTO, (Object)queryDiagnosisItemResVo);
            list.add(queryDiagnosisItemResVo);
        }
        queryDiagnosisResVo.setItem(list);
        return FrontResponse.success((String)param.getTransactionId(), (Object)queryDiagnosisResVo);
    }

    public FrontResponse<ResponseDrugResVo> getDrugList(FrontRequest<DrugListReqVo> frontRequest) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(EntityKeyEnum.GET_DRUG_LIST.getValue(), frontRequest.getBody());
        FrontResponse dtoFrontResponse = this.hisRemoteService.requestHis(frontRequest.getTransactionId(), MethodCodeEnum.GET_DRUG_LIST.getValue(), map, ResponseDrugResDTO.class);
        ResponseDrugResDTO responseDrug = (ResponseDrugResDTO)dtoFrontResponse.getBody();
        if (null == responseDrug) {
            return FrontResponse.error((String)frontRequest.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if (!"1".equals(responseDrug.getResult())) {
            return FrontResponse.error((String)frontRequest.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        ResponseDrugResVo responseDrugResVo = new ResponseDrugResVo();
        responseDrugResVo.setResult(responseDrug.getResult());
        responseDrugResVo.setErr(responseDrug.getErr());
        responseDrugResVo.setResponseDrugDetailList(responseDrug.getResponseDrugDetailList().getDrugDetailObjResDTO());
        return FrontResponse.success((String)frontRequest.getTransactionId(), (Object)responseDrugResVo);
    }

    public FrontResponse<ResponseDrugResVo> queryDrugPrice(FrontRequest<DrugListReqVo> frontRequest) {
        QueryDrugPriceDTO queryDrugPriceDTO = QueryDrugPriceDTO.builder().build();
        HashMap<String, QueryDrugPriceDTO> map = new HashMap<String, QueryDrugPriceDTO>();
        map.put(EntityKeyEnum.QUERY_DRUG_PRICE.getValue(), queryDrugPriceDTO);
        FrontResponse response = this.hisRemoteService.requestHis(frontRequest.getTransactionId(), MethodCodeEnum.GET_DRUG_LIST.getValue(), map, QueryDrugPriceResDTO.class);
        return null;
    }
}

