/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.date.DateUtil;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.CheckFeeDataRes;
import com.ebaiyihui.his.pojo.dto.CheckFeeDataResDTO;
import com.ebaiyihui.his.pojo.dto.GetBillResDTO;
import com.ebaiyihui.his.pojo.dto.GetRealTimeHisBillItemResDTO;
import com.ebaiyihui.his.pojo.dto.GetRealTimeHisBillReqDTO;
import com.ebaiyihui.his.pojo.dto.GetRealTimeHisBillResDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.bill.GetHisBillInfoReqVo;
import com.ebaiyihui.his.pojo.vo.bill.GetHisBillInfoRes;
import com.ebaiyihui.his.pojo.vo.bill.GetHisBillInfoResItem;
import com.ebaiyihui.his.pojo.vo.bill.GetRealTimeHisBillInfoRes;
import com.ebaiyihui.his.pojo.vo.bill.GetRealTimeHisBillReqVo;
import com.ebaiyihui.his.pojo.vo.bill.RefundCallBackReq;
import com.ebaiyihui.his.pojo.vo.bill.RefundCallBackRes;
import com.ebaiyihui.his.service.HisBillService;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.utils.EncryptUtils;
import com.ebaiyihui.his.utils.SnowflakeIdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HisBillServiceImpl
implements HisBillService {
    public static final int MAP_SIZE = 1;
    public static final String SUCCESS_FLAG = "0";
    @Autowired
    private HisRemoteService hisRemoteService;
    @Autowired
    private EncryptUtils encryptUtils;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public FrontResponse<GetHisBillInfoRes> getHisBillInfo(FrontRequest<GetHisBillInfoReqVo> param) {
        GetHisBillInfoRes getHisBillInfoRes = new GetHisBillInfoRes();
        ArrayList<GetHisBillInfoResItem> getHisBillInfoResItems = new ArrayList<GetHisBillInfoResItem>();
        GetHisBillInfoReqVo getHisBillInfoReqVo = (GetHisBillInfoReqVo)param.getBody();
        if (null == getHisBillInfoReqVo) {
            this.logger.error("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GetRealTimeHisBillReqDTO getRealTimeHisBillReqDTO = new GetRealTimeHisBillReqDTO();
        getRealTimeHisBillReqDTO.setTransType(getHisBillInfoReqVo.getTransType());
        getRealTimeHisBillReqDTO.setBegintime(getHisBillInfoReqVo.getBeginTime());
        getRealTimeHisBillReqDTO.setEndtime(getHisBillInfoReqVo.getEndTime());
        HashMap<String, GetRealTimeHisBillReqDTO> getRealTimeHisBillReqMap = new HashMap<String, GetRealTimeHisBillReqDTO>(1);
        getRealTimeHisBillReqMap.put(EntityKeyEnum.BILL_DETAIL_INFO.getValue(), getRealTimeHisBillReqDTO);
        FrontResponse getRealTimeHisBillRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.BILLING_DETAIL_HIS_INQUIRY.getValue(), getRealTimeHisBillReqMap, GetBillResDTO.class);
        GetBillResDTO hisBillResDTO = (GetBillResDTO)getRealTimeHisBillRes.getBody();
        if (null == hisBillResDTO) {
            return FrontResponse.error((String)getRealTimeHisBillRes.getTransactionId(), (String)"1", (String)hisBillResDTO.getResultMsg());
        }
        if (!SUCCESS_FLAG.equals(hisBillResDTO.getResultCode())) {
            return FrontResponse.error((String)getRealTimeHisBillRes.getTransactionId(), (String)SUCCESS_FLAG, (String)hisBillResDTO.getResultMsg());
        }
        List getRealTimeHisBillItemResDTOList = hisBillResDTO.getBillItemResDTO();
        if (CollectionUtils.isEmpty((Collection)getRealTimeHisBillItemResDTOList)) {
            return FrontResponse.error((String)getRealTimeHisBillRes.getTransactionId(), (String)SUCCESS_FLAG, (String)hisBillResDTO.getResultMsg());
        }
        for (GetRealTimeHisBillItemResDTO billItemResDTO : getRealTimeHisBillItemResDTOList) {
            GetHisBillInfoResItem infoResItem = new GetHisBillInfoResItem();
            BeanUtils.copyProperties((Object)billItemResDTO, (Object)infoResItem);
            getHisBillInfoResItems.add(infoResItem);
        }
        getHisBillInfoRes.setItems(getHisBillInfoResItems);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getHisBillInfoRes);
    }

    public FrontResponse<GetRealTimeHisBillInfoRes> getRealTimeHisBillInfo(FrontRequest<GetRealTimeHisBillReqVo> param) {
        ArrayList getRealTimeHisBillInfoResItems = new ArrayList();
        GetRealTimeHisBillReqVo getRealTimeHisBillReqVo = (GetRealTimeHisBillReqVo)param.getBody();
        if (null == getRealTimeHisBillReqVo) {
            this.logger.error("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GetRealTimeHisBillReqDTO getRealTimeHisBillReqDTO = new GetRealTimeHisBillReqDTO();
        getRealTimeHisBillReqDTO.setTransType(getRealTimeHisBillReqVo.getTransType());
        getRealTimeHisBillReqDTO.setOrderId(getRealTimeHisBillReqVo.getOrderid());
        HashMap<String, GetRealTimeHisBillReqDTO> getRealTimeHisBillReqMap = new HashMap<String, GetRealTimeHisBillReqDTO>(1);
        getRealTimeHisBillReqMap.put(EntityKeyEnum.BILL_DETAIL_INFO.getValue(), getRealTimeHisBillReqDTO);
        FrontResponse getRealTimeHisBillRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.BILLING_REAL_TIME_HIS_INQUIRY.getValue(), getRealTimeHisBillReqMap, GetRealTimeHisBillResDTO.class);
        GetRealTimeHisBillResDTO hisBillResDTO = (GetRealTimeHisBillResDTO)getRealTimeHisBillRes.getBody();
        if (null == hisBillResDTO) {
            return FrontResponse.error((String)getRealTimeHisBillRes.getTransactionId(), (String)"1", (String)hisBillResDTO.getResultMsg());
        }
        if (!SUCCESS_FLAG.equals(hisBillResDTO.getResultCode())) {
            return FrontResponse.error((String)getRealTimeHisBillRes.getTransactionId(), (String)SUCCESS_FLAG, (String)hisBillResDTO.getResultMsg());
        }
        GetRealTimeHisBillInfoRes getRealTimeHisBillInfoRes = new GetRealTimeHisBillInfoRes();
        getRealTimeHisBillInfoRes.setItems(getRealTimeHisBillInfoResItems);
        return FrontResponse.success((String)getRealTimeHisBillRes.getTransactionId(), (Object)getRealTimeHisBillInfoRes);
    }

    public FrontResponse<RefundCallBackRes> refundCallBack(FrontRequest<RefundCallBackReq> param) {
        RefundCallBackRes refundCallBackRes = new RefundCallBackRes();
        refundCallBackRes.setState("1");
        return FrontResponse.success((String)param.getTransactionId(), (Object)refundCallBackRes);
    }

    public FrontResponse<CheckFeeDataResDTO> getHisOneDayBill(String startingTime, String endTime) {
        FrontRequest frontRequest = new FrontRequest();
        CheckFeeDataRes checkFeeDataRes = new CheckFeeDataRes();
        checkFeeDataRes.setStartingTime(startingTime);
        checkFeeDataRes.setEndTime(endTime);
        frontRequest.setBody((Object)checkFeeDataRes);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(EntityKeyEnum.HIS_BILL.getValue(), frontRequest.getBody());
        FrontResponse checkFeeDataResDTOFrontResponse = this.hisRemoteService.requestHisUrl("http://10.10.11.38:8099/Service.asmx/ProcessKiosk", String.valueOf(this.snowflakeIdWorker.nextId()), MethodCodeEnum.QUERY_HIS_BILL.getValue(), map, CheckFeeDataResDTO.class);
        if (Objects.isNull(checkFeeDataResDTOFrontResponse.getBody())) {
            return FrontResponse.error((String)checkFeeDataResDTOFrontResponse.getTransactionId(), (String)SUCCESS_FLAG, null);
        }
        if (!"1".equals(((CheckFeeDataResDTO)checkFeeDataResDTOFrontResponse.getBody()).getResultCode())) {
            return FrontResponse.error((String)checkFeeDataResDTOFrontResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)checkFeeDataResDTOFrontResponse.getErrCode());
        }
        ((CheckFeeDataResDTO)checkFeeDataResDTOFrontResponse.getBody()).getCheckFeeDataList().forEach(checkFeeData -> checkFeeData.setOperDate(DateUtil.format((Date)DateUtil.parse((CharSequence)checkFeeData.getOperDate()), (String)"yyyy-MM-dd HH:mm:ss")));
        return checkFeeDataResDTOFrontResponse;
    }
}

