/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.utils.HttpUtils;
import com.ebaiyihui.his.utils.XmlTemplateKit;
import com.ebaiyihui.his.utils.XmlUtil;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class HisRemoteServiceImpl
implements HisRemoteService {
    private static final Logger log = LoggerFactory.getLogger(HisRemoteServiceImpl.class);
    @Value(value="${his.wsdlUrl}")
    public String hisWsdlUrl;
    @Value(value="${his.method}")
    public String method;
    @Value(value="${his.debug}")
    public Boolean debug;
    private String code = "?transCode=";
    private String xml = "&xml=";

    public <T> FrontResponse<T> requestGetHis(String transactionId, String transCode, Map map, Class<T> clazz) {
        String requestHisXml = XmlTemplateKit.process((String)transCode, (Map)map);
        if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        log.info("requestHisXml\u6a21\u677f\uff1a" + JSON.toJSONString((Object)requestHisXml));
        String responseHisXml = "";
        String url = this.hisWsdlUrl.concat(this.code).concat(transCode).concat(this.xml).concat(requestHisXml);
        log.info("url\uff1a" + url);
        try {
            responseHisXml = HttpUtils.get((String)url);
        }
        catch (Exception e) {
            log.info("his\u7ed3\u679c\u54cd\u5e94\u5931\u8d25 \u5f02\u5e38\u4fe1\u606f\u4e3a - >{}", (Object)e.getMessage());
            return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        log.info("requestHisXml\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)responseHisXml));
        Object resHisDTO = XmlUtil.convertToJavaBean((String)responseHisXml, clazz);
        log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resHisDTO));
        if (null == resHisDTO) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
        }
        return FrontResponse.success((String)transactionId, (Object)resHisDTO);
    }

    public <T> FrontResponse<T> requestHisUrl(String Url, String transactionId, String transCode, Map map, Class<T> clazz) {
        String requestHisXml = XmlTemplateKit.process((String)transCode, (Map)map);
        if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        log.info("requestHisXml\u6a21\u677f\uff1a" + JSON.toJSONString((Object)requestHisXml));
        String responseHisXml = "";
        try {
            responseHisXml = HttpUtils.getContent((String)Url, (String)transCode, (String)requestHisXml);
        }
        catch (Exception e) {
            e.printStackTrace();
            return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        responseHisXml = responseHisXml.replace("<?xml version=\"1.0\" encoding=\"utf-8\"?>", "");
        responseHisXml = responseHisXml.replace("<string xmlns=\"http://tempuri.org/\">", "");
        responseHisXml = responseHisXml.replace("&lt;", "<");
        responseHisXml = responseHisXml.replace("&gt;", ">");
        responseHisXml = responseHisXml.replace("\r\n", "");
        responseHisXml = responseHisXml.replace("<?xml version=\"1.0\" encoding=\"utf-16\"?>", "");
        responseHisXml = responseHisXml.replace("</string>", "");
        log.info("xml\u5904\u7406\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)responseHisXml));
        Object resHisDTO = XmlUtil.convertToJavaBean((String)responseHisXml, clazz);
        log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resHisDTO));
        if (null == resHisDTO) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
        }
        return FrontResponse.success((String)transactionId, (Object)resHisDTO);
    }

    public <T> FrontResponse<T> requestHis(String transactionId, String transCode, Map map, Class<T> clazz) {
        String requestHisXml = XmlTemplateKit.process((String)transCode, (Map)map);
        if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        log.info("\u8bf7\u6c42his\u63a5\u53e3:{},\u8bf7\u6c42\u53c2\u6570:{}", (Object)transCode, (Object)JSON.toJSONString((Object)requestHisXml));
        String responseHisXml = "";
        try {
            responseHisXml = HttpUtils.getContent((String)this.hisWsdlUrl, (String)transCode, (String)requestHisXml);
        }
        catch (Exception e) {
            e.printStackTrace();
            return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        if (responseHisXml.contains("\u83b7\u53d6\u6570\u636e\u9519\u8bef")) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u8bf7\u6c42\u5931\u8d25");
        }
        responseHisXml = responseHisXml.replace("<?xml version=\"1.0\" encoding=\"utf-8\"?>", "");
        responseHisXml = responseHisXml.replace("<string xmlns=\"http://tempuri.org/\">", "");
        responseHisXml = responseHisXml.replace("&lt;", "<");
        responseHisXml = responseHisXml.replace("&gt;", ">");
        responseHisXml = responseHisXml.replace("\r\n", "");
        responseHisXml = responseHisXml.replace("<?xml version=\"1.0\" encoding=\"utf-16\"?>", "");
        responseHisXml = responseHisXml.replace("</string>", "");
        log.info("\u8bf7\u6c42his\u63a5\u53e3:{},\u8fd4\u56de\u53c2\u6570:{}", (Object)transCode, (Object)JSON.toJSONString((Object)responseHisXml));
        Object resHisDTO = XmlUtil.convertToJavaBean((String)responseHisXml, clazz);
        if (null == resHisDTO) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
        }
        return FrontResponse.success((String)transactionId, (Object)resHisDTO);
    }

    static {
        XmlTemplateKit.init();
    }
}

