/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.GetOutPatientAdmResDTO;
import com.ebaiyihui.his.pojo.dto.GetOutPatientAdmResItemDTO;
import com.ebaiyihui.his.pojo.dto.GetPayRecordsReqDTO;
import com.ebaiyihui.his.pojo.dto.GetPayRecordsResDTO;
import com.ebaiyihui.his.pojo.dto.GetPayRecordsResItemDTO;
import com.ebaiyihui.his.pojo.dto.HealthOutpatientComfirePayResDTO;
import com.ebaiyihui.his.pojo.dto.OutPatientComfireDeptInfoResDto;
import com.ebaiyihui.his.pojo.dto.OutpatientComfirePayResDTO;
import com.ebaiyihui.his.pojo.dto.PendingPayDetailResDTO;
import com.ebaiyihui.his.pojo.dto.PendingPayDetailResItemDTO;
import com.ebaiyihui.his.pojo.vo.HisPresSendReq;
import com.ebaiyihui.his.pojo.vo.HisPresSendResVo;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.card.RechargeReqVo;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewReq;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewRes;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionRes;
import com.ebaiyihui.his.pojo.vo.outpatient.GetPayRecordsReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetPayRecordsRes;
import com.ebaiyihui.his.pojo.vo.outpatient.PayItemReq;
import com.ebaiyihui.his.pojo.vo.outpatient.PayItemRes;
import com.ebaiyihui.his.pojo.vo.outpatient.datas.PayItemResDatas;
import com.ebaiyihui.his.pojo.vo.outpatient.items.GetAdmissionItems;
import com.ebaiyihui.his.pojo.vo.outpatient.items.GetPayRecordsResDetails;
import com.ebaiyihui.his.pojo.vo.outpatient.items.GetPayRecordsResItems;
import com.ebaiyihui.his.pojo.vo.outpatient.items.PayItemResItems;
import com.ebaiyihui.his.pojo.vo.yb.SiBaseinfoDTO;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.ICardService;
import com.ebaiyihui.his.service.OutpatientPaymentService;
import com.ebaiyihui.his.utils.HttpUtils;
import com.ebaiyihui.his.utils.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OutpatientPaymentServiceImpl
implements OutpatientPaymentService {
    private static final Logger log = LoggerFactory.getLogger(OutpatientPaymentServiceImpl.class);
    private static final String PAY_SUCCESS = "Y";
    private static final String PAY_FAIL = "N";
    private static final String HIS_PAY_SUCCESS = "SUCCESS";
    private static final String HIS_PAY_FAIL = "FAIL";
    @Value(value="${his.wsdlUrl}")
    public String hisWsdlUrl;
    @Autowired
    private HisRemoteService hisRemoteService;
    @Autowired
    private ICardService iCardService;

    public FrontResponse<GetAdmissionRes> getAdmission(FrontRequest<GetAdmissionReq> param) {
        GetAdmissionRes getAdmissionRes = new GetAdmissionRes();
        HashMap<String, Object> admMap = new HashMap<String, Object>(1);
        admMap.put(EntityKeyEnum.Get_ADMSSION_INFO.getValue(), param.getBody());
        FrontResponse admRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.GET_MEDICAL_RECORDS.getValue(), admMap, GetOutPatientAdmResDTO.class);
        GetOutPatientAdmResDTO getOutPatientAdmRes = (GetOutPatientAdmResDTO)admRes.getBody();
        if (Objects.isNull(getOutPatientAdmRes)) {
            return FrontResponse.error((String)admRes.getTransactionId(), (String)"0", (String)admRes.getMessage());
        }
        if (!"1".equals(getOutPatientAdmRes.getResultCode())) {
            return FrontResponse.error((String)admRes.getTransactionId(), (String)"0", (String)getOutPatientAdmRes.getResultMsg());
        }
        List getOutPatientAdmResItemDTOList = getOutPatientAdmRes.getItems();
        if (CollectionUtils.isEmpty((Collection)getOutPatientAdmResItemDTOList)) {
            return FrontResponse.error((String)admRes.getTransactionId(), (String)"0", (String)getOutPatientAdmRes.getResultMsg());
        }
        ArrayList<GetAdmissionItems> admissionItemsList = new ArrayList<GetAdmissionItems>();
        for (GetOutPatientAdmResItemDTO getOutPatientAdmResItemDTO : getOutPatientAdmResItemDTOList) {
            GetAdmissionItems getAdmissionItems = new GetAdmissionItems();
            getAdmissionItems.setAdmDate(getOutPatientAdmResItemDTO.getRegDate());
            getAdmissionItems.setDeptName(getOutPatientAdmResItemDTO.getDeptName());
            getAdmissionItems.setDocName(getOutPatientAdmResItemDTO.getDocName());
            getAdmissionItems.setAdmStatus("3");
            getAdmissionItems.setAdmId(getOutPatientAdmResItemDTO.getAdmId());
            admissionItemsList.add(getAdmissionItems);
        }
        getAdmissionRes.setItems(admissionItemsList);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getAdmissionRes);
    }

    public FrontResponse<PayItemRes> payItem(FrontRequest<PayItemReq> param) {
        PayItemRes payItemRes = new PayItemRes();
        HashMap<String, Object> pendingPayMap = new HashMap<String, Object>(1);
        pendingPayMap.put(EntityKeyEnum.QUERY_PRESCRIPTION.getValue(), param.getBody());
        FrontResponse detailRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.PENDING_RECORD_INQUIRY_DETAIL.getValue(), pendingPayMap, PendingPayDetailResDTO.class);
        PendingPayDetailResDTO resBody = (PendingPayDetailResDTO)detailRes.getBody();
        if (Objects.isNull(resBody)) {
            return FrontResponse.error((String)detailRes.getTransactionId(), (String)"0", (String)detailRes.getMessage());
        }
        if (!"1".equals(resBody.getResultCode())) {
            return FrontResponse.error((String)detailRes.getTransactionId(), (String)"0", (String)resBody.getResultMsg());
        }
        List payDetailResList = resBody.getItem();
        if (CollectionUtils.isEmpty((Collection)payDetailResList)) {
            return FrontResponse.error((String)detailRes.getTransactionId(), (String)"0", (String)resBody.getResultMsg());
        }
        SiBaseinfoDTO siBaseinfoDTO = resBody.getSiBaseinfoDTO();
        if (Objects.isNull(siBaseinfoDTO)) {
            return FrontResponse.error((String)detailRes.getTransactionId(), (String)"0", (String)"his\u8fd4\u56de\u533b\u4fdd\u5bf9\u7167\u4fe1\u606f\u4e3a\u7a7a");
        }
        ArrayList<PayItemResDatas> datas = new ArrayList<PayItemResDatas>();
        for (PendingPayDetailResItemDTO pendingPayDetailResItemDTO : payDetailResList) {
            PayItemResDatas payItemResDatas = new PayItemResDatas();
            payItemResDatas.setSiInfoBaseInfoDTO(siBaseinfoDTO.getSiInfoBaseInfoDTO());
            payItemResDatas.setDiseinfoList(siBaseinfoDTO.getDiseinfoList());
            PayItemResItems payItemResItems = new PayItemResItems();
            payItemResItems.setSiFeeDetail(pendingPayDetailResItemDTO.getSiFeeDetail());
            payItemResDatas.setAmount(pendingPayDetailResItemDTO.getCost());
            payItemResDatas.setStartDate(pendingPayDetailResItemDTO.getFeeDate());
            String drugFlag = pendingPayDetailResItemDTO.getDrugFlag();
            if (Objects.equals("1", drugFlag)) {
                payItemResDatas.setItemType("3");
            } else {
                payItemResDatas.setItemType("1");
            }
            ArrayList<PayItemResItems> items = new ArrayList<PayItemResItems>();
            payItemResItems.setPrescriptionNo(pendingPayDetailResItemDTO.getRecipeNO());
            payItemResItems.setDesc(pendingPayDetailResItemDTO.getItemName());
            payItemResItems.setUnit(pendingPayDetailResItemDTO.getDoseUnit());
            payItemResItems.setPrice(pendingPayDetailResItemDTO.getPrice());
            payItemResItems.setQty(pendingPayDetailResItemDTO.getQty());
            payItemResItems.setSum(pendingPayDetailResItemDTO.getCost());
            payItemResItems.setItemType(pendingPayDetailResItemDTO.getMinfee());
            payItemResItems.setComBo(pendingPayDetailResItemDTO.getComBo());
            payItemResItems.setSeqNo(pendingPayDetailResItemDTO.getSeqNO());
            payItemResItems.setMoOrder(pendingPayDetailResItemDTO.getMoOrder());
            payItemResItems.setDoseNoce(pendingPayDetailResItemDTO.getDoseNoce());
            payItemResItems.setPriceUnit(pendingPayDetailResItemDTO.getPriceUnit());
            payItemResItems.setCost(pendingPayDetailResItemDTO.getCost());
            items.add(payItemResItems);
            payItemResDatas.setItems(items);
            datas.add(payItemResDatas);
        }
        payItemRes.setDatas(datas);
        return FrontResponse.success((String)param.getTransactionId(), (Object)payItemRes);
    }

    public FrontResponse<ComfirmPayNewRes> comfirmPayNew(FrontRequest<ComfirmPayNewReq> param) {
        ComfirmPayNewReq comfirmPayNewReq = (ComfirmPayNewReq)param.getBody();
        log.info("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u4f20\u5165\u53c2\u6570\u4e3a:{}", (Object)comfirmPayNewReq);
        ComfirmPayNewRes comfirmPayNewRes = new ComfirmPayNewRes();
        HashMap<String, ComfirmPayNewReq> confirmPaymap = new HashMap<String, ComfirmPayNewReq>(1);
        confirmPaymap.put(EntityKeyEnum.SELF_PAY.getValue(), comfirmPayNewReq);
        FrontResponse comfirePayResDTO = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.OUTPATIENT_PAYMENT.getValue(), confirmPaymap, OutpatientComfirePayResDTO.class);
        OutpatientComfirePayResDTO resDTOBody = (OutpatientComfirePayResDTO)comfirePayResDTO.getBody();
        if (Objects.isNull(resDTOBody)) {
            return FrontResponse.error((String)comfirePayResDTO.getTransactionId(), (String)"0", (String)comfirePayResDTO.getMessage());
        }
        if (!"1".equals(resDTOBody.getResultCode())) {
            return FrontResponse.error((String)comfirePayResDTO.getTransactionId(), (String)"0", (String)((OutpatientComfirePayResDTO)comfirePayResDTO.getBody()).getResultMsg());
        }
        List outPatientComfireDeptInfoResDtoList = resDTOBody.getOutPatientComfireDeptInfoResDtoList();
        comfirmPayNewRes.setReceiptId(resDTOBody.getMark());
        comfirmPayNewRes.setAdmId(comfirmPayNewReq.getId());
        comfirmPayNewRes.setCardNo(comfirmPayNewReq.getCardNo());
        comfirmPayNewRes.setAmount(comfirmPayNewReq.getAmount());
        comfirmPayNewRes.setRemark(((OutPatientComfireDeptInfoResDto)outPatientComfireDeptInfoResDtoList.get(0)).getDeptAddress());
        String eleStr = "";
        for (OutPatientComfireDeptInfoResDto outPatientComfireDeptInfoResDto : outPatientComfireDeptInfoResDtoList) {
            eleStr = eleStr.concat(outPatientComfireDeptInfoResDto.getEleStr()).concat("--");
        }
        comfirmPayNewRes.setEleStr(eleStr);
        return FrontResponse.success((String)param.getTransactionId(), (Object)comfirmPayNewRes);
    }

    public FrontResponse<GetPayRecordsRes> getPayRecords(FrontRequest<GetPayRecordsReq> param) {
        GetPayRecordsRes getPayRecordsRes = new GetPayRecordsRes();
        GetPayRecordsReq body = (GetPayRecordsReq)param.getBody();
        GetPayRecordsReqDTO getPayRecordsReqDTO = GetPayRecordsReqDTO.builder().dtBegin(body.getStartDate()).dtEnd(body.getEndDate()).cardNO(body.getCardNo()).build();
        HashMap<String, GetPayRecordsReqDTO> map = new HashMap<String, GetPayRecordsReqDTO>();
        map.put(EntityKeyEnum.GET_PAY_RECORDS.getValue(), getPayRecordsReqDTO);
        FrontResponse recordsResDTO = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.OUTPATIENT_LIST_INQUIRY.getValue(), map, GetPayRecordsResDTO.class);
        GetPayRecordsResDTO resDTOBody = (GetPayRecordsResDTO)recordsResDTO.getBody();
        if (Objects.isNull(resDTOBody)) {
            return FrontResponse.error((String)recordsResDTO.getTransactionId(), (String)"0", (String)recordsResDTO.getMessage());
        }
        if (!"1".equals(resDTOBody.getResultCode())) {
            return FrontResponse.error((String)recordsResDTO.getTransactionId(), (String)"0", null);
        }
        List getPayRecordsResItemDTOList = resDTOBody.getItem();
        if (CollectionUtils.isEmpty((Collection)getPayRecordsResItemDTOList)) {
            return FrontResponse.error((String)recordsResDTO.getTransactionId(), (String)"0", null);
        }
        getPayRecordsRes.setCardNo(body.getCardNo());
        Map<String, List<GetPayRecordsResItemDTO>> collect = getPayRecordsResItemDTOList.stream().collect(Collectors.groupingBy(GetPayRecordsResItemDTO::getRecipeNO));
        ArrayList items = new ArrayList();
        collect.forEach((Key2, value) -> {
            GetPayRecordsResItems getPayRecordsResItems = new GetPayRecordsResItems();
            ArrayList details = new ArrayList();
            value.forEach(v -> {
                getPayRecordsResItems.setPayDateTime(v.getFeeDate());
                getPayRecordsResItems.setAdmId(v.getMoOrder());
                getPayRecordsResItems.setAdmType("O");
                getPayRecordsResItems.setDeptName(v.getExecDept());
                getPayRecordsResItems.setDocName(v.getDoctName());
                GetPayRecordsResDetails getPayRecordsResDetails = new GetPayRecordsResDetails();
                getPayRecordsResDetails.setPrice(v.getPrice());
                getPayRecordsResDetails.setDesc(v.getItemName());
                getPayRecordsResDetails.setQty(v.getQty());
                getPayRecordsResDetails.setUnit(v.getPriceUnit());
                details.add(getPayRecordsResDetails);
            });
            items.add(getPayRecordsResItems);
        });
        getPayRecordsRes.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getPayRecordsRes);
    }

    public BaseResponse<String> hisPresSend(HisPresSendReq parm) {
        String reqxml = XmlUtil.beanToXml((Object)parm, (String)"utf-8");
        log.info("\u63a8\u9001\u5904\u65b9\u5165\u53c2\uff1a" + reqxml);
        String responseHisXml = null;
        try {
            responseHisXml = HttpUtils.getContent((String)this.hisWsdlUrl, (String)"ORDER1", (String)reqxml);
            log.info("\u63a8\u9001\u5904\u65b9\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)responseHisXml));
        }
        catch (Exception e) {
            log.info("\u63a8\u9001\u5904\u65b9\u5f02\u5e38\uff1a" + e);
            return BaseResponse.error((String)"\u63a8\u9001\u5904\u65b9\u5f02\u5e38");
        }
        if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
            return BaseResponse.error((String)"\u63a8\u9001\u5904\u65b9\u8fd4\u56de\u4e3a\u7a7a");
        }
        responseHisXml = responseHisXml.replace("<?xml version=\"1.0\" encoding=\"utf-8\"?>", "");
        responseHisXml = responseHisXml.replace("<string xmlns=\"http://tempuri.org/\">", "");
        responseHisXml = responseHisXml.replace("&lt;", "<");
        responseHisXml = responseHisXml.replace("&gt;", ">");
        responseHisXml = responseHisXml.replace("\r\n", "");
        responseHisXml = responseHisXml.replace("<?xml version=\"1.0\" encoding=\"utf-16\"?>", "");
        responseHisXml = responseHisXml.replace("</string>", "");
        log.info("\u63a8\u9001\u5904\u65b9\u8fd4\u56dexml\u5904\u7406\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)responseHisXml));
        HisPresSendResVo resHisDTO = (HisPresSendResVo)XmlUtil.convertToJavaBean((String)responseHisXml, HisPresSendResVo.class);
        log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resHisDTO));
        if (null == resHisDTO) {
            return BaseResponse.error((String)"JAXB\u6267\u884c\u5931\u8d25");
        }
        return BaseResponse.success();
    }

    public FrontResponse<ComfirmPayNewRes> healthComfirmPayNew(FrontRequest<ComfirmPayNewReq> param) {
        ComfirmPayNewReq comfirmPayNewReq = (ComfirmPayNewReq)param.getBody();
        log.info("\u533b\u4fdd\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u4f20\u5165\u53c2\u6570\u4e3a:{}", (Object)comfirmPayNewReq);
        ComfirmPayNewRes comfirmPayNewRes = new ComfirmPayNewRes();
        HashMap<String, ComfirmPayNewReq> confirmPaymap = new HashMap<String, ComfirmPayNewReq>(1);
        confirmPaymap.put(EntityKeyEnum.HEALTH_OUT_PATIENT_PAY.getValue(), comfirmPayNewReq);
        FrontResponse comfirePayResDTO = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.HEALTH_OUT_PATIENT_PAY.getValue(), confirmPaymap, HealthOutpatientComfirePayResDTO.class);
        HealthOutpatientComfirePayResDTO resDTOBody = (HealthOutpatientComfirePayResDTO)comfirePayResDTO.getBody();
        if (Objects.isNull(resDTOBody)) {
            return FrontResponse.error((String)comfirePayResDTO.getTransactionId(), (String)"0", (String)comfirePayResDTO.getMessage());
        }
        if (!"1".equals(resDTOBody.getResultCode())) {
            return FrontResponse.error((String)comfirePayResDTO.getTransactionId(), (String)"0", (String)((HealthOutpatientComfirePayResDTO)comfirePayResDTO.getBody()).getResultMsg());
        }
        List outPatientComfireDeptInfoResDtoList = resDTOBody.getOutPatientComfireDeptInfoResDtoList();
        if (!CollectionUtils.isEmpty((Collection)outPatientComfireDeptInfoResDtoList)) {
            comfirmPayNewRes.setReceiptId(((OutPatientComfireDeptInfoResDto)outPatientComfireDeptInfoResDtoList.get(0)).getRecipeNo());
            comfirmPayNewRes.setRemark(((OutPatientComfireDeptInfoResDto)outPatientComfireDeptInfoResDtoList.get(0)).getDeptAddress());
            String eleStr = "";
            for (OutPatientComfireDeptInfoResDto outPatientComfireDeptInfoResDto : outPatientComfireDeptInfoResDtoList) {
                eleStr = eleStr.concat(outPatientComfireDeptInfoResDto.getEleStr()).concat("--");
            }
            comfirmPayNewRes.setEleStr(eleStr);
        }
        comfirmPayNewRes.setAdmId(comfirmPayNewReq.getId());
        comfirmPayNewRes.setCardNo(comfirmPayNewReq.getCardNo());
        comfirmPayNewRes.setAmount(comfirmPayNewReq.getAmount());
        comfirmPayNewRes.setTotCost(resDTOBody.getTotCost());
        comfirmPayNewRes.setPubCost(resDTOBody.getPubCost());
        comfirmPayNewRes.setPayCost(resDTOBody.getPayCost());
        comfirmPayNewRes.setOwnCost(resDTOBody.getOwnCost());
        comfirmPayNewRes.setVacancy(resDTOBody.getVacancy());
        return FrontResponse.success((String)param.getTransactionId(), (Object)comfirmPayNewRes);
    }

    private FrontRequest<RechargeReqVo> getRechargeReqVoFrontRequest(FrontRequest<ComfirmPayNewReq> param) {
        ComfirmPayNewReq comfirmPayNewReq = (ComfirmPayNewReq)param.getBody();
        FrontRequest frontRequest = new FrontRequest();
        RechargeReqVo rechargeReqVo = new RechargeReqVo();
        rechargeReqVo.setCardNO(comfirmPayNewReq.getCardNo());
        rechargeReqVo.setName(comfirmPayNewReq.getRespmsg().getPosid());
        rechargeReqVo.setCost(comfirmPayNewReq.getAmount());
        rechargeReqVo.setOrderNO(comfirmPayNewReq.getFlowNo());
        rechargeReqVo.setTransNO(comfirmPayNewReq.getFlowNo());
        rechargeReqVo.setPayType("CP");
        frontRequest.setBody((Object)rechargeReqVo);
        frontRequest.setChannel(param.getChannel());
        frontRequest.setChannelName(param.getChannel());
        frontRequest.setOrganCode(param.getOrganCode());
        frontRequest.setTransactionId(param.getTransactionId());
        return frontRequest;
    }
}

