/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.DoctorScoreDTO;
import com.ebaiyihui.his.pojo.dto.DoctorScoreRes;
import com.ebaiyihui.his.pojo.dto.GetDeptDoctorResDTO;
import com.ebaiyihui.his.pojo.dto.GetDeptDoctorResItemDTO;
import com.ebaiyihui.his.pojo.dto.GetDeptScheduleDTO;
import com.ebaiyihui.his.pojo.dto.GetDeptScheduleResDTO;
import com.ebaiyihui.his.pojo.dto.GetDeptScheduleResItemDTO;
import com.ebaiyihui.his.pojo.dto.GetDocSourceScheduleResDTO;
import com.ebaiyihui.his.pojo.dto.GetDocSourceScheduleResItemDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptDoctorInfoReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetDoctorScoreResVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.items.DoctorScore;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetDeptScheduleResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetScheduleResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.TimeArrangeItems;
import com.ebaiyihui.his.pojo.vo.yb.SiBaseinfoDTO;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.ScheduleService;
import com.ebaiyihui.his.utils.DateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<GetScheduleResVO> getSchedule(FrontRequest<GetScheduleReqVO> param) {
        GetScheduleResVO getScheduleResVO = new GetScheduleResVO();
        ArrayList<GetScheduleResItems> items = new ArrayList<GetScheduleResItems>();
        GetScheduleReqVO paramBody = (GetScheduleReqVO)param.getBody();
        HashMap<String, GetScheduleReqVO> map = new HashMap<String, GetScheduleReqVO>();
        map.put(EntityKeyEnum.DEPT_DOCTOR_INFO.getValue(), paramBody);
        FrontResponse dtoFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_SCHEDULING_INFO_NEW.getValue(), map, GetDeptDoctorResDTO.class);
        GetDeptDoctorResDTO body = (GetDeptDoctorResDTO)dtoFrontResponse.getBody();
        if (Objects.isNull(body)) {
            return FrontResponse.error((String)dtoFrontResponse.getTransactionId(), (String)"0", null);
        }
        if (!"1".equals(body.getResultCode())) {
            return FrontResponse.error((String)dtoFrontResponse.getTransactionId(), (String)"0", (String)body.getResultMsg());
        }
        List getDeptDoctorResItemDTOList = body.getItem();
        if (CollectionUtils.isEmpty((Collection)getDeptDoctorResItemDTOList)) {
            return FrontResponse.success((String)dtoFrontResponse.getTransactionId(), (Object)getScheduleResVO);
        }
        String bgDate = paramBody.getBgDate();
        String currentDateStr = DateUtil.getCurrentDateStr();
        String docCode = "66666";
        int i = 0;
        for (GetDeptDoctorResItemDTO getDeptDoctorResItemDTO : getDeptDoctorResItemDTOList) {
            int regAvailable;
            String endDate = getDeptDoctorResItemDTO.getEndDate();
            boolean noon = DateUtil.checkTimeRange((String)endDate, (String)DateUtil.FULL_FORMAT);
            if (!noon) continue;
            GetScheduleResItems getScheduleResItems = new GetScheduleResItems();
            String scoreSub = StringUtils.isBlank((CharSequence)getDeptDoctorResItemDTO.getScoreSub()) ? "0" : getDeptDoctorResItemDTO.getScoreSub();
            getScheduleResItems.setScoreSub(scoreSub);
            getScheduleResItems.setRemainScore(String.valueOf(12 - Integer.parseInt(scoreSub)));
            getScheduleResItems.setScoreStatus(getDeptDoctorResItemDTO.getScoreStatus());
            getScheduleResItems.setScoreYear(getDeptDoctorResItemDTO.getScoreYear());
            getScheduleResItems.setSiFeeDetail(getDeptDoctorResItemDTO.getSiFeeDetail());
            getScheduleResItems.setSiFeeDetails(getDeptDoctorResItemDTO.getSiFeeDetails());
            SiBaseinfoDTO siBaseinfoDTO = getDeptDoctorResItemDTO.getSiBaseinfoDTO();
            getScheduleResItems.setDiseinfoList(siBaseinfoDTO.getDiseinfoList());
            getScheduleResItems.setSiInfoBaseInfoDTO(siBaseinfoDTO.getSiInfoBaseInfoDTO());
            getScheduleResItems.setBranchCode(getDeptDoctorResItemDTO.getBranchCode());
            getScheduleResItems.setAdmDate(bgDate);
            getScheduleResItems.setScheduleType(Integer.valueOf(1));
            getScheduleResItems.setLocCode(getDeptDoctorResItemDTO.getDeptCode());
            getScheduleResItems.setLocName(getDeptDoctorResItemDTO.getDeptName());
            getScheduleResItems.setScheduleId(getDeptDoctorResItemDTO.getSchemaId());
            getScheduleResItems.setRegFee(getDeptDoctorResItemDTO.getRegFee());
            getScheduleResItems.setDiagFee("0");
            String regLeveName = getDeptDoctorResItemDTO.getRegLeveName();
            String regLeve = getDeptDoctorResItemDTO.getRegLeve();
            getScheduleResItems.setRegTitleName(regLeveName);
            getScheduleResItems.setAdmLocation(getDeptDoctorResItemDTO.getDeptName());
            getScheduleResItems.setAdmTimeRange(getDeptDoctorResItemDTO.getNoonCode());
            getScheduleResItems.setIsTimeArrange(Integer.valueOf(1));
            getScheduleResItems.setHospitalArea("\u4fdd\u5b9a\u5e02\u7b2c\u4e00\u4e2d\u533b\u9662");
            getScheduleResItems.setScheduleLevelName(regLeveName);
            getScheduleResItems.setScheduleLevelCode(regLeve);
            if (StringUtils.isBlank((CharSequence)getDeptDoctorResItemDTO.getDoctorName())) {
                getScheduleResItems.setDocName(regLeveName);
                getScheduleResItems.setDocCode(docCode + i);
                for (GetScheduleResItems item : items) {
                    if (!Objects.equals(regLeveName, item.getDocName())) continue;
                    getScheduleResItems.setDocCode(item.getDocCode());
                }
            } else {
                getScheduleResItems.setDocName(getDeptDoctorResItemDTO.getDoctorName());
                getScheduleResItems.setDocCode(getDeptDoctorResItemDTO.getDoctorCode());
            }
            ++i;
            if (Objects.equals(bgDate, currentDateStr)) {
                int reged;
                int regLimit = Integer.parseInt(getDeptDoctorResItemDTO.getRegLimit());
                regAvailable = regLimit - (reged = Integer.parseInt(getDeptDoctorResItemDTO.getReged()));
                if (regAvailable < 0) {
                    regAvailable = 0;
                }
                getScheduleResItems.setRegTotal(Integer.valueOf(regLimit));
                getScheduleResItems.setRegAvailable(Integer.valueOf(regAvailable));
            } else {
                List item;
                int telReged;
                int telLimit = Integer.parseInt(getDeptDoctorResItemDTO.getTelLimit());
                regAvailable = telLimit - (telReged = Integer.parseInt(getDeptDoctorResItemDTO.getTelReged()));
                if (regAvailable < 0) {
                    regAvailable = 0;
                }
                getScheduleResItems.setRegTotal(Integer.valueOf(getDeptDoctorResItemDTO.getTelLimit()));
                getScheduleResItems.setRegAvailable(Integer.valueOf(regAvailable));
                HashMap<String, GetDeptDoctorResItemDTO> mapSchedule = new HashMap<String, GetDeptDoctorResItemDTO>();
                mapSchedule.put(EntityKeyEnum.DOC_SCHEDULE_SOURCE.getValue(), getDeptDoctorResItemDTO);
                FrontResponse docSourceScheduleRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.DOCTOR_SOURCE_LIST.getValue(), mapSchedule, GetDocSourceScheduleResDTO.class);
                GetDocSourceScheduleResDTO docSourceScheduleResBody = (GetDocSourceScheduleResDTO)docSourceScheduleRes.getBody();
                if (Objects.isNull(docSourceScheduleResBody)) {
                    return FrontResponse.error((String)dtoFrontResponse.getTransactionId(), (String)"0", null);
                }
                if (!"1".equals(docSourceScheduleResBody.getResultCode()) || CollectionUtils.isEmpty((Collection)(item = docSourceScheduleResBody.getItem()))) continue;
                ArrayList<TimeArrangeItems> timeArrangeItemsList = new ArrayList<TimeArrangeItems>();
                for (GetDocSourceScheduleResItemDTO getDocSourceScheduleResItemDTO : item) {
                    int reged;
                    String limitedString = getDocSourceScheduleResItemDTO.getLimited();
                    int limited = Integer.parseInt(limitedString);
                    int availablNo = limited - (reged = Integer.parseInt(getDocSourceScheduleResItemDTO.getReged()));
                    if (availablNo <= 0) continue;
                    TimeArrangeItems timeArrangeItems = new TimeArrangeItems();
                    timeArrangeItems.setTimeArrangeId(getDocSourceScheduleResItemDTO.getSchemaID());
                    timeArrangeItems.setStartTime(getDocSourceScheduleResItemDTO.getBeginTime());
                    timeArrangeItems.setEndTime(getDocSourceScheduleResItemDTO.getEndTime());
                    timeArrangeItems.setAvailablNo(String.valueOf(availablNo));
                    timeArrangeItems.setTotalNo(limitedString);
                    timeArrangeItems.setStartNo(Integer.valueOf(getDocSourceScheduleResItemDTO.getSortID()));
                    timeArrangeItemsList.add(timeArrangeItems);
                }
                getScheduleResItems.setTimeArrangeItems(timeArrangeItemsList);
            }
            if (StringUtils.isNotBlank((CharSequence)paramBody.getDocCode())) {
                if (!Objects.equals(paramBody.getDocCode(), getScheduleResItems.getDocCode())) continue;
                items.add(getScheduleResItems);
                continue;
            }
            items.add(getScheduleResItems);
        }
        getScheduleResVO.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getScheduleResVO);
    }

    public FrontResponse<GetDeptScheduleResVO> getDeptSchedule(FrontRequest<GetDeptScheduleReqVO> param) {
        GetDeptScheduleResVO getDeptScheduleResVO = new GetDeptScheduleResVO();
        ArrayList<GetDeptScheduleResItems> items = new ArrayList<GetDeptScheduleResItems>();
        GetDeptScheduleDTO getDeptScheduleDTO = GetDeptScheduleDTO.builder().build();
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put(EntityKeyEnum.DOC_DAY_SCHEDULE_SOURCE.getValue(), param.getBody());
        FrontResponse getDeptList = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.REGISTERED_DOCTOR_LIST.getValue(), map, GetDeptScheduleResDTO.class);
        GetDeptScheduleResDTO body = (GetDeptScheduleResDTO)getDeptList.getBody();
        if (Objects.isNull(getDeptList)) {
            return FrontResponse.error((String)getDeptList.getTransactionId(), (String)"0", null);
        }
        if (!"1".equals(body.getResultCode())) {
            return FrontResponse.error((String)getDeptList.getTransactionId(), (String)"0", (String)body.getResultMsg());
        }
        List getDeptItemList = body.getDept();
        if (CollectionUtils.isEmpty((Collection)getDeptItemList)) {
            return FrontResponse.error((String)getDeptList.getTransactionId(), (String)"0", (String)body.getResultMsg());
        }
        for (GetDeptScheduleResItemDTO getDeptScheduleResItemDTO : getDeptItemList) {
            GetDeptScheduleResItems getDeptScheduleResItems = new GetDeptScheduleResItems();
            getDeptScheduleResItems.setDeptCode(getDeptScheduleResItemDTO.getId());
            getDeptScheduleResItems.setDeptName(getDeptScheduleResItemDTO.getName());
            getDeptScheduleResItems.setDeptAddress(getDeptScheduleResItemDTO.getAddress());
            items.add(getDeptScheduleResItems);
        }
        getDeptScheduleResVO.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getDeptScheduleResVO);
    }

    public FrontResponse<GetScheduleResVO> getDeptDoctorInfo(FrontRequest<GetDeptDoctorInfoReqVO> param) {
        GetScheduleResVO getScheduleResVO = new GetScheduleResVO();
        ArrayList<GetScheduleResItems> items = new ArrayList<GetScheduleResItems>();
        GetScheduleResItems getScheduleResItems = new GetScheduleResItems();
        TimeArrangeItems timeArrangeItems = new TimeArrangeItems();
        ArrayList<TimeArrangeItems> timeArrangeItemsList = new ArrayList<TimeArrangeItems>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(EntityKeyEnum.DEPT_DOCTOR_INFO.getValue(), param.getBody());
        FrontResponse dtoFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_SCHEDULING_INFO_NEW.getValue(), map, GetDeptDoctorResDTO.class);
        GetDeptDoctorResDTO body = (GetDeptDoctorResDTO)dtoFrontResponse.getBody();
        if (Objects.isNull(body)) {
            return FrontResponse.error((String)dtoFrontResponse.getTransactionId(), (String)"0", null);
        }
        if (!"1".equals(body.getResultCode())) {
            return FrontResponse.error((String)dtoFrontResponse.getTransactionId(), (String)"0", (String)body.getResultMsg());
        }
        List getDeptDoctorResItemDTOList = body.getItem();
        if (CollectionUtils.isEmpty((Collection)getDeptDoctorResItemDTOList)) {
            return FrontResponse.error((String)dtoFrontResponse.getTransactionId(), (String)"0", (String)body.getResultMsg());
        }
        for (GetDeptDoctorResItemDTO getDeptDoctorResItemDTO : getDeptDoctorResItemDTOList) {
            String scoreSub = StringUtils.isBlank((CharSequence)getDeptDoctorResItemDTO.getScoreSub()) ? "0" : getDeptDoctorResItemDTO.getScoreSub();
            getScheduleResItems.setScoreSub(scoreSub);
            getScheduleResItems.setRemainScore(String.valueOf(12 - Integer.parseInt(scoreSub)));
            getScheduleResItems.setScoreStatus(getDeptDoctorResItemDTO.getScoreStatus());
            getScheduleResItems.setScoreYear(getDeptDoctorResItemDTO.getScoreYear());
            getScheduleResItems.setRegFee("0");
            getScheduleResItems.setDiagFee(getDeptDoctorResItemDTO.getRegFee());
            getScheduleResItems.setLocCode(getDeptDoctorResItemDTO.getDeptCode());
            getScheduleResItems.setLocName(getDeptDoctorResItemDTO.getDeptName());
            getScheduleResItems.setDocName(getDeptDoctorResItemDTO.getDoctorName());
            getScheduleResItems.setDocCode(getDeptDoctorResItemDTO.getDoctorCode());
            getScheduleResItems.setScheduleLevelName(getDeptDoctorResItemDTO.getRegLeveName());
            getScheduleResItems.setScheduleLevelCode(getDeptDoctorResItemDTO.getRegLeve());
            getScheduleResItems.setAdmTimeRange(getDeptDoctorResItemDTO.getNoonCode());
            HashMap<String, GetDeptDoctorResItemDTO> mapSchedule = new HashMap<String, GetDeptDoctorResItemDTO>();
            mapSchedule.put(EntityKeyEnum.DOC_SCHEDULE_SOURCE.getValue(), getDeptDoctorResItemDTO);
            FrontResponse docSourceScheduleRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.DOCTOR_SOURCE_LIST.getValue(), mapSchedule, GetDocSourceScheduleResDTO.class);
            for (GetDocSourceScheduleResItemDTO getDocSourceScheduleResItemDTO : ((GetDocSourceScheduleResDTO)docSourceScheduleRes.getBody()).getItem()) {
                timeArrangeItems.setTimeArrangeId(getDocSourceScheduleResItemDTO.getSchemaID());
                timeArrangeItems.setStartTime(getDocSourceScheduleResItemDTO.getBeginTime());
                timeArrangeItems.setEndTime(getDocSourceScheduleResItemDTO.getEndTime());
                timeArrangeItems.setAvailablNo(getDocSourceScheduleResItemDTO.getLimited());
                timeArrangeItemsList.add(timeArrangeItems);
            }
            getScheduleResItems.setTimeArrangeItems(timeArrangeItemsList);
            items.add(getScheduleResItems);
            getScheduleResVO.setItems(items);
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)getScheduleResVO);
    }

    public FrontResponse<GetDeptScheduleResVO> getDeptScheduleTest(FrontRequest<GetDeptScheduleReqVO> param) {
        GetDeptScheduleResVO getDeptScheduleResVO = new GetDeptScheduleResVO();
        ArrayList<GetDeptScheduleResItems> items = new ArrayList<GetDeptScheduleResItems>();
        GetDeptScheduleDTO getDeptScheduleDTO = GetDeptScheduleDTO.builder().build();
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put(EntityKeyEnum.DOC_DAY_SCHEDULE_SOURCE.getValue(), param.getBody());
        FrontResponse getDeptList = this.hisRemoteService.requestHisUrl("http://10.10.11.38:8111/Service.asmx/ProcessKiosk", param.getTransactionId(), MethodCodeEnum.REGISTERED_DOCTOR_LIST.getValue(), map, GetDeptScheduleResDTO.class);
        GetDeptScheduleResDTO body = (GetDeptScheduleResDTO)getDeptList.getBody();
        if (Objects.isNull(getDeptList)) {
            return FrontResponse.error((String)getDeptList.getTransactionId(), (String)"0", null);
        }
        if (!"1".equals(body.getResultCode())) {
            return FrontResponse.error((String)getDeptList.getTransactionId(), (String)"0", (String)body.getResultMsg());
        }
        List getDeptItemList = body.getDept();
        if (CollectionUtils.isEmpty((Collection)getDeptItemList)) {
            return FrontResponse.error((String)getDeptList.getTransactionId(), (String)"0", (String)body.getResultMsg());
        }
        for (GetDeptScheduleResItemDTO getDeptScheduleResItemDTO : getDeptItemList) {
            GetDeptScheduleResItems getDeptScheduleResItems = new GetDeptScheduleResItems();
            getDeptScheduleResItems.setDeptCode(getDeptScheduleResItemDTO.getId());
            getDeptScheduleResItems.setDeptName(getDeptScheduleResItemDTO.getName());
            getDeptScheduleResItems.setDeptAddress(getDeptScheduleResItemDTO.getAddress());
            items.add(getDeptScheduleResItems);
        }
        getDeptScheduleResVO.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getDeptScheduleResVO);
    }

    public FrontResponse<GetDoctorScoreResVO> getDoctorScore(FrontRequest param) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(EntityKeyEnum.DOCTOR_SCORE.getValue(), param.getBody());
        FrontResponse dtoFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_DOCTOR_SCORE.getValue(), map, DoctorScoreRes.class);
        DoctorScoreRes body = (DoctorScoreRes)dtoFrontResponse.getBody();
        if (Objects.isNull(body)) {
            return FrontResponse.error((String)dtoFrontResponse.getTransactionId(), (String)"0", null);
        }
        if (!"1".equals(body.getResultCode())) {
            return FrontResponse.error((String)dtoFrontResponse.getTransactionId(), (String)"0", (String)body.getResultMsg());
        }
        List doctorScoreDTOS = body.getDoctorScoreDTOS();
        if (CollectionUtils.isEmpty((Collection)doctorScoreDTOS)) {
            return FrontResponse.success((String)dtoFrontResponse.getTransactionId(), null);
        }
        GetDoctorScoreResVO getDoctorScoreResVO = new GetDoctorScoreResVO();
        ArrayList<DoctorScore> doctorScoreList = new ArrayList<DoctorScore>();
        for (DoctorScoreDTO doctorScoreDTO : doctorScoreDTOS) {
            DoctorScore doctorScore = new DoctorScore();
            doctorScore.setDoctCode(doctorScoreDTO.getDoctCode());
            doctorScore.setDoctName(doctorScoreDTO.getDoctName());
            doctorScore.setScoreYear(doctorScoreDTO.getScoreYear());
            doctorScore.setScoreStatus(doctorScoreDTO.getScoreStatus());
            String subScore = StringUtils.isNotBlank((CharSequence)doctorScoreDTO.getScoreSub()) ? doctorScoreDTO.getScoreSub() : "0";
            doctorScore.setScoreSub(subScore);
            doctorScore.setRemainScore(String.valueOf(12 - Integer.parseInt(subScore)));
            doctorScoreList.add(doctorScore);
        }
        getDoctorScoreResVO.setDoctorScoreList(doctorScoreList);
        return FrontResponse.success((String)dtoFrontResponse.getTransactionId(), (Object)getDoctorScoreResVO);
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.checkTimeRange((String)"2022/1/10 17:00:00", (String)DateUtil.TIME));
    }
}

