/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.interceptor;

import com.ebaiyihui.his.pojo.pay.vo.RequestHeaderVO;
import com.ebaiyihui.his.utils.IPUtils;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class OrderInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(OrderInterceptor.class);
    public static ThreadLocal<RequestHeaderVO> headerVOThreadLocal = new ThreadLocal();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        RequestHeaderVO requestHeaderVO = new RequestHeaderVO();
        long timeInMillis = Calendar.getInstance().getTimeInMillis();
        requestHeaderVO.setTimestamp(String.valueOf(timeInMillis));
        String uuid = UUID.randomUUID().toString().replace("-", "").substring(0, 16);
        requestHeaderVO.setNoncestr(uuid);
        String ipAddress = IPUtils.getIpAddress((HttpServletRequest)request);
        requestHeaderVO.setClientIp(ipAddress);
        String appId = request.getHeader("appId");
        requestHeaderVO.setAppId(appId);
        String deviceId = request.getHeader("deviceid");
        requestHeaderVO.setDeviceId(deviceId);
        HashMap<String, String> map = new HashMap<String, String>(10);
        map.put("timestamp", requestHeaderVO.getTimestamp());
        map.put("noncestr", requestHeaderVO.getNoncestr());
        map.put("appid", requestHeaderVO.getAppId());
        map.put("clientip", requestHeaderVO.getClientIp());
        map.put("deviceid", requestHeaderVO.getDeviceId());
        String appSecret = request.getHeader("appsecret");
        List keys = map.keySet().stream().collect(Collectors.toList());
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = (String)map.get(key);
            map.remove(key);
            map.put(key, (value + appSecret).toLowerCase());
        }
        TreeSet sortSet = new TreeSet(new /* Unavailable Anonymous Inner Class!! */);
        sortSet.addAll(map.keySet());
        List collect = sortSet.stream().map(item -> item + (String)map.get(item)).collect(Collectors.toList());
        StringBuffer sb = new StringBuffer();
        collect.stream().forEach(item -> sb.append((String)item));
        String md5 = DigestUtils.md5DigestAsHex((byte[])sb.toString().getBytes(StandardCharsets.UTF_8));
        requestHeaderVO.setSign(md5);
        headerVOThreadLocal.set(requestHeaderVO);
        return true;
    }
}

