/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.his.common.enums.TransNoEnum;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.DoctorDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.DoctorReqDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.DoctorYbDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.DoctorYbReqDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.HisHeadDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.DoctorResVO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.DoctorVO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.DoctorYbResVO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.DoctorYbVO;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.service.DoctorService;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.utils.XmlUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DoctorServiceImpl
implements DoctorService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<List<DoctorResVO>> getDoctorList(DoctorReqDTO param) {
        param.setOperCode("70019");
        param.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        DoctorDTO doctorDTO = new DoctorDTO();
        HisHeadDTO headDTO = new HisHeadDTO();
        headDTO.setSource("HLWYY");
        headDTO.setTransNo(TransNoEnum.HIS_DOCTOR_INFO.getValue());
        doctorDTO.setHeadDTO(headDTO);
        doctorDTO.setDoctorReqDTO(param);
        String converTomXml = XmlUtil.converTomXml((Object)doctorDTO);
        FrontResponse doctorVORes = this.hisRemoteService.hisNewRequest(TransNoEnum.HIS_DOCTOR_INFO.getValue(), converTomXml, DoctorVO.class);
        DoctorVO doctorVO = (DoctorVO)doctorVORes.getBody();
        if (null == doctorVO) {
            return FrontResponse.error((String)doctorVORes.getTransactionId(), (String)"0", (String)doctorVO.getHeadVO().getHisReturnVO().getRetCont());
        }
        if (!"1".equals(doctorVO.getHeadVO().getHisReturnVO().getRetCode())) {
            return FrontResponse.error((String)doctorVORes.getTransactionId(), (String)"0", (String)doctorVO.getHeadVO().getHisReturnVO().getRetCont());
        }
        List doctorResVOS = doctorVO.getDoctorsVO().getDoctorResVOS();
        return FrontResponse.success((String)doctorVORes.getTransactionId(), (Object)doctorResVOS);
    }

    public FrontResponse<DoctorYbResVO> getDoctorYbInfo(DoctorYbReqDTO param) {
        param.setOperCode("70019");
        param.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        DoctorYbDTO doctorDTO = new DoctorYbDTO();
        HisHeadDTO headDTO = new HisHeadDTO();
        headDTO.setSource("HLWYY");
        headDTO.setTransNo(TransNoEnum.HIS_YB_DOCTOR_INFO.getValue());
        doctorDTO.setHeadDTO(headDTO);
        doctorDTO.setDoctorYbReqDTO(param);
        String converTomXml = XmlUtil.converTomXml((Object)doctorDTO);
        FrontResponse doctorVORes = this.hisRemoteService.hisNewRequest(TransNoEnum.HIS_YB_DOCTOR_INFO.getValue(), converTomXml, DoctorYbVO.class);
        this.logger.info("\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c" + JSONObject.toJSONString((Object)doctorVORes));
        DoctorYbVO doctorVO = (DoctorYbVO)doctorVORes.getBody();
        if (!"1".equals(doctorVORes.getCode())) {
            return FrontResponse.error((String)doctorVORes.getTransactionId(), (String)"0", (String)doctorVO.getHeadVO().getRetCont());
        }
        DoctorYbResVO doctorYbResVO = doctorVO.getDoctorsVO().getDoctors().getDoctorYbResVO();
        return FrontResponse.success((String)doctorVORes.getTransactionId(), (Object)doctorYbResVO);
    }
}

