/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.date.DateUtil;
import com.ebaiyihui.his.common.enums.HospitalRegionEnum;
import com.ebaiyihui.his.common.enums.TransNoEnum;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.HisHeadDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.MedicalItemAddDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.MedicalItemAddReqDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.MedicalItemDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.MedicalItemReqDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.MedicalItemAddVO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.MedicalItemVO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.inspection.MedicalItemAddReq;
import com.ebaiyihui.his.pojo.vo.inspection.MedicalItemAddRes;
import com.ebaiyihui.his.pojo.vo.inspection.MedicalItemReq;
import com.ebaiyihui.his.pojo.vo.inspection.MedicalItemRes;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.InspectionService;
import com.ebaiyihui.his.utils.XmlUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InspectionServiceImpl
implements InspectionService {
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<List<MedicalItemRes>> medicalItem(FrontRequest<MedicalItemReq> param) {
        MedicalItemReq medicalItemReq = (MedicalItemReq)param.getBody();
        MedicalItemReqDTO medicalItemReqDTO = new MedicalItemReqDTO();
        BeanUtils.copyProperties((Object)medicalItemReq, (Object)medicalItemReqDTO);
        medicalItemReqDTO.setHospitalCode(HospitalRegionEnum.PJ.getValue());
        medicalItemReqDTO.setOperCode("70019");
        medicalItemReqDTO.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        medicalItemReqDTO.setHlwyyFlag("1");
        MedicalItemDTO medicalItemDTO = new MedicalItemDTO();
        HisHeadDTO headDTO = new HisHeadDTO();
        headDTO.setSource("HLWYY");
        headDTO.setTransNo(TransNoEnum.HIS_INSPECTION.getValue());
        medicalItemDTO.setHeadDTO(headDTO);
        medicalItemDTO.setMedicalItemReqDTO(medicalItemReqDTO);
        String converTomXml = XmlUtil.converTomXml((Object)medicalItemDTO);
        FrontResponse medicalItemVORes = this.hisRemoteService.hisNewRequest(TransNoEnum.HIS_INSPECTION.getValue(), converTomXml, MedicalItemVO.class);
        MedicalItemVO medicalItemVO = (MedicalItemVO)medicalItemVORes.getBody();
        if (null == medicalItemVO) {
            return FrontResponse.error((String)medicalItemVORes.getTransactionId(), (String)"0", (String)medicalItemVO.getHeadVO().getHisReturnVO().getRetCont());
        }
        if (!"1".equals(medicalItemVO.getHeadVO().getHisReturnVO().getRetCode())) {
            return FrontResponse.error((String)medicalItemVORes.getTransactionId(), (String)"0", (String)medicalItemVO.getHeadVO().getHisReturnVO().getRetCont());
        }
        ArrayList medicalItemResList = new ArrayList();
        List medicalItemResVos = medicalItemVO.getMedicalItemResBodyVo().getMedicalItemResVos();
        medicalItemResVos.forEach(medicalItemResVo -> {
            MedicalItemRes medicalItemRes = new MedicalItemRes();
            BeanUtils.copyProperties((Object)medicalItemResVo, (Object)medicalItemRes);
            medicalItemResList.add(medicalItemRes);
        });
        return FrontResponse.success((String)medicalItemVORes.getTransactionId(), medicalItemResList);
    }

    public FrontResponse<List<MedicalItemRes>> patientmedicalItem(FrontRequest<MedicalItemReq> param) {
        MedicalItemReq medicalItemReq = (MedicalItemReq)param.getBody();
        MedicalItemReqDTO medicalItemReqDTO = new MedicalItemReqDTO();
        BeanUtils.copyProperties((Object)medicalItemReq, (Object)medicalItemReqDTO);
        medicalItemReqDTO.setHospitalCode(HospitalRegionEnum.PJ.getValue());
        medicalItemReqDTO.setOperCode("70019");
        medicalItemReqDTO.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        MedicalItemDTO medicalItemDTO = new MedicalItemDTO();
        HisHeadDTO headDTO = new HisHeadDTO();
        headDTO.setSource("HLWYY");
        headDTO.setTransNo(TransNoEnum.PATIENT_HIS_INSPECTION.getValue());
        medicalItemDTO.setHeadDTO(headDTO);
        medicalItemDTO.setMedicalItemReqDTO(medicalItemReqDTO);
        String converTomXml = XmlUtil.converTomXml((Object)medicalItemDTO);
        FrontResponse medicalItemVORes = this.hisRemoteService.hisNewRequest(TransNoEnum.PATIENT_HIS_INSPECTION.getValue(), converTomXml, MedicalItemVO.class);
        MedicalItemVO medicalItemVO = (MedicalItemVO)medicalItemVORes.getBody();
        if (null == medicalItemVO) {
            return FrontResponse.error((String)medicalItemVORes.getTransactionId(), (String)"0", (String)medicalItemVO.getHeadVO().getHisReturnVO().getRetCont());
        }
        if (!"1".equals(medicalItemVO.getHeadVO().getHisReturnVO().getRetCode())) {
            return FrontResponse.error((String)medicalItemVORes.getTransactionId(), (String)"0", (String)medicalItemVO.getHeadVO().getHisReturnVO().getRetCont());
        }
        ArrayList medicalItemResList = new ArrayList();
        List medicalItemResVos = medicalItemVO.getMedicalItemResBodyVo().getPatMedicalItemResVos();
        medicalItemResVos.forEach(medicalItemResVo -> {
            MedicalItemRes medicalItemRes = new MedicalItemRes();
            BeanUtils.copyProperties((Object)medicalItemResVo, (Object)medicalItemRes);
            medicalItemRes.setMedicalItemPrice(medicalItemResVo.getPrice());
            medicalItemResList.add(medicalItemRes);
        });
        return FrontResponse.success((String)medicalItemVORes.getTransactionId(), medicalItemResList);
    }

    public FrontResponse<List<MedicalItemAddRes>> medicalItemAdd(FrontRequest<MedicalItemAddReq> param) {
        MedicalItemAddReq medicalItemAddReq = (MedicalItemAddReq)param.getBody();
        MedicalItemAddReqDTO medicalItemAddReqDTO = new MedicalItemAddReqDTO();
        BeanUtils.copyProperties((Object)medicalItemAddReq, (Object)medicalItemAddReqDTO);
        medicalItemAddReqDTO.setHospitalCode(HospitalRegionEnum.PJ.getValue());
        medicalItemAddReqDTO.setOperCode("70019");
        medicalItemAddReqDTO.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        MedicalItemAddDTO medicalItemAddDTO = new MedicalItemAddDTO();
        HisHeadDTO headDTO = new HisHeadDTO();
        headDTO.setSource("HLWYY");
        headDTO.setTransNo(TransNoEnum.HIS_INSPECTION_SURCHARGE.getValue());
        medicalItemAddDTO.setHeadDTO(headDTO);
        medicalItemAddDTO.setMedicalItemAddReqDTO(medicalItemAddReqDTO);
        String converTomXml = XmlUtil.converTomXml((Object)medicalItemAddDTO);
        FrontResponse medicalItemAddVORes = this.hisRemoteService.hisNewRequest(TransNoEnum.HIS_INSPECTION_SURCHARGE.getValue(), converTomXml, MedicalItemAddVO.class);
        MedicalItemAddVO medicalItemAddVO = (MedicalItemAddVO)medicalItemAddVORes.getBody();
        if (null == medicalItemAddVO) {
            return FrontResponse.error((String)medicalItemAddVORes.getTransactionId(), (String)"0", (String)medicalItemAddVO.getHeadVO().getHisReturnVO().getRetCont());
        }
        if (!"1".equals(medicalItemAddVO.getHeadVO().getHisReturnVO().getRetCode())) {
            return FrontResponse.error((String)medicalItemAddVORes.getTransactionId(), (String)"0", (String)medicalItemAddVO.getHeadVO().getHisReturnVO().getRetCont());
        }
        ArrayList medicalItemAddResList = new ArrayList();
        List medicalItemAddResVOS = medicalItemAddVO.getMedicalItemAddBodyVO().getMedicalItemAddResVOS();
        if (null != medicalItemAddResVOS && medicalItemAddResVOS.size() > 0) {
            medicalItemAddResVOS.forEach(medicalItemAddResVO -> {
                MedicalItemAddRes medicalItemAddRes = new MedicalItemAddRes();
                BeanUtils.copyProperties((Object)medicalItemAddResVO, (Object)medicalItemAddRes);
                medicalItemAddResList.add(medicalItemAddRes);
            });
        }
        return FrontResponse.success((String)medicalItemAddVORes.getTransactionId(), medicalItemAddResList);
    }
}

