/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpKit;
import com.ebaiyihui.his.config.MedicalInsuranceConfig;
import com.ebaiyihui.his.config.NodeConfig;
import com.ebaiyihui.his.mapper.MedicalInsuranceOrderMapper;
import com.ebaiyihui.his.pojo.dto.MedicalInsuranceDto;
import com.ebaiyihui.his.pojo.dto.MedicalPayDto;
import com.ebaiyihui.his.pojo.dto.MedicalRefundDto;
import com.ebaiyihui.his.pojo.dto.MedicalResultDto;
import com.ebaiyihui.his.pojo.entity.MedicalInsuranceOrder;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.MedicalNotifyReq;
import com.ebaiyihui.his.pojo.vo.MedicalPayVo;
import com.ebaiyihui.his.pojo.vo.MedicalQueryVo;
import com.ebaiyihui.his.pojo.vo.MedicalRefundVo;
import com.ebaiyihui.his.pojo.vo.MedicalResultVo;
import com.ebaiyihui.his.pojo.vo.MedicalUrlVo;
import com.ebaiyihui.his.service.MedicalInsuranceService;
import com.ebaiyihui.his.utils.HttpUtils;
import com.ebaiyihui.his.utils.RedisUtil;
import com.ebaiyihui.his.utils.SdyRequestUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class MedicalInsuranceServiceImpl
implements MedicalInsuranceService {
    private static final Logger log = LoggerFactory.getLogger(MedicalInsuranceServiceImpl.class);
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private ObjectMapper objectMapper;
    @Resource
    private MedicalInsuranceOrderMapper medicalInsuranceOrderMapper;
    @Resource
    private MedicalInsuranceConfig medicalInsuranceConfig;
    @Autowired
    private NodeConfig nodeConfig;

    public BaseResponse<MedicalRefundDto> onlineRefund(MedicalRefundVo medicalRefundVo) {
        log.info("\u8fdb\u5165\u533b\u4fdd\u7ebf\u4e0a\u9000\u8d39\uff0c\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)medicalRefundVo));
        LinkedHashMap<String, Object> innerParam = new LinkedHashMap<String, Object>();
        Map params = SdyRequestUtil.publicParamByPlain(innerParam);
        innerParam.put("appId", "1GB7LT8LO00176430B0A00001331DF77");
        innerParam.put("cashRefdAmt", medicalRefundVo.getCashRefdAmt());
        innerParam.put("ecToken", medicalRefundVo.getEcToken());
        innerParam.put("extData", medicalRefundVo.getExtData());
        innerParam.put("fundRefdAmt", medicalRefundVo.getFundRefdAmt());
        innerParam.put("medOrgOrd", medicalRefundVo.getMedOrgOrd());
        innerParam.put("orgCodg", "H32050800113");
        innerParam.put("payToken", medicalRefundVo.getPayToken());
        innerParam.put("psnAcctRefdAmt", medicalRefundVo.getPsnAcctRefdAmt());
        innerParam.put("qrCode", medicalRefundVo.getQrCode());
        innerParam.put("refdType", "ALL");
        innerParam.put("totlRefdAmt", medicalRefundVo.getTotlRefdAmt());
        innerParam.put("businessType", "2");
        String requestUrl = this.medicalInsuranceConfig.getRequestAddr() + this.medicalInsuranceConfig.getOnlineRefundHttp();
        log.info("\u8bf7\u6c426266\u63a5\u53e3\u5730\u5740{},\u672a\u52a0\u5bc6\u5165\u53c2{}", (Object)requestUrl, (Object)JSONObject.toJSONString((Object)params));
        try {
            String result = HttpKit.jsonPost((String)requestUrl, (String)JSONObject.toJSONString((Object)params));
            log.info("\u8bf7\u6c426266\u63a5\u53e3\u8fd4\u56de{}", (Object)JSONObject.toJSONString((Object)result));
            JSONObject resultObject = JSONObject.parseObject((String)result);
            if (resultObject.get((Object)"code").equals(0)) {
                String encData = resultObject.get((Object)this.medicalInsuranceConfig.getResponseStr()).toString();
                MedicalRefundDto medicalRefundDto = (MedicalRefundDto)JSONObject.parseObject((String)encData, MedicalRefundDto.class);
                return BaseResponse.success((Object)medicalRefundDto);
            }
            String message = resultObject.get((Object)"message").toString();
            return BaseResponse.error((String)message);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c426266\u63a5\u53e3\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    public BaseResponse<String> orderCancel(MedicalResultVo medicalResultVo) {
        log.info("\u8fdb\u5165\u533b\u4fdd\u8ba2\u5355\u64a4\u9500\uff0c\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)medicalResultVo));
        LinkedHashMap<String, String> innerParam = new LinkedHashMap<String, String>();
        Map params = SdyRequestUtil.publicParamByPlain(innerParam);
        innerParam.put("appId", "1GB7LT8LO00176430B0A00001331DF77");
        innerParam.put("medOrgOrd", medicalResultVo.getMedOrgOrd());
        innerParam.put("orgCodg", "H32050800113");
        String requestUrl = this.medicalInsuranceConfig.getRequestAddr() + this.medicalInsuranceConfig.getOrderCancelHttp();
        log.info("\u8bf7\u6c426461\u63a5\u53e3\u5730\u5740{},\u660e\u6587\u5165\u53c2{}", (Object)requestUrl, (Object)JSONObject.toJSONString((Object)params));
        try {
            String result = HttpKit.jsonPost((String)requestUrl, (String)JSONObject.toJSONString((Object)params));
            log.info("\u8bf7\u6c426461\u63a5\u53e3\u8fd4\u56de\u503c{}", (Object)JSONObject.toJSONString((Object)result));
            JSONObject resultObject = JSONObject.parseObject((String)result);
            if (resultObject.get((Object)"code").equals(0)) {
                String encData = resultObject.get((Object)this.medicalInsuranceConfig.getResponseStr()).toString();
                String success = JSONObject.parseObject((String)encData).get((Object)"success").toString();
                return BaseResponse.success((Object)success);
            }
            String message = resultObject.get((Object)"message").toString();
            return BaseResponse.error((String)message);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c426461\u63a5\u53e3\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    public String payNotify(JSONObject jsonObject) {
        String str;
        MedicalNotifyReq medicalNotifyReq;
        boolean outcome = true;
        log.info("==========>\u6536\u5230\u533b\u4fdd\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u3010\u6210\u529f\u65f6\u56de\u8c03\u3011\u5f00\u59cb\u89e3\u6790\u53c2\u6570:{}", (Object)jsonObject);
        try {
            medicalNotifyReq = (MedicalNotifyReq)this.objectMapper.readValue(JSON.toJSONString((Object)jsonObject), MedicalNotifyReq.class);
            JSONObject chargeLeader = jsonObject.getJSONObject("data");
            String extData = ObjectUtils.isEmpty((Object)chargeLeader) ? "" : chargeLeader.getString("extData");
            medicalNotifyReq.getData().setJsonStringExtData(extData);
        }
        catch (Exception e) {
            log.info("\u533b\u4fdd\u56de\u8c03\u89e3\u6790\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            e.printStackTrace();
            return JSONObject.toJSONString((Object)SdyRequestUtil.errorPublicResponse((String)this.medicalInsuranceConfig.getResponseStr(), null));
        }
        log.info("==========>\u533b\u4fdd\u652f\u4ed8\u56de\u8c03\u6570\u636e\u89e3\u6790\u5b8c\u6210:\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)medicalNotifyReq));
        if ("2".equals(medicalNotifyReq.getData().getCallType())) {
            try {
                log.info("==========><\u652f\u4ed8\u56de\u8c03>\u3010\u8bca\u7597\u3011\u8bf7\u6c42\u5730\u5740:{}", (Object)this.nodeConfig.getHealthCarePaymentCallbacksDiagnosisUrl());
                str = HttpUtils.post((String)this.nodeConfig.getHealthCarePaymentCallbacksDiagnosisUrl(), null, (String)JSON.toJSONString((Object)medicalNotifyReq));
                log.info("==========><\u652f\u4ed8\u56de\u8c03>\u3010\u8bca\u7597\u3011\u4e92\u8054\u7f51\u533b\u9662\u8fd4\u56de\u539f\u59cb\u6570\u636e{}", (Object)str);
            }
            catch (Exception e) {
                log.error("<\u652f\u4ed8\u56de\u8c03>\u3010\u8bca\u7597\u3011\u8bf7\u6c42\u4e92\u8054\u7f51\u533b\u9662\u5730\u5740\u56de\u8c03\u51fa\u73b0\u9519\u8bef", (Throwable)e);
                e.printStackTrace();
                outcome = false;
            }
            try {
                log.info("==========><\u652f\u4ed8\u56de\u8c03>\u3010\u533b\u836f\u4e91\u3011\u8bf7\u6c42\u4e92\u8054\u7f51\u533b\u9662\u5730\u5740:{}", (Object)this.nodeConfig.getHealthCarePaymentPharmaCloudUrl());
                str = HttpUtils.post((String)this.nodeConfig.getHealthCarePaymentPharmaCloudUrl(), null, (String)JSON.toJSONString((Object)medicalNotifyReq));
                log.info("==========><\u652f\u4ed8\u56de\u8c03>\u3010\u533b\u836f\u4e91\u3011\u4e92\u8054\u7f51\u533b\u9662\u8fd4\u56de\u539f\u59cb\u6570\u636e{}", (Object)str);
            }
            catch (Exception e) {
                log.error("<\u652f\u4ed8\u56de\u8c03>\u3010\u533b\u836f\u4e91\u3011\u8bf7\u6c42\u4e92\u8054\u7f51\u533b\u9662\u5730\u5740\u56de\u8c03\u51fa\u73b0\u9519\u8bef", (Throwable)e);
                e.printStackTrace();
                outcome = false;
            }
        } else if ("4".equals(medicalNotifyReq.getData().getCallType())) {
            try {
                log.info("==========><\u9000\u6b3e\u56de\u8c03>\u3010\u8bca\u7597\u3011\u8bf7\u6c42\u5730\u5740:{}", (Object)this.nodeConfig.getHealthFundamentalCallbacksDiagnosisUrl());
                str = HttpUtils.post((String)this.nodeConfig.getHealthFundamentalCallbacksDiagnosisUrl(), null, (String)JSON.toJSONString((Object)medicalNotifyReq));
                log.info("==========><\u9000\u6b3e\u56de\u8c03>\u3010\u8bca\u7597\u3011\u4e92\u8054\u7f51\u533b\u9662\u8fd4\u56de\u539f\u59cb\u6570\u636e{}", (Object)str);
            }
            catch (Exception e) {
                log.error("<\u9000\u6b3e\u56de\u8c03>\u3010\u8bca\u7597\u3011\u8bf7\u6c42\u4e92\u8054\u7f51\u533b\u9662\u5730\u5740\u56de\u8c03\u51fa\u73b0\u9519\u8bef", (Throwable)e);
                e.printStackTrace();
                outcome = false;
            }
            try {
                log.info("==========><\u9000\u6b3e\u56de\u8c03>\u3010\u533b\u836f\u4e91\u3011\u8bf7\u6c42\u4e92\u8054\u7f51\u533b\u9662\u5730\u5740:{}", (Object)this.nodeConfig.getHealthCareFundamentPharmaCloudUrl());
                str = HttpUtils.post((String)this.nodeConfig.getHealthCareFundamentPharmaCloudUrl(), null, (String)JSON.toJSONString((Object)medicalNotifyReq));
                log.info("==========><\u9000\u6b3e\u56de\u8c03>\u3010\u533b\u836f\u4e91\u3011\u4e92\u8054\u7f51\u533b\u9662\u8fd4\u56de\u539f\u59cb\u6570\u636e{}", (Object)str);
            }
            catch (Exception e) {
                log.error("<\u9000\u6b3e\u56de\u8c03>\u3010\u533b\u836f\u4e91\u3011\u8bf7\u6c42\u4e92\u8054\u7f51\u533b\u9662\u5730\u5740\u56de\u8c03\u51fa\u73b0\u9519\u8bef", (Throwable)e);
                e.printStackTrace();
                outcome = false;
            }
        }
        if (!outcome) {
            return JSONObject.toJSONString((Object)SdyRequestUtil.errorPublicResponse((String)this.medicalInsuranceConfig.getResponseStr(), null));
        }
        return JSONObject.toJSONString((Object)SdyRequestUtil.successPublicResponse((String)this.medicalInsuranceConfig.getResponseStr(), null));
    }

    public BaseResponse<MedicalResultDto> getPayResult(MedicalResultVo medicalResultVo) {
        LinkedHashMap<String, String> innerParam = new LinkedHashMap<String, String>();
        Map params = SdyRequestUtil.publicParamByPlain(innerParam);
        innerParam.put("appId", "1GB7LT8LO00176430B0A00001331DF77");
        innerParam.put("medOrgOrd", medicalResultVo.getMedOrgOrd());
        innerParam.put("orgCodg", "H32050800113");
        String requestUrl = this.medicalInsuranceConfig.getRequestAddr() + this.medicalInsuranceConfig.getPayResultHttp();
        log.info("\u67e5\u8be26360\u63a5\u53e3\u5730\u5740{},\u660e\u6587\u5165\u53c2{}", (Object)requestUrl, (Object)JSONObject.toJSONString((Object)params));
        try {
            String result = HttpKit.jsonPost((String)requestUrl, (String)JSONObject.toJSONString((Object)params));
            log.info("\u8bf7\u6c426360\u63a5\u53e3\u8fd4\u56de{}", (Object)JSONObject.toJSONString((Object)result));
            JSONObject resultObject = JSONObject.parseObject((String)result);
            if (resultObject.get((Object)"code").equals(0)) {
                String encData = resultObject.get((Object)this.medicalInsuranceConfig.getResponseStr()).toString();
                MedicalResultDto medicalResultDto = (MedicalResultDto)JSONObject.parseObject((String)encData, MedicalResultDto.class);
                MedicalInsuranceOrder order = (MedicalInsuranceOrder)this.medicalInsuranceOrderMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"med_org_ord", (Object)medicalResultDto.getMedOrgOrd()));
                BeanUtils.copyProperties((Object)medicalResultDto, (Object)order);
                if (ObjectUtils.isEmpty((Object)order)) {
                    this.medicalInsuranceOrderMapper.insert((Object)order);
                } else {
                    this.medicalInsuranceOrderMapper.updateById((Object)order);
                }
                return BaseResponse.success((Object)medicalResultDto);
            }
            String message = resultObject.get((Object)"message").toString();
            return BaseResponse.error((String)message);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c426360\u63a5\u53e3\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    public BaseResponse<MedicalPayDto> jumpToPay(MedicalPayVo medicalPayVo) {
        LinkedHashMap<String, Object> innerParam = new LinkedHashMap<String, Object>();
        Map params = SdyRequestUtil.publicParamByPlain(innerParam);
        LinkedHashMap<String, String> inParam = new LinkedHashMap<String, String>();
        String token = this.redisUtil.get("TOKEN").toString();
        inParam.put("accessToken", token);
        inParam.put("source", "jsybyapp");
        innerParam.put("appId", "1GB7LT8LO00176430B0A00001331DF77");
        innerParam.put("authMeta", inParam);
        innerParam.put("businessType", "0");
        innerParam.put("envVersion", this.medicalInsuranceConfig.envVersion);
        innerParam.put("medOrgOrd", medicalPayVo.getMedOrgOrd());
        innerParam.put("method", "ALL");
        innerParam.put("orgCodg", "H32050800113");
        innerParam.put("chnlSource", "hlwyy");
        innerParam.put("businessType", medicalPayVo.getBusinessType());
        String requestUrl = this.medicalInsuranceConfig.getRequestAddr() + this.medicalInsuranceConfig.getJumpToPayHttp();
        try {
            log.info("\u8bf7\u6c426470\u63a5\u53e3\u5730\u5740{},\u660e\u6587\u5165\u53c2{}", (Object)requestUrl, (Object)JSONObject.toJSONString((Object)params));
            String result = HttpKit.jsonPost((String)requestUrl, (String)JSONObject.toJSONString((Object)params));
            log.info("\u8bf7\u6c426470\u63a5\u53e3\u8fd4\u56de\u503c{}", (Object)JSONObject.toJSONString((Object)result));
            JSONObject resultObject = JSONObject.parseObject((String)result);
            if (resultObject.get((Object)"code").equals(0)) {
                String encData = resultObject.get((Object)this.medicalInsuranceConfig.getResponseStr()).toString();
                String url = JSONObject.parseObject((String)encData).get((Object)"url").toString();
                MedicalPayDto medicalPayDto = new MedicalPayDto();
                medicalPayDto.setUrl(url);
                medicalPayDto.setMedOrgOrd(medicalPayVo.getMedOrgOrd());
                medicalPayDto.setAccessToken(token);
                medicalPayDto.setAppId("1GB7LT8LO00176430B0A00001331DF77");
                medicalPayDto.setBusinessType(medicalPayVo.getBusinessType());
                medicalPayDto.setEnvVersion("trial");
                medicalPayDto.setMethod("ALL");
                medicalPayDto.setOrgCodg("H32050800113");
                medicalPayDto.setSource("jsybyapp");
                medicalPayDto.setChnlSource("hlwyy");
                return BaseResponse.success((Object)medicalPayDto);
            }
            String message = resultObject.get((Object)"message").toString();
            return BaseResponse.error((String)message);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u53d1\u9001\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    public MedicalInsuranceDto getWxUrl(MedicalUrlVo medicalUrlVo) {
        MedicalInsuranceDto medicalInsuranceDto = new MedicalInsuranceDto();
        String accessToken = this.getSdyAccessToken(medicalUrlVo);
        medicalInsuranceDto.setAccessToken(accessToken);
        StringBuilder builder = new StringBuilder();
        String schemeUrl = builder.append(this.medicalInsuranceConfig.getWxSchemaHttp()).append("?access_token=").append(accessToken).toString();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        HashMap<String, String> innerParam = new HashMap<String, String>();
        innerParam.put("path", medicalUrlVo.getPath());
        String query = "accessToken=" + medicalUrlVo.getAccessToken() + "&orgCodg=" + medicalUrlVo.getOrgCodg();
        innerParam.put("query", query);
        innerParam.put("env_version", medicalUrlVo.getEnvVersion());
        params.put("jump_wxa", innerParam);
        params.put("is_expire", Boolean.valueOf(true));
        params.put("expire_type", Integer.valueOf(1));
        params.put("expire_interval", Integer.valueOf(30));
        String openlink = "";
        try {
            String result = HttpKit.jsonPost((String)schemeUrl, (String)JSON.toJSONString(params));
            log.info("\u8bf7\u6c42\u5fae\u4fe1scheme\u8fd4\u56de{}", (Object)JSONObject.toJSONString((Object)result));
            if (JSONObject.parseObject((String)result).get((Object)"errcode").equals(0)) {
                openlink = JSONObject.parseObject((String)result).get((Object)"openlink").toString();
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001scheme\u8bf7\u6c42\u51fa\u9519", (Throwable)e);
        }
        medicalInsuranceDto.setWxUrl(openlink);
        return medicalInsuranceDto;
    }

    private String getSdyAccessToken(MedicalUrlVo medicalUrlVo) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "client_credential");
        params.put("appid", medicalUrlVo.getAppId());
        params.put("secret", medicalUrlVo.getAppSercert());
        String url = this.medicalInsuranceConfig.getWxAccessHttp();
        try {
            String result = HttpKit.get((String)url, params);
            log.info("\u8bf7\u6c42accessToken\u8fd4\u56de\u503c{}", (Object)JSONObject.toJSONString((Object)result));
            String access_token = JSONObject.parseObject((String)result).get((Object)"access_token").toString();
            String expires_in = JSONObject.parseObject((String)result).get((Object)"expires_in").toString();
            return access_token;
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u62a5\u9519", (Throwable)e);
            return null;
        }
    }

    public String jumpToHospital(String params) {
        log.info("6471\u5165\u53c2{}", (Object)params);
        String encData = JSONObject.parseObject((String)params).get((Object)this.medicalInsuranceConfig.getResponseStr()).toString();
        log.info("6471\u5165\u53c2\u83b7\u53d6encData={}", (Object)encData);
        MedicalQueryVo medicalQueryVo = (MedicalQueryVo)JSONObject.parseObject((String)encData, MedicalQueryVo.class);
        this.redisUtil.set("TOKEN", (Object)medicalQueryVo.getAccessToken());
        MedicalUrlVo medicalUrlVo = new MedicalUrlVo();
        medicalUrlVo.setAppId("wx2ada99edc8d3b1df");
        medicalUrlVo.setAppSercert("17b55e44dd3148fd9a78c6ef0ab3e2ec");
        medicalUrlVo.setPath("pages/index/main/index");
        medicalUrlVo.setAppCode("SDY");
        BeanUtils.copyProperties((Object)medicalQueryVo, (Object)medicalUrlVo);
        log.info("\u8bf7\u6c42schema\u53c2\u6570{}", (Object)JSONObject.toJSONString((Object)medicalQueryVo));
        MedicalInsuranceDto wxUrl = this.getWxUrl(medicalUrlVo);
        log.info("\u83b7\u53d6wxUrl={}", (Object)JSONObject.toJSONString((Object)wxUrl));
        String url = wxUrl.getWxUrl();
        if (StringUtils.isEmpty((Object)url)) {
            SdyRequestUtil.publicResponse((Integer)-1, (String)"plain", (String)"plain", null, (Object)"\u83b7\u53d6\u5fae\u4fe1schema\u5931\u8d25", (boolean)false, (String)this.medicalInsuranceConfig.getResponseStr(), null);
        }
        LinkedHashMap<String, String> innermap = new LinkedHashMap<String, String>();
        innermap.put("url", url);
        Map map = SdyRequestUtil.publicResponse((Integer)0, (String)"plain", (String)"plain", null, (Object)"\u6210\u529f", (boolean)true, (String)this.medicalInsuranceConfig.getResponseStr(), innermap);
        String response = JSONObject.toJSONString((Object)map);
        log.info("6471\u8fd4\u56de\u54cd\u5e94{}", (Object)response);
        return response;
    }
}

