/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.utils;

import com.ebaiyihui.his.utils.SslUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class HttpSslUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpSslUtils.class);

    public String postRequest(String urlAddress, String args, Map<String, String> headers, int timeOut) throws Exception {
        OutputStream out = null;
        BufferedReader in = null;
        String result = "";
        try {
            String line;
            URL url = new URL(urlAddress);
            if ("https".equalsIgnoreCase(url.getProtocol())) {
                SslUtils.ignoreSsl();
            }
            URLConnection connection = url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setConnectTimeout(timeOut);
            connection.setReadTimeout(timeOut);
            if (!CollectionUtils.isEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            out = connection.getOutputStream();
            out.write(args.getBytes("utf-8"));
            out.flush();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001 POST \u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
            e.printStackTrace();
            throw new Exception(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }
}

