/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.utils.medicalInsurance;

import cn.hsaf.common.utils.BCUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.spec.SM2ParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

/*
 * Exception performing whole class analysis ignored.
 */
public class EasyGmUtils {
    private static X9ECParameters x9ECParameters = GMNamedCurves.getByName((String)"sm2p256v1");
    private static ECDomainParameters ecDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
    private static ECParameterSpec ecParameterSpec = new ECParameterSpec(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
    private static final int RS_LEN = 32;

    public static byte[] signSm3WithSm2(byte[] msg, byte[] userId, byte[] privateKeyBytes) {
        BCECPrivateKey bcecPrivateKey = EasyGmUtils.getPrivatekeyFromD((BigInteger)BigIntegers.fromUnsignedByteArray((byte[])privateKeyBytes));
        return EasyGmUtils.signSm3WithSm2((byte[])msg, (byte[])userId, (PrivateKey)bcecPrivateKey);
    }

    public static byte[] signSm3WithSm2(byte[] msg, byte[] userId, PrivateKey privateKey) {
        return EasyGmUtils.rsAsn1ToPlainByteArray((byte[])EasyGmUtils.signSm3WithSm2Asn1Rs((byte[])msg, (byte[])userId, (PrivateKey)privateKey));
    }

    public static byte[] signSm3WithSm2Asn1Rs(byte[] msg, byte[] userId, PrivateKey privateKey) {
        try {
            SM2ParameterSpec parameterSpec = new SM2ParameterSpec(userId);
            Signature signer = BCUtils.getSignature((String)"SM3withSM2");
            signer.initSign(privateKey, new SecureRandom());
            signer.update(msg, 0, msg.length);
            byte[] sig = signer.sign();
            return sig;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean verifySm3WithSm2(byte[] msg, byte[] userId, byte[] rs, byte[] publicKeyBytes) {
        BigInteger y;
        BigInteger x;
        if (publicKeyBytes.length != 64 && publicKeyBytes.length != 65) {
            throw new RuntimeException("err key length");
        }
        if (publicKeyBytes.length > 64) {
            x = BigIntegers.fromUnsignedByteArray((byte[])publicKeyBytes, (int)1, (int)32);
            y = BigIntegers.fromUnsignedByteArray((byte[])publicKeyBytes, (int)33, (int)32);
        } else {
            x = BigIntegers.fromUnsignedByteArray((byte[])publicKeyBytes, (int)0, (int)32);
            y = BigIntegers.fromUnsignedByteArray((byte[])publicKeyBytes, (int)32, (int)32);
        }
        BCECPublicKey bcecPublicKey = EasyGmUtils.getPublickeyFromXY((BigInteger)x, (BigInteger)y);
        return EasyGmUtils.verifySm3WithSm2((byte[])msg, (byte[])userId, (byte[])rs, (PublicKey)bcecPublicKey);
    }

    public static boolean verifySm3WithSm2(byte[] msg, byte[] userId, byte[] rs, PublicKey publicKey) {
        return EasyGmUtils.verifySm3WithSm2Asn1Rs((byte[])msg, (byte[])userId, (byte[])EasyGmUtils.rsPlainByteArrayToAsn1((byte[])rs), (PublicKey)publicKey);
    }

    public static boolean verifySm3WithSm2Asn1Rs(byte[] msg, byte[] userId, byte[] rs, PublicKey publicKey) {
        try {
            Signature verifier = BCUtils.getSignature((String)"SM3withSM2");
            verifier.initVerify(publicKey);
            verifier.update(msg, 0, msg.length);
            return verifier.verify(rs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] changeC1C2C3ToC1C3C2(byte[] c1c2c3) {
        int c1Len = (x9ECParameters.getCurve().getFieldSize() + 7) / 8 * 2 + 1;
        int c3Len = 32;
        byte[] result = new byte[c1c2c3.length];
        System.arraycopy(c1c2c3, 0, result, 0, c1Len);
        System.arraycopy(c1c2c3, c1c2c3.length - 32, result, c1Len, 32);
        System.arraycopy(c1c2c3, c1Len, result, c1Len + 32, c1c2c3.length - c1Len - 32);
        return result;
    }

    private static byte[] changeC1C3C2ToC1C2C3(byte[] c1c3c2) {
        int c1Len = (x9ECParameters.getCurve().getFieldSize() + 7) / 8 * 2 + 1;
        int c3Len = 32;
        byte[] result = new byte[c1c3c2.length];
        System.arraycopy(c1c3c2, 0, result, 0, c1Len);
        System.arraycopy(c1c3c2, c1Len + 32, result, c1Len, c1c3c2.length - c1Len - 32);
        System.arraycopy(c1c3c2, c1Len, result, c1c3c2.length - 32, 32);
        return result;
    }

    private static byte[] bigIntToFixexLengthBytes(BigInteger rOrS) {
        byte[] rs = rOrS.toByteArray();
        if (rs.length == 32) {
            return rs;
        }
        if (rs.length == 33 && rs[0] == 0) {
            return Arrays.copyOfRange(rs, 1, 33);
        }
        if (rs.length < 32) {
            byte[] result = new byte[32];
            Arrays.fill(result, (byte)0);
            System.arraycopy(rs, 0, result, 32 - rs.length, rs.length);
            return result;
        }
        throw new RuntimeException("err rs: " + Hex.toHexString((byte[])rs));
    }

    private static byte[] rsAsn1ToPlainByteArray(byte[] rsDer) {
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)rsDer);
        byte[] r = EasyGmUtils.bigIntToFixexLengthBytes((BigInteger)ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue());
        byte[] s = EasyGmUtils.bigIntToFixexLengthBytes((BigInteger)ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getValue());
        byte[] result = new byte[64];
        System.arraycopy(r, 0, result, 0, r.length);
        System.arraycopy(s, 0, result, 32, s.length);
        return result;
    }

    private static byte[] rsPlainByteArrayToAsn1(byte[] sign) {
        if (sign.length != 64) {
            throw new RuntimeException("err rs. ");
        }
        BigInteger r = new BigInteger(1, Arrays.copyOfRange(sign, 0, 32));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange(sign, 32, 64));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        try {
            return new DERSequence(v).getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static BCECPrivateKey getPrivatekeyFromD(BigInteger d) {
        ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(d, ecParameterSpec);
        return new BCECPrivateKey("EC", ecPrivateKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    public static BCECPublicKey getPublickeyFromXY(BigInteger x, BigInteger y) {
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(x9ECParameters.getCurve().createPoint(x, y), ecParameterSpec);
        return new BCECPublicKey("EC", ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    public static byte[] sm2Decrypt(byte[] data, PrivateKey key) {
        return EasyGmUtils.sm2DecryptOld((byte[])EasyGmUtils.changeC1C3C2ToC1C2C3((byte[])data), (PrivateKey)key);
    }

    public static byte[] sm2Encrypt(byte[] data, PublicKey key) {
        return EasyGmUtils.changeC1C2C3ToC1C3C2((byte[])EasyGmUtils.sm2EncryptOld((byte[])data, (PublicKey)key));
    }

    public static byte[] sm2EncryptOld(byte[] data, PublicKey key) {
        BCECPublicKey localECPublicKey = (BCECPublicKey)key;
        ECPublicKeyParameters ecPublicKeyParameters = new ECPublicKeyParameters(localECPublicKey.getQ(), ecDomainParameters);
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)ecPublicKeyParameters, new SecureRandom()));
        try {
            return sm2Engine.processBlock(data, 0, data.length);
        }
        catch (InvalidCipherTextException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] sm2DecryptOld(byte[] data, PrivateKey key) {
        BCECPrivateKey localECPrivateKey = (BCECPrivateKey)key;
        ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(localECPrivateKey.getD(), ecDomainParameters);
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(false, (CipherParameters)ecPrivateKeyParameters);
        try {
            return sm2Engine.processBlock(data, 0, data.length);
        }
        catch (InvalidCipherTextException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] sm4Encrypt(byte[] keyBytes, byte[] plain) {
        if (keyBytes.length != 16) {
            throw new RuntimeException("err key length");
        }
        try {
            SecretKeySpec key = new SecretKeySpec(keyBytes, "SM4");
            Cipher out = BCUtils.getCipher((String)"SM4/ECB/PKCS7Padding");
            out.init(1, key);
            return out.doFinal(plain);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] sm4Decrypt(byte[] keyBytes, byte[] cipher) {
        if (cipher.length % 16 != 0) {
            throw new RuntimeException("err data length");
        }
        try {
            SecretKeySpec key = new SecretKeySpec(keyBytes, "SM4");
            Cipher in = BCUtils.getCipher((String)"SM4/ECB/PKCS7Padding");
            in.init(2, key);
            return in.doFinal(cipher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        byte[] msg = "1234567890".getBytes();
        byte[] userId = "D91CEB11EE62219CD91CEB11EE62219C".getBytes();
        byte[] prvkey = Hex.decode((String)"5B015D0B2C0B6BEBB27EA8");
        byte[] pubkey = Hex.decode((String)"409AEFE32E150677FC2372B758178ECBAD3BBED494975596B3CD603C36F9ED7E690A5B052AFDBD86D46288FA9919BA05F3D48F6532EB28DC02D0DAA35689A50C");
        prvkey = Base64.getDecoder().decode("JShsBOJL0RgPAoPttEB1hgtPAvCikOl0V1oTOYL7k5U=");
        pubkey = Base64.getDecoder().decode("BE8d9gaaCGrE4dHErWCjqyahm6X8l6Rd7fOGx0gNyrGPp0XDoPbbpu1pk9A2fZ9rEsBtwB1Aecnto/gH4h+T7cY=");
        byte[] asig = EasyGmUtils.signSm3WithSm2((byte[])msg, (byte[])userId, (byte[])prvkey);
        System.out.println(Hex.toHexString((byte[])asig));
        boolean verified = EasyGmUtils.verifySm3WithSm2((byte[])msg, (byte[])userId, (byte[])asig, (byte[])pubkey);
        System.out.println(verified);
        String plainString = "1234567890abcdef";
        byte[] plain = plainString.getBytes();
        System.out.println(new String(plain));
        byte[] sm4key = "0123456789abcdef".getBytes();
        byte[] bs = EasyGmUtils.sm4Encrypt((byte[])sm4key, (byte[])plain);
        System.out.println(Hex.toHexString((byte[])bs));
        bs = EasyGmUtils.sm4Decrypt((byte[])sm4key, (byte[])bs);
        System.out.println(new String(bs));
        System.out.println(Hex.toHexString((byte[])bs));
    }
}

