/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicarecore.ybBusiness.service.prescription.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.medicarecore.ybBusiness.common.YbCommitUtil;
import com.ebaiyihui.medicarecore.ybBusiness.domain.ResultResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.database.YbPrescriptionConfigEntity;
import com.ebaiyihui.medicarecore.ybBusiness.domain.prescription.BasePrescriptionResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.prescription.request.FileUpldRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.prescription.request.FixmedinsSignRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.prescription.request.RxSetlStockQueryRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.prescription.request.RxUodoRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.prescription.request.UploadChkRequest;
import com.ebaiyihui.medicarecore.ybBusiness.domain.prescription.response.FileUpldResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.prescription.response.FixmedinsSignResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.prescription.response.RxSetlStockQueryResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.prescription.response.RxUndoResponse;
import com.ebaiyihui.medicarecore.ybBusiness.domain.prescription.response.UploadChkResponse;
import com.ebaiyihui.medicarecore.ybBusiness.mapper.YbPrescriptionConfigMapper;
import com.ebaiyihui.medicarecore.ybBusiness.service.prescription.PrescriptionService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrescriptionServiceImpl
implements PrescriptionService {
    private static final Logger log = LoggerFactory.getLogger(PrescriptionServiceImpl.class);
    public static final String PRESCRIPTION_TEST_URL = "http://10.77.245.22:9001/epc/api";
    public static final String PRESCRIPTION_URL = "http://10.77.197.139/csb";
    @Autowired
    private YbCommitUtil ybCommitUtil;
    @Autowired
    private YbPrescriptionConfigMapper ybPrescriptionConfigMapper;

    public ResultResponse<UploadChkResponse> prescriptionUploadChk(UploadChkRequest uploadChkRequest) {
        ResultResponse ybConfigResponse = this.getYbPrescriptionConfigEntity(uploadChkRequest.getOrganCode());
        if (ybConfigResponse.getCode().equals("0")) {
            return ResultResponse.error((String)"\u83b7\u53d6\u7535\u5b50\u5904\u65b9\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        String params = JSONObject.toJSONString((Object)uploadChkRequest);
        String url = "http://10.77.245.22:9001/epc/api/fixmedins/uploadChk";
        log.info("======\u7535\u5b50\u5904\u65b9\u4e0a\u4f20\u9884\u6821\u9a8curl:{},data:{}", (Object)url, (Object)params);
        BasePrescriptionResponse basePrescriptionResponse = this.ybCommitUtil.commitPrescriptionInfo((YbPrescriptionConfigEntity)ybConfigResponse.getBody(), "rx.uploadChk", params, UploadChkResponse.class, url);
        if ("0".equals(basePrescriptionResponse.getCode())) {
            return ResultResponse.success((Object)basePrescriptionResponse.getData());
        }
        return ResultResponse.error((String)basePrescriptionResponse.getMessage());
    }

    public ResultResponse<FixmedinsSignResponse> prescriptionFixmedinsSign(FixmedinsSignRequest fixmedinsSignRequest) {
        ResultResponse ybConfigResponse = this.getYbPrescriptionConfigEntity(fixmedinsSignRequest.getOrganCode());
        if (ybConfigResponse.getCode().equals("0")) {
            return ResultResponse.error((String)"\u83b7\u53d6\u7535\u5b50\u5904\u65b9\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        String params = JSONObject.toJSONString((Object)fixmedinsSignRequest);
        String url = "http://10.77.245.22:9001/epc/api/fixmedins/rxFixmedinsSign";
        log.info("==========\u7535\u5b50\u5904\u65b9\u533b\u4fdd\u7535\u5b50\u7b7e\u540durl:{},data:{}", (Object)url, (Object)params);
        BasePrescriptionResponse basePrescriptionResponse = this.ybCommitUtil.commitPrescriptionInfo((YbPrescriptionConfigEntity)ybConfigResponse.getBody(), "rx.rxFixmedinsSign", params, FixmedinsSignResponse.class, url);
        if ("0".equals(basePrescriptionResponse.getCode())) {
            return ResultResponse.success((Object)basePrescriptionResponse.getData());
        }
        return ResultResponse.error((String)basePrescriptionResponse.getMessage());
    }

    public ResultResponse<FileUpldResponse> prescriptionFileUpld(FileUpldRequest fileUpldRequest) {
        ResultResponse ybConfigResponse = this.getYbPrescriptionConfigEntity(fileUpldRequest.getOrganCode());
        if (ybConfigResponse.getCode().equals("0")) {
            return ResultResponse.error((String)"\u83b7\u53d6\u7535\u5b50\u5904\u65b9\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        String params = JSONObject.toJSONString((Object)fileUpldRequest);
        String url = "http://10.77.245.22:9001/epc/api/fixmedins/rxFileUpld";
        log.info("==========\u7535\u5b50\u5904\u65b9\u4e0a\u4f20url:{},data:{}", (Object)url, (Object)params);
        BasePrescriptionResponse basePrescriptionResponse = this.ybCommitUtil.commitPrescriptionInfo((YbPrescriptionConfigEntity)ybConfigResponse.getBody(), "rx.fileUpld", params, FileUpldResponse.class, url);
        if ("0".equals(basePrescriptionResponse.getCode())) {
            return ResultResponse.success((Object)basePrescriptionResponse.getData());
        }
        return ResultResponse.error((String)basePrescriptionResponse.getMessage());
    }

    public ResultResponse<RxSetlStockQueryResponse> rxSetlStockQuery(RxSetlStockQueryRequest rxSetlStockQueryRequest) {
        ResultResponse ybConfigResponse = this.getYbPrescriptionConfigEntity(rxSetlStockQueryRequest.getOrganCode());
        if (ybConfigResponse.getCode().equals("0")) {
            return ResultResponse.error((String)"\u83b7\u53d6\u7535\u5b50\u5904\u65b9\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        String params = JSONObject.toJSONString((Object)rxSetlStockQueryRequest);
        String url = "http://10.77.245.22:9001/epc/api/pcs-manage/pcs/fixmedins/rxSetlStockQuery";
        log.info("==========\u5e93\u5b58\u6821\u9a8c\u63a5\u53e3url:{},data:{}", (Object)url, (Object)params);
        BasePrescriptionResponse basePrescriptionResponse = this.ybCommitUtil.commitPrescriptionInfo((YbPrescriptionConfigEntity)ybConfigResponse.getBody(), "rx.rxSetlStockQuery", params, RxSetlStockQueryResponse.class, url);
        if ("0".equals(basePrescriptionResponse.getCode())) {
            return ResultResponse.success((Object)basePrescriptionResponse.getData());
        }
        return ResultResponse.error((String)basePrescriptionResponse.getMessage());
    }

    public ResultResponse<RxUndoResponse> rxUndo(RxUodoRequest rxUodoRequest) {
        ResultResponse ybConfigResponse = this.getYbPrescriptionConfigEntity(rxUodoRequest.getOrganCode());
        if (ybConfigResponse.getCode().equals("0")) {
            return ResultResponse.error((String)"\u83b7\u53d6\u7535\u5b50\u5904\u65b9\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        String params = JSONObject.toJSONString((Object)rxUodoRequest);
        String url = "http://10.77.245.22:9001/epc/api/fixmedins/rxUndo";
        log.info("==========\u5904\u65b9\u64a4\u9500\u63a5\u53e3url:{},data:{}", (Object)url, (Object)params);
        BasePrescriptionResponse basePrescriptionResponse = this.ybCommitUtil.commitPrescriptionInfo((YbPrescriptionConfigEntity)ybConfigResponse.getBody(), "rx.undo", params, RxUndoResponse.class, url);
        if ("0".equals(basePrescriptionResponse.getCode())) {
            return ResultResponse.success((Object)basePrescriptionResponse.getData());
        }
        return ResultResponse.error((String)basePrescriptionResponse.getMessage());
    }

    public static void main(String[] args) {
    }

    public ResultResponse<YbPrescriptionConfigEntity> getYbPrescriptionConfigEntity(String orgCode) {
        if ("".equals(orgCode) || null == orgCode || "GNYFY".equals(orgCode)) {
            orgCode = "360";
        }
        log.info("orgCode===={}", (Object)orgCode);
        YbPrescriptionConfigEntity ybPrescriptionConfigEntity = (YbPrescriptionConfigEntity)this.ybPrescriptionConfigMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"organ_code", (Object)orgCode));
        if (Objects.isNull(ybPrescriptionConfigEntity)) {
            return ResultResponse.error((String)"\u83b7\u53d6\u533b\u4fdd\u7535\u5b50\u5904\u65b9\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        return ResultResponse.success((Object)ybPrescriptionConfigEntity);
    }

    public ResultResponse<UploadChkResponse> prescriptionUploadChkNew(UploadChkRequest uploadChkRequest) {
        ResultResponse ybConfigResponse = this.getYbPrescriptionConfigEntity(uploadChkRequest.getOrganCode());
        if (ybConfigResponse.getCode().equals("0")) {
            return ResultResponse.error((String)"\u83b7\u53d6\u7535\u5b50\u5904\u65b9\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        String params = JSONObject.toJSONString((Object)uploadChkRequest);
        String url = "http://10.77.197.139/csb/fixmedins/uploadChk";
        log.info("======\u7535\u5b50\u5904\u65b9\u4e0a\u4f20\u9884\u6821\u9a8curl:{},data:{}", (Object)url, (Object)params);
        BasePrescriptionResponse basePrescriptionResponse = this.ybCommitUtil.commitPrescInfo((YbPrescriptionConfigEntity)ybConfigResponse.getBody(), "fix-uploadChk", params, UploadChkResponse.class, url);
        if ("0".equals(basePrescriptionResponse.getCode())) {
            return ResultResponse.success((Object)basePrescriptionResponse.getData());
        }
        return ResultResponse.error((String)basePrescriptionResponse.getMessage());
    }

    public ResultResponse<FixmedinsSignResponse> prescriptionFixmedinsSignNew(FixmedinsSignRequest fixmedinsSignRequest) {
        ResultResponse ybConfigResponse = this.getYbPrescriptionConfigEntity(fixmedinsSignRequest.getOrganCode());
        if (ybConfigResponse.getCode().equals("0")) {
            return ResultResponse.error((String)"\u83b7\u53d6\u7535\u5b50\u5904\u65b9\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        String params = JSONObject.toJSONString((Object)fixmedinsSignRequest);
        String url = "http://10.77.197.139/csb/epc/api/fixmedins/rxFixmedinsSign";
        log.info("==========\u7535\u5b50\u5904\u65b9\u533b\u4fdd\u7535\u5b50\u7b7e\u540durl:{},data:{}", (Object)url, (Object)params);
        BasePrescriptionResponse basePrescriptionResponse = this.ybCommitUtil.commitPrescInfo((YbPrescriptionConfigEntity)ybConfigResponse.getBody(), "fix-rxFixmedinsSign", params, FixmedinsSignResponse.class, url);
        if ("0".equals(basePrescriptionResponse.getCode())) {
            return ResultResponse.success((Object)basePrescriptionResponse.getData());
        }
        return ResultResponse.error((String)basePrescriptionResponse.getMessage());
    }

    public ResultResponse<FileUpldResponse> prescriptionFileUpldNew(FileUpldRequest fileUpldRequest) {
        ResultResponse ybConfigResponse = this.getYbPrescriptionConfigEntity(fileUpldRequest.getOrganCode());
        if (ybConfigResponse.getCode().equals("0")) {
            return ResultResponse.error((String)"\u83b7\u53d6\u7535\u5b50\u5904\u65b9\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        String params = JSONObject.toJSONString((Object)fileUpldRequest);
        String url = "http://10.77.197.139/csb/epc/api/fixmedins/rxFileUpld";
        log.info("==========\u7535\u5b50\u5904\u65b9\u4e0a\u4f20url:{},data:{}", (Object)url, (Object)params);
        BasePrescriptionResponse basePrescriptionResponse = this.ybCommitUtil.commitPrescInfo((YbPrescriptionConfigEntity)ybConfigResponse.getBody(), "fix-rxFileUpld", params, FileUpldResponse.class, url);
        if ("0".equals(basePrescriptionResponse.getCode())) {
            return ResultResponse.success((Object)basePrescriptionResponse.getData());
        }
        return ResultResponse.error((String)basePrescriptionResponse.getMessage());
    }

    public ResultResponse<RxSetlStockQueryResponse> rxSetlStockQueryNew(RxSetlStockQueryRequest rxSetlStockQueryRequest) {
        ResultResponse ybConfigResponse = this.getYbPrescriptionConfigEntity(rxSetlStockQueryRequest.getOrganCode());
        if (ybConfigResponse.getCode().equals("0")) {
            return ResultResponse.error((String)"\u83b7\u53d6\u7535\u5b50\u5904\u65b9\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        String params = JSONObject.toJSONString((Object)rxSetlStockQueryRequest);
        String url = "http://10.77.197.139/csb/pcs-manage/pcs/fixmedins/rxSetlStockQuery";
        log.info("==========\u5e93\u5b58\u6821\u9a8c\u63a5\u53e3url:{},data:{}", (Object)url, (Object)params);
        BasePrescriptionResponse basePrescriptionResponse = this.ybCommitUtil.commitPrescInfo((YbPrescriptionConfigEntity)ybConfigResponse.getBody(), "pss-indiho", params, RxSetlStockQueryResponse.class, url);
        if ("0".equals(basePrescriptionResponse.getCode())) {
            return ResultResponse.success((Object)basePrescriptionResponse.getData());
        }
        return ResultResponse.error((String)basePrescriptionResponse.getMessage());
    }

    public ResultResponse<RxUndoResponse> rxUndoNew(RxUodoRequest rxUodoRequest) {
        ResultResponse ybConfigResponse = this.getYbPrescriptionConfigEntity(rxUodoRequest.getOrganCode());
        if (ybConfigResponse.getCode().equals("0")) {
            return ResultResponse.error((String)"\u83b7\u53d6\u7535\u5b50\u5904\u65b9\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        String params = JSONObject.toJSONString((Object)rxUodoRequest);
        String url = "http://10.77.197.139/csb/epc/api/fixmedins/rxUndo";
        log.info("==========\u5904\u65b9\u64a4\u9500\u63a5\u53e3url:{},data:{}", (Object)url, (Object)params);
        BasePrescriptionResponse basePrescriptionResponse = this.ybCommitUtil.commitPrescInfo((YbPrescriptionConfigEntity)ybConfigResponse.getBody(), "fix-rxUndo", params, RxUndoResponse.class, url);
        if ("0".equals(basePrescriptionResponse.getCode())) {
            return ResultResponse.success((Object)basePrescriptionResponse.getData());
        }
        return ResultResponse.error((String)basePrescriptionResponse.getMessage());
    }
}

