/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.gateway.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
@Configuration
@Primary
@Profile(value={"dev", "test", "local"})
public class SwaggerConfig
implements SwaggerResourcesProvider {
    @Value(value="${swagger.enabled}")
    private boolean swaggerEnabled;
    @Autowired
    private RouteLocator routeLocator;
    @Value(value="${spring.application.name}")
    private String applicationName;

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).enable(this.swaggerEnabled).select().apis(RequestHandlerSelectors.basePackage((String)"com.ebaiyihui.gateway.controller")).paths(PathSelectors.any()).build().pathMapping("/");
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("byh-node-gateway(\u8282\u70b9\u7f51\u5173)").description("\u5fae\u670d\u52a1\u805a\u5408API\u6587\u6863").version("1.0.0").build();
    }

    public List<SwaggerResource> get() {
        ArrayList<SwaggerResource> resources = new ArrayList<SwaggerResource>();
        resources.add(this.swaggerResource("byh-node-gateway", "/v2/api-docs", "1.0"));
        this.routeLocator.getRoutes().forEach(route -> resources.add(this.swaggerResource(route.getId(), route.getFullPath().replace("**", "v2/api-docs"), "1.0")));
        return resources;
    }

    private SwaggerResource swaggerResource(String name, String location, String version) {
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setName(name);
        swaggerResource.setLocation(location);
        swaggerResource.setSwaggerVersion(version);
        return swaggerResource;
    }
}

