/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.gateway.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.gateway.model.AuthRequest;
import com.ebaiyihui.gateway.model.AuthResult;
import com.ebaiyihui.gateway.service.AuthenticationService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.stereotype.Service;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;

@Service
public class WebSocketAuthService {
    private static final Logger log = LoggerFactory.getLogger(WebSocketAuthService.class);
    @Autowired
    private AuthenticationService authenticationService;

    public AuthResult authenticateHandshakeWithResult(ServerHttpRequest request, ServerHttpResponse response) {
        try {
            log.info("WebSocket\u63e1\u624b\u8ba4\u8bc1\u5f00\u59cb: {}", (Object)request.getURI());
            AuthRequest authRequest = AuthRequest.fromWebSocketHandshake((ServerHttpRequest)request);
            AuthResult result = this.authenticationService.authenticate(authRequest);
            if (!result.isSuccess()) {
                log.warn("WebSocket\u63e1\u624b\u8ba4\u8bc1\u5931\u8d25: {}", (Object)result.getMessage());
                response.setStatusCode(HttpStatus.UNAUTHORIZED);
                return result;
            }
            if (result.isWhitelisted()) {
                log.info("WebSocket\u767d\u540d\u5355\u63e1\u624b\u6210\u529f - \u539f\u56e0: {}, \u8def\u5f84: {}", (Object)result.getWhitelistReason(), (Object)authRequest.getUrl());
            } else {
                log.info("WebSocket\u6b63\u5e38\u8ba4\u8bc1\u63e1\u624b\u6210\u529f - IP: {}, \u8def\u5f84: {}", (Object)authRequest.getIpAddress(), (Object)authRequest.getUrl());
            }
            return result;
        }
        catch (Exception e) {
            log.error("WebSocket\u63e1\u624b\u8ba4\u8bc1\u5f02\u5e38", (Throwable)e);
            response.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            return AuthResult.fail((String)("\u8ba4\u8bc1\u5f02\u5e38: " + e.getMessage()));
        }
    }

    public boolean authenticateHandshake(ServerHttpRequest request, ServerHttpResponse response) {
        AuthResult result = this.authenticateHandshakeWithResult(request, response);
        return result.isSuccess();
    }

    public boolean authenticateMessage(WebSocketSession session, Object payload) {
        try {
            if (payload instanceof TextMessage) {
                String content = (String)((TextMessage)payload).getPayload();
                try {
                    JSONObject json = JSON.parseObject((String)content);
                    String sign = json.getString("sign");
                    String data = json.getString("data");
                    if (StringUtils.isNotBlank((CharSequence)sign) && StringUtils.isNotBlank((CharSequence)data)) {
                        AuthRequest authRequest = AuthRequest.builder().sign(sign).params(data).appCode(this.getSessionAttribute(session, "appCode")).channelSource(this.getSessionAttribute(session, "channelSource")).ipAddress(this.getSessionAttribute(session, "ipAddress")).build();
                        AuthResult result = this.authenticationService.authenticate(authRequest);
                        if (!result.isSuccess()) {
                            log.warn("WebSocket\u6d88\u606f\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25: {}", (Object)result.getMessage());
                            return false;
                        }
                        log.debug("WebSocket\u6d88\u606f\u7b7e\u540d\u9a8c\u8bc1\u6210\u529f");
                        return true;
                    }
                }
                catch (Exception e) {
                    log.debug("WebSocket\u6d88\u606f\u975eJSON\u683c\u5f0f\u6216\u65e0\u7b7e\u540d\uff0c\u5141\u8bb8\u901a\u8fc7: {}", (Object)e.getMessage());
                }
            }
            return true;
        }
        catch (Exception e) {
            log.error("WebSocket\u6d88\u606f\u8ba4\u8bc1\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    private String getSessionAttribute(WebSocketSession session, String key) {
        Object value = session.getAttributes().get(key);
        return value != null ? value.toString() : null;
    }
}

