/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.physical.dto.QuestionnaireDTO;
import com.ebaiyihui.physical.dto.pay.MerchantDTO;
import com.ebaiyihui.physical.entity.DictionaryEntity;
import com.ebaiyihui.physical.entity.DictionaryTypeEntity;
import com.ebaiyihui.physical.service.DictionaryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/dic"})
@Api(tags={"\u5b57\u5178\u7ba1\u7406"})
public class DictionaryController {
    @Autowired
    DictionaryService dictionaryService;

    @PostMapping(value={"/uploadOss"})
    @ApiOperation(value="\u6587\u4ef6\u4e0a\u4f20\u81f3oss", notes="\u6587\u4ef6\u4e0a\u4f20\u81f3oss")
    public BaseResponse<String> uploadOss(@RequestParam(value="file") MultipartFile file, @RequestParam(value="path") String path) {
        try {
            BaseResponse ObjectRes = this.dictionaryService.uploadOss(file, path);
            return ObjectRes;
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u533b\u9662\u4fe1\u606f")
    @GetMapping(value={"/dic/organ"})
    public BaseResponse<List<MerchantDTO>> getAllOrgan() {
        List allOrganList = this.dictionaryService.getAllOrgan();
        return BaseResponse.success((Object)allOrganList);
    }

    @ApiOperation(value="\u4f53\u68c0\u987b\u77e5")
    @PostMapping(value={"/notice/update"})
    public BaseResponse physicalNotice(@RequestBody DictionaryEntity dictionaryEntity) {
        this.dictionaryService.saveOrUpdate((Object)dictionaryEntity);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u5b57\u5178")
    @PostMapping(value={"/dic/list"})
    public BaseResponse<List<DictionaryEntity>> getDicLabel(@RequestBody DictionaryTypeEntity typeEntity) {
        List dictionary = this.dictionaryService.getByCode(typeEntity);
        return BaseResponse.success((Object)dictionary);
    }

    @ApiOperation(value="\u67e5\u8be2\u8c03\u67e5\u95ee\u5377")
    @GetMapping(value={"/dic/question"})
    public BaseResponse<List<QuestionnaireDTO>> getQuestionnaire() {
        List dtoList = this.dictionaryService.getQuestionnaire();
        return BaseResponse.success((Object)dtoList);
    }
}

