/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.physical.dto.QuestionnaireDTO;
import com.ebaiyihui.physical.dto.pay.MerchantDTO;
import com.ebaiyihui.physical.entity.DictionaryEntity;
import com.ebaiyihui.physical.entity.DictionaryTypeEntity;
import com.ebaiyihui.physical.mapper.DictionaryMapper;
import com.ebaiyihui.physical.service.DictionaryService;
import com.ebaiyihui.physical.utils.OSSClientUtil;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DictionaryServiceImpl
extends ServiceImpl<DictionaryMapper, DictionaryEntity>
implements DictionaryService {
    public List<QuestionnaireDTO> getQuestionnaire() {
        List questionnaire = this.list((Wrapper)new QueryWrapper().eq((Object)"parent_code", (Object)"questionnaire"));
        List<QuestionnaireDTO> dtoList = questionnaire.stream().map(item -> {
            QuestionnaireDTO dto = new QuestionnaireDTO();
            String[] dicDesc = item.getDicDesc().split(",");
            dto.setQuestion(item.getDicName());
            dto.setAnswer(Arrays.asList(dicDesc));
            return dto;
        }).collect(Collectors.toList());
        return dtoList;
    }

    public List<DictionaryEntity> getByCode(DictionaryTypeEntity typeEntity) {
        List dicList = ((DictionaryMapper)this.baseMapper).getDicByCode(typeEntity.getTypeCode());
        return dicList;
    }

    public List<MerchantDTO> getAllOrgan() {
        return ((DictionaryMapper)this.baseMapper).getAllOrgan();
    }

    public BaseResponse<String> uploadOss(MultipartFile file, String path) {
        String doctorSignUrl = "";
        try {
            String doctorFileName = OSSClientUtil.uploadImg2OssNew((MultipartFile)file, (String)path);
            doctorSignUrl = OSSClientUtil.getUrl((String)doctorFileName);
        }
        catch (Exception e) {
            return BaseResponse.error((String)("\u4e0a\u4f20\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        return BaseResponse.success((Object)doctorSignUrl);
    }
}

