/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.service.impl;

import com.ebaiyihui.physical.constant.ComponentConstant;
import com.ebaiyihui.physical.entity.OrderEntity;
import com.ebaiyihui.physical.service.ProgramPushService;
import com.ebaiyihui.physical.utils.DateUtils;
import com.ebaiyihui.physical.utils.ProgramUtil;
import com.ebaiyihui.physical.utils.PushParamUtil;
import com.ebaiyihui.physical.vo.req.GetTokenReqVO;
import com.ebaiyihui.physical.vo.req.PushSubscribeMessageReqVO;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ProgramPushServiceImpl
implements ProgramPushService {
    private static final Logger log = LoggerFactory.getLogger(ProgramPushServiceImpl.class);
    @Resource
    private PushParamUtil pushParamUtil;
    @Resource
    private ComponentConstant componentConstant;
    @Resource
    private ProgramUtil programUtil;
    private static final String VALUE = "value";

    public void returnVisitNotify(OrderEntity order) {
        LinkedHashMap data = new LinkedHashMap();
        HashMap<String, String> patientNameMap = new HashMap<String, String>(10);
        patientNameMap.put(VALUE, order.getPatientName());
        data.put("thing2", patientNameMap);
        HashMap<String, String> address = new HashMap<String, String>(5);
        address.put(VALUE, "\u5357\u660c\u5927\u5b66\u7b2c\u4e8c\u9644\u5c5e\u533b\u9662\u4f53\u68c0\u4e2d\u5fc3");
        data.put("thing4", address);
        HashMap<String, String> thingMap = new HashMap<String, String>(10);
        thingMap.put(VALUE, "\u4e1c\u6e56\u9662\u533a\u4f53\u68c0\u5927\u697c/\u7ea2\u89d2\u6d32\u9662\u533a\u4f53\u68c0\u4e2d\u5fc3");
        data.put("thing6", thingMap);
        HashMap<String, String> Map2 = new HashMap<String, String>(10);
        Map2.put(VALUE, "\u60a8\u597d\uff0c\u60a8\u7684\u4f53\u68c0\u5df2\u6ee1\u4e00\u5e74\uff0c\u8bf7\u6ce8\u610f\u5b9a\u65f6\u590d\u68c0");
        data.put("thing1", Map2);
        String templateCode = this.componentConstant.getRE_INSPECTION_REMINDER();
        String page = this.componentConstant.getREMINDER_PUSH_JUMPURL();
        this.goPush(this.componentConstant.appCode, order.getUserId(), data, templateCode, page);
    }

    public void arriveOnTimeNotify(OrderEntity order) {
        LinkedHashMap data = new LinkedHashMap();
        HashMap<String, String> patientNameMap = new HashMap<String, String>(10);
        patientNameMap.put(VALUE, order.getPatientName());
        data.put("thing1", patientNameMap);
        HashMap<String, String> timeTwo = new HashMap<String, String>(10);
        timeTwo.put(VALUE, DateUtils.getFormatDateString((Date)order.getAppointmentDate(), (String)"yyyy\u5e74MM\u6708dd\u65e5") + " " + order.getAppointmentTime().substring(0, 5));
        data.put("time2", timeTwo);
        HashMap<String, String> thingMap = new HashMap<String, String>(10);
        thingMap.put(VALUE, "\u5357\u660c\u5927\u5b66\u7b2c\u4e8c\u9644\u5c5e\u533b\u9662\u4f53\u68c0\u4e2d\u5fc3");
        data.put("thing4", thingMap);
        HashMap<String, String> Map2 = new HashMap<String, String>(10);
        Map2.put(VALUE, "\u4f53\u68c0\u5373\u5c06\u5f00\u59cb\uff0c\u8bf7\u6309\u65f6\u5230\u68c0\uff0c\u5982\u5df2\u6539\u7b7e\u8bf7\u5ffd\u7565");
        data.put("thing3", Map2);
        String page = this.componentConstant.getARRIVE_ONTIME_PUSH_JUMPURL() + order.getId();
        String templateCode = this.componentConstant.getARRIVE_ONTIME_FOR_INSPECTION();
        this.goPush(this.componentConstant.appCode, order.getUserId(), data, templateCode, page);
    }

    public void paymentReminder(OrderEntity order) {
        LinkedHashMap data = new LinkedHashMap();
        HashMap<String, String> nameMap = new HashMap<String, String>(10);
        nameMap.put(VALUE, order.getCombinationName());
        data.put("thing3", nameMap);
        HashMap<String, String> amount = new HashMap<String, String>(10);
        amount.put(VALUE, order.getPayAmount().setScale(2, RoundingMode.HALF_UP).toString());
        data.put("amount4", amount);
        HashMap<String, String> thingfivMap = new HashMap<String, String>(10);
        thingfivMap.put(VALUE, DateUtils.getFormatDateString((Date)order.getAppointmentDate(), (String)"yyyy\u5e74MM\u6708dd\u65e5") + " " + order.getAppointmentTime().substring(0, 5));
        data.put("time5", thingfivMap);
        HashMap<String, String> timesevMap = new HashMap<String, String>(10);
        timesevMap.put(VALUE, DateUtils.getFormatDateString((Date)order.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        data.put("time7", timesevMap);
        HashMap<String, String> thingeigMap = new HashMap<String, String>(10);
        thingeigMap.put(VALUE, "\u60a8\u6709\u672a\u652f\u4ed8\u7684\u8ba2\u5355\uff0c\u70b9\u51fb\u67e5\u770b\u8be6\u60c5\u5b8c\u6210\u652f\u4ed8");
        data.put("thing8", thingeigMap);
        String templateCode = this.componentConstant.getPAYMENT_REMINDER();
        String page = this.componentConstant.getARRIVE_ONTIME_PUSH_JUMPURL() + order.getId();
        this.goPush(this.componentConstant.appCode, order.getUserId(), data, templateCode, page);
    }

    private void goPush(String appCode, String userId, Map<String, Map<String, Object>> data, String templateCode, String page) {
        String openId = this.pushParamUtil.getWxOpenId(userId, appCode);
        log.info("\u5c0f\u7a0b\u5e8f\u63a8\u9001\u9000\u6b3eopenId:{}", (Object)openId);
        String clientCode = this.pushParamUtil.getPushConfig(appCode, "weChatApplets", "patient", "weChatApplets").getClientCode();
        log.info("\u5c0f\u7a0b\u5e8f\u63a8\u9001\u9000\u6b3eclientCode:{}", (Object)clientCode);
        GetTokenReqVO getTokenReqVO = new GetTokenReqVO();
        getTokenReqVO.setClientCode(clientCode);
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
        pushSubscribeMessageReqVO.setOpenId(openId);
        pushSubscribeMessageReqVO.setTemplateCode(templateCode);
        pushSubscribeMessageReqVO.setPage(page);
        pushSubscribeMessageReqVO.setData(data);
        pushSubscribeMessageReqVO.setGetTokenReqVO(getTokenReqVO);
        pushSubscribeMessageReqVO.setClientCode(clientCode);
        this.programUtil.pushSubscribeMessage(pushSubscribeMessageReqVO);
    }
}

