/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.physical.entity.CombinationTagEntity;
import com.ebaiyihui.physical.entity.CombinationTagRelEntity;
import com.ebaiyihui.physical.mapper.TagCombinationRelMapper;
import com.ebaiyihui.physical.mapper.TagMapper;
import com.ebaiyihui.physical.service.TagService;
import com.ebaiyihui.physical.vo.req.DelTagReq;
import com.ebaiyihui.physical.vo.req.SaveTagReq;
import com.ebaiyihui.physical.vo.res.FindTagListRes;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TagServiceImpl
extends ServiceImpl<TagMapper, CombinationTagEntity>
implements TagService {
    private static final Logger log = LogManager.getLogger(TagServiceImpl.class);
    @Autowired
    private TagCombinationRelMapper tagRelMapper;

    public BaseResponse<String> saveTag(SaveTagReq saveTagReq) {
        if (saveTagReq == null || saveTagReq.getTagName() == null) {
            return BaseResponse.error((String)"\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CombinationTagEntity::getTagName, (Object)saveTagReq.getTagName());
        queryWrapper.eq(CombinationTagEntity::getStatus, (Object)1);
        List combinationTagEntities = ((TagMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!combinationTagEntities.isEmpty()) {
            return BaseResponse.error((String)"\u6807\u7b7e\u5df2\u5b58\u5728");
        }
        CombinationTagEntity tagEntity = new CombinationTagEntity();
        tagEntity.setTagName(saveTagReq.getTagName());
        if (((TagMapper)this.baseMapper).insert((Object)tagEntity) <= 0) {
            return BaseResponse.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        return BaseResponse.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public List<FindTagListRes> getTagListByCombinationId(Integer combinationId) {
        List tagIds = this.tagRelMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CombinationTagRelEntity::getStatus, (Object)1)).eq(CombinationTagRelEntity::getCombinationId, (Object)combinationId)).stream().map(CombinationTagRelEntity::getTagId).collect(Collectors.toList());
        if (tagIds.isEmpty()) {
            return Collections.emptyList();
        }
        List tagEntityList = ((TagMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CombinationTagEntity::getStatus, (Object)1)).in(CombinationTagEntity::getId, tagIds));
        return tagEntityList.stream().map(tag -> new FindTagListRes(tag.getId(), tag.getTagName())).collect(Collectors.toList());
    }

    public BaseResponse<List<FindTagListRes>> getTagList() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CombinationTagEntity::getStatus, (Object)1);
        List tagList = ((TagMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        List outList = tagList.stream().map(tag -> new FindTagListRes(tag.getId(), tag.getTagName())).collect(Collectors.toList());
        return BaseResponse.success(outList);
    }

    public Boolean saveTagRel(List<Integer> tagIdList, Integer combinationId) {
        log.info("tagIdList: {}, combinationId: {}", tagIdList, (Object)combinationId);
        if (tagIdList == null || tagIdList.isEmpty()) {
            return true;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.lambda().eq(CombinationTagRelEntity::getCombinationId, (Object)combinationId)).set(CombinationTagRelEntity::getStatus, (Object)2);
        this.tagRelMapper.update(null, (Wrapper)updateWrapper);
        for (Integer tagId : tagIdList) {
            CombinationTagRelEntity tagRel = new CombinationTagRelEntity();
            tagRel.setCombinationId(combinationId);
            tagRel.setTagId(tagId);
            this.tagRelMapper.insert((Object)tagRel);
        }
        return true;
    }

    public void delTagRelByCombinationId(Integer combinationId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().eq(CombinationTagRelEntity::getCombinationId, (Object)combinationId)).eq(CombinationTagRelEntity::getStatus, (Object)1)).set(CombinationTagRelEntity::getStatus, (Object)2);
        int rowsAffected = this.tagRelMapper.update(null, (Wrapper)updateWrapper);
        if (rowsAffected == 0) {
            log.warn("No records were updated for combinationId: {}", (Object)combinationId);
        }
    }

    public BaseResponse<Object> delTagById(DelTagReq delTagReq) {
        log.info("\u5220\u9664\u6807\u7b7e\u5165\u53c2===\u300b: {}", (Object)delTagReq);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.lambda().in(CombinationTagRelEntity::getTagId, (Collection)delTagReq.getTagIds())).set(CombinationTagRelEntity::getStatus, (Object)2);
        this.tagRelMapper.update(null, (Wrapper)updateWrapper);
        UpdateWrapper tagEntityUpdateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)tagEntityUpdateWrapper.lambda().in(CombinationTagEntity::getId, (Collection)delTagReq.getTagIds())).set(CombinationTagEntity::getStatus, (Object)2);
        ((TagMapper)this.baseMapper).update(null, (Wrapper)tagEntityUpdateWrapper);
        return BaseResponse.success((Object)"\u5220\u9664\u6210\u529f");
    }
}

