/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.controller;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.physical.dto.AuditDetailDTO;
import com.ebaiyihui.physical.dto.AuditListDTO;
import com.ebaiyihui.physical.dto.OrderDetailDTO;
import com.ebaiyihui.physical.dto.OrderListDTO;
import com.ebaiyihui.physical.dto.pay.BaseOperationDTO;
import com.ebaiyihui.physical.dto.pay.PartRefundDTO;
import com.ebaiyihui.physical.entity.OrderEntity;
import com.ebaiyihui.physical.service.OrderService;
import com.ebaiyihui.physical.utils.GenSeqUtils;
import com.ebaiyihui.physical.utils.PageUtils;
import com.ebaiyihui.physical.vo.ApplyVO;
import com.ebaiyihui.physical.vo.CheckCodeVO;
import com.ebaiyihui.physical.vo.CreateOrderVO;
import com.ebaiyihui.physical.vo.OrderListVO;
import com.ebaiyihui.physical.vo.SubmitVO;
import com.ebaiyihui.physical.vo.pay.PayNotifyReqVO;
import com.ebaiyihui.physical.vo.pay.PayVO;
import com.ebaiyihui.physical.vo.pay.RefundCallBackReqVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/order"})
@Api(tags={"\u8ba2\u5355\u7ba1\u7406"})
public class OrderController {
    private static final Logger log = LogManager.getLogger(OrderController.class);
    @Autowired
    OrderService orderService;

    @ApiOperation(value="\u521b\u5efa\u8ba2\u5355")
    @PostMapping(value={"/create"})
    public BaseResponse<OrderEntity> createOrder(@RequestBody CreateOrderVO vo) {
        OrderEntity order = this.orderService.createOrder(vo);
        return BaseResponse.success((Object)order);
    }

    @ApiOperation(value="\u5957\u9910\u9884\u7ea6")
    @GetMapping(value={"/subscribe"})
    public BaseResponse<String> subscribe(@RequestParam String combinationId) {
        return this.orderService.judgeCombination(combinationId);
    }

    @ApiOperation(value="\u8ba2\u5355\u5217\u8868")
    @PostMapping(value={"/list"})
    public BaseResponse<OrderListDTO> orderList(@RequestBody OrderListVO vo) {
        OrderListDTO dto = this.orderService.orderPage(vo);
        return BaseResponse.success((Object)dto);
    }

    @ApiOperation(value="\u4e0b\u8f7d\u8ba2\u5355\u5217\u8868", notes="\u4e0b\u8f7d\u8ba2\u5355\u5217\u8868")
    @PostMapping(value={"/dowOrderList"})
    public void dowOrderList(@RequestBody OrderListVO vo, HttpServletResponse response) {
        this.orderService.dowOrderList(vo, response);
    }

    @ApiOperation(value="\u7533\u8bf7\u5217\u8868")
    @PostMapping(value={"/apply/list"})
    public BaseResponse<PageUtils> applyList(@RequestBody ApplyVO vo) {
        PageUtils page = this.orderService.applyPage(vo);
        return BaseResponse.success((Object)page);
    }

    @ApiOperation(value="\u5ba1\u6838\u8ba2\u5355\u5217\u8868")
    @PostMapping(value={"/audit/list"})
    public BaseResponse<AuditListDTO> auditOrderList(@RequestBody OrderListVO vo) {
        AuditListDTO dto = this.orderService.auditOrderList(vo);
        return BaseResponse.success((Object)dto);
    }

    @ApiOperation(value="\u8ba2\u5355\u8be6\u60c5")
    @GetMapping(value={"/detail"})
    public BaseResponse<OrderDetailDTO> orderDetail(@RequestParam String orderId) {
        OrderDetailDTO dto = this.orderService.orderDetail(orderId);
        return BaseResponse.success((Object)dto);
    }

    @ApiOperation(value="\u5ba1\u6838\u8ba2\u5355")
    @PostMapping(value={"/audit"})
    public BaseResponse<OrderEntity> auditOrder(@RequestBody OrderEntity orderEntity) {
        OrderEntity order = this.orderService.auditOrder(orderEntity);
        return BaseResponse.success((Object)order);
    }

    @ApiOperation(value="\u5ba1\u6838\u8be6\u60c5")
    @GetMapping(value={"/audit/detail"})
    public BaseResponse<AuditDetailDTO> auditDetail(@RequestParam String orderId) {
        AuditDetailDTO detailDTO = this.orderService.auditDetail(orderId);
        return BaseResponse.success((Object)detailDTO);
    }

    @ApiOperation(value="\u8ba2\u5355\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    public BaseResponse submitOrder(@RequestBody SubmitVO vo) throws ParseException {
        return this.orderService.submit(vo);
    }

    @ApiOperation(value="\u8ba2\u5355\u652f\u4ed8")
    @PostMapping(value={"/pay"})
    public BaseResponse<JSONObject> payOrder(@RequestBody PayVO payVO) {
        return this.orderService.pay(payVO);
    }

    @ApiOperation(value="\u8ba2\u5355\u9000\u6b3e")
    @PostMapping(value={"/refund"})
    public BaseResponse<String> applyRefund(@RequestBody BaseOperationDTO baseOperationDto) {
        return this.orderService.applyRefund(baseOperationDto);
    }

    @ApiOperation(value="\u90e8\u5206\u9000\u6b3e/\u6574\u5355\u9000\u6b3e")
    @PostMapping(value={"/refundPartOrAll"})
    public BaseResponse<String> refundPartOrAll(@RequestBody PartRefundDTO partRefundDTO) {
        return this.orderService.refundPartOrAll(partRefundDTO);
    }

    @ApiOperation(value="\u652f\u4ed8\u56de\u8c03")
    @PostMapping(value={"/paynotify"})
    public BaseResponse<String> orderNotify(@RequestBody PayNotifyReqVO payNotifyReqVO) {
        try {
            this.orderService.orderNotify(payNotifyReqVO);
        }
        catch (Exception e) {
            log.error("\u652f\u4ed8\u56de\u8c03\u5f02\u5e38\uff1a", (Throwable)e);
            return BaseResponse.success((Object)"SUCCESS");
        }
        return BaseResponse.success((Object)"SUCCESS");
    }

    @ApiOperation(value="\u9000\u6b3e\u56de\u8c03")
    @PostMapping(value={"/refundnotify"})
    public BaseResponse<String> refundNotify(@RequestBody RefundCallBackReqVO refundNotifyReqVO) {
        return this.orderService.refundNotify(refundNotifyReqVO);
    }

    @ApiOperation(value="\u8ba2\u5355\u6838\u9500")
    @PostMapping(value={"/verification"})
    public BaseResponse orderVerification(@RequestBody CheckCodeVO vo) {
        return this.orderService.verification(vo);
    }

    @ApiOperation(value="\u751f\u6210\u8ba2\u5355\u53f7")
    @GetMapping(value={"/getOrderId"})
    public BaseResponse<String> getOrderId() {
        try {
            return BaseResponse.success((Object)GenSeqUtils.getUniqueNo());
        }
        catch (Exception e) {
            log.info(e.getMessage());
            return BaseResponse.error((String)e.toString());
        }
    }
}

