/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.physical.service.TagService;
import com.ebaiyihui.physical.vo.req.DelTagReq;
import com.ebaiyihui.physical.vo.req.SaveTagReq;
import com.ebaiyihui.physical.vo.res.FindTagListRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tag"})
@Api(tags={"\u6807\u7b7e\u7ba1\u7406"})
public class TagController {
    private static final Logger log = LoggerFactory.getLogger(TagController.class);
    @Autowired
    private TagService tagService;

    @ApiOperation(value="\u65b0\u589e\u6807\u7b7e")
    @PostMapping(value={"/saveTag"})
    public BaseResponse<String> saveTag(@RequestBody SaveTagReq saveTagReq) {
        try {
            return this.tagService.saveTag(saveTagReq);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6807\u7b7e-\u6807\u7b7e\u4e0b\u62c9\u9009\u62e9\u6846")
    @GetMapping(value={"/getTagList"})
    public BaseResponse<List<FindTagListRes>> getTagList() {
        try {
            return this.tagService.getTagList();
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="\u6839\u636e\u6807\u7b7eid\u5220\u9664\u6807\u7b7e")
    @PostMapping(value={"/delTagById"})
    public BaseResponse<Object> delTagById(@RequestBody DelTagReq delTagReq) {
        try {
            return this.tagService.delTagById(delTagReq);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.toString());
        }
    }
}

