/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.mq;

import com.ebaiyihui.physical.entity.OrderEntity;
import com.ebaiyihui.physical.enums.OrderStatusEnum;
import com.ebaiyihui.physical.mapper.OrderMapper;
import com.ebaiyihui.physical.service.ProgramPushService;
import com.ebaiyihui.physical.vo.req.OrderTaskVo;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
public class SendMassageService {
    private static final Logger log = LoggerFactory.getLogger(SendMassageService.class);
    @Resource
    private ProgramPushService programPushService;
    @Autowired
    OrderMapper orderMapper;
    private ExecutorService executor = Executors.newCachedThreadPool();

    @RabbitListener(queues={"physical.delayed.order.push.name"})
    public void orderDelayQueue1(@Payload OrderTaskVo orderTaskVo) {
        try {
            OrderEntity orderEntity;
            if (orderTaskVo.getType() == 1) {
                orderEntity = this.orderMapper.getOrderByOrderId(orderTaskVo.getId());
                if (orderEntity.getOrderStatus() != OrderStatusEnum.WAIT_USING.getCode()) {
                    return;
                }
                try {
                    this.programPushService.arriveOnTimeNotify(orderEntity);
                }
                catch (Exception e) {
                    log.error("\u4f53\u68c0\u5230\u68c0\u6d88\u606f\u63a8\u9001\u51fa\u9519", (Throwable)e);
                }
            }
            if (orderTaskVo.getType() == 2) {
                orderEntity = this.orderMapper.getOrderByOrderId(orderTaskVo.getId());
                if (orderEntity.getOrderStatus() != OrderStatusEnum.WAIT_PAY.getCode()) {
                    return;
                }
                try {
                    this.programPushService.paymentReminder(orderEntity);
                }
                catch (Exception e) {
                    log.error("\u652f\u4ed8\u6d88\u606f\u63a8\u9001\u51fa\u9519", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            return;
        }
    }
}

