/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.physical.dto.CombinationCountDTO;
import com.ebaiyihui.physical.dto.CombinationTypeDTO;
import com.ebaiyihui.physical.entity.CombinationEntity;
import com.ebaiyihui.physical.entity.CombinationTypeEntity;
import com.ebaiyihui.physical.mapper.CombinationMapper;
import com.ebaiyihui.physical.mapper.CombinationTypeMapper;
import com.ebaiyihui.physical.mapper.OrderMapper;
import com.ebaiyihui.physical.service.CombinationService;
import com.ebaiyihui.physical.service.CombinationTypeService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CombinationTypeServiceImpl
extends ServiceImpl<CombinationTypeMapper, CombinationTypeEntity>
implements CombinationTypeService {
    private static final Logger log = LoggerFactory.getLogger(CombinationTypeServiceImpl.class);
    @Autowired
    CombinationService combinationService;
    @Autowired
    CombinationMapper combinationMapper;
    @Autowired
    CombinationTypeMapper combinationTypeMapper;
    @Autowired
    private OrderMapper orderMapper;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BaseResponse saveOrUpdateCombinationType(CombinationTypeEntity combinationTypeEntity) {
        log.info("\u4fdd\u5b58\u6216\u66f4\u65b0\u5957\u9910\u7c7b\u578b,\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)combinationTypeEntity));
        if (Objects.isNull(combinationTypeEntity.getId())) {
            CombinationTypeEntity typeEntity = (CombinationTypeEntity)this.getOne((Wrapper)new QueryWrapper().eq((Object)"combination_name", (Object)combinationTypeEntity.getCombinationName()));
            if (!Objects.isNull(typeEntity)) return BaseResponse.error((String)"\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u521b\u5efa");
            this.save((Object)combinationTypeEntity);
            return BaseResponse.success();
        } else {
            List combinationListByProjectName = this.combinationTypeMapper.getCombinationListByProjectName(combinationTypeEntity.getCombinationName());
            combinationListByProjectName.removeIf(o -> o.getId() == combinationTypeEntity.getId());
            if (combinationListByProjectName.size() > 0) {
                return BaseResponse.error((String)"\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
            }
            this.updateById((Object)combinationTypeEntity);
        }
        return BaseResponse.success();
    }

    public BaseResponse delCombinationType(Integer combinationTypId) {
        log.info("\u5220\u9664\u5957\u9910\u7c7b\u578b,\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)combinationTypId));
        Integer combinationCount = this.combinationMapper.selectCount((Wrapper)new QueryWrapper().lambda().eq(CombinationEntity::getCombinationTypeId, (Object)combinationTypId));
        if (combinationCount > 0) {
            return BaseResponse.error((String)"\u9700\u5c06\u5206\u7c7b\u4e0b\u7684\u9879\u76ee\u5168\u90e8\u79fb\u9664\u540e\u624d\u53ef\u5220\u9664\u8be5\u5206\u7c7b");
        }
        this.removeById((Serializable)combinationTypId);
        return BaseResponse.success();
    }

    public void updateIsShowIndex(CombinationTypeEntity combinationTypeEntity) {
        log.info("\u66f4\u65b0\u9996\u9875\u72b6\u6001,\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)combinationTypeEntity));
        CombinationTypeEntity typeEntity = (CombinationTypeEntity)this.getById((Serializable)combinationTypeEntity);
        if (Objects.equals(typeEntity.getShowIndex(), 0)) {
            typeEntity.setShowIndex(Integer.valueOf(1));
        } else {
            typeEntity.setShowIndex(Integer.valueOf(0));
        }
        this.updateById((Object)typeEntity);
    }

    public CombinationCountDTO getCountData() {
        CombinationCountDTO countDTO = new CombinationCountDTO();
        BigDecimal totalPrice = new BigDecimal("0");
        List combinationEntities = this.combinationService.list();
        for (CombinationEntity c : combinationEntities) {
            totalPrice = totalPrice.add(c.getTotalPrice());
        }
        countDTO.setCount(Integer.valueOf(combinationEntities.size()));
        countDTO.setTotalPrice(totalPrice.toString());
        log.info("\u83b7\u5f97\u4f53\u68c0\u5957\u9910\u603b\u6570\u548c\u603b\u91d1\u989d,\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)countDTO));
        return countDTO;
    }

    public List<CombinationTypeDTO> typeList(String organId) {
        List list = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"organ_id", (Object)organId)).orderByDesc((Object)"create_time"));
        list.sort(Comparator.comparing(CombinationTypeEntity::getSort));
        List<CombinationTypeDTO> collect = list.stream().map(item -> {
            int count = this.combinationService.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"combination_type_id", (Object)item.getId())).orderByDesc((Object)"create_time"));
            CombinationTypeDTO typeDTO = new CombinationTypeDTO();
            typeDTO.setCombinationType(item);
            typeDTO.setCount(Integer.valueOf(count));
            return typeDTO;
        }).collect(Collectors.toList());
        log.info("\u5957\u9910\u7c7b\u578b\u5217\u8868, \u8fd4\u56de{}", collect);
        return collect;
    }

    public BaseResponse<String> updateOrderStatusById(String id, String status) {
        if (!StrUtil.isNotBlank((CharSequence)status)) {
            return BaseResponse.error((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int orderEntity = this.orderMapper.updateOrderStatus(id, Integer.valueOf(status));
        if (0 == orderEntity) {
            return BaseResponse.error((String)"\u4fee\u6539\u5931\u8d25");
        }
        return BaseResponse.success((Object)"\u4fee\u6539\u6210\u529f");
    }
}

