/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.utils;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.physical.entity.OrderEntity;
import com.ebaiyihui.physical.mapper.OrderMapper;
import com.ebaiyihui.physical.utils.DateUtils;
import com.ebaiyihui.physical.vo.req.OrderTaskVo;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RabbitMqUtils {
    private static final Logger log = LoggerFactory.getLogger(RabbitMqUtils.class);
    @Autowired
    OrderMapper orderMapper;
    @Autowired
    private AmqpTemplate rabbitTemplate;
    public static final int ONE_THOUSAND = 1000;
    public static final int TWELVE_THOUS = 43200000;
    public static final int TWENTY_MIN = 1200000;
    private static final String X_DELAY = "x-delay";
    private static final String SEND = "send message to rabbitmq: ";

    public static void delayedUpdateOrderStatus(RabbitTemplate rabbitTemplate, String delayMqEntity, Integer orderExpireTime) {
        rabbitTemplate.convertAndSend("physical.delayed_exchange", "physical.delayed_order_routing_key", (Object)delayMqEntity, message -> {
            message.getMessageProperties().setHeader(X_DELAY, (Object)(orderExpireTime * 1000));
            log.info("\u5ef6\u8fdf\u6d88\u8d39\u7684\u65f6\u95f4{}", (Object)(orderExpireTime * 1000));
            log.info("\u53d1\u9001\u81f3RabbitMQ\u7684\u6d88\u606f{}", (Object)(SEND + JSON.toJSONString((Object)delayMqEntity)));
            return message;
        });
    }

    public void sendDelay(OrderTaskVo orderTaskVo) {
        if (orderTaskVo.getType() == 1) {
            this.rabbitTemplate.convertAndSend("physical.delayed_exchange", "physical.delayed.order.push.key", (Object)orderTaskVo, message -> {
                long second = this.buildSecond(orderTaskVo);
                message.getMessageProperties().setHeader(X_DELAY, (Object)second);
                message.getMessageProperties().setDeliveryMode(MessageDeliveryMode.PERSISTENT);
                return message;
            });
        }
        if (orderTaskVo.getType() == 2) {
            this.rabbitTemplate.convertAndSend("physical.delayed_exchange", "physical.delayed.order.push.key", (Object)orderTaskVo, message -> {
                message.getMessageProperties().setHeader(X_DELAY, (Object)1200000);
                message.getMessageProperties().setDeliveryMode(MessageDeliveryMode.PERSISTENT);
                return message;
            });
        }
    }

    private long buildSecond(OrderTaskVo orderTaskVo) {
        OrderEntity orderEntity = this.orderMapper.getOrderByOrderId(orderTaskVo.getId());
        Date scheduleDate = orderEntity.getAppointmentDate();
        String nowDateTimeStr = DateUtils.getCurrentDateToString();
        String scheduleDateStr = DateUtils.dateToSimpleString((Date)scheduleDate) + " " + orderEntity.getAppointmentTime().substring(0, 5) + ":00";
        Date expirationDateTime = DateUtils.stringToFullDate((String)scheduleDateStr);
        Date nowDateTime = DateUtils.stringToFullDate((String)nowDateTimeStr);
        long seconds = DateUtils.secondsBetween1((Date)nowDateTime, (Date)expirationDateTime);
        return seconds * 1000L - 43200000L;
    }
}

