/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hkdhisfront.service.impl;

import com.ebaiyihui.hkdhisfront.appoint.Request6202;
import com.ebaiyihui.hkdhisfront.appoint.Response6202;
import com.ebaiyihui.hkdhisfront.base.FrontRequest;
import com.ebaiyihui.hkdhisfront.base.FrontResponse;
import com.ebaiyihui.hkdhisfront.common.enums.EntityKeyEnum;
import com.ebaiyihui.hkdhisfront.common.enums.MethodCodeEnum;
import com.ebaiyihui.hkdhisfront.outpatient.ComfirmPayNewReq;
import com.ebaiyihui.hkdhisfront.outpatient.ComfirmPayNewRes;
import com.ebaiyihui.hkdhisfront.outpatient.CostDetailVo;
import com.ebaiyihui.hkdhisfront.outpatient.FeeDetail;
import com.ebaiyihui.hkdhisfront.outpatient.GetAdmissionReq;
import com.ebaiyihui.hkdhisfront.outpatient.GetPayRecordsReq;
import com.ebaiyihui.hkdhisfront.outpatient.PayItemReq;
import com.ebaiyihui.hkdhisfront.outpatient.Register;
import com.ebaiyihui.hkdhisfront.pojo.dto.ReponseCostDetailDTO;
import com.ebaiyihui.hkdhisfront.pojo.dto.ReponseFeeDetailRecordDTO;
import com.ebaiyihui.hkdhisfront.pojo.dto.ReponseFeeRegDTO;
import com.ebaiyihui.hkdhisfront.pojo.dto.ReponsePrePayDTO;
import com.ebaiyihui.hkdhisfront.pojo.vo.RequestCardNoDateVo;
import com.ebaiyihui.hkdhisfront.pojo.vo.RequestCardNoVo;
import com.ebaiyihui.hkdhisfront.pojo.vo.RequestCostDetailVo;
import com.ebaiyihui.hkdhisfront.pojo.vo.RequestPayVo;
import com.ebaiyihui.hkdhisfront.service.HisRemoteService;
import com.ebaiyihui.hkdhisfront.service.OutpatientPaymentService;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OutpatientPaymentServiceImpl
implements OutpatientPaymentService {
    private static final Logger log = LoggerFactory.getLogger(OutpatientPaymentServiceImpl.class);
    private static final String PAY_SUCCESS = "Y";
    private static final String PAY_FAIL = "N";
    private static final String HIS_PAY_SUCCESS = "SUCCESS";
    private static final String HIS_PAY_FAIL = "FAIL";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<List<Register>> getAdmission(FrontRequest<GetAdmissionReq> param) {
        HashMap<String, RequestCardNoVo> map = new HashMap<String, RequestCardNoVo>(1);
        RequestCardNoVo requestCardNo = RequestCardNoVo.builder().cardNo(((GetAdmissionReq)param.getBody()).getCardNo()).build();
        map.put(EntityKeyEnum.QUERY_BILL_PAYMENT.getValue(), requestCardNo);
        FrontResponse frontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_BILL_PAYMENT.getValue(), map, ReponseFeeRegDTO.class);
        if (Objects.isNull(frontResponse)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-027\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
        }
        ReponseFeeRegDTO responseBody = (ReponseFeeRegDTO)frontResponse.getBody();
        if (Objects.isNull(responseBody)) {
            return FrontResponse.error((String)frontResponse.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-027\u63a5\u53e3\u8fd4\u56de\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!Objects.equals(responseBody.getResult(), "1")) {
            return FrontResponse.error((String)frontResponse.getTransactionId(), (String)frontResponse.getErrCode(), (String)responseBody.getErr());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)responseBody.getRegister());
    }

    public FrontResponse<List<CostDetailVo>> payItem(FrontRequest<PayItemReq> param) {
        PayItemReq payItemReq = (PayItemReq)param.getBody();
        HashMap<String, RequestCostDetailVo> map = new HashMap<String, RequestCostDetailVo>(1);
        RequestCostDetailVo requestCostDetail = RequestCostDetailVo.builder().cardNo(payItemReq.getCardNo()).clinicNo(payItemReq.getAdmId()).pactCode(payItemReq.getPactCode()).build();
        map.put(EntityKeyEnum.QUERY_PAYMENT_DETAILS.getValue(), requestCostDetail);
        FrontResponse frontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_PAYMENT_DETAILS.getValue(), map, ReponseCostDetailDTO.class);
        if (Objects.isNull(frontResponse)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-017\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
        }
        ReponseCostDetailDTO responseBody = (ReponseCostDetailDTO)frontResponse.getBody();
        if (Objects.isNull(responseBody)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-017\u63a5\u53e3\u8fd4\u56de\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!Objects.equals(responseBody.getResult(), "1")) {
            return FrontResponse.error((String)frontResponse.getTransactionId(), (String)frontResponse.getErrCode(), (String)responseBody.getErr());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)responseBody.getCostDetailList());
    }

    public FrontResponse<ComfirmPayNewRes> comfirmPayNew(FrontRequest<ComfirmPayNewReq> param) {
        ComfirmPayNewReq comfirmPayNewReq = (ComfirmPayNewReq)param.getBody();
        HashMap<String, RequestPayVo> map = new HashMap<String, RequestPayVo>(1);
        RequestPayVo requestPay = RequestPayVo.builder().cardNo(comfirmPayNewReq.getCardNo()).clinicNo(comfirmPayNewReq.getClinicNo()).pactCode(comfirmPayNewReq.getPactCode()).userID("zwby").flowNo(comfirmPayNewReq.getFlowNo()).payMode(comfirmPayNewReq.getPayMode()).bankNo(comfirmPayNewReq.getBankNo()).bankName(comfirmPayNewReq.getBankName()).money(comfirmPayNewReq.getMoney()).recipeId(comfirmPayNewReq.getRecipeId()).ybInfo(comfirmPayNewReq.getYbInfo()).build();
        map.put(EntityKeyEnum.PAY_COST.getValue(), requestPay);
        FrontResponse frontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.PAY_COST.getValue(), map, ReponsePrePayDTO.class);
        if (Objects.isNull(frontResponse)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-018\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
        }
        ReponsePrePayDTO responseBody = (ReponsePrePayDTO)frontResponse.getBody();
        if (Objects.isNull(responseBody)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-018\u63a5\u53e3\u8fd4\u56de\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!Objects.equals(responseBody.getResult(), "1")) {
            return FrontResponse.error((String)frontResponse.getTransactionId(), (String)frontResponse.getErrCode(), (String)responseBody.getErr());
        }
        ComfirmPayNewRes comfirmPayNewRes = ComfirmPayNewRes.builder().receiptId(responseBody.getInvoiceNo()).build();
        return FrontResponse.success((String)param.getTransactionId(), (Object)comfirmPayNewRes);
    }

    public FrontResponse<List<FeeDetail>> getPayRecords(FrontRequest<GetPayRecordsReq> param) {
        GetPayRecordsReq getPayRecordsReq = (GetPayRecordsReq)param.getBody();
        HashMap<String, RequestCardNoDateVo> map = new HashMap<String, RequestCardNoDateVo>(1);
        RequestCardNoDateVo requestCardNoDate = RequestCardNoDateVo.builder().cardNo(getPayRecordsReq.getCardNo()).beginDate(getPayRecordsReq.getStartDate()).endDate(getPayRecordsReq.getEndDate()).build();
        map.put(EntityKeyEnum.ACQUIRE_PAYCOST_RECORD.getValue(), requestCardNoDate);
        FrontResponse frontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.ACQUIRE_PAYCOST_RECORD.getValue(), map, ReponseFeeDetailRecordDTO.class);
        if (Objects.isNull(frontResponse)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-015\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
        }
        ReponseFeeDetailRecordDTO feeDetailRecordDTO = (ReponseFeeDetailRecordDTO)frontResponse.getBody();
        if (Objects.isNull(feeDetailRecordDTO)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-015\u63a5\u53e3\u8fd4\u56de\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!Objects.equals(feeDetailRecordDTO.getResult(), "1")) {
            return FrontResponse.error((String)frontResponse.getTransactionId(), (String)frontResponse.getErrCode(), (String)feeDetailRecordDTO.getErr());
        }
        List getPayRecordsRes = feeDetailRecordDTO.getFeeDetailList();
        return FrontResponse.success((String)param.getTransactionId(), (Object)getPayRecordsRes);
    }

    public FrontResponse<Response6202> outpatientYbPayment(FrontRequest<Request6202> param) {
        Request6202 request6202 = (Request6202)param.getBody();
        HashMap<String, Request6202> map = new HashMap<String, Request6202>(1);
        map.put(EntityKeyEnum.OUT_PATIENT_YB_PAYMENT.getValue(), request6202);
        FrontResponse frontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.OUT_PATIENT_YB_PAYMENT.getValue(), map, Response6202.class);
        if (Objects.isNull(frontResponse)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-NM6202\u3001\u56fd\u5bb6\u533b\u4fdd\u4e0b\u5355\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
        }
        Response6202 response6202 = (Response6202)frontResponse.getBody();
        if (Objects.isNull(response6202)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-NM6202\u3001\u56fd\u5bb6\u533b\u4fdd\u4e0b\u5355\u8fd4\u56de\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!Objects.equals(response6202.getResult(), "1")) {
            return FrontResponse.error((String)frontResponse.getTransactionId(), (String)frontResponse.getErrCode(), (String)response6202.getErr());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)response6202);
    }
}

