/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hkdhisfront.service.roc;

import cn.hutool.core.collection.CollectionUtil;
import com.ebaiyihui.hkdhisfront.appoint.NoSchedulingRegistResVO;
import com.ebaiyihui.hkdhisfront.appoint.NoSchedulingRequestRegVo;
import com.ebaiyihui.hkdhisfront.appoint.RequestCancelRegVo;
import com.ebaiyihui.hkdhisfront.appoint.ResultInfoVo;
import com.ebaiyihui.hkdhisfront.base.FrontRequest;
import com.ebaiyihui.hkdhisfront.base.FrontResponse;
import com.ebaiyihui.hkdhisfront.outpatient.ComfirmPayNewReq;
import com.ebaiyihui.hkdhisfront.outpatient.ComfirmPayNewRes;
import com.ebaiyihui.hkdhisfront.outpatient.CostDetailVo;
import com.ebaiyihui.hkdhisfront.outpatient.PayItemReq;
import com.ebaiyihui.hkdhisfront.pojo.dto.MedicalRecordDTO;
import com.ebaiyihui.hkdhisfront.pojo.dto.RocMedicalRecordResDTO;
import com.ebaiyihui.hkdhisfront.roc.DeleteMedicalOrderInfoDTO;
import com.ebaiyihui.hkdhisfront.roc.DrugStorageResData;
import com.ebaiyihui.hkdhisfront.roc.FrequencyResData;
import com.ebaiyihui.hkdhisfront.roc.MedicalOrderInfoDTO;
import com.ebaiyihui.hkdhisfront.roc.MedicalOrderRes;
import com.ebaiyihui.hkdhisfront.roc.MedicalRecord;
import com.ebaiyihui.hkdhisfront.roc.MedicalRecordDetail;
import com.ebaiyihui.hkdhisfront.roc.MedicalRecordReqVO;
import com.ebaiyihui.hkdhisfront.roc.RegisteredRecordReqVo;
import com.ebaiyihui.hkdhisfront.roc.RegisteredRecordResVo;
import com.ebaiyihui.hkdhisfront.roc.RocResponse;
import com.ebaiyihui.hkdhisfront.roc.UsageResData;
import com.ebaiyihui.hkdhisfront.service.AppointService;
import com.ebaiyihui.hkdhisfront.service.OutpatientPaymentService;
import com.ebaiyihui.hkdhisfront.service.roc.IRocApi;
import com.ebaiyihui.hkdhisfront.service.roc.IRocService;
import com.ebaiyihui.hkdhisfront.utils.XmlUtil;
import io.jsonwebtoken.lang.Collections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import retrofit2.Call;

@Service
public class RocServiceImpl
implements IRocService {
    private static final Logger log = LoggerFactory.getLogger(RocServiceImpl.class);
    private final AppointService appointService;
    private final IRocApi rocApi;
    private final OutpatientPaymentService outpatientPaymentService;

    public RocServiceImpl(AppointService appointService, IRocApi rocApi, OutpatientPaymentService outpatientPaymentService) {
        this.appointService = appointService;
        this.rocApi = rocApi;
        this.outpatientPaymentService = outpatientPaymentService;
    }

    public FrontResponse<List<RegisteredRecordResVo>> checkReRegister(FrontRequest<RegisteredRecordReqVo> param) {
        try {
            RegisteredRecordReqVo paramBody = (RegisteredRecordReqVo)param.getBody();
            Call rocResponseCall = this.rocApi.queryMedicalRecordList(paramBody.getCardNo(), paramBody.getDeptCode(), paramBody.getBgDate(), paramBody.getEdDate());
            RocResponse rocResponse = (RocResponse)rocResponseCall.execute().body();
            if (!rocResponse.isSuccess()) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)rocResponse.getMsg());
            }
            List medicalRecords = ((RocMedicalRecordResDTO)rocResponse.getData()).getList();
            if (Collections.isEmpty((Collection)medicalRecords)) {
                return FrontResponse.success((String)param.getTransactionId(), new ArrayList());
            }
            medicalRecords.sort(Comparator.comparing(MedicalRecord::getCreateDate).reversed());
            MedicalRecord medicalRecord = (MedicalRecord)medicalRecords.get(0);
            Call rocResponseCallDetail = this.rocApi.queryMedicalRecordDetail(medicalRecord.getRecordId(), "2");
            RocResponse rocResponseDetail = (RocResponse)rocResponseCallDetail.execute().body();
            if (!rocResponseDetail.isSuccess()) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)rocResponseDetail.getMsg());
            }
            MedicalRecord medicalRecordDetail = (MedicalRecord)rocResponseDetail.getData();
            String medicalRecordXml = medicalRecordDetail.getXml();
            medicalRecordXml = medicalRecordXml.substring(medicalRecordXml.indexOf("<DocObjContent>"), medicalRecordXml.indexOf("</DocObjContent>") + 16);
            MedicalRecordDTO medicalRecordDTO = (MedicalRecordDTO)XmlUtil.convertToJavaBean((String)medicalRecordXml, MedicalRecordDTO.class);
            List medicalRecordDetails = medicalRecordDTO.getMedicalRecordDetails();
            Map<String, List<MedicalRecordDetail>> groupedByTagId = medicalRecordDetails.stream().collect(Collectors.groupingBy(MedicalRecordDetail::getControlId));
            ArrayList<RegisteredRecordResVo> recordResVoList = new ArrayList<RegisteredRecordResVo>();
            RegisteredRecordResVo registeredRecordResVo = RegisteredRecordResVo.builder().clinicNO(medicalRecord.getClinicNo()).deptName(medicalRecord.getDeptName()).deptCode(medicalRecord.getDeptCode()).doctCode(medicalRecord.getOperDocCode()).doctName(medicalRecord.getOperDocName()).regDate(medicalRecord.getCreateDate()).cardNo(medicalRecord.getPatientId()).pactName(medicalRecord.getRecordName()).build();
            if (CollectionUtil.isNotEmpty((Collection)medicalRecordDetails)) {
                registeredRecordResVo.setDiagnose(this.getContentText(groupedByTagId, "20170418166547"));
                registeredRecordResVo.setMainSuit(this.getContentText(groupedByTagId, "20160615181973"));
                registeredRecordResVo.setCurrentHistory(this.getContentText(groupedByTagId, "20160610169629"));
                registeredRecordResVo.setPastHistory(this.getContentText(groupedByTagId, "202302231418547300"));
                registeredRecordResVo.setAge(this.getContentText(groupedByTagId, "20160610168334"));
                registeredRecordResVo.setAdvice(this.getContentText(groupedByTagId, "202008061343231"));
                registeredRecordResVo.setSex(this.getContentText(groupedByTagId, "20160610166615"));
            }
            recordResVoList.add(registeredRecordResVo);
            return FrontResponse.success((String)param.getTransactionId(), recordResVoList);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u75c5\u5386\u6216\u8005\u75c5\u5386\u8be6\u60c5\u63a5\u53e3\u5f02\u5e38--->", (Throwable)e);
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u75c5\u5386\u6216\u8005\u75c5\u5386\u8be6\u60c5\u63a5\u53e3\u5f02\u5e38");
        }
    }

    public FrontResponse<NoSchedulingRegistResVO> noSchedulingRegister(FrontRequest<NoSchedulingRequestRegVo> param) {
        return this.appointService.noSchedulingRegister(param);
    }

    public FrontResponse<ResultInfoVo> backNumber(FrontRequest<RequestCancelRegVo> param) {
        return this.appointService.backNumber(param);
    }

    public FrontResponse<List<MedicalRecord>> queryMedicalRecordList(FrontRequest<MedicalRecordReqVO> param) {
        try {
            Call rocResponseCall = this.rocApi.queryMedicalRecordList(((MedicalRecordReqVO)param.getBody()).getPatientId(), ((MedicalRecordReqVO)param.getBody()).getDeptCode(), ((MedicalRecordReqVO)param.getBody()).getStartTime(), ((MedicalRecordReqVO)param.getBody()).getEndTime());
            RocResponse rocResponse = (RocResponse)rocResponseCall.execute().body();
            if (rocResponse.isSuccess()) {
                return FrontResponse.success((String)param.getTransactionId(), (Object)((RocMedicalRecordResDTO)rocResponse.getData()).getList());
            }
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)rocResponse.getMsg());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5386\u53f2\u75c5\u5386\u8bb0\u5f55\u63a5\u53e3\u5f02\u5e38--->", (Throwable)e);
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5386\u53f2\u75c5\u5386\u8bb0\u5f55\u63a5\u53e3\u5f02\u5e38");
        }
    }

    public FrontResponse<MedicalRecord> queryMedicalRecordDetail(FrontRequest<String> param) {
        try {
            Call rocResponseCall = this.rocApi.queryMedicalRecordDetail((String)param.getBody(), "2");
            RocResponse rocResponse = (RocResponse)rocResponseCall.execute().body();
            if (!rocResponse.isSuccess()) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)rocResponse.getMsg());
            }
            MedicalRecord medicalRecord = (MedicalRecord)rocResponse.getData();
            String medicalRecordXml = medicalRecord.getXml();
            medicalRecordXml = medicalRecordXml.substring(medicalRecordXml.indexOf("<DocObjContent>"), medicalRecordXml.indexOf("</DocObjContent>") + 16);
            MedicalRecordDTO medicalRecordDTO = (MedicalRecordDTO)XmlUtil.convertToJavaBean((String)medicalRecordXml, MedicalRecordDTO.class);
            medicalRecord.setMedicalRecordDetailList(medicalRecordDTO.getMedicalRecordDetails());
            return FrontResponse.success((String)param.getTransactionId(), (Object)medicalRecord);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u75c5\u5386\u8be6\u60c5\u63a5\u53e3\u5f02\u5e38--->", (Throwable)e);
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u75c5\u5386\u8be6\u60c5\u63a5\u53e3\u5f02\u5e38");
        }
    }

    public FrontResponse<List<FrequencyResData>> queryFrequency(FrontRequest<String> param) {
        try {
            Call rocResponseCall = this.rocApi.queryFrequency((String)param.getBody());
            RocResponse rocResponse = (RocResponse)rocResponseCall.execute().body();
            if (rocResponse.isSuccess()) {
                return FrontResponse.success((String)param.getTransactionId(), (Object)rocResponse.getData());
            }
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)rocResponse.getMsg());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u9891\u6b21\u63a5\u53e3\u5f02\u5e38--->", (Throwable)e);
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u9891\u6b21\u63a5\u53e3\u5f02\u5e38");
        }
    }

    public FrontResponse<List<UsageResData>> queryUsage(FrontRequest<String> param) {
        try {
            Call rocResponseCall = this.rocApi.queryUsage(999, 1, (String)param.getBody(), null, null, null, null);
            RocResponse rocResponse = (RocResponse)rocResponseCall.execute().body();
            if (rocResponse.isSuccess()) {
                return FrontResponse.success((String)param.getTransactionId(), (Object)rocResponse.getData());
            }
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)rocResponse.getMsg());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u7528\u6cd5\u63a5\u53e3\u5f02\u5e38--->", (Throwable)e);
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u7528\u6cd5\u63a5\u53e3\u5f02\u5e38");
        }
    }

    public FrontResponse<List<DrugStorageResData>> queryDrugStorage(FrontRequest<String> param) {
        try {
            Call rocResponseCall = this.rocApi.queryDrugStorage(null, "6004", (String)param.getBody(), null);
            RocResponse rocResponse = (RocResponse)rocResponseCall.execute().body();
            if (rocResponse.isSuccess()) {
                return FrontResponse.success((String)param.getTransactionId(), (Object)rocResponse.getData());
            }
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)rocResponse.getMsg());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u836f\u54c1\u5e93\u5b58\u63a5\u53e3\u5f02\u5e38--->", (Throwable)e);
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u836f\u54c1\u5e93\u5b58\u63a5\u53e3\u5f02\u5e38");
        }
    }

    public FrontResponse<List<MedicalOrderRes>> saveMedicalOrder(FrontRequest<MedicalOrderInfoDTO> param) {
        try {
            Call rocResponseCall = this.rocApi.saveMedicalOrder((MedicalOrderInfoDTO)param.getBody());
            RocResponse rocResponse = (RocResponse)rocResponseCall.execute().body();
            if (rocResponse.isSuccess()) {
                return FrontResponse.success((String)param.getTransactionId(), (Object)rocResponse.getData());
            }
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)rocResponse.getMsg());
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u533b\u5631\u63a5\u53e3\u5f02\u5e38--->", (Throwable)e);
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u4fdd\u5b58\u533b\u5631\u63a5\u53e3\u5f02\u5e38");
        }
    }

    public FrontResponse deleteMedicalOrder(FrontRequest<DeleteMedicalOrderInfoDTO> param) {
        try {
            Call rocResponseCall = this.rocApi.deleteMedicalOrder((DeleteMedicalOrderInfoDTO)param.getBody());
            RocResponse rocResponse = (RocResponse)rocResponseCall.execute().body();
            if (rocResponse.isSuccess()) {
                return FrontResponse.success((String)param.getTransactionId(), (Object)rocResponse.getData());
            }
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)rocResponse.getMsg());
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u533b\u5631\u63a5\u53e3\u5f02\u5e38--->", (Throwable)e);
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u5220\u9664\u533b\u5631\u63a5\u53e3\u5f02\u5e38");
        }
    }

    public FrontResponse<List<CostDetailVo>> payItem(FrontRequest<PayItemReq> param) {
        return this.outpatientPaymentService.payItem(param);
    }

    public FrontResponse<ComfirmPayNewRes> comfirmPay(FrontRequest<ComfirmPayNewReq> param) {
        return this.outpatientPaymentService.comfirmPayNew(param);
    }

    private String getContentText(Map<String, List<MedicalRecordDetail>> groupedByTagId, String tagId) {
        List<MedicalRecordDetail> details = groupedByTagId.get(tagId);
        if (CollectionUtil.isNotEmpty(details)) {
            MedicalRecordDetail detail = details.get(0);
            return detail != null ? detail.getContentText() : null;
        }
        return null;
    }
}

