/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hkdhisfront.config;

import com.ebaiyihui.hkdhisfront.payment.config.PayProperties;
import com.ebaiyihui.hkdhisfront.payment.service.IPaymentApi;
import com.ebaiyihui.hkdhisfront.service.roc.IRocApi;
import com.ebaiyihui.hkdhisfront.service.waitingqueue.IWaitingQueueApi;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Configuration
@EnableConfigurationProperties(value={PayProperties.class})
public class Retrofit2Config {
    private static final Logger log = LoggerFactory.getLogger(Retrofit2Config.class);

    @Bean
    public OkHttpClient okHttpClient() {
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
        httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        return new OkHttpClient.Builder().addInterceptor((Interceptor)httpLoggingInterceptor).connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();
    }

    @Bean
    public IPaymentApi paymentApi(OkHttpClient httpClient, PayProperties payProperties) {
        return (IPaymentApi)new Retrofit.Builder().baseUrl(payProperties.getPayUrl()).client(httpClient).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(IPaymentApi.class);
    }

    @Bean
    public IRocApi rocApi(OkHttpClient httpClient) {
        return (IRocApi)new Retrofit.Builder().baseUrl("http://192.168.121.95:80").client(httpClient).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(IRocApi.class);
    }

    @Bean
    public IWaitingQueueApi waitingQueueApi(OkHttpClient httpClient) {
        return (IWaitingQueueApi)new Retrofit.Builder().baseUrl("http://192.168.121.100:81").client(httpClient).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(IWaitingQueueApi.class);
    }
}

